/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.documentation;

import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.ui.ColorUtil;
import com.intellij.util.ui.JBUI;
import com.jetbrains.cmake.CMakePsiLog;
import com.jetbrains.cmake.completion.contributors.providers.CMakeStandardCommands;
import com.jetbrains.cmake.documentation.PropertyKind;
import com.jetbrains.cmake.documentation.PygmentsTokenAttribute;
import com.jetbrains.cmake.psi.CMakeArgument;
import com.jetbrains.cmake.psi.CMakeCommand;
import com.jetbrains.cmake.psi.CMakeElementType;
import com.jetbrains.cmake.psi.CMakeSyntaxHighlighter;
import com.jetbrains.cmake.psi.CMakeTokenTypes;
import com.jetbrains.cmake.psi.CMakeVarReferenceLexer;
import com.jetbrains.cmake.psi.util.CMakePsiUtils;
import java.awt.Color;
import java.io.IOException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u000e\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\u000fH\u0000\u001a\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u001a\b\u0010\u0013\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0016H\u0000\u001a\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u001a\u0018\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\u001a\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\u001a\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u001a\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u00012\u0006\u0010\"\u001a\u00020#H\u0002\u001a\f\u0010-\u001a\u0004\u0018\u00010.*\u00020\u000f\u001a\u001a\u0010*\u001a\u0004\u0018\u00010.2\u0006\u0010/\u001a\u00020\u000f2\u0006\u00100\u001a\u000201H\u0002\u001a\u0012\u00102\u001a\u0004\u0018\u00010.2\u0006\u0010/\u001a\u00020\u000fH\u0002\u001a\u001a\u00103\u001a\u0004\u0018\u00010.2\u0006\u0010/\u001a\u00020\u000f2\u0006\u00100\u001a\u000201H\u0002\u001a\u001a\u00104\u001a\u0004\u0018\u00010.2\u0006\u0010/\u001a\u00020\u000f2\u0006\u00100\u001a\u000201H\u0002\u001a\u001a\u00105\u001a\u0004\u0018\u00010.2\u0006\u0010/\u001a\u00020\u000f2\u0006\u00100\u001a\u000201H\u0002\u001a\u001a\u00106\u001a\u0004\u0018\u00010.2\u0006\u0010/\u001a\u00020\u000f2\u0006\u00100\u001a\u000201H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"!\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001f0%8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b(\u0010)\u001a\u0004\b&\u0010'\"\u0015\u0010*\u001a\u00020+*\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010,\u00a8\u00067"}, d2={"CMAKE_POLICY_ARGUMENT_GET", "", "CMAKE_POLICY_ARGUMENT_SET", "CMAKE_GLOBAL_PROPERTY_ARG", "CMAKE_DIRECTORY_PROPERTY_ARG", "CMAKE_TARGET_PROPERTY_ARG", "CMAKE_SOURCE_PROPERTY_ARG", "CMAKE_INSTALL_PROPERTY_ARG", "CMAKE_TEST_PROPERTY_ARG", "CMAKE_CACHE_PROPERTY_ARG", "CMAKE_PROPERTY_ARG", "CMAKE_PROPERTIES_ARG", "CMAKE_DEFINITION_ARG", "CMAKE_FIND_PACKAGE_FILE_PREFIX", "findPreviousPropertiesArgument", "Lcom/jetbrains/cmake/psi/CMakeArgument;", "readFile", "path", "Ljava/nio/file/Path;", "linkCss", "convertToPygments", "colorScheme", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "convertColorKey", "", "colorKey", "Lcom/intellij/openapi/editor/colors/ColorKey;", "convertTextAttributeKey", "textAttributeKey", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "token", "Lcom/jetbrains/cmake/documentation/PygmentsTokenAttribute;", "tokenName", "pygmentsToken", "cmakeToken", "Lcom/intellij/psi/tree/IElementType;", "pygmentTokens", "", "getPygmentTokens", "()Ljava/util/List;", "pygmentTokens$delegate", "Lkotlin/Lazy;", "isProperty", "", "(Lcom/jetbrains/cmake/psi/CMakeArgument;)Z", "getPropertyKind", "Lcom/jetbrains/cmake/documentation/PropertyKind;", "argument", "command", "Lcom/jetbrains/cmake/psi/CMakeCommand;", "isGlobalProperty", "isDirectoryProperty", "isTargetProperty", "isSourceFileProperty", "isTestProperty", "intellij.cmake.psi"})
public final class CMakeDocumentationUtilKt {
    @NotNull
    public static final String CMAKE_POLICY_ARGUMENT_GET = "GET";
    @NotNull
    public static final String CMAKE_POLICY_ARGUMENT_SET = "SET";
    @NotNull
    public static final String CMAKE_GLOBAL_PROPERTY_ARG = "GLOBAL";
    @NotNull
    public static final String CMAKE_DIRECTORY_PROPERTY_ARG = "DIRECTORY";
    @NotNull
    public static final String CMAKE_TARGET_PROPERTY_ARG = "TARGET";
    @NotNull
    public static final String CMAKE_SOURCE_PROPERTY_ARG = "SOURCE";
    @NotNull
    public static final String CMAKE_INSTALL_PROPERTY_ARG = "INSTALL";
    @NotNull
    public static final String CMAKE_TEST_PROPERTY_ARG = "TEST";
    @NotNull
    public static final String CMAKE_CACHE_PROPERTY_ARG = "CACHE";
    @NotNull
    public static final String CMAKE_PROPERTY_ARG = "PROPERTY";
    @NotNull
    public static final String CMAKE_PROPERTIES_ARG = "PROPERTIES";
    @NotNull
    public static final String CMAKE_DEFINITION_ARG = "DEFINITION";
    @NotNull
    public static final String CMAKE_FIND_PACKAGE_FILE_PREFIX = "Find";
    @NotNull
    private static final Lazy pygmentTokens$delegate = LazyKt.lazy(CMakeDocumentationUtilKt::pygmentTokens_delegate$lambda$0);

    @Nullable
    public static final CMakeArgument findPreviousPropertiesArgument(@NotNull CMakeArgument $this$findPreviousPropertiesArgument) {
        Intrinsics.checkNotNullParameter((Object)$this$findPreviousPropertiesArgument, (String)"<this>");
        for (CMakeArgument propertiesArgument = $this$findPreviousPropertiesArgument.getPreviousArgument(); propertiesArgument != null; propertiesArgument = propertiesArgument.getPreviousArgument()) {
            if (StringsKt.equals((String)propertiesArgument.getText(), (String)CMAKE_PROPERTIES_ARG, (boolean)true)) {
                return propertiesArgument;
            }
            CMakeArgument cMakeArgument = propertiesArgument.getPreviousArgument();
            if (cMakeArgument == null) {
                return null;
            }
            propertiesArgument = cMakeArgument;
        }
        return null;
    }

    @Nullable
    public static final String readFile(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        try {
            return PathsKt.readText$default((Path)path, null, (int)1, null);
        }
        catch (FileSystemNotFoundException e) {
            CMakePsiLog.INSTANCE.getLOG().debug((Throwable)e);
            return null;
        }
        catch (SecurityException e) {
            CMakePsiLog.INSTANCE.getLOG().debug((Throwable)e);
            return null;
        }
        catch (IOException e) {
            CMakePsiLog.INSTANCE.getLOG().debug((Throwable)e);
            return null;
        }
    }

    @NotNull
    public static final String linkCss() {
        String string = ColorUtil.toHtmlColor((Color)JBUI.CurrentTheme.Link.Foreground.ENABLED);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toHtmlColor(...)");
        String linkColor = string;
        return "a { color: " + linkColor + "}";
    }

    @NotNull
    public static final String convertToPygments(@NotNull EditorColorsScheme colorScheme) {
        Intrinsics.checkNotNullParameter((Object)colorScheme, (String)"colorScheme");
        StringBuilder css = new StringBuilder();
        String string = ColorUtil.toHtmlColor((Color)colorScheme.getDefaultBackground());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toHtmlColor(...)");
        String defaultBackground = string;
        css.append(".highlight  { background: " + defaultBackground + "; }\n");
        for (PygmentsTokenAttribute token : CMakeDocumentationUtilKt.getPygmentTokens()) {
            CharSequence charSequence;
            ColorKey colorKey = token.getColorKey();
            TextAttributesKey textAttributesKey = token.getTextAttributeKey();
            if (colorKey != null) {
                charSequence = CMakeDocumentationUtilKt.convertColorKey(colorScheme, colorKey);
            } else {
                if (textAttributesKey == null) continue;
                charSequence = CMakeDocumentationUtilKt.convertTextAttributeKey(colorScheme, textAttributesKey);
            }
            CharSequence cssAttributes = charSequence;
            css.append(".highlight ." + token.getTokenName() + " { " + cssAttributes + " }\n");
        }
        String string2 = css.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    private static final CharSequence convertColorKey(EditorColorsScheme colorScheme, ColorKey colorKey) {
        Color color = colorScheme.getColor(colorKey);
        if (color == null) {
            Color color2 = colorScheme.getDefaultForeground();
            color = color2;
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"getDefaultForeground(...)");
        }
        Color color3 = color;
        String string = ColorUtil.toHtmlColor((Color)color3);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toHtmlColor(...)");
        return string;
    }

    private static final CharSequence convertTextAttributeKey(EditorColorsScheme colorScheme, TextAttributesKey textAttributeKey) {
        int fontType;
        Color backgroundColor;
        StringBuilder css = new StringBuilder();
        TextAttributes textAttributes = colorScheme.getAttributes(textAttributeKey);
        if (textAttributes == null) {
            return css;
        }
        TextAttributes textAttributes2 = textAttributes;
        Color foregroundColor = textAttributes2.getForegroundColor();
        if (foregroundColor != null) {
            css.append("color: " + ColorUtil.toHtmlColor((Color)foregroundColor) + "; ");
        }
        if ((backgroundColor = textAttributes2.getBackgroundColor()) != null) {
            css.append("background-color: " + ColorUtil.toHtmlColor((Color)backgroundColor) + "; ");
        }
        if ((fontType = textAttributes2.getFontType()) == 2) {
            css.append("font-style: italic; ");
        }
        if (fontType == 1) {
            css.append("font-weight: bold");
        }
        return css;
    }

    private static final PygmentsTokenAttribute token(String tokenName, TextAttributesKey textAttributeKey) {
        return new PygmentsTokenAttribute(tokenName, null, textAttributeKey);
    }

    private static final PygmentsTokenAttribute token(String tokenName, ColorKey colorKey) {
        return new PygmentsTokenAttribute(tokenName, colorKey, null);
    }

    private static final PygmentsTokenAttribute token(String pygmentsToken, IElementType cmakeToken) {
        TextAttributesKey textAttributesKey = CMakeSyntaxHighlighter.Companion.computeAttribute(cmakeToken);
        if (textAttributesKey == null) {
            textAttributesKey = HighlighterColors.TEXT;
        }
        TextAttributesKey attributesKey = textAttributesKey;
        Intrinsics.checkNotNull((Object)attributesKey);
        return CMakeDocumentationUtilKt.token(pygmentsToken, attributesKey);
    }

    private static final List<PygmentsTokenAttribute> getPygmentTokens() {
        Lazy lazy = pygmentTokens$delegate;
        return (List)lazy.getValue();
    }

    public static final boolean isProperty(@NotNull CMakeArgument $this$isProperty) {
        Intrinsics.checkNotNullParameter((Object)$this$isProperty, (String)"<this>");
        return CMakeDocumentationUtilKt.getPropertyKind($this$isProperty) != null;
    }

    @Nullable
    public static final PropertyKind getPropertyKind(@NotNull CMakeArgument $this$getPropertyKind) {
        PropertyKind propertyKind;
        CMakeCommand command;
        Intrinsics.checkNotNullParameter((Object)$this$getPropertyKind, (String)"<this>");
        CMakeArgument argument = $this$getPropertyKind;
        CMakeCommand cMakeCommand = CMakePsiUtils.getCommand($this$getPropertyKind);
        if (cMakeCommand == null) {
            return null;
        }
        CMakeCommand $this$getPropertyKind_u24lambda_u241 = command = cMakeCommand;
        boolean bl = false;
        if (CMakePsiUtils.isCommand($this$getPropertyKind_u24lambda_u241, CMakeStandardCommands.SET_PROPERTY_COMMAND_NAME) || CMakePsiUtils.isCommand($this$getPropertyKind_u24lambda_u241, CMakeStandardCommands.GET_PROPERTY) || CMakePsiUtils.isCommand($this$getPropertyKind_u24lambda_u241, CMakeStandardCommands.DEFINE_PROPERTY)) {
            propertyKind = CMakeDocumentationUtilKt.isProperty(argument, command);
        } else if (CMakePsiUtils.isCommand($this$getPropertyKind_u24lambda_u241, CMakeStandardCommands.GET_CMAKE_PROPERTY)) {
            propertyKind = CMakeDocumentationUtilKt.isGlobalProperty(argument);
        } else if (CMakePsiUtils.isCommand($this$getPropertyKind_u24lambda_u241, CMakeStandardCommands.SET_DIRECTORY_PROPERTIES) || CMakePsiUtils.isCommand($this$getPropertyKind_u24lambda_u241, CMakeStandardCommands.GET_DIRECTORY_PROPERTY)) {
            propertyKind = CMakeDocumentationUtilKt.isDirectoryProperty(argument, command);
        } else if (CMakePsiUtils.isCommand($this$getPropertyKind_u24lambda_u241, CMakeStandardCommands.SET_TARGET_PROPERTIES) || CMakePsiUtils.isCommand($this$getPropertyKind_u24lambda_u241, CMakeStandardCommands.GET_TARGET_PROPERTY)) {
            propertyKind = CMakeDocumentationUtilKt.isTargetProperty(argument, command);
        } else if (CMakePsiUtils.isCommand($this$getPropertyKind_u24lambda_u241, CMakeStandardCommands.SET_SOURCE_FILES_PROPERTIES_COMMAND_NAME) || CMakePsiUtils.isCommand($this$getPropertyKind_u24lambda_u241, CMakeStandardCommands.GET_SOURCE_FILE_PROPERTY)) {
            propertyKind = CMakeDocumentationUtilKt.isSourceFileProperty(argument, command);
        } else if (CMakePsiUtils.isCommand($this$getPropertyKind_u24lambda_u241, CMakeStandardCommands.SET_TESTS_PROPERTIES) || CMakePsiUtils.isCommand($this$getPropertyKind_u24lambda_u241, CMakeStandardCommands.GET_TEST_PROPERTY)) {
            propertyKind = CMakeDocumentationUtilKt.isTestProperty(argument, command);
        } else {
            return null;
        }
        return propertyKind;
    }

    private static final PropertyKind isProperty(CMakeArgument argument, CMakeCommand command) {
        CMakeCommand $this$isProperty_u24lambda_u242 = command;
        boolean bl = false;
        CMakeArgument kindArgument = CMakePsiUtils.isCommand($this$isProperty_u24lambda_u242, CMakeStandardCommands.SET_PROPERTY_COMMAND_NAME) ? command.getFirstArgument() : (CMakePsiUtils.isCommand($this$isProperty_u24lambda_u242, CMakeStandardCommands.GET_PROPERTY) || CMakePsiUtils.isCommand($this$isProperty_u24lambda_u242, CMakeStandardCommands.DEFINE_PROPERTY) ? CMakePsiUtils.secondArgument(command) : null);
        if (kindArgument == null) {
            return null;
        }
        String string = kindArgument.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String string2 = string.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
        PropertyKind kind = switch (string2) {
            case CMAKE_GLOBAL_PROPERTY_ARG -> PropertyKind.GLOBAL_PROPERTY;
            case CMAKE_DIRECTORY_PROPERTY_ARG -> PropertyKind.DIRECTORY_PROPERTY;
            case CMAKE_TARGET_PROPERTY_ARG -> PropertyKind.TARGET_PROPERTY;
            case CMAKE_SOURCE_PROPERTY_ARG -> PropertyKind.SOURCE_PROPERTY;
            case CMAKE_INSTALL_PROPERTY_ARG -> PropertyKind.INSTALL_PROPERTY;
            case CMAKE_TEST_PROPERTY_ARG -> PropertyKind.TEST_PROPERTY;
            case CMAKE_CACHE_PROPERTY_ARG -> PropertyKind.CACHE_PROPERTY;
            default -> null;
        };
        CMakeArgument prevArgument = argument.getPreviousArgument();
        if (prevArgument == null || !StringsKt.equals((String)prevArgument.getText(), (String)CMAKE_PROPERTY_ARG, (boolean)true)) {
            return null;
        }
        return kind;
    }

    private static final PropertyKind isGlobalProperty(CMakeArgument argument) {
        if (CMakePsiUtils.isNotLastArgument(argument)) {
            return null;
        }
        return PropertyKind.GLOBAL_PROPERTY;
    }

    private static final PropertyKind isDirectoryProperty(CMakeArgument argument, CMakeCommand command) {
        block6: {
            block8: {
                block7: {
                    block5: {
                        if (!CMakePsiUtils.isCommand(command, CMakeStandardCommands.SET_DIRECTORY_PROPERTIES)) break block5;
                        if (CMakeDocumentationUtilKt.findPreviousPropertiesArgument(argument) != null) {
                            return PropertyKind.DIRECTORY_PROPERTY;
                        }
                        break block6;
                    }
                    if (!CMakePsiUtils.isCommand(command, CMakeStandardCommands.GET_DIRECTORY_PROPERTY)) break block6;
                    if (CMakePsiUtils.isNotLastArgument(argument)) break block7;
                    CMakeArgument cMakeArgument = argument.getPreviousArgument();
                    if (!Intrinsics.areEqual((Object)(cMakeArgument != null ? cMakeArgument.getText() : null), (Object)CMAKE_DEFINITION_ARG) || argument.getParentCommandArguments().getCMakeArgumentList().size() != 5) break block8;
                }
                return null;
            }
            return PropertyKind.DIRECTORY_PROPERTY;
        }
        return null;
    }

    private static final PropertyKind isTargetProperty(CMakeArgument argument, CMakeCommand command) {
        if (CMakePsiUtils.isCommand(command, CMakeStandardCommands.SET_TARGET_PROPERTIES)) {
            if (CMakeDocumentationUtilKt.findPreviousPropertiesArgument(argument) != null) {
                return PropertyKind.TARGET_PROPERTY;
            }
        } else if (CMakePsiUtils.isCommand(command, CMakeStandardCommands.GET_TARGET_PROPERTY)) {
            if (CMakePsiUtils.isNotLastArgument(argument)) {
                return null;
            }
            return PropertyKind.TARGET_PROPERTY;
        }
        return null;
    }

    private static final PropertyKind isSourceFileProperty(CMakeArgument argument, CMakeCommand command) {
        if (CMakePsiUtils.isCommand(command, CMakeStandardCommands.SET_SOURCE_FILES_PROPERTIES_COMMAND_NAME)) {
            if (CMakeDocumentationUtilKt.findPreviousPropertiesArgument(argument) != null) {
                return PropertyKind.SOURCE_PROPERTY;
            }
        } else if (CMakePsiUtils.isCommand(command, CMakeStandardCommands.GET_SOURCE_FILE_PROPERTY)) {
            if (CMakePsiUtils.isNotLastArgument(argument)) {
                return null;
            }
            return PropertyKind.SOURCE_PROPERTY;
        }
        return null;
    }

    private static final PropertyKind isTestProperty(CMakeArgument argument, CMakeCommand command) {
        if (CMakePsiUtils.isCommand(command, CMakeStandardCommands.SET_TESTS_PROPERTIES)) {
            if (CMakeDocumentationUtilKt.findPreviousPropertiesArgument(argument) != null) {
                return PropertyKind.TEST_PROPERTY;
            }
        } else if (CMakePsiUtils.isCommand(command, CMakeStandardCommands.GET_TEST_PROPERTY)) {
            if (!CMakePsiUtils.isSecondArgument(argument)) {
                return null;
            }
            return PropertyKind.TEST_PROPERTY;
        }
        return null;
    }

    private static final List pygmentTokens_delegate$lambda$0() {
        Object[] objectArray = new PygmentsTokenAttribute[76];
        ColorKey colorKey = EditorColors.WHITESPACES_COLOR;
        Intrinsics.checkNotNullExpressionValue((Object)colorKey, (String)"WHITESPACES_COLOR");
        objectArray[0] = CMakeDocumentationUtilKt.token("w", colorKey);
        TextAttributesKey textAttributesKey = HighlighterColors.TEXT;
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"TEXT");
        objectArray[1] = CMakeDocumentationUtilKt.token("esc", textAttributesKey);
        IElementType iElementType = TokenType.BAD_CHARACTER;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"BAD_CHARACTER");
        objectArray[2] = CMakeDocumentationUtilKt.token("err", iElementType);
        TextAttributesKey textAttributesKey2 = HighlighterColors.TEXT;
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey2, (String)"TEXT");
        objectArray[3] = CMakeDocumentationUtilKt.token("x", textAttributesKey2);
        IElementType iElementType2 = CMakeTokenTypes.IF;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType2, (String)"IF");
        objectArray[4] = CMakeDocumentationUtilKt.token("k", iElementType2);
        IElementType iElementType3 = CMakeTokenTypes.LITERAL;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType3, (String)"LITERAL");
        objectArray[5] = CMakeDocumentationUtilKt.token("kc", iElementType3);
        IElementType iElementType4 = CMakeTokenTypes.IF;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType4, (String)"IF");
        objectArray[6] = CMakeDocumentationUtilKt.token("kd", iElementType4);
        IElementType iElementType5 = CMakeTokenTypes.IF;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType5, (String)"IF");
        objectArray[7] = CMakeDocumentationUtilKt.token("kn", iElementType5);
        IElementType iElementType6 = CMakeTokenTypes.IF;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType6, (String)"IF");
        objectArray[8] = CMakeDocumentationUtilKt.token("kp", iElementType6);
        IElementType iElementType7 = CMakeTokenTypes.IF;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType7, (String)"IF");
        objectArray[9] = CMakeDocumentationUtilKt.token("kr", iElementType7);
        IElementType iElementType8 = CMakeTokenTypes.IF;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType8, (String)"IF");
        objectArray[10] = CMakeDocumentationUtilKt.token("kt", iElementType8);
        IElementType iElementType9 = CMakeTokenTypes.ID;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType9, (String)"ID");
        objectArray[11] = CMakeDocumentationUtilKt.token("n", iElementType9);
        IElementType iElementType10 = CMakeTokenTypes.LITERAL;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType10, (String)"LITERAL");
        objectArray[12] = CMakeDocumentationUtilKt.token("na", iElementType10);
        IElementType iElementType11 = CMakeTokenTypes.LITERAL;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType11, (String)"LITERAL");
        objectArray[13] = CMakeDocumentationUtilKt.token("nb", iElementType11);
        IElementType iElementType12 = CMakeTokenTypes.LITERAL;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType12, (String)"LITERAL");
        objectArray[14] = CMakeDocumentationUtilKt.token("bp", iElementType12);
        IElementType iElementType13 = CMakeTokenTypes.LITERAL;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType13, (String)"LITERAL");
        objectArray[15] = CMakeDocumentationUtilKt.token("nc", iElementType13);
        IElementType iElementType14 = CMakeTokenTypes.LITERAL;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType14, (String)"LITERAL");
        objectArray[16] = CMakeDocumentationUtilKt.token("no", iElementType14);
        IElementType iElementType15 = CMakeTokenTypes.LITERAL;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType15, (String)"LITERAL");
        objectArray[17] = CMakeDocumentationUtilKt.token("nd", iElementType15);
        IElementType iElementType16 = CMakeTokenTypes.LITERAL;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType16, (String)"LITERAL");
        objectArray[18] = CMakeDocumentationUtilKt.token("ni", iElementType16);
        IElementType iElementType17 = CMakeTokenTypes.LITERAL;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType17, (String)"LITERAL");
        objectArray[19] = CMakeDocumentationUtilKt.token("ne", iElementType17);
        IElementType iElementType18 = CMakeTokenTypes.ID;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType18, (String)"ID");
        objectArray[20] = CMakeDocumentationUtilKt.token("nf", iElementType18);
        IElementType iElementType19 = CMakeTokenTypes.ID;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType19, (String)"ID");
        objectArray[21] = CMakeDocumentationUtilKt.token("fm", iElementType19);
        IElementType iElementType20 = CMakeTokenTypes.LITERAL;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType20, (String)"LITERAL");
        objectArray[22] = CMakeDocumentationUtilKt.token("py", iElementType20);
        IElementType iElementType21 = CMakeTokenTypes.LITERAL;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType21, (String)"LITERAL");
        objectArray[23] = CMakeDocumentationUtilKt.token("nl", iElementType21);
        IElementType iElementType22 = CMakeTokenTypes.LITERAL;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType22, (String)"LITERAL");
        objectArray[24] = CMakeDocumentationUtilKt.token("nn", iElementType22);
        IElementType iElementType23 = CMakeTokenTypes.LITERAL;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType23, (String)"LITERAL");
        objectArray[25] = CMakeDocumentationUtilKt.token("nx", iElementType23);
        IElementType iElementType24 = CMakeTokenTypes.LITERAL;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType24, (String)"LITERAL");
        objectArray[26] = CMakeDocumentationUtilKt.token("nt", iElementType24);
        IElementType iElementType25 = CMakeTokenTypes.LITERAL;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType25, (String)"LITERAL");
        objectArray[27] = CMakeDocumentationUtilKt.token("nv", iElementType25);
        IElementType iElementType26 = CMakeTokenTypes.LITERAL;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType26, (String)"LITERAL");
        objectArray[28] = CMakeDocumentationUtilKt.token("vc", iElementType26);
        IElementType iElementType27 = CMakeTokenTypes.LITERAL;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType27, (String)"LITERAL");
        objectArray[29] = CMakeDocumentationUtilKt.token("vg", iElementType27);
        IElementType iElementType28 = CMakeTokenTypes.LITERAL;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType28, (String)"LITERAL");
        objectArray[30] = CMakeDocumentationUtilKt.token("vi", iElementType28);
        IElementType iElementType29 = CMakeTokenTypes.LITERAL;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType29, (String)"LITERAL");
        objectArray[31] = CMakeDocumentationUtilKt.token("vm", iElementType29);
        IElementType iElementType30 = CMakeTokenTypes.LITERAL;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType30, (String)"LITERAL");
        objectArray[32] = CMakeDocumentationUtilKt.token("l", iElementType30);
        IElementType iElementType31 = CMakeTokenTypes.LITERAL;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType31, (String)"LITERAL");
        objectArray[33] = CMakeDocumentationUtilKt.token("ld", iElementType31);
        IElementType iElementType32 = CMakeTokenTypes.LITERAL;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType32, (String)"LITERAL");
        objectArray[34] = CMakeDocumentationUtilKt.token("s", iElementType32);
        IElementType iElementType33 = CMakeTokenTypes.LITERAL;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType33, (String)"LITERAL");
        objectArray[35] = CMakeDocumentationUtilKt.token("sa", iElementType33);
        IElementType iElementType34 = CMakeTokenTypes.LITERAL;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType34, (String)"LITERAL");
        objectArray[36] = CMakeDocumentationUtilKt.token("sb", iElementType34);
        IElementType iElementType35 = CMakeTokenTypes.LITERAL;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType35, (String)"LITERAL");
        objectArray[37] = CMakeDocumentationUtilKt.token("sc", iElementType35);
        IElementType iElementType36 = CMakeTokenTypes.LITERAL;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType36, (String)"LITERAL");
        objectArray[38] = CMakeDocumentationUtilKt.token("dl", iElementType36);
        IElementType iElementType37 = CMakeTokenTypes.LITERAL;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType37, (String)"LITERAL");
        objectArray[39] = CMakeDocumentationUtilKt.token("sd", iElementType37);
        IElementType iElementType38 = CMakeTokenTypes.LITERAL;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType38, (String)"LITERAL");
        objectArray[40] = CMakeDocumentationUtilKt.token("s2", iElementType38);
        IElementType iElementType39 = CMakeTokenTypes.LITERAL;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType39, (String)"LITERAL");
        objectArray[41] = CMakeDocumentationUtilKt.token("se", iElementType39);
        IElementType iElementType40 = CMakeTokenTypes.LITERAL;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType40, (String)"LITERAL");
        objectArray[42] = CMakeDocumentationUtilKt.token("sh", iElementType40);
        IElementType iElementType41 = CMakeTokenTypes.LITERAL;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType41, (String)"LITERAL");
        objectArray[43] = CMakeDocumentationUtilKt.token("si", iElementType41);
        IElementType iElementType42 = CMakeTokenTypes.LITERAL;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType42, (String)"LITERAL");
        objectArray[44] = CMakeDocumentationUtilKt.token("sx", iElementType42);
        IElementType iElementType43 = CMakeTokenTypes.LITERAL;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType43, (String)"LITERAL");
        objectArray[45] = CMakeDocumentationUtilKt.token("sr", iElementType43);
        IElementType iElementType44 = CMakeTokenTypes.LITERAL;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType44, (String)"LITERAL");
        objectArray[46] = CMakeDocumentationUtilKt.token("s1", iElementType44);
        IElementType iElementType45 = CMakeTokenTypes.LITERAL;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType45, (String)"LITERAL");
        objectArray[47] = CMakeDocumentationUtilKt.token("ss", iElementType45);
        IElementType iElementType46 = CMakeTokenTypes.LITERAL;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType46, (String)"LITERAL");
        objectArray[48] = CMakeDocumentationUtilKt.token("m", iElementType46);
        IElementType iElementType47 = CMakeTokenTypes.LITERAL;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType47, (String)"LITERAL");
        objectArray[49] = CMakeDocumentationUtilKt.token("mb", iElementType47);
        IElementType iElementType48 = CMakeTokenTypes.LITERAL;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType48, (String)"LITERAL");
        objectArray[50] = CMakeDocumentationUtilKt.token("mf", iElementType48);
        IElementType iElementType49 = CMakeTokenTypes.LITERAL;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType49, (String)"LITERAL");
        objectArray[51] = CMakeDocumentationUtilKt.token("mh", iElementType49);
        IElementType iElementType50 = CMakeTokenTypes.LITERAL;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType50, (String)"LITERAL");
        objectArray[52] = CMakeDocumentationUtilKt.token("mi", iElementType50);
        IElementType iElementType51 = CMakeTokenTypes.LITERAL;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType51, (String)"LITERAL");
        objectArray[53] = CMakeDocumentationUtilKt.token("il", iElementType51);
        IElementType iElementType52 = CMakeTokenTypes.LITERAL;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType52, (String)"LITERAL");
        objectArray[54] = CMakeDocumentationUtilKt.token("mo", iElementType52);
        CMakeElementType cMakeElementType = CMakeVarReferenceLexer.VAR_REFERENCE_START;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)cMakeElementType), (String)"VAR_REFERENCE_START");
        objectArray[55] = CMakeDocumentationUtilKt.token("o", cMakeElementType);
        CMakeElementType cMakeElementType2 = CMakeVarReferenceLexer.VAR_REFERENCE_START;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)cMakeElementType2), (String)"VAR_REFERENCE_START");
        objectArray[56] = CMakeDocumentationUtilKt.token("ow", cMakeElementType2);
        IElementType iElementType53 = CMakeTokenTypes.LITERAL;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType53, (String)"LITERAL");
        objectArray[57] = CMakeDocumentationUtilKt.token("p", iElementType53);
        IElementType iElementType54 = CMakeTokenTypes.COMMENT;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType54, (String)"COMMENT");
        objectArray[58] = CMakeDocumentationUtilKt.token("c", iElementType54);
        IElementType iElementType55 = CMakeTokenTypes.COMMENT;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType55, (String)"COMMENT");
        objectArray[59] = CMakeDocumentationUtilKt.token("ch", iElementType55);
        IElementType iElementType56 = CMakeTokenTypes.COMMENT;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType56, (String)"COMMENT");
        objectArray[60] = CMakeDocumentationUtilKt.token("cm", iElementType56);
        IElementType iElementType57 = CMakeTokenTypes.COMMENT;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType57, (String)"COMMENT");
        objectArray[61] = CMakeDocumentationUtilKt.token("cp", iElementType57);
        IElementType iElementType58 = CMakeTokenTypes.COMMENT;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType58, (String)"COMMENT");
        objectArray[62] = CMakeDocumentationUtilKt.token("cpf", iElementType58);
        IElementType iElementType59 = CMakeTokenTypes.COMMENT;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType59, (String)"COMMENT");
        objectArray[63] = CMakeDocumentationUtilKt.token("c1", iElementType59);
        IElementType iElementType60 = CMakeTokenTypes.COMMENT;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType60, (String)"COMMENT");
        objectArray[64] = CMakeDocumentationUtilKt.token("cs", iElementType60);
        TextAttributesKey textAttributesKey3 = HighlighterColors.TEXT;
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey3, (String)"TEXT");
        objectArray[65] = CMakeDocumentationUtilKt.token("g", textAttributesKey3);
        TextAttributesKey textAttributesKey4 = HighlighterColors.TEXT;
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey4, (String)"TEXT");
        objectArray[66] = CMakeDocumentationUtilKt.token("gd", textAttributesKey4);
        TextAttributesKey textAttributesKey5 = HighlighterColors.TEXT;
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey5, (String)"TEXT");
        objectArray[67] = CMakeDocumentationUtilKt.token("ge", textAttributesKey5);
        TextAttributesKey textAttributesKey6 = HighlighterColors.TEXT;
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey6, (String)"TEXT");
        objectArray[68] = CMakeDocumentationUtilKt.token("gr", textAttributesKey6);
        TextAttributesKey textAttributesKey7 = HighlighterColors.TEXT;
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey7, (String)"TEXT");
        objectArray[69] = CMakeDocumentationUtilKt.token("gh", textAttributesKey7);
        TextAttributesKey textAttributesKey8 = HighlighterColors.TEXT;
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey8, (String)"TEXT");
        objectArray[70] = CMakeDocumentationUtilKt.token("gi", textAttributesKey8);
        TextAttributesKey textAttributesKey9 = HighlighterColors.TEXT;
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey9, (String)"TEXT");
        objectArray[71] = CMakeDocumentationUtilKt.token("go", textAttributesKey9);
        TextAttributesKey textAttributesKey10 = HighlighterColors.TEXT;
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey10, (String)"TEXT");
        objectArray[72] = CMakeDocumentationUtilKt.token("gp", textAttributesKey10);
        TextAttributesKey textAttributesKey11 = HighlighterColors.TEXT;
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey11, (String)"TEXT");
        objectArray[73] = CMakeDocumentationUtilKt.token("gs", textAttributesKey11);
        TextAttributesKey textAttributesKey12 = HighlighterColors.TEXT;
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey12, (String)"TEXT");
        objectArray[74] = CMakeDocumentationUtilKt.token("gu", textAttributesKey12);
        TextAttributesKey textAttributesKey13 = HighlighterColors.TEXT;
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey13, (String)"TEXT");
        objectArray[75] = CMakeDocumentationUtilKt.token("gt", textAttributesKey13);
        return CollectionsKt.listOf((Object[])objectArray);
    }
}

