/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.compiler;

import com.jetbrains.cidr.lang.OCLanguageMacroFeature;
import com.jetbrains.cidr.lang.OCLibraryMacroFeature;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerBase;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010!\n\u0002\b\u0007\u001a2\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00160\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00160 2\u000e\u0010!\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00160\"\u001a\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00160\u001e\"\u001b\u0010\u0000\u001a\u00020\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0005\u001a\u0004\b\u0002\u0010\u0003\"\u001b\u0010\u0006\u001a\u00020\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\u0005\u001a\u0004\b\u0007\u0010\u0003\"\u001b\u0010\t\u001a\u00020\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\u0005\u001a\u0004\b\n\u0010\u0003\"\u001b\u0010\f\u001a\u00020\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u0005\u001a\u0004\b\r\u0010\u0003\"\u001b\u0010\u000f\u001a\u00020\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0005\u001a\u0004\b\u0010\u0010\u0003\"\u001b\u0010\u0012\u001a\u00020\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0005\u001a\u0004\b\u0013\u0010\u0003\"\u000e\u0010\u0015\u001a\u00020\u0016X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u0017\u001a\n \u0019*\u0004\u0018\u00010\u00180\u0018X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001a\"\u0010\u0010$\u001a\u00020\u00168\u0002X\u0083T\u00a2\u0006\u0002\n\u0000\"\u0010\u0010%\u001a\u00020\u00168\u0002X\u0083T\u00a2\u0006\u0002\n\u0000\"\u0010\u0010&\u001a\u00020\u00168\u0002X\u0083T\u00a2\u0006\u0002\n\u0000\"\u0010\u0010'\u001a\u00020\u00168\u0002X\u0083T\u00a2\u0006\u0002\n\u0000\"\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00160\u001e8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"MSVC_VERSION_RE", "Lkotlin/text/Regex;", "getMSVC_VERSION_RE", "()Lkotlin/text/Regex;", "MSVC_VERSION_RE$delegate", "Lkotlin/Lazy;", "MSC_VER_RE", "getMSC_VER_RE", "MSC_VER_RE$delegate", "MSVC_TRADITIONAL_RE", "getMSVC_TRADITIONAL_RE", "MSVC_TRADITIONAL_RE$delegate", "WIN_64_RE", "getWIN_64_RE", "WIN_64_RE$delegate", "DEFINE_PREFIX_RE", "getDEFINE_PREFIX_RE", "DEFINE_PREFIX_RE$delegate", "INCLUDE_FILE_RE", "getINCLUDE_FILE_RE", "INCLUDE_FILE_RE$delegate", "MSVC_MODULES_JSON_FILENAME", "", "CANT_OPEN_FILE_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "Ljava/util/regex/Pattern;", "collectMSVCSkipOptions", "", "lines", "", "skipOptions", "", "warnLog", "", "getBuiltinMacrosNames", "DEFINES_START", "DEFINES_END", "DEFINE_PREFIX", "FAKE_NO_ALTERNATIVE_OPERATORS_MACRO", "BUILT_IN_MACROS", "intellij.cidr.projectModel"})
public final class MSVCCompilerKt {
    @NotNull
    private static final Lazy MSVC_VERSION_RE$delegate = LazyKt.lazy(MSVCCompilerKt::MSVC_VERSION_RE_delegate$lambda$0);
    @NotNull
    private static final Lazy MSC_VER_RE$delegate = LazyKt.lazy(MSVCCompilerKt::MSC_VER_RE_delegate$lambda$1);
    @NotNull
    private static final Lazy MSVC_TRADITIONAL_RE$delegate = LazyKt.lazy(MSVCCompilerKt::MSVC_TRADITIONAL_RE_delegate$lambda$2);
    @NotNull
    private static final Lazy WIN_64_RE$delegate = LazyKt.lazy(MSVCCompilerKt::WIN_64_RE_delegate$lambda$3);
    @NotNull
    private static final Lazy DEFINE_PREFIX_RE$delegate = LazyKt.lazy(MSVCCompilerKt::DEFINE_PREFIX_RE_delegate$lambda$4);
    @NotNull
    private static final Lazy INCLUDE_FILE_RE$delegate = LazyKt.lazy(MSVCCompilerKt::INCLUDE_FILE_RE_delegate$lambda$5);
    @NotNull
    private static final String MSVC_MODULES_JSON_FILENAME = "modules.json";
    private static final Pattern CANT_OPEN_FILE_PATTERN = Pattern.compile(".+fatal error (?:\\w+): Cannot open (?:source|include) file: '(.+)':.+");
    @NonNls
    @NotNull
    private static final String DEFINES_START = "__cidr_defines_start__\n";
    @NonNls
    @NotNull
    private static final String DEFINES_END = "__cidr_defines_end__\n";
    @NonNls
    @NotNull
    private static final String DEFINE_PREFIX = "__cidr_define_";
    @NonNls
    @NotNull
    private static final String FAKE_NO_ALTERNATIVE_OPERATORS_MACRO = "__CIDR_FAKE_ALTERNATIVE_OPERATORS_MACRO";
    @NonNls
    @NotNull
    private static final List<String> BUILT_IN_MACROS;

    private static final Regex getMSVC_VERSION_RE() {
        Lazy lazy = MSVC_VERSION_RE$delegate;
        return (Regex)lazy.getValue();
    }

    private static final Regex getMSC_VER_RE() {
        Lazy lazy = MSC_VER_RE$delegate;
        return (Regex)lazy.getValue();
    }

    private static final Regex getMSVC_TRADITIONAL_RE() {
        Lazy lazy = MSVC_TRADITIONAL_RE$delegate;
        return (Regex)lazy.getValue();
    }

    private static final Regex getWIN_64_RE() {
        Lazy lazy = WIN_64_RE$delegate;
        return (Regex)lazy.getValue();
    }

    private static final Regex getDEFINE_PREFIX_RE() {
        Lazy lazy = DEFINE_PREFIX_RE$delegate;
        return (Regex)lazy.getValue();
    }

    private static final Regex getINCLUDE_FILE_RE() {
        Lazy lazy = INCLUDE_FILE_RE$delegate;
        return (Regex)lazy.getValue();
    }

    public static final boolean collectMSVCSkipOptions(@NotNull List<String> lines, @NotNull Set<String> skipOptions, @NotNull List<? super String> warnLog) {
        Intrinsics.checkNotNullParameter(lines, (String)"lines");
        Intrinsics.checkNotNullParameter(skipOptions, (String)"skipOptions");
        Intrinsics.checkNotNullParameter(warnLog, (String)"warnLog");
        Pattern[] patternArray = new Pattern[]{CANT_OPEN_FILE_PATTERN};
        return OCCompilerBase.collectOptionsToSkip(lines, skipOptions, warnLog, patternArray);
    }

    @NotNull
    public static final List<String> getBuiltinMacrosNames() {
        return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)BUILT_IN_MACROS, (Iterable)OCLanguageMacroFeature.Companion.getALL()), (Iterable)OCLibraryMacroFeature.Companion.getALL());
    }

    private static final Regex MSVC_VERSION_RE_delegate$lambda$0() {
        Object[] objectArray = new RegexOption[]{RegexOption.DOT_MATCHES_ALL, RegexOption.MULTILINE};
        return new Regex(".+Version (.+?)$", SetsKt.mutableSetOf((Object[])objectArray));
    }

    private static final Regex MSC_VER_RE_delegate$lambda$1() {
        return new Regex("#define\\s+_MSC_VER\\s+(\\d+)");
    }

    private static final Regex MSVC_TRADITIONAL_RE_delegate$lambda$2() {
        return new Regex("#define\\s+_MSVC_TRADITIONAL\\s+(\\d+)");
    }

    private static final Regex WIN_64_RE_delegate$lambda$3() {
        return new Regex("#define\\s+_WIN64\\s+1");
    }

    private static final Regex DEFINE_PREFIX_RE_delegate$lambda$4() {
        return new Regex("^__cidr_define_", RegexOption.MULTILINE);
    }

    private static final Regex INCLUDE_FILE_RE_delegate$lambda$5() {
        return new Regex("#line [\\d]+ \"(.*)\"\\s*[\\r\\n]");
    }

    public static final /* synthetic */ Regex access$getDEFINE_PREFIX_RE() {
        return MSVCCompilerKt.getDEFINE_PREFIX_RE();
    }

    public static final /* synthetic */ Regex access$getINCLUDE_FILE_RE() {
        return MSVCCompilerKt.getINCLUDE_FILE_RE();
    }

    public static final /* synthetic */ Regex access$getMSC_VER_RE() {
        return MSVCCompilerKt.getMSC_VER_RE();
    }

    public static final /* synthetic */ Regex access$getWIN_64_RE() {
        return MSVCCompilerKt.getWIN_64_RE();
    }

    public static final /* synthetic */ Regex access$getMSVC_TRADITIONAL_RE() {
        return MSVCCompilerKt.getMSVC_TRADITIONAL_RE();
    }

    public static final /* synthetic */ Regex access$getMSVC_VERSION_RE() {
        return MSVCCompilerKt.getMSVC_VERSION_RE();
    }

    static {
        Object[] objectArray = new String[]{"__cplusplus", "__STDC__", "__STDC_HOSTED__", "__STDC_NO_ATOMICS__", "__STDC_NO_COMPLEX__", "__STDC_NO_THREADS__", "__STDC_NO_VLA__", "__STDC_VERSION__", "__STDCPP_DEFAULT_NEW_ALIGNMENT__", "__STDCPP_THREADS__", "__ARM_ARCH", "__ATOM__", "__AVX__", "__AVX2__", "__AVX512BW__", "__AVX512CD__", "__AVX512DQ__", "__AVX512F__", "__AVX512VL__", "__AVX10_VER__", "_CHAR_UNSIGNED", "__CLR_VER", "_CONTROL_FLOW_GUARD", "__cplusplus_cli", "__cplusplus_winrt", "_CPPRTTI", "_CPPUNWIND", "_DEBUG", "_DLL", "_INTEGRAL_MAX_BITS", "_ISO_VOLATILE", "_KERNEL_MODE", "_M_AMD64", "_M_ARM", "_M_ARM_ARMV7VE", "_M_ARM_FP", "_M_ARM64", "_M_CEE", "_M_CEE_PURE", "_M_CEE_SAFE", "_M_CEE_CONTRACT", "_M_FP_EXCEPT", "_M_FP_FAST", "_M_FP_PRECISE", "_M_FP_STRICT", "_M_IX86", "_M_IX86_FP", "_M_X64", "_MANAGED", "_MSC_BUILD", "_MSC_EXTENSIONS", "_MSC_FULL_VER", "_MSC_VER", "_MSVC_LANG", "__MSVC_RUNTIME_CHECKS", "_MSVC_TRADITIONAL", "_MT", "_NATIVE_WCHAR_T_DEFINED", "_OPENMP", "_PREFAST_", "__SANITIZE_ADDRESS__", "_VC_NODEFAULTLIB", "_WCHAR_T_DEFINED", "_WIN32", "_WIN64", "_WINRT_DLL", "_M_IA64", "_NATIVE_NULLPTR_SUPPORTED", "_RVALUE_REFERENCES_SUPPORTED", "_RVALUE_REFERENCES_V2_SUPPORTED", "__has_include", "__has_include_next", "__has_cpp_attribute"};
        BUILT_IN_MACROS = CollectionsKt.listOf((Object[])objectArray);
    }
}

