/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.compiler;

import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompilerSplitArgs {
    private final Map<String, String> myDefines;
    private final List<String> myIncludes;
    private final List<String> mySources;
    private final List<String> myUnrecognizedArgs;
    private final CidrCompilerSwitches myFilteredSwitches;
    private final boolean myHasPrecompiledOrImplicitHeaders;
    private static final String[] PRECOMPILED_OR_IMPLICIT_HEADER_PREFIXES = new String[]{"include", "include-pch", "Yc", "Yd", "YI", "Yu", "Fp", "FI"};

    private CompilerSplitArgs(@NotNull Map<String, String> defines, @NotNull List<String> includes, @NotNull List<String> sources, @NotNull List<String> unrecognizedArgs, @NotNull List<String> filteredArgs, boolean hasPrecompiledOrImplicitHeaders) {
        if (defines == null) {
            CompilerSplitArgs.$$$reportNull$$$0(0);
        }
        if (includes == null) {
            CompilerSplitArgs.$$$reportNull$$$0(1);
        }
        if (sources == null) {
            CompilerSplitArgs.$$$reportNull$$$0(2);
        }
        if (unrecognizedArgs == null) {
            CompilerSplitArgs.$$$reportNull$$$0(3);
        }
        if (filteredArgs == null) {
            CompilerSplitArgs.$$$reportNull$$$0(4);
        }
        this.myDefines = Collections.unmodifiableMap(defines);
        this.myIncludes = Collections.unmodifiableList(includes);
        this.mySources = Collections.unmodifiableList(sources);
        this.myUnrecognizedArgs = Collections.unmodifiableList(unrecognizedArgs);
        this.myFilteredSwitches = new CidrCompilerSwitches(filteredArgs);
        this.myHasPrecompiledOrImplicitHeaders = hasPrecompiledOrImplicitHeaders;
    }

    private static boolean isKey(String s, boolean isWindows) {
        if (s.length() < 2) {
            return false;
        }
        if (s.equals("-I-")) {
            return false;
        }
        if (isWindows && s.startsWith("/cygdrive")) {
            return false;
        }
        char c = s.charAt(0);
        return c == '/' && isWindows || c == '-';
    }

    public static CompilerSplitArgs parse(@NotNull CidrCompilerSwitches switches, @NotNull Set<ArgType> filteredArgTypes, boolean interruptIfPrecompiledHeaderFound, boolean isWindows) {
        if (switches == null) {
            CompilerSplitArgs.$$$reportNull$$$0(5);
        }
        if (filteredArgTypes == null) {
            CompilerSplitArgs.$$$reportNull$$$0(6);
        }
        return CompilerSplitArgs.parse(switches.getList(CidrCompilerSwitches.Format.RAW), filteredArgTypes, interruptIfPrecompiledHeaderFound, isWindows);
    }

    public static CompilerSplitArgs parse(@NotNull List<String> args, boolean isWindows) {
        if (args == null) {
            CompilerSplitArgs.$$$reportNull$$$0(7);
        }
        return CompilerSplitArgs.parse(args, null, false, isWindows);
    }

    private static CompilerSplitArgs parse(@NotNull List<String> args, @Nullable Set<ArgType> filteredArgTypes, boolean interruptIfPrecompiledHeaderFound, boolean isWindows) {
        if (args == null) {
            CompilerSplitArgs.$$$reportNull$$$0(8);
        }
        LinkedHashMap<String, String> defines = new LinkedHashMap<String, String>();
        ArrayList<String> includes = new ArrayList<String>();
        ArrayList<String> sources = new ArrayList<String>();
        ArrayList<String> unrecognizedArgs = new ArrayList<String>();
        boolean hasPrecompiledOrImplicitHeaders = false;
        Object[] filteredArgs = new String[args.size()];
        filteredArgs = args.toArray(filteredArgs);
        HashMap<ArgType, Function<String, Boolean>> actions = new HashMap<ArgType, Function<String, Boolean>>();
        actions.put(ArgType.DEFINE, value -> CompilerSplitArgs.processDefine(value, defines));
        actions.put(ArgType.INCLUDE, value -> includes.add((String)value));
        for (int i = 0; i < args.size(); ++i) {
            String arg = args.get(i).trim();
            if (CompilerSplitArgs.isKey(arg, isWindows)) {
                ArgType argType = ArgType.of(arg);
                if (argType != null) {
                    boolean needLookup;
                    boolean bl = needLookup = arg.length() == argType.keyLength;
                    String value2 = needLookup ? (++i < args.size() ? args.get(i).trim() : null) : arg.substring(argType.keyLength).trim();
                    if (value2 == null || CompilerSplitArgs.isKey(value2, isWindows) || !((Boolean)((Function)actions.get((Object)argType)).apply(value2)).booleanValue() || filteredArgTypes != null && !filteredArgTypes.contains((Object)argType)) continue;
                    filteredArgs[i] = null;
                    if (!needLookup) continue;
                    filteredArgs[i - 1] = null;
                    continue;
                }
                if (!hasPrecompiledOrImplicitHeaders) {
                    hasPrecompiledOrImplicitHeaders = CompilerSplitArgs.isPrecompiledOrImplicitHeaderArg(arg);
                    if (interruptIfPrecompiledHeaderFound && hasPrecompiledOrImplicitHeaders) break;
                }
                unrecognizedArgs.add(arg);
                continue;
            }
            if (CompilerSplitArgs.isCExtension(arg) || CompilerSplitArgs.isCppExtension(arg)) {
                sources.add(arg);
                continue;
            }
            unrecognizedArgs.add(arg);
        }
        return new CompilerSplitArgs(defines, includes, sources, unrecognizedArgs, new ArrayList<String>(ContainerUtil.mapNotNull((Object[])filteredArgs, it -> it)), hasPrecompiledOrImplicitHeaders);
    }

    private static boolean processDefine(@NotNull String value, @NotNull Map<String, String> defines) {
        int length;
        if (value == null) {
            CompilerSplitArgs.$$$reportNull$$$0(9);
        }
        if (defines == null) {
            CompilerSplitArgs.$$$reportNull$$$0(10);
        }
        if ((length = value.length()) > 1 && value.startsWith("\"") && value.endsWith("\"")) {
            value = value.substring(1, value.length() - 1);
        }
        int eqIdxEq = value.indexOf(61);
        int eqIdxHash = value.indexOf(35);
        int eqIdx = eqIdxEq >= 0 && eqIdxHash >= 0 ? Math.min(eqIdxEq, eqIdxHash) : Math.max(eqIdxEq, eqIdxHash);
        if (eqIdx > 0) {
            defines.put(value.substring(0, eqIdx).trim(), value.substring(eqIdx + 1).trim());
        } else {
            defines.put(value.trim(), "");
        }
        return true;
    }

    private static boolean isPrecompiledOrImplicitHeaderArg(@NotNull String arg) {
        if (arg == null) {
            CompilerSplitArgs.$$$reportNull$$$0(11);
        }
        arg = arg.startsWith("--") ? arg.substring(2) : arg.substring(1);
        for (String prefix : PRECOMPILED_OR_IMPLICIT_HEADER_PREFIXES) {
            if (!arg.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public static boolean isCppExtension(String s) {
        String lowerCase = s.toLowerCase(Locale.ROOT);
        return lowerCase.endsWith(".c++") || lowerCase.endsWith(".cpp") || lowerCase.endsWith(".cc") || lowerCase.endsWith(".cxx");
    }

    public static boolean isCExtension(String s) {
        return s.endsWith(".c") || s.endsWith(".C");
    }

    public Map<String, String> getDefines() {
        return this.myDefines;
    }

    public List<String> getIncludes() {
        return this.myIncludes;
    }

    public List<String> getSources() {
        return this.mySources;
    }

    public List<String> getUnrecognizedArgs() {
        return this.myUnrecognizedArgs;
    }

    public CidrCompilerSwitches getFilteredSwitches() {
        return this.myFilteredSwitches;
    }

    public boolean hasPrecompiledOrImplicitHeaders() {
        return this.myHasPrecompiledOrImplicitHeaders;
    }

    public String toString() {
        return "CompilerSplitArgs{defines=" + this.myDefines + ", includes=" + this.myIncludes + ", sources=" + this.mySources + ", unrecognized args=" + this.myUnrecognizedArgs + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defines";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "includes";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sources";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unrecognizedArgs";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filteredArgs";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switches";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filteredArgTypes";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arg";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/workspace/compiler/CompilerSplitArgs";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "parse";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "processDefine";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "isPrecompiledOrImplicitHeaderArg";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum ArgType {
        INCLUDE("I"),
        DEFINE("D");

        final String key;
        final int keyLength;

        private ArgType(String key) {
            this.key = key;
            this.keyLength = key.length() + 1;
        }

        @Nullable
        private static ArgType of(@NotNull String arg) {
            if (arg == null) {
                ArgType.$$$reportNull$$$0(0);
            }
            for (ArgType argType : ArgType.values()) {
                if (!arg.startsWith(argType.key, 1)) continue;
                return argType;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arg", "com/jetbrains/cidr/lang/workspace/compiler/CompilerSplitArgs$ArgType", "of"));
        }
    }
}

