/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.compiler;

import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.system.OS;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceImplUtilKt;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceInterner;
import com.jetbrains.cidr.lang.workspace.compiler.CachedTempFilesPool;
import com.jetbrains.cidr.lang.workspace.compiler.CompilerInfo;
import com.jetbrains.cidr.lang.workspace.compiler.CompilerInfoEventCollector;
import com.jetbrains.cidr.lang.workspace.compiler.CompilerSettingsKey;
import com.jetbrains.cidr.lang.workspace.compiler.CompilerSplitArgs;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompiler;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerBase;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.TempFilesPool;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchPath;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchPathTree;
import com.jetbrains.cidr.lang.workspace.moduleRoots.ModuleSearchPath;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.util.events.CidrEventSpan;
import java.io.File;
import java.lang.invoke.CallSite;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class CompilerInfoCache {
    @NotNull
    private static final Logger LOG = Logger.getInstance(CompilerInfoCache.class);
    private static final ExecutorService ourExecutor = CompilerInfoCache.createExecutor(CompilerInfoCache.defaultMaxProcesses(Runtime.getRuntime().availableProcessors()));
    @NotNull
    protected final Map<CompilerSettingsKey, Result> myCache = this.createCacheMap();
    @NotNull
    private final Map<CompilerSettingsKey, CompletableFuture<Result>> myInProcess = new HashMap<CompilerSettingsKey, CompletableFuture<Result>>();
    @NotNull
    protected final Object myLock = new Object();

    static int defaultMaxProcesses(int availableProcessors) {
        return Math.max(1, (int)Math.floor((double)availableProcessors * 0.8));
    }

    @NotNull
    static ExecutorService createExecutor(int maxProcesses) {
        int registryValue = Registry.intValue((String)"cidr.compiler.info.cache.pool.size");
        ExecutorService executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"CompilerInfoCache Pool", (int)(registryValue < 1 ? maxProcesses : registryValue));
        if (executorService == null) {
            CompilerInfoCache.$$$reportNull$$$0(0);
        }
        return executorService;
    }

    public static <ID extends Comparable<ID>> void flushConsoleMessages(@NotNull @NonNls String prefix, @NotNull Message.Type flushMessagesType, @NotNull MultiMap<ID, Message> messages, @NotNull BiConsumer<ID, String> messagesCollector) {
        if (prefix == null) {
            CompilerInfoCache.$$$reportNull$$$0(1);
        }
        if (flushMessagesType == null) {
            CompilerInfoCache.$$$reportNull$$$0(2);
        }
        if (messages == null) {
            CompilerInfoCache.$$$reportNull$$$0(3);
        }
        if (messagesCollector == null) {
            CompilerInfoCache.$$$reportNull$$$0(4);
        }
        for (Map.Entry entry : ContainerUtil.sorted((Collection)messages.entrySet(), Map.Entry.comparingByKey())) {
            List filtered = ContainerUtil.mapNotNull((Collection)((Collection)entry.getValue()), it -> it.getType() == flushMessagesType ? it.getText() : null);
            if (filtered.isEmpty()) continue;
            LinkedHashSet unique = new LinkedHashSet(filtered);
            String text = "\n" + prefix + ":\n\t" + StringUtil.replace((String)String.join((CharSequence)"\n", unique), (String)"\n", (String)"\n\t");
            messagesCollector.accept((Comparable)entry.getKey(), text);
        }
    }

    @NotNull
    protected Map<CompilerSettingsKey, Result> createCacheMap() {
        return new ConcurrentHashMap<CompilerSettingsKey, Result>();
    }

    @TestOnly
    @NotNull
    public Result getCompilerInfo(@NotNull Project project, @NotNull OCLanguageKind lang, @NotNull CidrCompilerSwitches switches, @NotNull OCCompilerKind compilerKind, @NotNull File compilerExecutable, @NotNull File compilerWorkingDirectory, @NotNull CidrToolEnvironment environment, @NotNull OCWorkspaceInterner interner) {
        if (project == null) {
            CompilerInfoCache.$$$reportNull$$$0(5);
        }
        if (lang == null) {
            CompilerInfoCache.$$$reportNull$$$0(6);
        }
        if (switches == null) {
            CompilerInfoCache.$$$reportNull$$$0(7);
        }
        if (compilerKind == null) {
            CompilerInfoCache.$$$reportNull$$$0(8);
        }
        if (compilerExecutable == null) {
            CompilerInfoCache.$$$reportNull$$$0(9);
        }
        if (compilerWorkingDirectory == null) {
            CompilerInfoCache.$$$reportNull$$$0(10);
        }
        if (environment == null) {
            CompilerInfoCache.$$$reportNull$$$0(11);
        }
        if (interner == null) {
            CompilerInfoCache.$$$reportNull$$$0(12);
        }
        CompilerSettingsKey key = interner.intern(CompilerInfoCache.createCompilerKey(lang, switches, compilerExecutable, compilerWorkingDirectory), oldKey -> new CompilerSettingsKey(interner.intern(oldKey.getValue())));
        OCCompiler compiler = OCCompilerBase.getCompilerInstance(project, compilerKind, compilerExecutable, compilerWorkingDirectory, environment, TempFilesPool.INSTANCE);
        Result result2 = this.getCompilerInfo(interner, project, compiler, lang, key, switches, ourExecutor, environment, "");
        if (result2 == null) {
            CompilerInfoCache.$$$reportNull$$$0(13);
        }
        return result2;
    }

    @NotNull
    public CompletableFuture<Result> getCompilerInfoAsync(@NotNull Project project, @NotNull OCLanguageKind lang, @NotNull CidrCompilerSwitches switches, @NotNull OCCompilerKind compilerKind, @NotNull File compilerExecutable, @NotNull File compilerWorkingDirectory, @NotNull CidrToolEnvironment environment, @NotNull Executor executor, @NotNull TempFilesPool tempFilesPool, @NotNull OCWorkspaceInterner interner, @NotNull String projectPath) {
        if (project == null) {
            CompilerInfoCache.$$$reportNull$$$0(14);
        }
        if (lang == null) {
            CompilerInfoCache.$$$reportNull$$$0(15);
        }
        if (switches == null) {
            CompilerInfoCache.$$$reportNull$$$0(16);
        }
        if (compilerKind == null) {
            CompilerInfoCache.$$$reportNull$$$0(17);
        }
        if (compilerExecutable == null) {
            CompilerInfoCache.$$$reportNull$$$0(18);
        }
        if (compilerWorkingDirectory == null) {
            CompilerInfoCache.$$$reportNull$$$0(19);
        }
        if (environment == null) {
            CompilerInfoCache.$$$reportNull$$$0(20);
        }
        if (executor == null) {
            CompilerInfoCache.$$$reportNull$$$0(21);
        }
        if (tempFilesPool == null) {
            CompilerInfoCache.$$$reportNull$$$0(22);
        }
        if (interner == null) {
            CompilerInfoCache.$$$reportNull$$$0(23);
        }
        if (projectPath == null) {
            CompilerInfoCache.$$$reportNull$$$0(24);
        }
        CompilerSettingsKey key = interner.intern(CompilerInfoCache.createCompilerKey(lang, switches, compilerExecutable, compilerWorkingDirectory));
        OCCompiler compiler = OCCompilerBase.getCompilerInstance(project, compilerKind, compilerExecutable, compilerWorkingDirectory, environment, tempFilesPool);
        CompletableFuture<Result> completableFuture = this.getCompilerInfoAsync(interner, project, compiler, lang, key, switches, executor, environment, projectPath);
        if (completableFuture == null) {
            CompilerInfoCache.$$$reportNull$$$0(25);
        }
        return completableFuture;
    }

    @NotNull
    public static CompilerSettingsKey createCompilerKey(@NotNull OCLanguageKind lang, @NotNull CidrCompilerSwitches switches, @NotNull File compilerExecutable, @NotNull File compilerWorkingDirectory) {
        if (lang == null) {
            CompilerInfoCache.$$$reportNull$$$0(26);
        }
        if (switches == null) {
            CompilerInfoCache.$$$reportNull$$$0(27);
        }
        if (compilerExecutable == null) {
            CompilerInfoCache.$$$reportNull$$$0(28);
        }
        if (compilerWorkingDirectory == null) {
            CompilerInfoCache.$$$reportNull$$$0(29);
        }
        StringBuilder builder = new StringBuilder().append(compilerExecutable.getPath()).append("\u0000").append(compilerWorkingDirectory).append("\u0000").append(lang.getDisplayName()).append("\u0000");
        StringUtil.join(switches.getList(CidrCompilerSwitches.Format.RAW), (String)"\u0000", (StringBuilder)builder);
        return new CompilerSettingsKey(builder.toString());
    }

    @NotNull
    Result getCompilerInfo(@NotNull OCWorkspaceInterner interner, @NotNull Project project, @NotNull OCCompiler compiler, @NotNull OCLanguageKind lang, @NotNull CompilerSettingsKey key, @NotNull CidrCompilerSwitches switches, @NotNull Executor executor, @NotNull CidrToolEnvironment env, @NotNull String projectPath) {
        if (interner == null) {
            CompilerInfoCache.$$$reportNull$$$0(30);
        }
        if (project == null) {
            CompilerInfoCache.$$$reportNull$$$0(31);
        }
        if (compiler == null) {
            CompilerInfoCache.$$$reportNull$$$0(32);
        }
        if (lang == null) {
            CompilerInfoCache.$$$reportNull$$$0(33);
        }
        if (key == null) {
            CompilerInfoCache.$$$reportNull$$$0(34);
        }
        if (switches == null) {
            CompilerInfoCache.$$$reportNull$$$0(35);
        }
        if (executor == null) {
            CompilerInfoCache.$$$reportNull$$$0(36);
        }
        if (env == null) {
            CompilerInfoCache.$$$reportNull$$$0(37);
        }
        if (projectPath == null) {
            CompilerInfoCache.$$$reportNull$$$0(38);
        }
        CompletableFuture<Result> future = this.getCompilerInfoAsync(interner, project, compiler, lang, key, switches, executor, env, projectPath);
        while (true) {
            Result result2;
            ProgressManager.checkCanceled();
            try {
                result2 = future.get(100L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                throw new ProcessCanceledException();
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
            catch (TimeoutException timeoutException) {
                continue;
            }
            if (result2 == null) {
                CompilerInfoCache.$$$reportNull$$$0(39);
            }
            return result2;
            break;
        }
    }

    @NotNull
    CompletableFuture<Result> getCompilerInfoAsync(@NotNull OCWorkspaceInterner interner, @NotNull Project project, @NotNull OCCompiler compiler, @NotNull OCLanguageKind lang, @NotNull CompilerSettingsKey originalKey, @NotNull CidrCompilerSwitches originalSwitches, @NotNull Executor executor, @NotNull CidrToolEnvironment env, @NotNull String projectPath) {
        CompletionStage future;
        if (interner == null) {
            CompilerInfoCache.$$$reportNull$$$0(40);
        }
        if (project == null) {
            CompilerInfoCache.$$$reportNull$$$0(41);
        }
        if (compiler == null) {
            CompilerInfoCache.$$$reportNull$$$0(42);
        }
        if (lang == null) {
            CompilerInfoCache.$$$reportNull$$$0(43);
        }
        if (originalKey == null) {
            CompilerInfoCache.$$$reportNull$$$0(44);
        }
        if (originalSwitches == null) {
            CompilerInfoCache.$$$reportNull$$$0(45);
        }
        if (executor == null) {
            CompilerInfoCache.$$$reportNull$$$0(46);
        }
        if (env == null) {
            CompilerInfoCache.$$$reportNull$$$0(47);
        }
        if (projectPath == null) {
            CompilerInfoCache.$$$reportNull$$$0(48);
        }
        if (!this.preparseCompilerISwitch(compiler)) {
            return this.getCompilerInfoAsyncInternal(interner, compiler, lang, originalKey, originalSwitches, executor, env);
        }
        HostMachine host = env.getHostMachine();
        boolean isWindows = host.getOS() == OS.Windows;
        CompilerSplitArgs splitArgs = CompilerSplitArgs.parse(originalSwitches, this.preparseCompilerDefineSwitch(compiler) ? Set.of(CompilerSplitArgs.ArgType.INCLUDE, CompilerSplitArgs.ArgType.DEFINE) : Set.of(CompilerSplitArgs.ArgType.INCLUDE), true, isWindows);
        List<String> nonBuiltinSearchPaths = splitArgs.getIncludes();
        CidrCompilerSwitches switches = splitArgs.getFilteredSwitches();
        if (splitArgs.hasPrecompiledOrImplicitHeaders() || nonBuiltinSearchPaths.isEmpty()) {
            return this.getCompilerInfoAsyncInternal(interner, compiler, lang, originalKey, originalSwitches, executor, env);
        }
        File executable = ((OCCompilerBase)compiler).myExecutable;
        File compilerWorkingDirectory = ((OCCompilerBase)compiler).myWorkingDirectory;
        File workingDirectoryKey = Registry.is((String)"cidr.compiler.info.optimize.cwd", (boolean)false) && ContainerUtil.and(nonBuiltinSearchPaths, it -> env.isEnvAbsolute(it)) ? compilerWorkingDirectory.toPath().getRoot().toFile() : compilerWorkingDirectory;
        CompilerSettingsKey key = interner.intern(CompilerInfoCache.createCompilerKey(lang, switches, executable, workingDirectoryKey));
        CompletableFuture<Result> result2 = this.getCompilerInfoAsyncInternal(interner, compiler, lang, key, switches, executor, env);
        CompletionStage completionStage = future = result2.thenApply(res -> {
            CompilerInfo info = res.getInfo();
            if (info != null) {
                ArrayList<CallSite> paths = new ArrayList<CallSite>(nonBuiltinSearchPaths);
                for (int i = 0; i < paths.size(); ++i) {
                    String path = (String)paths.get(i);
                    if (env.isEnvAbsolute(path)) continue;
                    paths.set(i, (CallSite)((Object)(env.toEnvPath(workingDirectoryKey.getPath()) + "/" + path)));
                }
                String[] canonicalPaths = ArrayUtil.toStringArray(paths);
                List<String> resolvedPaths = CompilerInfoCache.resolvePaths(env, Arrays.asList(canonicalPaths));
                HeadersSearchPathTree pathTree = new HeadersSearchPathTree();
                pathTree.addSearchPathsCompacting(info.getHeadersSearchPaths());
                @NotNull String rootPath = FileUtil.toSystemIndependentName((String)projectPath);
                for (String path : resolvedPaths) {
                    boolean preferQuotes = FileUtil.toSystemIndependentName((String)path).startsWith(rootPath);
                    pathTree.addSearchPathCompacting(new HeadersSearchPath(interner.intern(path), false, HeadersSearchPath.Kind.SYSTEM, preferQuotes));
                }
                List<HeadersSearchPath> headersSearchPaths = pathTree.getCompactedPaths();
                CompilerInfo updatedInfo = new CompilerInfo(originalSwitches, info.getDefines(), info.getFeatures(), headersSearchPaths, info.getImplicitIncludes(), info.getPrecompiledIncludes(), info.getWarnings(), info.getCompilerExitCode(), info.getModuleSearchPaths());
                return Result.create(originalKey, updatedInfo);
            }
            CompilerInfoEventCollector.COLLECT_FAILED.log(project);
            return Result.error(originalKey, Objects.requireNonNull(res.getError()));
        });
        if (completionStage == null) {
            CompilerInfoCache.$$$reportNull$$$0(49);
        }
        return completionStage;
    }

    protected boolean preparseCompilerISwitch(@NotNull OCCompiler compiler) {
        if (compiler == null) {
            CompilerInfoCache.$$$reportNull$$$0(50);
        }
        return Registry.is((String)"cidr.compiler.info.parse.switches", (boolean)true) && compiler instanceof OCCompilerBase;
    }

    protected boolean preparseCompilerDefineSwitch(@NotNull OCCompiler compiler) {
        if (compiler == null) {
            CompilerInfoCache.$$$reportNull$$$0(51);
        }
        return Registry.is((String)"cidr.compiler.info.parse.define.switch", (boolean)false) && compiler instanceof OCCompilerBase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private CompletableFuture<Result> getCompilerInfoAsyncInternal(@NotNull OCWorkspaceInterner interner, @NotNull OCCompiler compiler, @NotNull OCLanguageKind lang, @NotNull CompilerSettingsKey key, @NotNull CidrCompilerSwitches switches, @NotNull Executor executor, @NotNull CidrToolEnvironment env) {
        Result cached;
        if (interner == null) {
            CompilerInfoCache.$$$reportNull$$$0(52);
        }
        if (compiler == null) {
            CompilerInfoCache.$$$reportNull$$$0(53);
        }
        if (lang == null) {
            CompilerInfoCache.$$$reportNull$$$0(54);
        }
        if (key == null) {
            CompilerInfoCache.$$$reportNull$$$0(55);
        }
        if (switches == null) {
            CompilerInfoCache.$$$reportNull$$$0(56);
        }
        if (executor == null) {
            CompilerInfoCache.$$$reportNull$$$0(57);
        }
        if (env == null) {
            CompilerInfoCache.$$$reportNull$$$0(58);
        }
        if ((cached = this.myCache.get(key)) != null) {
            CompletableFuture<Result> completableFuture = CompletableFuture.completedFuture(cached);
            if (completableFuture != null) return completableFuture;
            CompilerInfoCache.$$$reportNull$$$0(59);
            return completableFuture;
        }
        Object object = this.myLock;
        // MONITORENTER : object
        cached = this.myCache.get(key);
        if (cached != null) {
            CompletableFuture<Result> completableFuture = CompletableFuture.completedFuture(cached);
            // MONITOREXIT : object
            if (completableFuture != null) return completableFuture;
            CompilerInfoCache.$$$reportNull$$$0(60);
            return completableFuture;
        }
        CompletableFuture<Result> processing = this.myInProcess.get(key);
        if (processing == null) {
            processing = CompletableFuture.supplyAsync(() -> {
                try {
                    ProgressManager.checkCanceled();
                    Result result2 = CompilerInfoCache.doCollectCompilerInfo(interner, compiler, lang, key, switches, env);
                    Object object = this.myLock;
                    synchronized (object) {
                        this.myCache.put(key, result2);
                        this.myInProcess.remove(key);
                        this.cacheDidChange();
                    }
                    return result2;
                }
                catch (ProcessCanceledException e) {
                    Object object = this.myLock;
                    synchronized (object) {
                        this.myInProcess.remove(key);
                    }
                    throw e;
                }
            }, executor);
            this.myInProcess.put(key, processing);
        }
        CompletableFuture<Result> completableFuture = processing;
        // MONITOREXIT : object
        if (completableFuture != null) return completableFuture;
        CompilerInfoCache.$$$reportNull$$$0(61);
        return completableFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropUncleanResults() {
        Object object = this.myLock;
        synchronized (object) {
            ArrayList keysToRemove = new ArrayList();
            this.myCache.forEach((key, result2) -> {
                CompilerInfo info = result2.getInfo();
                if (info != null && info.getCompilerExitCode() != 0) {
                    keysToRemove.add(key);
                }
            });
            for (CompilerSettingsKey key2 : keysToRemove) {
                this.myCache.remove(key2);
            }
        }
    }

    /*
     * Loose catch block
     */
    @NotNull
    private static Result doCollectCompilerInfo(@NotNull OCWorkspaceInterner interner, @NotNull OCCompiler compiler, @NotNull OCLanguageKind lang, @NotNull CompilerSettingsKey key, @NotNull CidrCompilerSwitches switches, @NotNull CidrToolEnvironment env) {
        if (interner == null) {
            CompilerInfoCache.$$$reportNull$$$0(62);
        }
        if (compiler == null) {
            CompilerInfoCache.$$$reportNull$$$0(63);
        }
        if (lang == null) {
            CompilerInfoCache.$$$reportNull$$$0(64);
        }
        if (key == null) {
            CompilerInfoCache.$$$reportNull$$$0(65);
        }
        if (switches == null) {
            CompilerInfoCache.$$$reportNull$$$0(66);
        }
        if (env == null) {
            CompilerInfoCache.$$$reportNull$$$0(67);
        }
        CidrEventSpan ignored = new CidrEventSpan("compilerInfo", () -> "collectCompilerInfo", () -> ((OCCompilerBase)compiler).myWorkingDirectory + " " + StringUtil.firstLast((String)switches.toString(), (int)1000));
        CompilerInfo info = compiler.collectInfo(lang, switches);
        HeadersSearchPathTree pathTree = new HeadersSearchPathTree();
        pathTree.addSearchPathsCompacting(info.getHeadersSearchPaths());
        HostMachine hostMachine = env.getHostMachine();
        List<HeadersSearchPath> compactedInternedPaths = CompilerInfoCache.resolve(hostMachine, pathTree.getCompactedPaths(), interner);
        List<ModuleSearchPath> internedModulePaths = CompilerInfoCache.resolveModules(hostMachine, info.getModuleSearchPaths(), interner);
        List<File> implicitIncludes = CompilerInfoCache.resolveImplicitIncludes(env, info.getImplicitIncludes(), interner);
        Result result2 = Result.create(key, new CompilerInfo(interner.intern(info.getSwitches(), oldSwitches -> new CidrCompilerSwitches(interner.intern(oldSwitches.getList(CidrCompilerSwitches.Format.RAW), switchesList -> new ArrayList(ContainerUtil.map((Collection)switchesList, switchValue -> interner.intern(switchValue)))))), interner.intern(info.getDefines(), oldDefines -> new ArrayList(ContainerUtil.map((Collection)oldDefines, define -> interner.intern(define)))), interner.intern(info.getFeatures()), compactedInternedPaths, implicitIncludes, info.getPrecompiledIncludes(), info.getWarnings(), info.getCompilerExitCode(), internedModulePaths));
        ignored.close();
        Result result3 = result2;
        if (result3 == null) {
            CompilerInfoCache.$$$reportNull$$$0(68);
        }
        return result3;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (com.intellij.execution.ExecutionException e) {
                    CompilerInfoEventCollector.COLLECT_FAILED.log();
                    Result result4 = Result.error(key, e);
                    if (result4 == null) {
                        CompilerInfoCache.$$$reportNull$$$0(69);
                    }
                    return result4;
                }
            }
        }
    }

    @NotNull
    private static List<HeadersSearchPath> resolve(@NotNull HostMachine host, @NotNull List<HeadersSearchPath> headersSearchPaths, @NotNull OCWorkspaceInterner interner) {
        if (host == null) {
            CompilerInfoCache.$$$reportNull$$$0(70);
        }
        if (headersSearchPaths == null) {
            CompilerInfoCache.$$$reportNull$$$0(71);
        }
        if (interner == null) {
            CompilerInfoCache.$$$reportNull$$$0(72);
        }
        ArrayList paths = new ArrayList(ContainerUtil.map(headersSearchPaths, p -> p.getPath()));
        List resolved = host.resolveAndCache(paths);
        int size = headersSearchPaths.size();
        assert (size == resolved.size());
        ArrayList<HeadersSearchPath> result2 = new ArrayList<HeadersSearchPath>(size);
        for (int i = 0; i < size; ++i) {
            result2.add(new HeadersSearchPath(interner.intern((String)resolved.get(i)), headersSearchPaths.get(i).getFlags()));
        }
        ArrayList<HeadersSearchPath> arrayList = result2;
        if (arrayList == null) {
            CompilerInfoCache.$$$reportNull$$$0(73);
        }
        return arrayList;
    }

    @NotNull
    private static List<ModuleSearchPath> resolveModules(@NotNull HostMachine host, @NotNull List<ModuleSearchPath> moduleSearchPaths, @NotNull OCWorkspaceInterner interner) {
        if (host == null) {
            CompilerInfoCache.$$$reportNull$$$0(74);
        }
        if (moduleSearchPaths == null) {
            CompilerInfoCache.$$$reportNull$$$0(75);
        }
        if (interner == null) {
            CompilerInfoCache.$$$reportNull$$$0(76);
        }
        HashSet<String> moduleDirectories = new HashSet<String>();
        for (ModuleSearchPath moduleSearchPath : moduleSearchPaths) {
            moduleDirectories.add(moduleSearchPath.getModulePath().getParent().toString());
        }
        host.resolveAndCache(moduleDirectories.stream().toList());
        List paths = ContainerUtil.map(moduleSearchPaths, module -> module.getModulePath().toString());
        List resolved = host.resolveAndCache(paths);
        int size = moduleSearchPaths.size();
        LOG.assertTrue(size == resolved.size());
        ArrayList result2 = new ArrayList(ContainerUtil.map((Collection)resolved, path -> new ModuleSearchPath(Path.of(path, new String[0]))));
        List list = interner.intern(result2, oldModuleSearchPaths -> new ArrayList(ContainerUtil.map((Collection)oldModuleSearchPaths, modulesSearchPath -> interner.intern(modulesSearchPath, path -> interner.intern(new ModuleSearchPath(interner.intern(path.getModulePath(), pathString -> interner.intern(pathString))))))));
        if (list == null) {
            CompilerInfoCache.$$$reportNull$$$0(77);
        }
        return list;
    }

    @NotNull
    private static List<File> resolveImplicitIncludes(@NotNull CidrToolEnvironment env, @NotNull List<File> implicitIncludes, @NotNull OCWorkspaceInterner interner) {
        if (env == null) {
            CompilerInfoCache.$$$reportNull$$$0(78);
        }
        if (implicitIncludes == null) {
            CompilerInfoCache.$$$reportNull$$$0(79);
        }
        if (interner == null) {
            CompilerInfoCache.$$$reportNull$$$0(80);
        }
        if (implicitIncludes.isEmpty()) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                CompilerInfoCache.$$$reportNull$$$0(81);
            }
            return list;
        }
        ArrayList paths = new ArrayList(ContainerUtil.map(implicitIncludes, p -> env.toEnvPath(p.getPath())));
        List<String> canonicalPaths = List.of(env.getHostMachine().toCanonicalPath(paths, true));
        List resolved = env.getHostMachine().resolveAndCache(canonicalPaths);
        int size = implicitIncludes.size();
        assert (size == resolved.size());
        ArrayList<File> result2 = new ArrayList<File>(size);
        for (int i = 0; i < size; ++i) {
            result2.add(new File(interner.intern((String)resolved.get(i))));
        }
        ArrayList<File> arrayList = result2;
        if (arrayList == null) {
            CompilerInfoCache.$$$reportNull$$$0(82);
        }
        return arrayList;
    }

    @NotNull
    private static List<String> resolvePaths(@NotNull CidrToolEnvironment env, @NotNull List<String> paths) {
        if (env == null) {
            CompilerInfoCache.$$$reportNull$$$0(83);
        }
        if (paths == null) {
            CompilerInfoCache.$$$reportNull$$$0(84);
        }
        HostMachine host = env.getHostMachine();
        List resolved = host.resolveAndCache(paths);
        assert (paths.size() == resolved.size());
        return new ArrayList<String>(ContainerUtil.map((Collection)resolved, p -> env.toLocalPath(p)));
    }

    protected void cacheDidChange() {
    }

    public <ID> Session<ID> createSession(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            CompilerInfoCache.$$$reportNull$$$0(85);
        }
        return this.createSession(indicator, null);
    }

    public <ID> Session<ID> createSession(@NotNull ProgressIndicator indicator, @Nullable OCWorkspaceInterner interner) {
        if (indicator == null) {
            CompilerInfoCache.$$$reportNull$$$0(86);
        }
        return new Session(this, indicator, interner);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 52, 53, 54, 55, 56, 57, 58, 62, 63, 64, 65, 66, 67, 70, 71, 72, 74, 75, 76, 78, 79, 80, 83, 84, 85, 86 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/workspace/compiler/CompilerInfoCache";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flushMessagesType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messages";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messagesCollector";
                break;
            }
            case 5: 
            case 14: 
            case 31: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 15: 
            case 26: 
            case 33: 
            case 43: 
            case 54: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lang";
                break;
            }
            case 7: 
            case 16: 
            case 27: 
            case 35: 
            case 56: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switches";
                break;
            }
            case 8: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilerKind";
                break;
            }
            case 9: 
            case 18: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilerExecutable";
                break;
            }
            case 10: 
            case 19: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilerWorkingDirectory";
                break;
            }
            case 11: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 12: 
            case 23: 
            case 30: 
            case 40: 
            case 52: 
            case 62: 
            case 72: 
            case 76: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interner";
                break;
            }
            case 21: 
            case 36: 
            case 46: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tempFilesPool";
                break;
            }
            case 24: 
            case 38: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 32: 
            case 42: 
            case 50: 
            case 51: 
            case 53: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compiler";
                break;
            }
            case 34: 
            case 55: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 37: 
            case 47: 
            case 58: 
            case 67: 
            case 78: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalKey";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalSwitches";
                break;
            }
            case 70: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "headersSearchPaths";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleSearchPaths";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "implicitIncludes";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 85: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createExecutor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 70: 
            case 71: 
            case 72: 
            case 74: 
            case 75: 
            case 76: 
            case 78: 
            case 79: 
            case 80: 
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/workspace/compiler/CompilerInfoCache";
                break;
            }
            case 13: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompilerInfo";
                break;
            }
            case 25: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompilerInfoAsync";
                break;
            }
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompilerInfoAsyncInternal";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "doCollectCompilerInfo";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "resolve";
                break;
            }
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveModules";
                break;
            }
            case 81: 
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveImplicitIncludes";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "flushConsoleMessages";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getCompilerInfo";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getCompilerInfoAsync";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createCompilerKey";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "preparseCompilerISwitch";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "preparseCompilerDefineSwitch";
                break;
            }
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getCompilerInfoAsyncInternal";
                break;
            }
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "doCollectCompilerInfo";
                break;
            }
            case 70: 
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 74: 
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "resolveModules";
                break;
            }
            case 78: 
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "resolveImplicitIncludes";
                break;
            }
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "resolvePaths";
                break;
            }
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "createSession";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 52, 53, 54, 55, 56, 57, 58, 62, 63, 64, 65, 66, 67, 70, 71, 72, 74, 75, 76, 78, 79, 80, 83, 84, 85, 86 -> new IllegalArgumentException(string);
        };
    }

    public static class Message {
        @NotNull
        public final Type type;
        @NotNull
        @NlsSafe
        public final String text;

        public Message(@NotNull Type type, @NotNull String text) {
            if (type == null) {
                Message.$$$reportNull$$$0(0);
            }
            if (text == null) {
                Message.$$$reportNull$$$0(1);
            }
            this.type = type;
            this.text = text;
        }

        @NotNull
        public Type getType() {
            Type type = this.type;
            if (type == null) {
                Message.$$$reportNull$$$0(2);
            }
            return type;
        }

        @NotNull
        public String getText() {
            String string = this.text;
            if (string == null) {
                Message.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/workspace/compiler/CompilerInfoCache$Message";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/workspace/compiler/CompilerInfoCache$Message";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }

        public static enum Type {
            ERROR,
            WARNING;

        }
    }

    public static final class Result {
        @NotNull
        private final CompilerSettingsKey myKey;
        @Nullable
        private final CompilerInfo myInfo;
        @Nullable
        private final Throwable myError;

        @Contract(value="_,null,null -> fail; _,!null,!null -> fail")
        private Result(@NotNull CompilerSettingsKey key, @Nullable CompilerInfo info, @Nullable Throwable error) {
            if (key == null) {
                Result.$$$reportNull$$$0(0);
            }
            assert (info != null ^ error != null);
            this.myKey = key;
            this.myInfo = info;
            this.myError = error;
        }

        @Contract(pure=true)
        @NotNull
        public CompilerSettingsKey getKey() {
            CompilerSettingsKey compilerSettingsKey = this.myKey;
            if (compilerSettingsKey == null) {
                Result.$$$reportNull$$$0(1);
            }
            return compilerSettingsKey;
        }

        @Contract(pure=true)
        @Nullable
        public CompilerInfo getInfo() {
            return this.myInfo;
        }

        @Contract(pure=true)
        @Nullable
        public Throwable getError() {
            return this.myError;
        }

        public static Result create(@NotNull CompilerSettingsKey key, @NotNull CompilerInfo info) {
            if (key == null) {
                Result.$$$reportNull$$$0(2);
            }
            if (info == null) {
                Result.$$$reportNull$$$0(3);
            }
            return new Result(key, info, null);
        }

        public static Result error(@NotNull CompilerSettingsKey key, @NotNull Throwable error) {
            if (key == null) {
                Result.$$$reportNull$$$0(4);
            }
            if (error == null) {
                Result.$$$reportNull$$$0(5);
            }
            return new Result(key, null, error);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/workspace/compiler/CompilerInfoCache$Result";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "error";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/workspace/compiler/CompilerInfoCache$Result";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKey";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "error";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    public static final class Session<ID> {
        @NotNull
        private final CompilerInfoCache myCache;
        @NotNull
        private final ProgressIndicator myCallerProgressIndicator;
        @NotNull
        private final ProgressIndicator myJobsProgressIndicator;
        @NotNull
        private final CancelableExecutor myCancelableJobsExecutor;
        @NotNull
        private final TempFilesPool myTempFilesPool;
        @NotNull
        private final OCWorkspaceInterner myInterner;
        @NotNull
        private final List<Pair<Future<List<Message>>, ID>> myJobs;
        @NotNull
        private final AtomicLong myTimeBefore;
        @NotNull
        private final AtomicInteger myStartedJobsCount;
        @NotNull
        private final AtomicInteger myCompletedJobsCount;
        @NotNull
        private final AtomicInteger myExpectedJobsCount;

        private Session(@NotNull CompilerInfoCache cache, @NotNull ProgressIndicator indicator, @Nullable OCWorkspaceInterner interner) {
            if (cache == null) {
                Session.$$$reportNull$$$0(0);
            }
            if (indicator == null) {
                Session.$$$reportNull$$$0(1);
            }
            this.myTempFilesPool = new CachedTempFilesPool();
            this.myJobs = new ArrayList<Pair<Future<List<Message>>, ID>>();
            this.myTimeBefore = new AtomicLong(0L);
            this.myStartedJobsCount = new AtomicInteger(0);
            this.myCompletedJobsCount = new AtomicInteger(0);
            this.myExpectedJobsCount = new AtomicInteger(0);
            this.myCache = cache;
            this.myInterner = interner != null ? interner : new OCWorkspaceInterner();
            this.myCallerProgressIndicator = indicator;
            this.myCallerProgressIndicator.setIndeterminate(false);
            this.myJobsProgressIndicator = new SensitiveProgressWrapper(indicator);
            this.myCancelableJobsExecutor = new CancelableExecutor(this.myJobsProgressIndicator);
        }

        public void schedule(@NotNull ID id, @NotNull OCResolveConfiguration.ModifiableModel model, @NotNull CidrToolEnvironment environment, @NotNull String projectPath) {
            if (id == null) {
                Session.$$$reportNull$$$0(2);
            }
            if (model == null) {
                Session.$$$reportNull$$$0(3);
            }
            if (environment == null) {
                Session.$$$reportNull$$$0(4);
            }
            if (projectPath == null) {
                Session.$$$reportNull$$$0(5);
            }
            if (this.myTimeBefore.get() == 0L) {
                this.myTimeBefore.set(System.currentTimeMillis());
            }
            this.myStartedJobsCount.incrementAndGet();
            CompletableFuture<List<Message>> future = OCWorkspaceImplUtilKt.collectCompilerSettingsAsync(model, environment, projectPath, this.myCache, this.myCancelableJobsExecutor, this.myTempFilesPool, this.myInterner, () -> {
                int completedJobs = this.myCompletedJobsCount.incrementAndGet();
                int expectedJobsCount = this.myExpectedJobsCount.get();
                if (expectedJobsCount == 0) {
                    expectedJobsCount = this.myStartedJobsCount.get();
                }
                if (!this.myCallerProgressIndicator.isIndeterminate() && expectedJobsCount > 0) {
                    this.myCallerProgressIndicator.setFraction((double)completedJobs / (double)expectedJobsCount);
                }
            });
            this.myJobs.add(Pair.create(future, id));
        }

        public void waitForAll(@NotNull MultiMap<ID, Message> result2) {
            if (result2 == null) {
                Session.$$$reportNull$$$0(6);
            }
            Throwable toReport = null;
            for (Pair<Future<List<Message>>, ID> eachJob : this.myJobs) {
                try {
                    result2.putValues(eachJob.second, (Collection)((Future)eachJob.first).get());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e);
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof ProcessCanceledException) {
                        this.myCallerProgressIndicator.cancel();
                        continue;
                    }
                    if (toReport == null) {
                        toReport = new RuntimeException(e);
                        continue;
                    }
                    toReport.addSuppressed(e);
                }
            }
            this.cleanTempFilesPool();
            if (toReport != null) {
                throw toReport;
            }
            this.myCallerProgressIndicator.checkCanceled();
            this.myCallerProgressIndicator.setFraction(1.0);
            long timeAfter = System.currentTimeMillis();
            OCWorkspaceImplUtilKt.getLOG().debug("Compiler info setup took " + StringUtil.formatDuration((long)(timeAfter - this.myTimeBefore.get())));
        }

        public void dispose() {
            this.myJobsProgressIndicator.cancel();
            for (Pair<Future<List<Message>>, ID> eachJob : this.myJobs) {
                try {
                    ((Future)eachJob.first).get();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
                catch (ExecutionException executionException) {
                }
            }
            this.cleanTempFilesPool();
        }

        public void setExpectedJobsCount(int expectedJobsCount) {
            this.myExpectedJobsCount.set(expectedJobsCount);
        }

        private void cleanTempFilesPool() {
            this.myTempFilesPool.clean();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cache";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "environment";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "projectPath";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/lang/workspace/compiler/CompilerInfoCache$Session";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "schedule";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "waitForAll";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static final class CancelableExecutor
        implements Executor {
            @NotNull
            ProgressIndicator myIndicator;

            private CancelableExecutor(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    CancelableExecutor.$$$reportNull$$$0(0);
                }
                this.myIndicator = indicator;
            }

            @Override
            public void execute(@NotNull Runnable command) {
                if (command == null) {
                    CancelableExecutor.$$$reportNull$$$0(1);
                }
                ourExecutor.execute(() -> {
                    SensitiveProgressWrapper jobIndicator = new SensitiveProgressWrapper(this.myIndicator);
                    ProgressManager.getInstance().runProcess(command, (ProgressIndicator)jobIndicator);
                    if (jobIndicator.isCanceled()) {
                        this.myIndicator.cancel();
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "indicator";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "command";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/cidr/lang/workspace/compiler/CompilerInfoCache$Session$CancelableExecutor";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "execute";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }
}

