/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.LightVirtualFile;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.workspace.OCCompilerSettings;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculatorBase;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCResolveConfigurations;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRoot;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001:\u0001\u001aB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001c\u0010\u000b\u001a\u00020\u00052\n\u0010\f\u001a\u00060\rj\u0002`\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J$\u0010\u0011\u001a\u0016\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00122\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0015H\u0002\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/cidr/lang/workspace/ShowCompilerInfoForFile;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "appendAdditionalCompilerInfo", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "context", "Lcom/jetbrains/cidr/lang/workspace/ShowCompilerInfoForFile$Context;", "getProjectAndFile", "Lkotlin/Triple;", "Lcom/intellij/openapi/project/Project;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/psi/PsiFile;", "getContext", "isHeaderOrSourceFile", "", "file", "Context", "intellij.cidr.projectModel"})
@SourceDebugExtension(value={"SMAP\nShowCompilerInfoForFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShowCompilerInfoForFile.kt\ncom/jetbrains/cidr/lang/workspace/ShowCompilerInfoForFile\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,101:1\n1863#2,2:102\n1#3:104\n*S KotlinDebug\n*F\n+ 1 ShowCompilerInfoForFile.kt\ncom/jetbrains/cidr/lang/workspace/ShowCompilerInfoForFile\n*L\n44#1:102,2\n*E\n"})
public class ShowCompilerInfoForFile
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setEnabledAndVisible(this.getProjectAndFile(e) != null);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Context context = this.getContext(e);
        if (context == null) {
            return;
        }
        Context context2 = context;
        Project project = context2.component1();
        VirtualFile file = context2.component2();
        OCLanguageKind kind = context2.component3();
        OCResolveConfiguration configuration = context2.component4();
        OCCompilerSettings oCCompilerSettings = configuration.getCompilerSettings(kind, file);
        Intrinsics.checkNotNullExpressionValue((Object)oCCompilerSettings, (String)"getCompilerSettings(...)");
        OCCompilerSettings settings = oCCompilerSettings;
        StringBuilder builder = new StringBuilder();
        builder.append("Compiler info for '" + file.getName() + "' in configuration '" + configuration.getDisplayName() + "' for language " + kind + "\n");
        builder.append("\nCompiler kind: " + settings.getCompilerKind() + " path: " + settings.getCompilerExecutable() + "\n");
        this.appendAdditionalCompilerInfo(builder, context2);
        builder.append("\nCompiler switches:\n");
        CidrCompilerSwitches switches = settings.getCompilerSwitches();
        if (switches == null) {
            builder.append("\nnull\n");
        } else {
            List<String> list = switches.getList(CidrCompilerSwitches.Format.RAW);
            Intrinsics.checkNotNullExpressionValue(list, (String)"getList(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv = iterator.next();
                String it = (String)element$iv;
                boolean bl = false;
                builder.append("\t").append(it).append("\n");
            }
        }
        builder.append("\nCompiler info:\n");
        builder.append("\nDefines:\n");
        for (String preprocessorDefine : settings.getPreprocessorDefines()) {
            builder.append(preprocessorDefine).append('\n');
        }
        builder.append("\nFeatures:\n").append(CollectionsKt.joinToString$default((Iterable)settings.getCompilerFeatures().entrySet(), (CharSequence)"\n", null, null, (int)0, null, ShowCompilerInfoForFile::actionPerformed$lambda$1, (int)30, null));
        List<VirtualFile> list = settings.getImplicitIncludes();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getImplicitIncludes(...)");
        builder.append("\n\nImplicit includes:\n" + CollectionsKt.joinToString$default((Iterable)list, (CharSequence)"\n", null, null, (int)0, null, ShowCompilerInfoForFile::actionPerformed$lambda$2, (int)30, null));
        builder.append("\n\nHeader Search paths:\n" + CollectionsKt.joinToString$default((Iterable)settings.getHeadersSearchRoots().getAllRoots(), (CharSequence)"\n", null, null, (int)0, null, ShowCompilerInfoForFile::actionPerformed$lambda$4, (int)30, null));
        LightVirtualFile infoFile = new LightVirtualFile("Compiler Info for '" + file.getName() + "' in '" + configuration.getDisplayName() + "'", (FileType)PlainTextFileType.INSTANCE, (CharSequence)builder);
        FileEditorManager.getInstance((Project)project).openFile((VirtualFile)infoFile, false);
    }

    protected void appendAdditionalCompilerInfo(@NotNull StringBuilder builder, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
    }

    private final Triple<Project, VirtualFile, PsiFile> getProjectAndFile(AnActionEvent e) {
        Project project = AnAction.getEventProject((AnActionEvent)e);
        if (project == null) {
            return null;
        }
        Project project2 = project;
        VirtualFile virtualFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile file = virtualFile;
        PsiFile psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        if (psiFile == null) {
            return null;
        }
        PsiFile psiFile2 = psiFile;
        if (!this.isHeaderOrSourceFile(psiFile2)) {
            return null;
        }
        return new Triple((Object)project2, (Object)file, (Object)psiFile2);
    }

    private final Context getContext(AnActionEvent e) {
        Triple<Project, VirtualFile, PsiFile> triple = this.getProjectAndFile(e);
        if (triple == null) {
            return null;
        }
        Triple<Project, VirtualFile, PsiFile> triple2 = triple;
        Project project = (Project)triple2.component1();
        VirtualFile file = (VirtualFile)triple2.component2();
        PsiFile psiFile = (PsiFile)triple2.component3();
        OCResolveConfiguration oCResolveConfiguration = OCResolveConfigurations.getPreselectedConfiguration(psiFile.getVirtualFile(), project);
        if (oCResolveConfiguration == null) {
            return null;
        }
        OCResolveConfiguration configuration = oCResolveConfiguration;
        OCLanguageKind oCLanguageKind = OCLanguageKindCalculatorBase.tryPsiFile(psiFile);
        if (oCLanguageKind == null) {
            return null;
        }
        OCLanguageKind kind = oCLanguageKind;
        return new Context(project, file, kind, configuration);
    }

    private final boolean isHeaderOrSourceFile(PsiFile file) {
        return OCFileTypeHelpers.isHeaderFile(file) || OCFileTypeHelpers.isSourceFile(file);
    }

    private static final CharSequence actionPerformed$lambda$1(Map.Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "\t" + it.getKey() + "=" + it.getValue();
    }

    private static final CharSequence actionPerformed$lambda$2(VirtualFile it) {
        return "\t" + it.getPath();
    }

    /*
     * WARNING - void declaration
     */
    private static final CharSequence actionPerformed$lambda$4(HeadersSearchRoot it) {
        Object object;
        String string;
        String string2;
        block3: {
            block2: {
                void f;
                Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                string2 = ((Object)((Object)it)).getClass().getSimpleName();
                string = it.getKind().isUser() ? "(user)" : "";
                object = it.getVirtualFile();
                if (object == null) break block2;
                VirtualFile virtualFile = object;
                String string3 = string;
                String string4 = string2;
                boolean bl = false;
                String string5 = ": " + (VirtualFile)f;
                string2 = string4;
                string = string3;
                String string6 = string5;
                object = string6;
                if (string6 != null) break block3;
            }
            object = "";
        }
        return "\t" + string2 + string + (String)object;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0084\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\tH\u00c6\u0003J1\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006 "}, d2={"Lcom/jetbrains/cidr/lang/workspace/ShowCompilerInfoForFile$Context;", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "kind", "Lcom/jetbrains/cidr/lang/OCLanguageKind;", "configuration", "Lcom/jetbrains/cidr/lang/workspace/OCResolveConfiguration;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/jetbrains/cidr/lang/OCLanguageKind;Lcom/jetbrains/cidr/lang/workspace/OCResolveConfiguration;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getKind", "()Lcom/jetbrains/cidr/lang/OCLanguageKind;", "getConfiguration", "()Lcom/jetbrains/cidr/lang/workspace/OCResolveConfiguration;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.cidr.projectModel"})
    protected static final class Context {
        @NotNull
        private final Project project;
        @NotNull
        private final VirtualFile file;
        @NotNull
        private final OCLanguageKind kind;
        @NotNull
        private final OCResolveConfiguration configuration;

        public Context(@NotNull Project project, @NotNull VirtualFile file, @NotNull OCLanguageKind kind, @NotNull OCResolveConfiguration configuration) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            this.project = project;
            this.file = file;
            this.kind = kind;
            this.configuration = configuration;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @NotNull
        public final VirtualFile getFile() {
            return this.file;
        }

        @NotNull
        public final OCLanguageKind getKind() {
            return this.kind;
        }

        @NotNull
        public final OCResolveConfiguration getConfiguration() {
            return this.configuration;
        }

        @NotNull
        public final Project component1() {
            return this.project;
        }

        @NotNull
        public final VirtualFile component2() {
            return this.file;
        }

        @NotNull
        public final OCLanguageKind component3() {
            return this.kind;
        }

        @NotNull
        public final OCResolveConfiguration component4() {
            return this.configuration;
        }

        @NotNull
        public final Context copy(@NotNull Project project, @NotNull VirtualFile file, @NotNull OCLanguageKind kind, @NotNull OCResolveConfiguration configuration) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            return new Context(project, file, kind, configuration);
        }

        public static /* synthetic */ Context copy$default(Context context, Project project, VirtualFile virtualFile, OCLanguageKind oCLanguageKind, OCResolveConfiguration oCResolveConfiguration, int n, Object object) {
            if ((n & 1) != 0) {
                project = context.project;
            }
            if ((n & 2) != 0) {
                virtualFile = context.file;
            }
            if ((n & 4) != 0) {
                oCLanguageKind = context.kind;
            }
            if ((n & 8) != 0) {
                oCResolveConfiguration = context.configuration;
            }
            return context.copy(project, virtualFile, oCLanguageKind, oCResolveConfiguration);
        }

        @NotNull
        public String toString() {
            return "Context(project=" + this.project + ", file=" + this.file + ", kind=" + this.kind + ", configuration=" + this.configuration + ")";
        }

        public int hashCode() {
            int result2 = this.project.hashCode();
            result2 = result2 * 31 + this.file.hashCode();
            result2 = result2 * 31 + this.kind.hashCode();
            result2 = result2 * 31 + this.configuration.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Context)) {
                return false;
            }
            Context context = (Context)other;
            if (!Intrinsics.areEqual((Object)this.project, (Object)context.project)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.file, (Object)context.file)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.kind, (Object)context.kind)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.configuration, (Object)context.configuration);
        }
    }
}

