/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.toolchains;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FileCollectionFactory;
import com.jetbrains.cidr.lang.toolchains.CidrSwitchBuilder;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public class CidrCompilerSwitches {
    @NotNull
    public static final CidrCompilerSwitches EMPTY = new CidrCompilerSwitches(ContainerUtil.emptyList());
    @NotNull
    private final @Unmodifiable List<String> myRawArgs;

    public CidrCompilerSwitches(@NotNull List<String> rawArgs) {
        if (rawArgs == null) {
            CidrCompilerSwitches.$$$reportNull$$$0(0);
        }
        this.myRawArgs = ContainerUtil.unmodifiableOrEmptyList(rawArgs);
    }

    @NotNull
    public @NotNull @Unmodifiable List<@NotNull String> getList(@NotNull Format format) {
        if (format == null) {
            CidrCompilerSwitches.$$$reportNull$$$0(1);
        }
        if (format == Format.RAW) {
            List<String> list = this.myRawArgs;
            if (list == null) {
                CidrCompilerSwitches.$$$reportNull$$$0(2);
            }
            return list;
        }
        List list = ContainerUtil.map(this.myRawArgs, it -> CidrSwitchBuilder.convertSingleRawArgTo(it, format));
        if (list == null) {
            CidrCompilerSwitches.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public String getCommandLineString(@NotNull Format format) {
        if (format == null) {
            CidrCompilerSwitches.$$$reportNull$$$0(4);
        }
        if (format == Format.RAW) {
            throw new IllegalArgumentException("RAW format cannot be correctly used in command line strings.");
        }
        String string = StringUtil.join(this.getList(format), (String)" ");
        if (string == null) {
            CidrCompilerSwitches.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public CidrCompilerSwitches filterOptions(@NotNull BiFunction<? super @NonNls String, ? super @NonNls String, Boolean> argumentsFilter) {
        if (argumentsFilter == null) {
            CidrCompilerSwitches.$$$reportNull$$$0(6);
        }
        ArrayList<String> filtered = null;
        int size = this.myRawArgs.size();
        for (int i = 0; i < size; ++i) {
            String nextParam;
            String param = this.myRawArgs.get(i).trim();
            String string = nextParam = i + 1 < size ? this.myRawArgs.get(i + 1).trim() : null;
            if (!argumentsFilter.apply(param, nextParam).booleanValue()) continue;
            if (filtered == null) {
                filtered = new ArrayList<String>();
            }
            filtered.add(param);
        }
        return filtered == null ? EMPTY : new CidrCompilerSwitches(filtered);
    }

    @NotNull
    public CidrCompilerSwitches expandResponseFiles(@NotNull File baseDirectory, @NotNull CidrToolEnvironment environment, @NotNull Format responseFileFormat) throws IOException {
        if (baseDirectory == null) {
            CidrCompilerSwitches.$$$reportNull$$$0(7);
        }
        if (environment == null) {
            CidrCompilerSwitches.$$$reportNull$$$0(8);
        }
        if (responseFileFormat == null) {
            CidrCompilerSwitches.$$$reportNull$$$0(9);
        }
        if (responseFileFormat != Format.GCC_RESPONSE_FILE && responseFileFormat != Format.MSVC_RESPONSE_FILE) {
            throw new IllegalArgumentException("Passed format cannot be used as response file format.");
        }
        ArrayList<String> expandedArguments = new ArrayList<String>(this.myRawArgs);
        Set expansionStack = FileCollectionFactory.createCanonicalFileSet();
        CidrCompilerSwitches.expandResponseFiles(baseDirectory, expandedArguments, expansionStack, environment, responseFileFormat);
        return new CidrCompilerSwitches(expandedArguments);
    }

    private static void expandResponseFiles(@NotNull File baseDirectory, @NotNull List<String> arguments, @NotNull Set<File> expansionStack, @NotNull CidrToolEnvironment environment, @NotNull Format responseFileFormat) throws IOException {
        if (baseDirectory == null) {
            CidrCompilerSwitches.$$$reportNull$$$0(10);
        }
        if (arguments == null) {
            CidrCompilerSwitches.$$$reportNull$$$0(11);
        }
        if (expansionStack == null) {
            CidrCompilerSwitches.$$$reportNull$$$0(12);
        }
        if (environment == null) {
            CidrCompilerSwitches.$$$reportNull$$$0(13);
        }
        if (responseFileFormat == null) {
            CidrCompilerSwitches.$$$reportNull$$$0(14);
        }
        if (expansionStack.size() > 20) {
            throw new IOException("Maximum recursion depth has been reached during response files expansion.");
        }
        int position = 0;
        while (position < arguments.size()) {
            String argument = arguments.get(position);
            if (!argument.startsWith("@")) {
                ++position;
                continue;
            }
            String responseFilePath = argument.substring(1);
            List<String> expandedArguments = CidrCompilerSwitches.expandResponseFile(baseDirectory, responseFilePath, expansionStack, environment, responseFileFormat);
            arguments.remove(position);
            arguments.addAll(position, expandedArguments);
            position += expandedArguments.size();
        }
    }

    private static List<String> expandResponseFile(@NotNull File baseDirectory, @NotNull String responseFilePath, @NotNull Set<File> expansionStack, @NotNull CidrToolEnvironment environment, @NotNull Format responseFileFormat) throws IOException {
        String responseFileLocalPath;
        File responseFile;
        if (baseDirectory == null) {
            CidrCompilerSwitches.$$$reportNull$$$0(15);
        }
        if (responseFilePath == null) {
            CidrCompilerSwitches.$$$reportNull$$$0(16);
        }
        if (expansionStack == null) {
            CidrCompilerSwitches.$$$reportNull$$$0(17);
        }
        if (environment == null) {
            CidrCompilerSwitches.$$$reportNull$$$0(18);
        }
        if (responseFileFormat == null) {
            CidrCompilerSwitches.$$$reportNull$$$0(19);
        }
        if (expansionStack.contains(responseFile = new File(responseFileLocalPath = environment.toLocalPath(baseDirectory, responseFilePath)))) {
            throw new IOException("Cyclic dependency has been detected during response files expansion.");
        }
        if (!responseFile.exists() || !responseFile.isFile()) {
            return Collections.emptyList();
        }
        expansionStack.add(responseFile);
        String content = FileUtil.loadFile((File)responseFile);
        List<String> arguments = CidrSwitchBuilder.parseArgs(content, responseFileFormat);
        CidrCompilerSwitches.expandResponseFiles(baseDirectory, arguments, expansionStack, environment, responseFileFormat);
        expansionStack.remove(responseFile);
        return arguments;
    }

    public String toString() {
        return this.getCommandLineString(Format.BASH_SHELL);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CidrCompilerSwitches switches = (CidrCompilerSwitches)o;
        return this.myRawArgs.equals(switches.myRawArgs);
    }

    public int hashCode() {
        return this.myRawArgs.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawArgs";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/toolchains/CidrCompilerSwitches";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentsFilter";
                break;
            }
            case 7: 
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDirectory";
                break;
            }
            case 8: 
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 9: 
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "responseFileFormat";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expansionStack";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "responseFilePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/toolchains/CidrCompilerSwitches";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getList";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandLineString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getList";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getCommandLineString";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "filterOptions";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "expandResponseFiles";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "expandResponseFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 5 -> new IllegalStateException(string);
        };
    }

    public static enum Format {
        RAW,
        BASH_SHELL,
        WINDOWS_SHELL,
        GNU_MAKEFILES,
        MINGW_MAKEFILES,
        NMAKE_MAKEFILES,
        GCC_RESPONSE_FILE,
        MSVC_RESPONSE_FILE;

    }
}

