/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.settings;

import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.WriteExternalException;
import com.jetbrains.cidr.lang.settings.NamingConventionStyle;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class FileExtensionPair
implements JDOMExternalizable {
    @NlsSafe
    @NotNull
    public final String mySourceExt;
    @NlsSafe
    @NotNull
    public final String myHeaderExt;
    @NotNull
    public final NamingConventionStyle myFileNamingConvention;

    public FileExtensionPair(@NlsSafe @NotNull String sourceExt, @NlsSafe @NotNull String headerExt, @NotNull NamingConventionStyle fileNamingConvention) {
        if (sourceExt == null) {
            FileExtensionPair.$$$reportNull$$$0(0);
        }
        if (headerExt == null) {
            FileExtensionPair.$$$reportNull$$$0(1);
        }
        if (fileNamingConvention == null) {
            FileExtensionPair.$$$reportNull$$$0(2);
        }
        this.mySourceExt = sourceExt;
        this.myHeaderExt = headerExt;
        this.myFileNamingConvention = fileNamingConvention;
    }

    @NlsSafe
    public String toString() {
        if (this.myHeaderExt.isEmpty()) {
            return "." + this.mySourceExt;
        }
        return "." + this.mySourceExt + " / ." + this.myHeaderExt + " (" + this.myFileNamingConvention.toString() + ")";
    }

    public int hashCode() {
        int result2 = this.mySourceExt.hashCode();
        result2 = 31 * result2 + this.myHeaderExt.hashCode();
        result2 = 31 * result2 + this.myFileNamingConvention.hashCode();
        return result2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileExtensionPair pair = (FileExtensionPair)o;
        if (!this.mySourceExt.equals(pair.mySourceExt)) {
            return false;
        }
        if (!this.myHeaderExt.equals(pair.myHeaderExt)) {
            return false;
        }
        return this.myFileNamingConvention.equals((Object)pair.myFileNamingConvention);
    }

    public void readExternal(Element parentElement) throws InvalidDataException {
    }

    public void writeExternal(Element parentElement) throws WriteExternalException {
        Element element = new Element("pair");
        element.setAttribute("source", this.mySourceExt);
        element.setAttribute("header", this.myHeaderExt);
        element.setAttribute("fileNamingConvention", this.myFileNamingConvention.name());
        parentElement.addContent(element);
    }

    @NotNull
    public static List<FileExtensionPair> readFileExtensionPairs(Element childElement) {
        ArrayList<FileExtensionPair> list = new ArrayList<FileExtensionPair>();
        for (Element e : childElement.getChildren("pair")) {
            String source = e.getAttributeValue("source");
            String header = e.getAttributeValue("header");
            if (source == null || header == null) continue;
            String cName = e.getAttributeValue("fileNamingConvention");
            NamingConventionStyle fileNamingConvention = NamingConventionStyle.byName(cName);
            list.add(new FileExtensionPair(source, header, fileNamingConvention));
        }
        ArrayList<FileExtensionPair> arrayList = list;
        if (arrayList == null) {
            FileExtensionPair.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceExt";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "headerExt";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileNamingConvention";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/settings/FileExtensionPair";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/settings/FileExtensionPair";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "readFileExtensionPairs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

