/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Function;
import com.jetbrains.cidr.CidrExecutionBundle;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class CidrTestScopeElementImpl
implements CidrTestScopeElement,
Comparable<CidrTestScopeElement> {
    @Nullable
    protected final String mySuiteName;
    @Nullable
    protected final String myTestName;
    @Nullable
    protected final AbstractPropertiesGenerator myDelegate;
    public static final long DEFAULT_TEST_ORDER = -1L;

    protected CidrTestScopeElementImpl(@Nullable String suiteName, @Nullable String testName) {
        this(suiteName, testName, (Function<CidrTestScopeElementImpl, AbstractPropertiesGenerator>)((Function)DefaultPropertiesGenerator::new));
    }

    protected CidrTestScopeElementImpl(@Nullable String suiteName, @Nullable String testName, @Nullable Function<CidrTestScopeElementImpl, AbstractPropertiesGenerator> factory) {
        this.mySuiteName = StringUtil.nullize((String)suiteName, (boolean)true);
        this.myTestName = StringUtil.nullize((String)testName, (boolean)true);
        this.myDelegate = factory == null ? null : (AbstractPropertiesGenerator)factory.fun((Object)this);
    }

    public CidrTestScopeElementImpl() {
        this(null, null, null);
    }

    @Override
    @Nullable
    public String getSuiteName() {
        return this.mySuiteName;
    }

    @Override
    @Nullable
    public String getTestName() {
        return this.myTestName;
    }

    @Override
    public boolean isTest() {
        this.checkDelegateNotNull();
        return this.myDelegate.isTest();
    }

    @Override
    public boolean isPatternLike() {
        this.checkDelegateNotNull();
        return this.myDelegate.isPatternLike();
    }

    public boolean isVirtualPathHolder() {
        return false;
    }

    @Override
    @NotNull
    public PsiElement getElement() {
        CidrTestScopeElementImpl.throwNotDefined();
        if (null == null) {
            CidrTestScopeElementImpl.$$$reportNull$$$0(0);
        }
        return null;
    }

    @Override
    @Nullable
    public String getId() {
        CidrTestScopeElementImpl.throwNotDefined();
        return null;
    }

    @Override
    public long getSortIndex() {
        return -1L;
    }

    @Contract(value=" -> fail")
    private static void throwNotDefined() {
        throw new RuntimeException("Not defined");
    }

    @Override
    @NotNull
    public String getTestPath() {
        if (this.isVirtualPathHolder()) {
            CidrTestScopeElementImpl.throwNotDefined();
        }
        this.checkDelegateNotNull();
        String string = this.myDelegate.getTestPath();
        if (string == null) {
            CidrTestScopeElementImpl.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String getPattern() {
        this.checkDelegateNotNull();
        String string = this.myDelegate.getPattern();
        if (string == null) {
            CidrTestScopeElementImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @Nullable
    public String getConfigurationName() {
        this.checkDelegateNotNull();
        return this.myDelegate.getConfigurationName();
    }

    private void checkDelegateNotNull() {
        if (this.myDelegate == null) {
            CidrTestScopeElementImpl.throwNotDefined();
        }
    }

    @NotNull
    public String toString() {
        String string = this.getPattern();
        if (string == null) {
            CidrTestScopeElementImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Contract(value="null -> false", pure=true)
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CidrTestScopeElement)) {
            return false;
        }
        return this.getPattern().equals(((CidrTestScopeElement)o).getPattern());
    }

    public int hashCode() {
        return this.getPattern().hashCode();
    }

    @Override
    public int compareTo(CidrTestScopeElement o) {
        return StringUtil.compare((String)this.getPattern(), (String)o.getPattern(), (boolean)false);
    }

    @NotNull
    public static String createPathFromParts(Collection<String> suites) {
        return CidrTestScopeElementImpl.createPathFromParts(ArrayUtilRt.toStringArray(suites));
    }

    @NotNull
    public static String createPathFromParts(String ... suites) {
        if (suites == null) {
            CidrTestScopeElementImpl.$$$reportNull$$$0(4);
        }
        StringBuilder path = new StringBuilder();
        for (String suite : suites) {
            if (!path.isEmpty()) {
                path.append('/');
            }
            path.append(suite);
        }
        String string = path.toString();
        if (string == null) {
            CidrTestScopeElementImpl.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static @Unmodifiable List<String> splitPath(@NotNull String pathWithoutProtocolPrefix) {
        if (pathWithoutProtocolPrefix == null) {
            CidrTestScopeElementImpl.$$$reportNull$$$0(6);
        }
        List list = StringUtil.splitHonorQuotes((String)pathWithoutProtocolPrefix, (char)'/');
        if (list == null) {
            CidrTestScopeElementImpl.$$$reportNull$$$0(7);
        }
        return list;
    }

    @Contract(pure=true)
    @NotNull
    public static CidrTestScopeElement createTestScopeElementForFile(final @NotNull PsiFile file, final @NotNull Supplier<String> patternForFile) {
        if (file == null) {
            CidrTestScopeElementImpl.$$$reportNull$$$0(8);
        }
        if (patternForFile == null) {
            CidrTestScopeElementImpl.$$$reportNull$$$0(9);
        }
        return new CidrTestScopeElementImpl(){

            @Override
            public boolean isPatternLike() {
                return true;
            }

            @Override
            @NotNull
            public String getConfigurationName() {
                String string = CidrExecutionBundle.message("test.defaultName.allTestsIn", file.getName());
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            @NotNull
            public String getPattern() {
                String string = StringUtil.notNullize((String)((String)patternForFile.get()));
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            @Override
            @NotNull
            public PsiElement getElement() {
                PsiFile psiFile = file;
                if (psiFile == null) {
                    1.$$$reportNull$$$0(2);
                }
                return psiFile;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/jetbrains/cidr/execution/testing/CidrTestScopeElementImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getConfigurationName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getPattern";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getElement";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    @Contract(pure=true)
    @NotNull
    public static CidrTestScopeElement createTestScopeElementForSuiteAndTest(@Nullable String suiteName, @Nullable String testName, @NotNull Function<CidrTestScopeElementImpl, AbstractPropertiesGenerator> generator) {
        if (generator == null) {
            CidrTestScopeElementImpl.$$$reportNull$$$0(10);
        }
        return new CidrTestScopeElementImpl(suiteName, testName, generator);
    }

    @Contract(pure=true)
    @NotNull
    public static CidrTestScopeElement createTestScopeElementForVirtualTestPath(final @NotNull String virtualTestPath, final @NotNull String configurationName, final @NotNull Supplier<? extends PsiElement> funGetElement, @Nullable Function<CidrTestScopeElementImpl, AbstractPropertiesGenerator> factory) {
        if (virtualTestPath == null) {
            CidrTestScopeElementImpl.$$$reportNull$$$0(11);
        }
        if (configurationName == null) {
            CidrTestScopeElementImpl.$$$reportNull$$$0(12);
        }
        if (funGetElement == null) {
            CidrTestScopeElementImpl.$$$reportNull$$$0(13);
        }
        return new CidrTestScopeElementImpl(null, null, factory){

            @Override
            public boolean isPatternLike() {
                return true;
            }

            @Override
            @NotNull
            public String getConfigurationName() {
                String string = configurationName;
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            @NotNull
            public String getTestPath() {
                String string = virtualTestPath;
                if (string == null) {
                    2.$$$reportNull$$$0(1);
                }
                return string;
            }

            @Override
            public boolean isVirtualPathHolder() {
                return true;
            }

            @Override
            @NotNull
            public PsiElement getElement() {
                PsiElement psiElement = (PsiElement)funGetElement.get();
                if (psiElement == null) {
                    2.$$$reportNull$$$0(2);
                }
                return psiElement;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/jetbrains/cidr/execution/testing/CidrTestScopeElementImpl$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getConfigurationName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTestPath";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getElement";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    @Contract(pure=true)
    @NotNull
    public static CidrTestScopeElement createTestScopeWithPatternAndConfigurationName(final @NotNull String configurationName, final @NotNull String pattern, final @NotNull Supplier<? extends PsiElement> funGetElement) {
        if (configurationName == null) {
            CidrTestScopeElementImpl.$$$reportNull$$$0(14);
        }
        if (pattern == null) {
            CidrTestScopeElementImpl.$$$reportNull$$$0(15);
        }
        if (funGetElement == null) {
            CidrTestScopeElementImpl.$$$reportNull$$$0(16);
        }
        return new CidrTestScopeElementImpl(){

            @Override
            @NotNull
            public String getConfigurationName() {
                String string = configurationName;
                if (string == null) {
                    3.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            @NotNull
            public String getPattern() {
                String string = pattern;
                if (string == null) {
                    3.$$$reportNull$$$0(1);
                }
                return string;
            }

            @Override
            public boolean isPatternLike() {
                return true;
            }

            @Override
            @NotNull
            public PsiElement getElement() {
                PsiElement psiElement = (PsiElement)funGetElement.get();
                if (psiElement == null) {
                    3.$$$reportNull$$$0(2);
                }
                return psiElement;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/jetbrains/cidr/execution/testing/CidrTestScopeElementImpl$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getConfigurationName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getPattern";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getElement";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 4, 6, 8, 9, 10, 11, 12, 13, 14, 15, 16 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/testing/CidrTestScopeElementImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suites";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathWithoutProtocolPrefix";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternForFile";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generator";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualTestPath";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationName";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "funGetElement";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestPath";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPattern";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/testing/CidrTestScopeElementImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createPathFromParts";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "splitPath";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createPathFromParts";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "splitPath";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createTestScopeElementForFile";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createTestScopeElementForSuiteAndTest";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createTestScopeElementForVirtualTestPath";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createTestScopeWithPatternAndConfigurationName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 4, 6, 8, 9, 10, 11, 12, 13, 14, 15, 16 -> new IllegalArgumentException(string);
        };
    }

    public static abstract class AbstractPropertiesGenerator
    implements CidrTestScopeElement {
        @Override
        @NotNull
        public PsiElement getElement() {
            CidrTestScopeElementImpl.throwNotDefined();
            if (null == null) {
                AbstractPropertiesGenerator.$$$reportNull$$$0(0);
            }
            return null;
        }

        @Override
        @Nullable
        public String getId() {
            CidrTestScopeElementImpl.throwNotDefined();
            return null;
        }

        @Override
        @Nullable
        public String getSuiteName() {
            CidrTestScopeElementImpl.throwNotDefined();
            return null;
        }

        @Override
        @Nullable
        public String getTestName() {
            CidrTestScopeElementImpl.throwNotDefined();
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/testing/CidrTestScopeElementImpl$AbstractPropertiesGenerator", "getElement"));
        }
    }

    public static class DefaultPropertiesGenerator
    extends AbstractPropertiesGenerator {
        protected final CidrTestScopeElementImpl myOwner;

        public DefaultPropertiesGenerator(CidrTestScopeElementImpl owner) {
            this.myOwner = owner;
        }

        @Override
        public boolean isTest() {
            return this.myOwner.myTestName != null;
        }

        @Override
        public boolean isPatternLike() {
            return false;
        }

        @Override
        @NotNull
        public String getTestPath() {
            if (this.myOwner.isVirtualPathHolder()) {
                String string = this.myOwner.getTestPath();
                if (string == null) {
                    DefaultPropertiesGenerator.$$$reportNull$$$0(0);
                }
                return string;
            }
            StringBuilder testName = new StringBuilder();
            if (this.myOwner.mySuiteName != null) {
                testName.append(this.myOwner.mySuiteName);
            }
            if (this.myOwner.myTestName != null) {
                if (!testName.isEmpty()) {
                    testName.append('/');
                }
                testName.append(this.myOwner.myTestName);
            }
            String string = testName.toString();
            if (string == null) {
                DefaultPropertiesGenerator.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @NotNull
        public String getPattern() {
            String string = this.getTestPath();
            if (string == null) {
                DefaultPropertiesGenerator.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        @NotNull
        public String getConfigurationName() {
            if (this.myOwner.myTestName != null) {
                String string = this.myOwner.myTestName;
                if (string == null) {
                    DefaultPropertiesGenerator.$$$reportNull$$$0(3);
                }
                return string;
            }
            if (this.myOwner.mySuiteName != null) {
                int index = this.myOwner.mySuiteName.lastIndexOf(47);
                String string = index < 0 ? this.myOwner.mySuiteName : this.myOwner.mySuiteName.substring(index + 1);
                if (string == null) {
                    DefaultPropertiesGenerator.$$$reportNull$$$0(4);
                }
                return string;
            }
            return "";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/jetbrains/cidr/execution/testing/CidrTestScopeElementImpl$DefaultPropertiesGenerator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTestPath";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPattern";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConfigurationName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

