/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.openapi.application.ReadAction;
import com.intellij.util.ui.GridBag;
import com.jetbrains.cidr.CidrLog;
import com.jetbrains.cidr.execution.CidrBuildConfiguration;
import com.jetbrains.cidr.execution.CidrBuildConfigurationHelper;
import com.jetbrains.cidr.execution.CidrBuildTarget;
import com.jetbrains.cidr.execution.CidrRunConfigurationBuildConfigurationEditor;
import com.jetbrains.cidr.execution.CidrRunConfigurationEditorUtil;
import com.jetbrains.cidr.ui.ComboBoxModelKt;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ComboBoxEditor<BC extends CidrBuildConfiguration, TARGET extends CidrBuildTarget<BC>, BCH extends CidrBuildConfigurationHelper<BC, TARGET>>
implements CidrRunConfigurationBuildConfigurationEditor {
    private final CidrRunConfigurationEditorUtil.ComboBox myComboBox;
    @NotNull
    private final BCH myConfigHelper;
    @NotNull
    private final JComboBox myTargetCombo;

    ComboBoxEditor(@NotNull BCH configHelper, @NotNull JComboBox targetCombo) {
        if (configHelper == null) {
            ComboBoxEditor.$$$reportNull$$$0(0);
        }
        if (targetCombo == null) {
            ComboBoxEditor.$$$reportNull$$$0(1);
        }
        CidrLog.LOG.assertTrue(configHelper.allowEditBuildConfiguration());
        this.myConfigHelper = configHelper;
        this.myTargetCombo = targetCombo;
        this.myComboBox = CidrRunConfigurationEditorUtil.createCombo();
        this.myComboBox.setRenderer(CidrRunConfigurationEditorUtil.getTargetsRenderer(this.myConfigHelper));
        this.myTargetCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 2 && ComboBoxEditor.this.myTargetCombo.getItemCount() > 0) {
                    return;
                }
                CidrBuildTarget target = e.getStateChange() == 1 ? (CidrBuildTarget)ComboBoxModelKt.getItemValue(e) : null;
                ReadAction.run(() -> {
                    ComboBoxEditor.this.myComboBox.setModel(new DefaultComboBoxModel<Object>(ComboBoxEditor.this.myConfigHelper.getConfigurations(target).toArray()));
                    ComboBoxEditor.this.myComboBox.setSelectedItem(null);
                    ComboBoxEditor.this.myComboBox.setSelectedItem(ComboBoxEditor.this.myConfigHelper.getDefaultConfiguration(target));
                });
            }
        });
    }

    @Override
    public void createAdditionalControls(@NotNull JPanel panel, @NotNull GridBag bag) {
        if (panel == null) {
            ComboBoxEditor.$$$reportNull$$$0(2);
        }
        if (bag == null) {
            ComboBoxEditor.$$$reportNull$$$0(3);
        }
        JLabel label = new JLabel(this.myConfigHelper.getConfigurationTitle() + ":");
        panel.add((Component)label, bag.nextLine().next());
        panel.add((Component)((Object)this.myComboBox), bag.next().coverLine());
        label.setLabelFor((Component)((Object)this.myComboBox));
    }

    @Override
    @Nullable
    public String getSelectedConfiguration() {
        CidrBuildConfiguration selectedConfiguration = (CidrBuildConfiguration)ComboBoxModelKt.getSelectedItemValue(this.myComboBox);
        return selectedConfiguration != null ? selectedConfiguration.getName() : (String)ComboBoxModelKt.getSelectedInvalidItemValue(this.myComboBox);
    }

    @Override
    public void selectConfiguration(@Nullable Object item, @Nullable Object invalidItemValue) {
        CidrRunConfigurationEditorUtil.setSelectedItem((JComboBox)((Object)this.myComboBox), item, invalidItemValue);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configHelper";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetCombo";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bag";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/execution/ComboBoxEditor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createAdditionalControls";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

