/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configuration.RunConfigurationExtensionsManager;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.jetbrains.cidr.execution.CidrRunConfigurationExtensionBase;
import com.jetbrains.cidr.execution.ConfigurationExtensionContext;
import com.jetbrains.cidr.execution.RunParameters;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.lang.workspace.OCRunConfiguration;
import java.io.File;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class CidrRunConfigurationExtensionsManager
extends RunConfigurationExtensionsManager<OCRunConfiguration<?, ?>, CidrRunConfigurationExtensionBase> {
    private static final Logger LOG = Logger.getInstance(CidrRunConfigurationExtensionsManager.class);

    public CidrRunConfigurationExtensionsManager() {
        super(CidrRunConfigurationExtensionBase.EP_NAME);
    }

    public static CidrRunConfigurationExtensionsManager getInstance() {
        return (CidrRunConfigurationExtensionsManager)((Object)ApplicationManager.getApplication().getService(CidrRunConfigurationExtensionsManager.class));
    }

    public void patchCommandLineState(@NotNull OCRunConfiguration configuration, @Nullable RunnerSettings runnerSettings, @NotNull CidrToolEnvironment environment, @Nullable File projectBaseDir, @NotNull CommandLineState state, @NotNull String runnerId, @NotNull ConfigurationExtensionContext context) {
        if (configuration == null) {
            CidrRunConfigurationExtensionsManager.$$$reportNull$$$0(0);
        }
        if (environment == null) {
            CidrRunConfigurationExtensionsManager.$$$reportNull$$$0(1);
        }
        if (state == null) {
            CidrRunConfigurationExtensionsManager.$$$reportNull$$$0(2);
        }
        if (runnerId == null) {
            CidrRunConfigurationExtensionsManager.$$$reportNull$$$0(3);
        }
        if (context == null) {
            CidrRunConfigurationExtensionsManager.$$$reportNull$$$0(4);
        }
        for (CidrRunConfigurationExtensionBase extension : this.getEnabledExtensions(configuration, environment, runnerSettings)) {
            extension.patchCommandLineState(configuration, runnerSettings, environment, projectBaseDir, state, runnerId, context);
        }
    }

    @Deprecated
    public void patchCommandLine(@NotNull OCRunConfiguration configuration, RunnerSettings runnerSettings, @NotNull GeneralCommandLine cmdLine, @NotNull String runnerId) {
        if (configuration == null) {
            CidrRunConfigurationExtensionsManager.$$$reportNull$$$0(5);
        }
        if (cmdLine == null) {
            CidrRunConfigurationExtensionsManager.$$$reportNull$$$0(6);
        }
        if (runnerId == null) {
            CidrRunConfigurationExtensionsManager.$$$reportNull$$$0(7);
        }
        LOG.error("This method is deprecated. Use another signature instead.");
    }

    public void patchCommandLine(@NotNull OCRunConfiguration configuration, @Nullable RunnerSettings runnerSettings, @NotNull CidrToolEnvironment environment, @NotNull GeneralCommandLine cmdLine, @NotNull String runnerId, @NotNull ConfigurationExtensionContext context) throws ExecutionException {
        if (configuration == null) {
            CidrRunConfigurationExtensionsManager.$$$reportNull$$$0(8);
        }
        if (environment == null) {
            CidrRunConfigurationExtensionsManager.$$$reportNull$$$0(9);
        }
        if (cmdLine == null) {
            CidrRunConfigurationExtensionsManager.$$$reportNull$$$0(10);
        }
        if (runnerId == null) {
            CidrRunConfigurationExtensionsManager.$$$reportNull$$$0(11);
        }
        if (context == null) {
            CidrRunConfigurationExtensionsManager.$$$reportNull$$$0(12);
        }
        for (CidrRunConfigurationExtensionBase extension : this.getEnabledExtensions(configuration, environment, runnerSettings)) {
            extension.patchCommandLine(configuration, runnerSettings, environment, cmdLine, runnerId, context);
        }
    }

    @Deprecated
    public void attachExtensionsToProcess(@NotNull OCRunConfiguration configuration, @NotNull ProcessHandler handler, RunnerSettings runnerSettings) {
        if (configuration == null) {
            CidrRunConfigurationExtensionsManager.$$$reportNull$$$0(13);
        }
        if (handler == null) {
            CidrRunConfigurationExtensionsManager.$$$reportNull$$$0(14);
        }
        LOG.error("This method is deprecated. Use another signature instead.");
    }

    public void attachExtensionsToProcess(@NotNull OCRunConfiguration configuration, @NotNull ProcessHandler handler, @NotNull CidrToolEnvironment environment, @Nullable RunnerSettings runnerSettings, @NotNull String runnerId, @NotNull ConfigurationExtensionContext context) {
        if (configuration == null) {
            CidrRunConfigurationExtensionsManager.$$$reportNull$$$0(15);
        }
        if (handler == null) {
            CidrRunConfigurationExtensionsManager.$$$reportNull$$$0(16);
        }
        if (environment == null) {
            CidrRunConfigurationExtensionsManager.$$$reportNull$$$0(17);
        }
        if (runnerId == null) {
            CidrRunConfigurationExtensionsManager.$$$reportNull$$$0(18);
        }
        if (context == null) {
            CidrRunConfigurationExtensionsManager.$$$reportNull$$$0(19);
        }
        for (CidrRunConfigurationExtensionBase extension : this.getEnabledExtensions(configuration, environment, runnerSettings)) {
            extension.attachToProcess(configuration, handler, environment, runnerSettings, runnerId, context);
        }
    }

    @RequiresBackgroundThread
    @Nullable
    public XDebugProcess createDebugProcess(@NotNull OCRunConfiguration<?, ?> configuration, @Nullable RunnerSettings runnerSettings, @NotNull CidrToolEnvironment environment, @NotNull Path file, @NotNull RunParameters parameters, @NotNull XDebugSession session, @NotNull TextConsoleBuilder consoleBuilder, boolean isEmulatedTerminal) throws ExecutionException {
        if (configuration == null) {
            CidrRunConfigurationExtensionsManager.$$$reportNull$$$0(20);
        }
        if (environment == null) {
            CidrRunConfigurationExtensionsManager.$$$reportNull$$$0(21);
        }
        if (file == null) {
            CidrRunConfigurationExtensionsManager.$$$reportNull$$$0(22);
        }
        if (parameters == null) {
            CidrRunConfigurationExtensionsManager.$$$reportNull$$$0(23);
        }
        if (session == null) {
            CidrRunConfigurationExtensionsManager.$$$reportNull$$$0(24);
        }
        if (consoleBuilder == null) {
            CidrRunConfigurationExtensionsManager.$$$reportNull$$$0(25);
        }
        for (CidrRunConfigurationExtensionBase extension : this.getEnabledExtensions(configuration, environment, runnerSettings)) {
            XDebugProcess process = extension.createDebugProcess(configuration.getProject(), file, environment, parameters, session, consoleBuilder, isEmulatedTerminal);
            if (process == null) continue;
            return process;
        }
        return null;
    }

    @NotNull
    private List<CidrRunConfigurationExtensionBase> getEnabledExtensions(@NotNull OCRunConfiguration configuration, @NotNull CidrToolEnvironment environment, @Nullable RunnerSettings runnerSettings) {
        if (configuration == null) {
            CidrRunConfigurationExtensionsManager.$$$reportNull$$$0(26);
        }
        if (environment == null) {
            CidrRunConfigurationExtensionsManager.$$$reportNull$$$0(27);
        }
        SmartList extensions = new SmartList();
        for (CidrRunConfigurationExtensionBase extension : this.getApplicableExtensions((RunConfigurationBase)configuration)) {
            if (!extension.isEnabledFor(configuration, environment, runnerSettings)) continue;
            extensions.add(extension);
        }
        List<CidrRunConfigurationExtensionBase> list = Collections.unmodifiableList(extensions);
        if (list == null) {
            CidrRunConfigurationExtensionsManager.$$$reportNull$$$0(28);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 28 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: 
            case 9: 
            case 17: 
            case 21: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnerId";
                break;
            }
            case 4: 
            case 12: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmdLine";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleBuilder";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/CidrRunConfigurationExtensionsManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/CidrRunConfigurationExtensionsManager";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnabledExtensions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "patchCommandLineState";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "patchCommandLine";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "attachExtensionsToProcess";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createDebugProcess";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getEnabledExtensions";
                break;
            }
            case 28: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 28 -> new IllegalStateException(string);
        };
    }
}

