/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cidr.translateCode;

import com.intellij.cidr.translateCode.CidrToggleRawTranslatedCodeAction;
import com.intellij.cidr.translateCode.CidrTranslateCodeActionKt;
import com.intellij.cidr.translateCode.CidrTranslateCodeBundle;
import com.intellij.cidr.translateCode.CidrTranslatedCodeBlock;
import com.intellij.cidr.translateCode.CidrTranslationCommand;
import com.intellij.cidr.translateCode.CidrTranslationResult;
import com.intellij.cidr.translateCode.CidrTranslator;
import com.intellij.cidr.translateCode.TranslatedCodeEditor;
import com.intellij.cidr.translateCode.TranslatedFile;
import com.intellij.cidr.translateCode.TranslatedResultUiInfo;
import com.intellij.cidr.translateCode.TranslationDividerPainter;
import com.intellij.cidr.translateCode.TranslationOptionsGroup;
import com.intellij.diff.tools.util.DiffSplitter;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.client.ClientSystemInfo;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.ex.EditorGutterFreePainterAreaState;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.editor.impl.EditorHeaderComponent;
import com.intellij.openapi.editor.markup.ActiveGutterRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.TextEditorWithPreview;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.JBColor;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.util.UiSizeUtilKt;
import com.intellij.util.DocumentUtil;
import com.intellij.util.Function;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u0000 92\u00020\u00012\u00020\u0002:\u00049:;<B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0002J\u0012\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010*\u001a\u00020'H\u0002J \u0010+\u001a\u00020%2\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0007J\b\u00100\u001a\u00020%H\u0002J\u0010\u00101\u001a\u00020%2\u0006\u00102\u001a\u000203H\u0002J\b\u00104\u001a\u000205H\u0014J\b\u00106\u001a\u000207H\u0014J\b\u00108\u001a\u00020%H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u001c\u0010\u0013\u001a\u0010\u0012\f\u0012\n \u0016*\u0004\u0018\u00010\u00150\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u001c\u0010\u001e\u001a\u0010\u0012\f\u0012\n \u0016*\u0004\u0018\u00010\u001f0\u001f0\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lcom/intellij/cidr/translateCode/TranslatedCodeEditor;", "Lcom/intellij/openapi/fileEditor/TextEditorWithPreview;", "Lcom/intellij/openapi/fileEditor/TextEditor;", "project", "Lcom/intellij/openapi/project/Project;", "leftTextEditor", "rightTextEditor", "translatedFile", "Lcom/intellij/cidr/translateCode/TranslatedFile;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/fileEditor/TextEditor;Lcom/intellij/openapi/fileEditor/TextEditor;Lcom/intellij/cidr/translateCode/TranslatedFile;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "leftEditor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "getLeftEditor", "()Lcom/intellij/openapi/editor/ex/EditorEx;", "rightEditor", "getRightEditor", "myTranslator", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/cidr/translateCode/CidrTranslator;", "kotlin.jvm.PlatformType", "translator", "getTranslator", "()Lcom/intellij/cidr/translateCode/CidrTranslator;", "translatorType", "", "getTranslatorType", "()Ljava/lang/String;", "myTranslationInfo", "Lcom/intellij/cidr/translateCode/TranslatedResultUiInfo;", "mySrcModStamp", "Ljava/util/concurrent/atomic/AtomicLong;", "mySplitter", "Lcom/intellij/diff/tools/util/DiffSplitter;", "scrollRightEditorToLeftOffset", "", "leftOffset", "", "findClosestBlockForSrcLine", "Lcom/intellij/cidr/translateCode/CidrTranslatedCodeBlock;", "srcLine0", "updateTranslationResult", "srcFileModStamp", "", "newResult", "Lcom/intellij/cidr/translateCode/CidrTranslationResult;", "highlightBlocks", "removeHighlighters", "editor", "Lcom/intellij/openapi/editor/Editor;", "createSplitter", "Lcom/intellij/ui/JBSplitter;", "createViewActionGroup", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "setupHeaderComponent", "Companion", "FloatingRefreshAction", "CmdHeader", "HoveredBlockHighlighter", "intellij.cidr.translateCode"})
@SourceDebugExtension(value={"SMAP\nCidrTranslateCodeAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CidrTranslateCodeAction.kt\ncom/intellij/cidr/translateCode/TranslatedCodeEditor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1236:1\n1#2:1237\n1863#3,2:1238\n*S KotlinDebug\n*F\n+ 1 CidrTranslateCodeAction.kt\ncom/intellij/cidr/translateCode/TranslatedCodeEditor\n*L\n817#1:1238,2\n*E\n"})
final class TranslatedCodeEditor
extends TextEditorWithPreview
implements TextEditor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final EditorEx leftEditor;
    @NotNull
    private final EditorEx rightEditor;
    @NotNull
    private final AtomicReference<CidrTranslator> myTranslator;
    @NotNull
    private final AtomicReference<TranslatedResultUiInfo> myTranslationInfo;
    @NotNull
    private final AtomicLong mySrcModStamp;
    @NotNull
    private final DiffSplitter mySplitter;
    public static final int gutterLeftRectWidth = 10;

    public TranslatedCodeEditor(@NotNull Project project, @NotNull TextEditor leftTextEditor, @NotNull TextEditor rightTextEditor, final @NotNull TranslatedFile translatedFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)leftTextEditor, (String)"leftTextEditor");
        Intrinsics.checkNotNullParameter((Object)rightTextEditor, (String)"rightTextEditor");
        Intrinsics.checkNotNullParameter((Object)((Object)translatedFile), (String)"translatedFile");
        super(leftTextEditor, (FileEditor)rightTextEditor, null, null, false, null, 60, null);
        this.project = project;
        Editor editor = leftTextEditor.getEditor();
        Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
        this.leftEditor = (EditorEx)editor;
        Editor editor2 = rightTextEditor.getEditor();
        Intrinsics.checkNotNull((Object)editor2, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
        this.rightEditor = (EditorEx)editor2;
        this.myTranslator = new AtomicReference<CidrTranslator>(translatedFile.getTranslator());
        this.myTranslationInfo = new AtomicReference<TranslatedResultUiInfo>(new TranslatedResultUiInfo(translatedFile.getTranslationResult(), (Editor)this.leftEditor, (Editor)this.rightEditor));
        this.mySrcModStamp = new AtomicLong(translatedFile.getSrcFileModStamp());
        Disposer.register((Disposable)((Disposable)this), () -> TranslatedCodeEditor._init_$lambda$0(this));
        Disposer.register((Disposable)((Disposable)this), () -> TranslatedCodeEditor._init_$lambda$1(this));
        this.leftEditor.putUserData(CidrTranslateCodeActionKt.access$getTranslatedCodeEditorKey$p(), (Object)this);
        this.rightEditor.putUserData(CidrTranslateCodeActionKt.access$getTranslatedCodeEditorKey$p(), (Object)this);
        this.rightEditor.getGutterComponentEx().setRightFreePaintersAreaState(EditorGutterFreePainterAreaState.SHOW);
        this.rightEditor.getColorsScheme().setColor(EditorColors.GUTTER_BACKGROUND, CidrTranslateCodeActionKt.getGutterColor((Editor)this.rightEditor));
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect((Disposable)this);
        Topic topic = EditorColorsManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, arg_0 -> TranslatedCodeEditor._init_$lambda$3(this, arg_0));
        this.highlightBlocks();
        this.setLayout(TextEditorWithPreview.Layout.SHOW_EDITOR_AND_PREVIEW);
        JComponent jComponent = this.leftEditor.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        UiNotifyConnector.Companion.installOn((Component)jComponent, new Activatable(){
            private boolean done;

            public final boolean getDone() {
                return this.done;
            }

            public final void setDone(boolean bl) {
                this.done = bl;
            }

            public void showNotify() {
                if (!this.done) {
                    this.getLeftEditor().getCaretModel().moveToOffset(translatedFile.getInitialCaretOffset());
                    this.getLeftEditor().getScrollingModel().scrollToCaret(ScrollType.CENTER);
                    this.getLeftEditor().getContentComponent().requestFocus();
                    this.scrollRightEditorToLeftOffset(translatedFile.getInitialCaretOffset());
                    this.done = true;
                }
            }
        });
        this.setupHeaderComponent();
        this.mySplitter = new DiffSplitter(){
            private Integer diffDividerWidth = this.getDividerWidth() + 10;

            public final Integer getDiffDividerWidth() {
                return this.diffDividerWidth;
            }

            public final void setDiffDividerWidth(Integer n) {
                this.diffDividerWidth = n;
            }

            public int getDividerWidth() {
                Integer n = this.diffDividerWidth;
                return n != null ? n.intValue() : super.getDividerWidth();
            }
        };
        Editor editor3 = (Editor)this.leftEditor;
        Editor editor4 = (Editor)this.rightEditor;
        TranslatedResultUiInfo translatedResultUiInfo = this.myTranslationInfo.get();
        Intrinsics.checkNotNullExpressionValue((Object)translatedResultUiInfo, (String)"get(...)");
        this.mySplitter.setPainter((DiffSplitter.Painter)new TranslationDividerPainter(editor3, editor4, translatedResultUiInfo));
        this.rightEditor.getGutterComponentEx().addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                ((TranslatedResultUiInfo)myTranslationInfo.get()).setMouseOverRightGutter(true);
                mySplitter.repaintDivider();
                this.getRightEditor().getGutterComponentEx().repaint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ((TranslatedResultUiInfo)myTranslationInfo.get()).setMouseOverRightGutter(false);
                mySplitter.repaintDivider();
                this.getRightEditor().getGutterComponentEx().repaint();
            }
        });
        VisibleAreaListener myScrollListener = arg_0 -> TranslatedCodeEditor._init_$lambda$4(this, arg_0);
        this.leftEditor.getScrollingModel().addVisibleAreaListener(myScrollListener);
        this.rightEditor.getScrollingModel().addVisibleAreaListener(myScrollListener);
        final HoveredBlockHighlighter leftHover = new HoveredBlockHighlighter(true);
        this.leftEditor.addEditorMouseMotionListener((EditorMouseMotionListener)leftHover);
        HoveredBlockHighlighter rightHover = new HoveredBlockHighlighter(false);
        this.rightEditor.addEditorMouseMotionListener((EditorMouseMotionListener)rightHover);
        final JPanel divider = (this.mySplitter).getDivider();
        divider.setBackground(CidrTranslateCodeActionKt.getGutterColor((Editor)this.rightEditor));
        divider.setCursor(Cursor.getPredefinedCursor(0));
        divider.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                if (e == null) {
                    return;
                }
                int dividerYOffset = e.getPoint().y;
                int yOffsetInEditor = CidrTranslateCodeActionKt.verticalScrollOffsetFromHeader((Editor)this.getLeftEditor()) + dividerYOffset;
                MouseEvent event = new MouseEvent(e.getComponent(), e.getID(), e.getWhen(), e.getModifiers(), 0, yOffsetInEditor, e.getClickCount(), e.isPopupTrigger(), e.getButton());
                leftHover.mouseMoved(new EditorMouseEvent((Editor)this.getLeftEditor(), event, EditorMouseEventArea.EDITING_AREA));
                int srcLine0 = this.getLeftEditor().xyToLogicalPosition((Point)new Point((int)0, (int)yOffsetInEditor)).line;
                TranslatedResultUiInfo transInfo = (TranslatedResultUiInfo)myTranslationInfo.get();
                int blockId = transInfo.blockIdForSrcLine0(srcLine0);
                if (blockId != 0) {
                    divider.setCursor(Cursor.getPredefinedCursor(12));
                } else if (e.getPoint().x < 5) {
                    divider.setCursor(Cursor.getPredefinedCursor(10));
                } else {
                    divider.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
        divider.addMouseListener(new MouseAdapter(){
            private int lastShownTranslatedRangeIndex;
            private int prevBlockId;

            public final int getLastShownTranslatedRangeIndex() {
                return this.lastShownTranslatedRangeIndex;
            }

            public final void setLastShownTranslatedRangeIndex(int n) {
                this.lastShownTranslatedRangeIndex = n;
            }

            public final int getPrevBlockId() {
                return this.prevBlockId;
            }

            public final void setPrevBlockId(int n) {
                this.prevBlockId = n;
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                int blockId;
                if (e == null) {
                    return;
                }
                int dividerYOffset = e.getPoint().y;
                int yOffsetInEditor = CidrTranslateCodeActionKt.verticalScrollOffsetFromHeader((Editor)this.getLeftEditor()) + dividerYOffset;
                int srcLine0 = this.getLeftEditor().xyToLogicalPosition((Point)new Point((int)0, (int)yOffsetInEditor)).line;
                TranslatedResultUiInfo transInfo = (TranslatedResultUiInfo)myTranslationInfo.get();
                CidrTranslatedCodeBlock block = transInfo.blockById(blockId = transInfo.blockIdForSrcLine0(srcLine0));
                if (block != null) {
                    if (blockId == this.prevBlockId) {
                        int n = this.lastShownTranslatedRangeIndex;
                        this.lastShownTranslatedRangeIndex = n + 1;
                    } else {
                        this.lastShownTranslatedRangeIndex = 0;
                    }
                    int transLine = block.getTranslatedRanges().get(this.lastShownTranslatedRangeIndex % block.getTranslatedRanges().size()).getFirst();
                    int transLineYOffset = this.getRightEditor().offsetToXY((int)this.getRightEditor().getDocument().getLineStartOffset((int)transLine)).y + CidrTranslateCodeActionKt.access$headerHeight((Editor)this.getRightEditor());
                    this.getRightEditor().getScrollingModel().scrollVertically(transLineYOffset - dividerYOffset);
                }
                this.prevBlockId = blockId;
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                ((TranslatedResultUiInfo)myTranslationInfo.get()).setMouseOverDivider(true);
                mySplitter.repaintDivider();
                this.getRightEditor().getGutterComponentEx().repaint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ((TranslatedResultUiInfo)myTranslationInfo.get()).setMouseOverDivider(false);
                mySplitter.repaintDivider();
                this.getRightEditor().getGutterComponentEx().repaint();
            }
        });
        this.leftEditor.getDocument().addDocumentListener(new DocumentListener(){

            public void documentChanged(DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.removeHighlighters((Editor)this.getLeftEditor());
                this.removeHighlighters((Editor)this.getRightEditor());
            }
        }, (Disposable)this);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final EditorEx getLeftEditor() {
        return this.leftEditor;
    }

    @NotNull
    public final EditorEx getRightEditor() {
        return this.rightEditor;
    }

    @NotNull
    public final CidrTranslator getTranslator() {
        CidrTranslator cidrTranslator = this.myTranslator.get();
        Intrinsics.checkNotNullExpressionValue((Object)cidrTranslator, (String)"get(...)");
        return cidrTranslator;
    }

    @NotNull
    public final String getTranslatorType() {
        return this.myTranslator.get().getType();
    }

    private final void scrollRightEditorToLeftOffset(int leftOffset) {
        DocumentEx documentEx = this.leftEditor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
        DocumentEx leftDoc = documentEx;
        boolean bl = 0 <= leftOffset ? leftOffset < leftDoc.getTextLength() : false;
        if (bl) {
            Integer rightLine;
            int srcLine = this.leftEditor.getDocument().getLineNumber(leftOffset);
            CidrTranslatedCodeBlock block = this.findClosestBlockForSrcLine(srcLine);
            Object object = block;
            Integer n = object != null && (object = ((CidrTranslatedCodeBlock)object).getTranslatedRanges()) != null && (object = (IntRange)CollectionsKt.firstOrNull((List)object)) != null ? Integer.valueOf(object.getFirst()) : (rightLine = null);
            if (rightLine != null && RangesKt.until((int)0, (int)this.rightEditor.getDocument().getLineCount()).contains(rightLine.intValue())) {
                int rightOffset = this.rightEditor.getDocument().getLineStartOffset(rightLine.intValue());
                this.rightEditor.getCaretModel().moveToOffset(rightOffset);
                this.rightEditor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
            }
        }
    }

    private final CidrTranslatedCodeBlock findClosestBlockForSrcLine(int srcLine0) {
        CidrTranslatedCodeBlock result2 = null;
        int minDistance = Integer.MAX_VALUE;
        for (CidrTranslatedCodeBlock block : this.myTranslationInfo.get().getTranslationResult().getBlocks()) {
            if (block.getSrcRange().contains(srcLine0)) {
                result2 = block;
                break;
            }
            int dist1 = Math.abs(srcLine0 - block.getSrcRange().getFirst());
            int dist2 = Math.abs(srcLine0 - block.getSrcRange().getLast());
            if (dist1 < minDistance) {
                result2 = block;
                minDistance = dist1;
            }
            if (dist2 >= minDistance) continue;
            result2 = block;
            minDistance = dist2;
        }
        return result2;
    }

    @RequiresEdt
    public final void updateTranslationResult(@NotNull CidrTranslator translator, long srcFileModStamp, @NotNull CidrTranslationResult newResult) {
        Intrinsics.checkNotNullParameter((Object)translator, (String)"translator");
        Intrinsics.checkNotNullParameter((Object)newResult, (String)"newResult");
        this.myTranslator.set(translator);
        this.myTranslationInfo.get().clearCurrentBlockHighlighters();
        if (!Intrinsics.areEqual((Object)this.myTranslationInfo.get().getTranslationResult().getFileType(), (Object)newResult.getFileType())) {
            EditorHighlighterFactory editorHighlighterFactory = EditorHighlighterFactory.Companion.getInstance();
            FileType fileType = newResult.getFileType();
            EditorColorsScheme editorColorsScheme = this.getEditor().getColorsScheme();
            Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getColorsScheme(...)");
            this.rightEditor.setHighlighter(editorHighlighterFactory.createEditorHighlighter(fileType, editorColorsScheme, this.project));
        }
        this.myTranslationInfo.set(new TranslatedResultUiInfo(newResult, (Editor)this.leftEditor, (Editor)this.rightEditor));
        this.mySrcModStamp.set(srcFileModStamp);
        this.setupHeaderComponent();
        this.highlightBlocks();
        Editor editor = (Editor)this.leftEditor;
        Editor editor2 = (Editor)this.rightEditor;
        TranslatedResultUiInfo translatedResultUiInfo = this.myTranslationInfo.get();
        Intrinsics.checkNotNullExpressionValue((Object)translatedResultUiInfo, (String)"get(...)");
        this.mySplitter.setPainter((DiffSplitter.Painter)new TranslationDividerPainter(editor, editor2, translatedResultUiInfo));
        this.mySplitter.repaintDivider();
        this.scrollRightEditorToLeftOffset(this.leftEditor.getCaretModel().getOffset());
    }

    private final void highlightBlocks() {
        this.removeHighlighters((Editor)this.leftEditor);
        this.removeHighlighters((Editor)this.rightEditor);
        MarkupModelEx markupModelEx = this.leftEditor.getMarkupModel();
        Intrinsics.checkNotNullExpressionValue((Object)markupModelEx, (String)"getMarkupModel(...)");
        MarkupModelEx leftMarkup = markupModelEx;
        MarkupModelEx markupModelEx2 = this.rightEditor.getMarkupModel();
        Intrinsics.checkNotNullExpressionValue((Object)markupModelEx2, (String)"getMarkupModel(...)");
        MarkupModelEx rightMarkup = markupModelEx2;
        DocumentEx documentEx = this.leftEditor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
        DocumentEx leftDoc = documentEx;
        DocumentEx documentEx2 = this.rightEditor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx2, (String)"getDocument(...)");
        DocumentEx rightDoc = documentEx2;
        int leftMaxLine = leftDoc.getLineCount() - 1;
        int rightMaxLine = rightDoc.getLineCount() - 1;
        IntRange leftRange = new IntRange(0, leftMaxLine);
        IntRange rightRange = new IntRange(0, rightMaxLine);
        if (leftRange.isEmpty() || rightRange.isEmpty()) {
            return;
        }
        ArrayList<RangeHighlighter> leftHighlighters = new ArrayList<RangeHighlighter>();
        ArrayList<RangeHighlighter> rightHighlighters = new ArrayList<RangeHighlighter>();
        TranslatedResultUiInfo translationInfo = this.myTranslationInfo.get();
        for (Pair<Integer, CidrTranslatedCodeBlock> pair : translationInfo.blocksWithId()) {
            Color bgColor;
            TextAttributes textAttributes;
            int blockId = ((Number)pair.component1()).intValue();
            CidrTranslatedCodeBlock block = (CidrTranslatedCodeBlock)pair.component2();
            if ((Color)translationInfo.colorForBlock(blockId).getFirst() == null) continue;
            TextAttributes $this$highlightBlocks_u24lambda_u245 = textAttributes = new TextAttributes();
            boolean bl = false;
            $this$highlightBlocks_u24lambda_u245.setBackgroundColor(bgColor);
            TextAttributes attributes = textAttributes;
            if (block.getSrcEndLine() > block.getSrcStartLine()) {
                int leftStartOffset = leftDoc.getLineStartOffset(RangesKt.coerceIn((int)block.getSrcStartLine(), (ClosedRange)((ClosedRange)leftRange)));
                int leftEndOffset = leftDoc.getLineEndOffset(RangesKt.coerceIn((int)(block.getSrcEndLine() - 1), (ClosedRange)((ClosedRange)leftRange)));
                leftHighlighters.add(leftMarkup.addRangeHighlighter(leftStartOffset, leftEndOffset, 3000, attributes, HighlighterTargetArea.LINES_IN_RANGE));
            }
            List<IntRange> transRanges = block.getTranslatedRanges();
            for (IntRange transRange : transRanges) {
                RangeHighlighter rightHighlighter;
                int transStart = transRange.getFirst();
                int transEnd = transRange.getLast();
                if (transEnd <= transStart) continue;
                int rightStartOffset = rightDoc.getLineStartOffset(RangesKt.coerceIn((int)transStart, (ClosedRange)((ClosedRange)rightRange)));
                int rightEndOffset = rightDoc.getLineEndOffset(RangesKt.coerceIn((int)(transEnd - 1), (ClosedRange)((ClosedRange)rightRange)));
                Intrinsics.checkNotNullExpressionValue((Object)rightMarkup.addRangeHighlighter(rightStartOffset, rightEndOffset, 3000, attributes, HighlighterTargetArea.LINES_IN_RANGE), (String)"addRangeHighlighter(...)");
                rightHighlighters.add(rightHighlighter);
            }
        }
        this.leftEditor.putUserData(CidrTranslateCodeActionKt.access$getHighlightersKey$p(), leftHighlighters);
        this.rightEditor.putUserData(CidrTranslateCodeActionKt.access$getHighlightersKey$p(), rightHighlighters);
    }

    private final void removeHighlighters(Editor editor) {
        List list = (List)editor.getUserData(CidrTranslateCodeActionKt.access$getHighlightersKey$p());
        if (list != null) {
            List highlighters = list;
            boolean bl = false;
            Iterable $this$forEach$iv = highlighters;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RangeHighlighter it = (RangeHighlighter)element$iv;
                boolean bl2 = false;
                editor.getMarkupModel().removeHighlighter(it);
            }
        }
        editor.putUserData(CidrTranslateCodeActionKt.access$getHighlightersKey$p(), null);
    }

    @NotNull
    protected JBSplitter createSplitter() {
        return (JBSplitter)this.mySplitter;
    }

    @NotNull
    protected ActionGroup createViewActionGroup() {
        ActionGroup actionGroup;
        CidrTranslationCommand cmd = this.myTranslationInfo.get().getTranslationResult().getCommand();
        if (cmd == null) {
            AnAction[] anActionArray = new AnAction[]{new FloatingRefreshAction()};
            actionGroup = (ActionGroup)new DefaultActionGroup(anActionArray);
        } else {
            actionGroup = (ActionGroup)new DefaultActionGroup();
        }
        return actionGroup;
    }

    private final void setupHeaderComponent() {
        CmdHeader cmdHeader;
        CidrTranslationResult translationResult = this.myTranslationInfo.get().getTranslationResult();
        CidrTranslationCommand cmd = translationResult.getCommand();
        if (cmd == null) {
            this.rightEditor.setPermanentHeaderComponent(null);
            this.rightEditor.setHeaderComponent(null);
            return;
        }
        JComponent jComponent = this.rightEditor.getPermanentHeaderComponent();
        CmdHeader cmdHeader2 = cmdHeader = jComponent instanceof CmdHeader ? (CmdHeader)((Object)jComponent) : null;
        if (cmdHeader != null) {
            cmdHeader.update(cmd, translationResult.getOptions());
        } else {
            CmdHeader header = new CmdHeader(cmd, translationResult.getOptions());
            this.rightEditor.setPermanentHeaderComponent((JComponent)((Object)header));
            this.rightEditor.setHeaderComponent((JComponent)((Object)header));
        }
    }

    private static final void _init_$lambda$0(TranslatedCodeEditor this$0) {
        EditorFactory.getInstance().releaseEditor((Editor)this$0.leftEditor);
    }

    private static final void _init_$lambda$1(TranslatedCodeEditor this$0) {
        EditorFactory.getInstance().releaseEditor((Editor)this$0.rightEditor);
    }

    private static final void lambda$3$lambda$2(TranslatedCodeEditor this$0) {
        this$0.highlightBlocks();
        this$0.rightEditor.getColorsScheme().setColor(EditorColors.GUTTER_BACKGROUND, CidrTranslateCodeActionKt.getGutterColor((Editor)this$0.rightEditor));
    }

    private static final void _init_$lambda$3(TranslatedCodeEditor this$0, EditorColorsScheme it) {
        ApplicationManager.getApplication().invokeLater(() -> TranslatedCodeEditor.lambda$3$lambda$2(this$0));
    }

    private static final void _init_$lambda$4(TranslatedCodeEditor this$0, VisibleAreaEvent visibleAreaEvent) {
        Intrinsics.checkNotNullParameter((Object)visibleAreaEvent, (String)"<unused var>");
        this$0.mySplitter.repaint();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000*\u0001\u001d\b\u0086\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u001c\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00042\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\b\u0010#\u001a\u00020\u0019H\u0002J\u0006\u0010$\u001a\u00020\u0004J\u0010\u0010%\u001a\u00020 2\u0006\u0010&\u001a\u00020'H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u000e\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u0006\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0011\u0010\u0012R&\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u00060\u000fX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0014\u0010\u0012R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001e\u00a8\u0006("}, d2={"Lcom/intellij/cidr/translateCode/TranslatedCodeEditor$CmdHeader;", "Lcom/intellij/openapi/editor/impl/EditorHeaderComponent;", "Lcom/intellij/openapi/actionSystem/UiDataProvider;", "cmd", "Lcom/intellij/cidr/translateCode/CidrTranslationCommand;", "options", "", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "<init>", "(Lcom/intellij/cidr/translateCode/TranslatedCodeEditor;Lcom/intellij/cidr/translateCode/CidrTranslationCommand;Ljava/util/List;)V", "executableLabel", "Ljavax/swing/JLabel;", "argumentsEditor", "Lcom/intellij/ui/RawCommandLineEditor;", "argsJoiner", "Lcom/intellij/util/Function;", "", "getArgsJoiner$annotations", "()V", "argsParser", "getArgsParser$annotations", "lastFocusedEditor", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/openapi/editor/Editor;", "actionsPanel", "Ljavax/swing/JPanel;", "refresh", "Lcom/intellij/openapi/actionSystem/impl/ActionButton;", "refreshHeaderAction", "com/intellij/cidr/translateCode/TranslatedCodeEditor$CmdHeader$refreshHeaderAction$1", "Lcom/intellij/cidr/translateCode/TranslatedCodeEditor$CmdHeader$refreshHeaderAction$1;", "update", "", "newCmd", "newOptions", "createActionsPanel", "getCustomCommand", "uiDataSnapshot", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "intellij.cidr.translateCode"})
    public final class CmdHeader
    extends EditorHeaderComponent
    implements UiDataProvider {
        @NotNull
        private CidrTranslationCommand cmd;
        @NotNull
        private List<? extends ToggleAction> options;
        @NotNull
        private final JLabel executableLabel;
        @NotNull
        private final RawCommandLineEditor argumentsEditor;
        @NotNull
        private final Function<List<String>, String> argsJoiner;
        @NotNull
        private final Function<String, List<String>> argsParser;
        @NotNull
        private final AtomicReference<Editor> lastFocusedEditor;
        @NotNull
        private JPanel actionsPanel;
        @NotNull
        private final ActionButton refresh;
        @NotNull
        private final refreshHeaderAction.1 refreshHeaderAction;

        public CmdHeader(@NotNull CidrTranslationCommand cmd, List<? extends ToggleAction> options2) {
            Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
            Intrinsics.checkNotNullParameter(options2, (String)"options");
            this.cmd = cmd;
            this.options = options2;
            this.lastFocusedEditor = new AtomicReference<EditorEx>(TranslatedCodeEditor.this.getLeftEditor());
            this.refreshHeaderAction = new AnAction(TranslatedCodeEditor.this){
                final /* synthetic */ TranslatedCodeEditor this$0;
                {
                    this.this$0 = $receiver;
                }

                public void actionPerformed(AnActionEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    e.getPresentation().setEnabled(false);
                    V v = TranslatedCodeEditor.access$getMyTranslator$p(this.this$0).get();
                    Intrinsics.checkNotNullExpressionValue(v, (String)"get(...)");
                    Job job = CidrTranslateCodeActionKt.runTranslator((CidrTranslator)v, this.this$0.getEditor());
                    if (job == null) {
                        e.getPresentation().setEnabled(true);
                    } else {
                        job.invokeOnCompletion(arg_0 -> refreshHeaderAction.1.actionPerformed$lambda$0(e, arg_0));
                    }
                }

                public void update(AnActionEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    e.getPresentation().setIcon(AllIcons.Actions.Refresh);
                }

                public ActionUpdateThread getActionUpdateThread() {
                    return ActionUpdateThread.EDT;
                }

                private static final Unit actionPerformed$lambda$0(AnActionEvent $e, Throwable it) {
                    $e.getPresentation().setEnabled(true);
                    return Unit.INSTANCE;
                }
            };
            EditorGutterComponentEx editorGutterComponentEx = TranslatedCodeEditor.this.getRightEditor().getGutterComponentEx();
            Intrinsics.checkNotNullExpressionValue((Object)editorGutterComponentEx, (String)"getGutterComponentEx(...)");
            this.setBorder(BorderFactory.createEmptyBorder(0, UiSizeUtilKt.getPreferredWidth((JComponent)((JComponent)editorGutterComponentEx)), 0, 0));
            TranslatedCodeEditor.this.getRightEditor().getGutterComponentEx().addComponentListener((ComponentListener)new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    EditorGutterComponentEx editorGutterComponentEx = TranslatedCodeEditor.this.getRightEditor().getGutterComponentEx();
                    Intrinsics.checkNotNullExpressionValue((Object)editorGutterComponentEx, (String)"getGutterComponentEx(...)");
                    this.setBorder(BorderFactory.createEmptyBorder(0, UiSizeUtilKt.getPreferredWidth((JComponent)((JComponent)editorGutterComponentEx)), 0, 0));
                }
            });
            this.executableLabel = new JLabel(this.cmd.getExecutableUiName());
            this.executableLabel.setFont(EditorUtil.getEditorFont((int)JBUI.Fonts.label().getSize()));
            this.executableLabel.setBorder((Border)new JBEmptyBorder(0, 0, 0, 10));
            this.add(this.executableLabel, "Before");
            this.argsJoiner = CmdHeader::_init_$lambda$0;
            this.argsParser = CmdHeader::_init_$lambda$1;
            this.argumentsEditor = new RawCommandLineEditor(this.argsParser, this.argsJoiner);
            this.argumentsEditor.getTextField().setFont(EditorUtil.getEditorFont((int)JBUI.Fonts.label().getSize()));
            this.argumentsEditor.setText((String)this.argsJoiner.fun(this.cmd.getParameters()));
            this.add((Component)this.argumentsEditor, "Center");
            Presentation presentation = new Presentation();
            TranslatedCodeEditor translatedCodeEditor = TranslatedCodeEditor.this;
            Presentation $this$_init__u24lambda_u243 = presentation;
            boolean bl = false;
            $this$_init__u24lambda_u243.setIcon(AllIcons.Actions.Refresh);
            $this$_init__u24lambda_u243.setText(() -> CmdHeader.lambda$3$lambda$2(translatedCodeEditor));
            Presentation presentation2 = presentation;
            this.refresh = new ActionButton((AnAction)this.refreshHeaderAction, presentation2, "unknown", ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
            this.actionsPanel = this.createActionsPanel();
            this.add(this.actionsPanel, "After");
            this.argumentsEditor.getEditorField().registerKeyboardAction(arg_0 -> CmdHeader._init_$lambda$4(this, arg_0), KeyStroke.getKeyStroke(10, ClientSystemInfo.Companion.isMac() ? 256 : 128), 0);
            FocusChangeListener focusTracker2 = new FocusChangeListener(this){
                final /* synthetic */ CmdHeader this$0;
                {
                    this.this$0 = $receiver;
                }

                public void focusGained(Editor editor) {
                    Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                    CmdHeader.access$getLastFocusedEditor$p(this.this$0).set(editor);
                }
            };
            TranslatedCodeEditor.this.getLeftEditor().addFocusListener(focusTracker2);
            TranslatedCodeEditor.this.getRightEditor().addFocusListener(focusTracker2);
            this.argumentsEditor.getEditorField().registerKeyboardAction(arg_0 -> CmdHeader._init_$lambda$5(this, arg_0), KeyStroke.getKeyStroke(27, 0), 0);
            if (ExperimentalUI.Companion.isNewUI()) {
                this.setBackground((Color)JBColor.namedColor((String)"Editor.SearchField.background", (Color)JBColor.background()));
                this.argumentsEditor.setBackground((Color)JBColor.namedColor((String)"Editor.SearchField.background", (Color)JBColor.background()));
                this.argumentsEditor.getEditorField().setBackground((Color)JBColor.namedColor((String)"Editor.SearchField.background", (Color)JBColor.background()));
            }
        }

        private static /* synthetic */ void getArgsJoiner$annotations() {
        }

        private static /* synthetic */ void getArgsParser$annotations() {
        }

        public final void update(@NotNull CidrTranslationCommand newCmd, @NotNull List<? extends ToggleAction> newOptions) {
            Intrinsics.checkNotNullParameter((Object)newCmd, (String)"newCmd");
            Intrinsics.checkNotNullParameter(newOptions, (String)"newOptions");
            this.cmd = newCmd;
            this.options = newOptions;
            this.executableLabel.setText(this.cmd.getExecutableUiName());
            this.argumentsEditor.setText((String)this.argsJoiner.fun(this.cmd.getParameters()));
            this.remove(this.actionsPanel);
            this.actionsPanel = this.createActionsPanel();
            this.add(this.actionsPanel, "After");
        }

        private final JPanel createActionsPanel() {
            TranslationOptionsGroup optionActions = new TranslationOptionsGroup(CollectionsKt.plus((Collection)this.options, (Iterable)CollectionsKt.listOf((Object)((Object)new CidrToggleRawTranslatedCodeAction()))));
            AnAction[] anActionArray = new AnAction[]{optionActions};
            ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("toolbar", (ActionGroup)new DefaultActionGroup(anActionArray), true);
            Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"createActionToolbar(...)");
            ActionToolbar toolbar = actionToolbar;
            toolbar.setTargetComponent((JComponent)((Object)this));
            JPanel result2 = new JPanel();
            result2.add((Component)this.refresh);
            result2.add(toolbar.getComponent());
            return result2;
        }

        @NotNull
        public final CidrTranslationCommand getCustomCommand() {
            String string = this.cmd.getExecutablePath();
            String string2 = this.cmd.getExecutableUiName();
            Object object = this.argsParser.fun((Object)this.argumentsEditor.getText());
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fun(...)");
            return new CidrTranslationCommand(string, string2, (List)object);
        }

        public void uiDataSnapshot(@NotNull DataSink sink) {
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            DataKey dataKey = CommonDataKeys.EDITOR_EVEN_IF_INACTIVE;
            Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"EDITOR_EVEN_IF_INACTIVE");
            sink.set(dataKey, (Object)TranslatedCodeEditor.this.getRightEditor());
        }

        private static final String _init_$lambda$0(List it) {
            return ParametersListUtil.join((List)it);
        }

        private static final List _init_$lambda$1(String it) {
            return ParametersListUtil.parse((String)it, (boolean)false);
        }

        private static final String lambda$3$lambda$2(TranslatedCodeEditor this$0) {
            Object[] objectArray = new Object[]{((CidrTranslator)this$0.myTranslator.get()).getName()};
            return CidrTranslateCodeBundle.INSTANCE.message("action.CidrRefreshTranslatedCode.specific.text", objectArray);
        }

        private static final void _init_$lambda$4(CmdHeader this$0, ActionEvent it) {
            this$0.refresh.click();
        }

        private static final void _init_$lambda$5(CmdHeader this$0, ActionEvent it) {
            Editor editor = this$0.lastFocusedEditor.get();
            if (editor != null && !editor.isDisposed()) {
                IdeFocusManager.getInstance((Project)editor.getProject()).requestFocus((Component)editor.getContentComponent(), true);
            }
        }

        public static final /* synthetic */ AtomicReference access$getLastFocusedEditor$p(CmdHeader $this) {
            return $this.lastFocusedEditor;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/cidr/translateCode/TranslatedCodeEditor$Companion;", "", "<init>", "()V", "gutterLeftRectWidth", "", "intellij.cidr.translateCode"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/cidr/translateCode/TranslatedCodeEditor$FloatingRefreshAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "(Lcom/intellij/cidr/translateCode/TranslatedCodeEditor;)V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "intellij.cidr.translateCode"})
    private final class FloatingRefreshAction
    extends AnAction {
        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            e.getPresentation().setIcon(AllIcons.Actions.Refresh);
            e.getPresentation().setEnabledAndVisible(TranslatedCodeEditor.this.mySrcModStamp.get() != TranslatedCodeEditor.this.getLeftEditor().getDocument().getModificationStamp());
            e.getPresentation().setText(() -> FloatingRefreshAction.update$lambda$0(TranslatedCodeEditor.this));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Object v = TranslatedCodeEditor.this.myTranslator.get();
            Intrinsics.checkNotNullExpressionValue(v, (String)"get(...)");
            CidrTranslateCodeActionKt.runTranslator((CidrTranslator)v, (Editor)TranslatedCodeEditor.this.getLeftEditor());
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        private static final String update$lambda$0(TranslatedCodeEditor this$0) {
            Object[] objectArray = new Object[]{((CidrTranslator)this$0.myTranslator.get()).getName()};
            return CidrTranslateCodeBundle.INSTANCE.message("action.CidrRefreshTranslatedCode.specific.text", objectArray);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/cidr/translateCode/TranslatedCodeEditor$HoveredBlockHighlighter;", "Lcom/intellij/openapi/editor/event/EditorMouseMotionListener;", "isSrcEditor", "", "<init>", "(Lcom/intellij/cidr/translateCode/TranslatedCodeEditor;Z)V", "mouseMoved", "", "e", "Lcom/intellij/openapi/editor/event/EditorMouseEvent;", "intellij.cidr.translateCode"})
    @SourceDebugExtension(value={"SMAP\nCidrTranslateCodeAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CidrTranslateCodeAction.kt\ncom/intellij/cidr/translateCode/TranslatedCodeEditor$HoveredBlockHighlighter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1236:1\n1#2:1237\n*E\n"})
    public final class HoveredBlockHighlighter
    implements EditorMouseMotionListener {
        private final boolean isSrcEditor;

        public HoveredBlockHighlighter(boolean isSrcEditor) {
            this.isSrcEditor = isSrcEditor;
        }

        public void mouseMoved(@NotNull EditorMouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (TranslatedCodeEditor.this.mySrcModStamp.get() != TranslatedCodeEditor.this.getLeftEditor().getDocument().getModificationStamp()) {
                return;
            }
            Editor editor = e.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
            Editor editor2 = editor;
            Document document = editor2.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            Document document2 = document;
            int line = EditorUtil.yPositionToLogicalLine((Editor)editor2, (int)e.getMouseEvent().getY());
            TranslatedResultUiInfo translationInfo = (TranslatedResultUiInfo)TranslatedCodeEditor.this.myTranslationInfo.get();
            if (DocumentUtil.isValidLine((int)line, (Document)document2)) {
                int blockId;
                int n = blockId = this.isSrcEditor ? translationInfo.blockIdForSrcLine0(line) : translationInfo.blockIdForTransLine0(line);
                if (blockId != translationInfo.getHighlightedBlockId()) {
                    translationInfo.clearCurrentBlockHighlighters();
                    translationInfo.setHighlightedBlockId(blockId);
                    TranslatedCodeEditor.this.mySplitter.repaintDivider();
                    CidrTranslatedCodeBlock block = translationInfo.blockById(blockId);
                    Pair<Color, Color> pair = translationInfo.colorForCurrentBlock(blockId);
                    Color bgColor = (Color)pair.component1();
                    Color borderColor = (Color)pair.component2();
                    if (block != null) {
                        TextAttributes textAttributes;
                        MarkupModelEx markupModelEx = TranslatedCodeEditor.this.getLeftEditor().getMarkupModel();
                        Intrinsics.checkNotNullExpressionValue((Object)markupModelEx, (String)"getMarkupModel(...)");
                        MarkupModelEx leftMarkup = markupModelEx;
                        MarkupModelEx markupModelEx2 = TranslatedCodeEditor.this.getRightEditor().getMarkupModel();
                        Intrinsics.checkNotNullExpressionValue((Object)markupModelEx2, (String)"getMarkupModel(...)");
                        MarkupModelEx rightMarkup = markupModelEx2;
                        Color color = bgColor;
                        if (color != null) {
                            TextAttributes textAttributes2;
                            Color it = color;
                            boolean bl = false;
                            TextAttributes $this$mouseMoved_u24lambda_u241_u24lambda_u240 = textAttributes2 = new TextAttributes();
                            boolean bl2 = false;
                            $this$mouseMoved_u24lambda_u241_u24lambda_u240.setBackgroundColor(it);
                            textAttributes = textAttributes2;
                        } else {
                            textAttributes = null;
                        }
                        TextAttributes attributes = textAttributes;
                        DocumentEx documentEx = TranslatedCodeEditor.this.getLeftEditor().getDocument();
                        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
                        DocumentEx leftDoc = documentEx;
                        DocumentEx documentEx2 = TranslatedCodeEditor.this.getRightEditor().getDocument();
                        Intrinsics.checkNotNullExpressionValue((Object)documentEx2, (String)"getDocument(...)");
                        DocumentEx rightDoc = documentEx2;
                        int leftStartOffset = leftDoc.getLineStartOffset(block.getSrcStartLine());
                        int leftEndOffset = leftDoc.getLineEndOffset(block.getSrcEndLine() - 1);
                        RangeHighlighter rangeHighlighter = leftMarkup.addRangeHighlighter(leftStartOffset, leftEndOffset, 3001, attributes, HighlighterTargetArea.LINES_IN_RANGE);
                        Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighter, (String)"addRangeHighlighter(...)");
                        RangeHighlighter leftHighlighter = rangeHighlighter;
                        translationInfo.getCurrentBlockSrcHighlighters().add(leftHighlighter);
                        List<IntRange> transRanges = block.getTranslatedRanges();
                        for (IntRange transRange : transRanges) {
                            RangeHighlighter rightHighlighter;
                            int transStart = transRange.getFirst();
                            int transEnd = transRange.getLast();
                            int rightStartOffset = rightDoc.getLineStartOffset(transStart);
                            int rightEndOffset = rightDoc.getLineEndOffset(transEnd - 1);
                            Intrinsics.checkNotNullExpressionValue((Object)rightMarkup.addRangeHighlighter(rightStartOffset, rightEndOffset, 3001, attributes, HighlighterTargetArea.LINES_IN_RANGE), (String)"addRangeHighlighter(...)");
                            rightHighlighter.setLineMarkerRenderer((LineMarkerRenderer)new ActiveGutterRenderer(TranslatedCodeEditor.this, transStart, transEnd, translationInfo, bgColor, borderColor, leftDoc, block){
                                final /* synthetic */ TranslatedCodeEditor this$0;
                                final /* synthetic */ int $transStart;
                                final /* synthetic */ int $transEnd;
                                final /* synthetic */ TranslatedResultUiInfo $translationInfo;
                                final /* synthetic */ Color $bgColor;
                                final /* synthetic */ Color $borderColor;
                                final /* synthetic */ DocumentEx $leftDoc;
                                final /* synthetic */ CidrTranslatedCodeBlock $block;
                                {
                                    this.this$0 = $receiver;
                                    this.$transStart = $transStart;
                                    this.$transEnd = $transEnd;
                                    this.$translationInfo = $translationInfo;
                                    this.$bgColor = $bgColor;
                                    this.$borderColor = $borderColor;
                                    this.$leftDoc = $leftDoc;
                                    this.$block = $block;
                                }

                                public void paint(Editor editor, Graphics g, Rectangle r) {
                                    Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                                    Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                                    Intrinsics.checkNotNullParameter((Object)r, (String)"r");
                                    DiffDrawUtil.MarkerRange markerRange = DiffDrawUtil.getGutterMarkerPaintRange((Editor)((Editor)this.this$0.getRightEditor()), (int)this.$transStart, (int)this.$transEnd);
                                    Intrinsics.checkNotNullExpressionValue((Object)markerRange, (String)"getGutterMarkerPaintRange(...)");
                                    DiffDrawUtil.MarkerRange gutterRange = markerRange;
                                    EditorGutterComponentEx editorGutterComponentEx = ((EditorEx)editor).getGutterComponentEx();
                                    Intrinsics.checkNotNullExpressionValue((Object)editorGutterComponentEx, (String)"getGutterComponentEx(...)");
                                    EditorGutterComponentEx gutter = editorGutterComponentEx;
                                    boolean drawBlockConnection = this.$translationInfo.shouldDrawBlockConnection();
                                    if (this.$bgColor != null) {
                                        g.setColor(this.$bgColor);
                                        int xStart = drawBlockConnection ? 0 : gutter.getWidth() - 10 - 5;
                                        g.fillRect(xStart, gutterRange.y1, gutter.getWidth(), gutterRange.y2 - gutterRange.y1);
                                    }
                                    if (this.$borderColor != null && drawBlockConnection) {
                                        g.setColor(this.$borderColor);
                                        int width = ExperimentalUI.Companion.isNewUI() ? gutter.getWidth() : gutter.getWhitespaceSeparatorOffset();
                                        g.drawLine(0, gutterRange.y1, width, gutterRange.y1);
                                        g.drawLine(0, gutterRange.y2, width, gutterRange.y2);
                                    }
                                }

                                public boolean canDoAction(Editor editor, MouseEvent e) {
                                    Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                                    return true;
                                }

                                public void doAction(Editor editor, MouseEvent e) {
                                    Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                                    int srcLineYOffset = this.this$0.getLeftEditor().offsetToXY((int)this.$leftDoc.getLineStartOffset((int)this.$block.getSrcStartLine())).y + CidrTranslateCodeActionKt.access$headerHeight((Editor)this.this$0.getLeftEditor());
                                    int gutterClickYOffset = e.getPoint().y;
                                    int rightScroll = CidrTranslateCodeActionKt.verticalScrollOffsetFromHeader((Editor)this.this$0.getRightEditor());
                                    int relativeClickOffsetFromTop = gutterClickYOffset - rightScroll;
                                    this.this$0.getLeftEditor().getScrollingModel().scrollVertically(srcLineYOffset - relativeClickOffsetFromTop);
                                }
                            });
                            translationInfo.getCurrentBlockTransHighlighters().add(rightHighlighter);
                        }
                    }
                }
            }
        }
    }
}

