/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cidr.cpp.util;

import com.intellij.cidr.cpp.util.CidrIntType;
import com.intellij.cidr.cpp.util.CidrStringLiteralUtil;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public class CidrStringLiteral {
    @NotNull
    public final CidrStringLiteralUtil.CidrStringPrefix prefix;
    @NotNull
    public final String contents;

    public CidrStringLiteral(@NotNull CidrStringLiteralUtil.CidrStringPrefix prefix, @NotNull String contents) {
        if (prefix == null) {
            CidrStringLiteral.$$$reportNull$$$0(0);
        }
        if (contents == null) {
            CidrStringLiteral.$$$reportNull$$$0(1);
        }
        this.prefix = prefix;
        this.contents = contents;
    }

    public String getContents(boolean escaped) {
        if (this.prefix.isRaw != escaped) {
            return this.contents;
        }
        if (escaped) {
            return StringUtil.escapeStringCharacters((String)this.contents);
        }
        return StringUtil.unescapeAnsiStringCharacters((String)this.contents);
    }

    @NotNull
    public CidrIntType getElementType(boolean isPlainOldC) {
        CidrIntType cidrIntType = isPlainOldC ? this.prefix.charTypePlainC : this.prefix.charTypeCpp;
        if (cidrIntType == null) {
            CidrStringLiteral.$$$reportNull$$$0(2);
        }
        return cidrIntType;
    }

    public int getContentLengthInCharacters() {
        String unescapedContents = this.getContents(false);
        if (this.prefix.encoding == CidrStringLiteralUtil.CidrEncoding.UTF8) {
            byte[] encodedContents = this.prefix.encoding.getBytes(unescapedContents);
            return encodedContents.length;
        }
        return unescapedContents.length();
    }

    public String toString() {
        return "CidrStringLiteral{prefix=" + this.prefix + ", contents='" + this.contents + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CidrStringLiteral literal = (CidrStringLiteral)o;
        if (this.prefix != literal.prefix) {
            return false;
        }
        return this.contents.equals(literal.contents);
    }

    public int hashCode() {
        int result2 = this.prefix.hashCode();
        result2 = 31 * result2 + this.contents.hashCode();
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contents";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/cidr/cpp/util/CidrStringLiteral";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/cidr/cpp/util/CidrStringLiteral";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

