/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.sisu.inject;

import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.inject.Provider;
import org.jetbrains.kotlin.com.google.inject.Binding;
import org.jetbrains.kotlin.com.google.inject.Scopes;
import org.jetbrains.kotlin.com.google.inject.spi.ElementSource;
import org.jetbrains.kotlin.com.google.inject.spi.InstanceBinding;
import org.jetbrains.kotlin.com.google.inject.spi.ProviderInstanceBinding;
import org.jetbrains.kotlin.com.google.inject.spi.ProvidesMethodBinding;

public final class Guice4 {
    private static final boolean HAS_DECLARING_SOURCE;
    private static final boolean HAS_USER_SUPPLIED_PROVIDER;
    private static final boolean HAS_OLD_SCOPES_SINGLETON;
    private static final boolean HAS_PROVIDES_METHOD_SPI;
    static final Object NIL;

    private Guice4() {
    }

    public static Object getDeclaringSource(Binding<?> binding) {
        Object source = binding.getSource();
        if (HAS_DECLARING_SOURCE && source instanceof ElementSource) {
            return ((ElementSource)source).getDeclaringSource();
        }
        return source;
    }

    public static Provider<?> getProviderInstance(ProviderInstanceBinding<?> binding) {
        return HAS_USER_SUPPLIED_PROVIDER ? binding.getUserSuppliedProvider() : binding.getProviderInstance();
    }

    public static Object invokeStaticBinding(Binding<?> binding) {
        if (binding instanceof InstanceBinding) {
            return ((InstanceBinding)binding).getInstance();
        }
        if (binding instanceof ProviderInstanceBinding) {
            Provider<?> provider = Guice4.getProviderInstance((ProviderInstanceBinding)binding);
            if (HAS_PROVIDES_METHOD_SPI && provider instanceof ProvidesMethodBinding) {
                try {
                    final ProvidesMethodBinding providesMethod = (ProvidesMethodBinding)((Object)provider);
                    if (!providesMethod.getMethod().isAccessible()) {
                        AccessController.doPrivileged(new PrivilegedAction<Void>(){

                            @Override
                            public Void run() {
                                providesMethod.getMethod().setAccessible(true);
                                return null;
                            }
                        });
                    }
                    return providesMethod.getMethod().invoke(providesMethod.getEnclosingInstance(), new Object[0]);
                }
                catch (Exception e) {
                    return null;
                }
                catch (LinkageError e) {
                    return null;
                }
            }
            return provider.get();
        }
        return null;
    }

    public static <T> Provider<T> lazy(Binding<T> binding) {
        if (HAS_OLD_SCOPES_SINGLETON) {
            return Scopes.SINGLETON.scope(binding.getKey(), binding.getProvider());
        }
        final org.jetbrains.kotlin.com.google.inject.Provider<T> provider = binding.getProvider();
        return new Provider<T>(){
            private volatile Object value = NIL;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T get() {
                if (NIL == this.value) {
                    2 var1_1 = this;
                    synchronized (var1_1) {
                        if (NIL == this.value) {
                            this.value = provider.get();
                        }
                    }
                }
                return this.value;
            }
        };
    }

    static {
        boolean hasProvidesMethodSpi;
        boolean hasOldScopesSingleton;
        boolean hasUserSuppliedProvider;
        boolean hasDeclaringSource;
        try {
            hasDeclaringSource = ElementSource.class.getMethod("getDeclaringSource", new Class[0]) != null;
        }
        catch (Exception e) {
            hasDeclaringSource = false;
        }
        catch (LinkageError e) {
            hasDeclaringSource = false;
        }
        HAS_DECLARING_SOURCE = hasDeclaringSource;
        try {
            hasUserSuppliedProvider = ProviderInstanceBinding.class.getMethod("getUserSuppliedProvider", new Class[0]) != null;
        }
        catch (Exception e) {
            hasUserSuppliedProvider = false;
        }
        catch (LinkageError e) {
            hasUserSuppliedProvider = false;
        }
        HAS_USER_SUPPLIED_PROVIDER = hasUserSuppliedProvider;
        try {
            hasOldScopesSingleton = Scopes.class.equals(Scopes.SINGLETON.getClass().getEnclosingClass()) && Scopes.SINGLETON.scope(null, null) != null;
        }
        catch (Exception e) {
            hasOldScopesSingleton = false;
        }
        catch (LinkageError e) {
            hasOldScopesSingleton = false;
        }
        HAS_OLD_SCOPES_SINGLETON = hasOldScopesSingleton;
        try {
            hasProvidesMethodSpi = ProvidesMethodBinding.class instanceof Class;
        }
        catch (Exception e) {
            hasProvidesMethodSpi = false;
        }
        catch (LinkageError e) {
            hasProvidesMethodSpi = false;
        }
        HAS_PROVIDES_METHOD_SPI = hasProvidesMethodSpi;
        NIL = new Object();
    }
}

