/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.openapi.actionSystem.ActionUiKind;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import java.awt.event.InputEvent;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J/\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J'\u0010\u000f\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00062\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\r\u001a\u00020\u000eH\u0007J<\u0010\u0012\u001a\u00020\u00052\b\u0010\u0013\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0007\u00a8\u0006\u0017"}, d2={"Lcom/intellij/openapi/actionSystem/AnActionEventCompat;", "", "<init>", "()V", "createFromAnAction", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "Lorg/jetbrains/annotations/NotNull;", "action", "Lcom/intellij/openapi/actionSystem/AnAction;", "inputEvent", "Ljava/awt/event/InputEvent;", "place", "", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "createFromDataContext", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "createFromInputEvent", "event", "isContextMenuAction", "", "isToolbarAction", "aiplugin.sdkcompat"})
public final class AnActionEventCompat {
    @NotNull
    public static final AnActionEventCompat INSTANCE = new AnActionEventCompat();

    private AnActionEventCompat() {
    }

    @JvmStatic
    @NotNull
    public static final AnActionEvent createFromAnAction(@NotNull AnAction action, @Nullable InputEvent inputEvent, @NotNull String place, @NotNull DataContext dataContext2) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        Intrinsics.checkNotNullParameter((Object)dataContext2, (String)"dataContext");
        AnActionEvent anActionEvent = AnActionEvent.createEvent((AnAction)action, (DataContext)dataContext2, null, (String)place, (ActionUiKind)ActionUiKind.NONE, (InputEvent)inputEvent);
        Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"createEvent(...)");
        return anActionEvent;
    }

    @JvmStatic
    @NotNull
    public static final AnActionEvent createFromDataContext(@NotNull String place, @Nullable Presentation presentation, @NotNull DataContext dataContext2) {
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        Intrinsics.checkNotNullParameter((Object)dataContext2, (String)"dataContext");
        AnActionEvent anActionEvent = AnActionEvent.createEvent((DataContext)dataContext2, (Presentation)presentation, (String)place, (ActionUiKind)ActionUiKind.NONE, null);
        Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"createEvent(...)");
        return anActionEvent;
    }

    @JvmStatic
    @NotNull
    public static final AnActionEvent createFromInputEvent(@Nullable InputEvent event, @NotNull String place, @Nullable Presentation presentation, @NotNull DataContext dataContext2, boolean isContextMenuAction, boolean isToolbarAction) {
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        Intrinsics.checkNotNullParameter((Object)dataContext2, (String)"dataContext");
        ActionUiKind uiKind = isContextMenuAction ? (ActionUiKind)ActionUiKind.POPUP : (isToolbarAction ? (ActionUiKind)ActionUiKind.TOOLBAR : ActionUiKind.NONE);
        AnActionEvent anActionEvent = AnActionEvent.createEvent((DataContext)dataContext2, (Presentation)presentation, (String)place, (ActionUiKind)uiKind, (InputEvent)event);
        Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"createEvent(...)");
        return anActionEvent;
    }
}

