/*
 * Decompiled with CFR 0.152.
 */
package com.google.tools.intellij.aiplugin.util;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"isControlChar", "", "c", "", "isText", "s", "", "aiplugin.ij-platform"})
public final class BinaryContentVerifierKt {
    public static final boolean isText(@NotNull byte[] s) {
        byte[] chunk;
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        int maxBytes = 1024;
        if (s.length > maxBytes) {
            byte[] byArray = s;
            int n = 0;
            v0 = ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)maxBytes);
        } else {
            v0 = chunk = s;
        }
        if (chunk.length < 4) {
            return true;
        }
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        Charset charset2 = charset;
        String str = new String(chunk, charset2);
        if (((CharSequence)str).length() == 0) {
            return true;
        }
        int n = str.length() - 1;
        for (int i2 = 0; i2 < n; ++i2) {
            char c = str.charAt(i2);
            if (c == '\ufffd') {
                return false;
            }
            if (!BinaryContentVerifierKt.isControlChar(c)) continue;
            return false;
        }
        return !BinaryContentVerifierKt.isControlChar(StringsKt.last((CharSequence)str));
    }

    public static final boolean isControlChar(char c) {
        return Intrinsics.compare((int)c, (int)32) < 0 && c != '\n' && c != '\t' && c != '\f';
    }
}

