/*
 * Decompiled with CFR 0.152.
 */
package com.google.tools.intellij.aiplugin.recitation;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.idea.studiobot.Citation;
import com.google.tools.intellij.aiplugin.SmlIjBundle;
import com.google.tools.intellij.aiplugin.util.ProjectsKt;
import com.intellij.codeWithMe.ClientId;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0006\b\u0007\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\bH\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u0006\u0010\u0010\u001a\u00020\u0004J \u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\bH\u0002J$\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\u00192\u0006\u0010\r\u001a\u00020\bJ\u0010\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\bH\u0002J\u000e\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/google/tools/intellij/aiplugin/recitation/RecitationLogService;", "", "()V", "citationLogFile", "Ljava/io/File;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "buildLogMessage", "", "citation", "Lcom/android/tools/idea/studiobot/Citation;", "timeNow", "citedText", "fileName", "createLogFile", "", "getCitationLogFile", "getCitedTextFromSuggestion", "content", "start", "", "end", "logCitationToLogFile", "logCitations", "citations", "", "notifyFailure", "message", "setCitationLogFile", "file", "Companion", "aiplugin.ij-platform"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nRecitationLogService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecitationLogService.kt\ncom/google/tools/intellij/aiplugin/recitation/RecitationLogService\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,163:1\n25#2:164\n*S KotlinDebug\n*F\n+ 1 RecitationLogService.kt\ncom/google/tools/intellij/aiplugin/recitation/RecitationLogService\n*L\n43#1:164\n*E\n"})
public final class RecitationLogService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private File citationLogFile;
    @NotNull
    private final Logger logger;
    public static final int $stable = 8;
    @NotNull
    public static final String DEFAULT_CITATION_LOG_FILENAME = "citations.log";
    @NotNull
    private static final Path DEFAULT_CITATION_LOG_FILE_PATH;

    public RecitationLogService() {
        File file = DEFAULT_CITATION_LOG_FILE_PATH.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        this.citationLogFile = file;
        RecitationLogService $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(RecitationLogService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.createLogFile();
    }

    @NotNull
    public final File getCitationLogFile() {
        return this.citationLogFile;
    }

    public final void setCitationLogFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.logger.info("Setting citation log file to " + file);
        this.citationLogFile = file;
        this.createLogFile();
    }

    public final void logCitations(@NotNull String content2, @NotNull List<? extends Citation> citations2, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        Intrinsics.checkNotNullParameter(citations2, (String)"citations");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        String timeNow = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        for (Citation citation : citations2) {
            String citedText = this.getCitedTextFromSuggestion(content2, citation.getRange().getStartOffset(), citation.getRange().getEndOffset());
            Intrinsics.checkNotNull((Object)timeNow);
            String logMessage = this.buildLogMessage(citation, timeNow, citedText, fileName);
            this.logCitationToLogFile(logMessage);
        }
    }

    private final String buildLogMessage(Citation citation, String timeNow, String citedText, String fileName) {
        String string;
        Citation citation2 = citation;
        if (citation2 instanceof Citation.Web) {
            CharSequence charSequence = ((Citation.Web)citation).getLicense();
            String license = !(charSequence == null || charSequence.length() == 0) ? ((Citation.Web)citation).getLicense() : "an unknown license";
            string = timeNow + ": Accepted generated code with cited text\n```\n" + citedText + "\n```\nfrom '" + ((Citation.Web)citation).getUrl() + "' with " + license + "\nTextDocument: " + fileName + "\n\n";
        } else if (citation2 instanceof Citation.LocalFile) {
            string = timeNow + ": Accepted generated code with prompt cited text\n```\n" + citedText + "\n```\nfrom file: " + ((Citation.LocalFile)citation).getFilePath() + "\nTextDocument: " + fileName + "\n\n";
        } else if (citation2 instanceof Citation.RemoteRepository) {
            string = timeNow + ": Accepted generated code with prompt cited text\n```\n" + citedText + "\n```\nfrom '" + ((Citation.RemoteRepository)citation).getRepositoryUrl() + "' file: " + ((Citation.RemoteRepository)citation).getFilePath() + "\nTextDocument: " + fileName + "\n\n";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    private final String getCitedTextFromSuggestion(String content2, int start2, int end) {
        int endIndex = Math.min(end, content2.length());
        int startIndex = Math.min(start2, endIndex);
        String string = content2.substring(startIndex, endIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }

    private final void logCitationToLogFile(String content2) {
        try {
            FilesKt.appendText$default((File)this.citationLogFile, (String)content2, null, (int)2, null);
        }
        catch (Exception e) {
            this.logger.error("Failed to log citation to " + this.citationLogFile, (Throwable)e);
            Object[] objectArray = new Object[2];
            Intrinsics.checkNotNullExpressionValue((Object)this.citationLogFile.getPath(), (String)"getPath(...)");
            objectArray[1] = String.valueOf(e.getMessage());
            this.notifyFailure(SmlIjBundle.message("ai.plugin.settings.recitation.notification.fail.log.message", objectArray));
        }
    }

    private final void notifyFailure(String message) {
        block0: {
            Project project2 = ProjectsKt.getCurrentProject();
            if (project2 == null) break block0;
            Project project3 = project2;
            boolean bl = false;
            NotificationGroupManager.getInstance().getNotificationGroup("com.google.tools.intellij.aiplugin.recitation").createNotification(SmlIjBundle.message("ai.plugin.settings.recitation.notification.title", new Object[0]), message, NotificationType.ERROR).notify(project3);
        }
    }

    private final void createLogFile() {
        if (!this.citationLogFile.exists()) {
            try {
                this.citationLogFile.getParentFile().mkdirs();
                this.citationLogFile.createNewFile();
            }
            catch (Exception e) {
                this.logger.error("Failed to create citation log file " + this.citationLogFile, (Throwable)e);
                Object[] objectArray = new Object[2];
                Intrinsics.checkNotNullExpressionValue((Object)this.citationLogFile.getPath(), (String)"getPath(...)");
                objectArray[1] = String.valueOf(e.getMessage());
                this.notifyFailure(SmlIjBundle.message("ai.plugin.settings.recitation.notification.fail.create.log.message", objectArray));
                File file = DEFAULT_CITATION_LOG_FILE_PATH.toFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
                this.setCitationLogFile(file);
            }
        }
    }

    static {
        String[] stringArray = new String[]{"caches", DEFAULT_CITATION_LOG_FILENAME};
        Path path2 = Paths.get(PathManager.getSystemPath(), stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
        DEFAULT_CITATION_LOG_FILE_PATH = path2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lcom/google/tools/intellij/aiplugin/recitation/RecitationLogService$Companion;", "", "()V", "DEFAULT_CITATION_LOG_FILENAME", "", "DEFAULT_CITATION_LOG_FILE_PATH", "Ljava/nio/file/Path;", "getDEFAULT_CITATION_LOG_FILE_PATH", "()Ljava/nio/file/Path;", "getInstance", "Lcom/google/tools/intellij/aiplugin/recitation/RecitationLogService;", "aiplugin.ij-platform"})
    @SourceDebugExtension(value={"SMAP\nRecitationLogService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecitationLogService.kt\ncom/google/tools/intellij/aiplugin/recitation/RecitationLogService$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,163:1\n40#2,3:164\n*S KotlinDebug\n*F\n+ 1 RecitationLogService.kt\ncom/google/tools/intellij/aiplugin/recitation/RecitationLogService$Companion\n*L\n160#1:164,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Path getDEFAULT_CITATION_LOG_FILE_PATH() {
            return DEFAULT_CITATION_LOG_FILE_PATH;
        }

        @NotNull
        public final RecitationLogService getInstance() {
            boolean $i$f$service = false;
            Class<RecitationLogService> serviceClass$iv = RecitationLogService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (RecitationLogService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

