/*
 * Decompiled with CFR 0.152.
 */
package com.google.tools.intellij.aiplugin.oauth;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.Authenticator;
import com.google.api.client.auth.oauth2.Credential;
import com.google.cloud.developerexperience.cloudcode.intellij.auth.GoogleLoginCredential;
import com.google.cloud.developerexperience.cloudcode.intellij.auth.GoogleLoginService;
import com.google.cloud.tools.intellij.oauth.OauthUserInfoFetcher;
import com.google.cloud.tools.intellij.oauth.UserinfoWithPicture;
import com.google.common.base.Stopwatch;
import com.google.tools.intellij.aiplugin.analytics.AiPluginOnboardingSessionTracking;
import com.google.tools.intellij.aiplugin.analytics.UsageTrackerService;
import com.google.tools.intellij.aiplugin.oauth.AiPluginAuthenticatorKt;
import com.google.tools.intellij.aiplugin.oauth.AiPluginLoginService;
import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import java.time.Duration;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0010\u001a\u00020\u000bH\u0002J\n\u0010\u0011\u001a\u0004\u0018\u00010\u000bH\u0002J\u001c\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\u0015H\u0096@\u00a2\u0006\u0002\u0010\u0016J\u000e\u0010\u0017\u001a\u00020\u0013H\u0096@\u00a2\u0006\u0002\u0010\u0018J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\r\u0010\u001b\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b\u001cJ\b\u0010\u001d\u001a\u00020\u0013H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\u0004\u0018\u00010\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001e"}, d2={"Lcom/google/tools/intellij/aiplugin/oauth/AiPluginAuthenticator;", "Lcom/android/studio/ml/Authenticator;", "()V", "_authStateFlow", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/android/studio/ml/Authenticator$AuthState;", "authenticationState", "Lkotlinx/coroutines/flow/StateFlow;", "getAuthenticationState", "()Lkotlinx/coroutines/flow/StateFlow;", "googleUserInfo", "Lcom/android/studio/ml/Authenticator$UserInfo;", "oauthToken", "", "getOauthToken", "()Ljava/lang/String;", "getUserInfo", "googleUserInfoByEmail", "logIn", "", "scopes", "", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "logOut", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "shouldShowLogOutInStatusBar", "", "updateAuthState", "updateAuthState$aiplugin_ij_platform", "updateUserInfoWithProfilePicture", "aiplugin.ij-platform"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nAiPluginAuthenticator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AiPluginAuthenticator.kt\ncom/google/tools/intellij/aiplugin/oauth/AiPluginAuthenticator\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,138:1\n40#2,3:139\n40#2,3:142\n25#3:145\n25#3:146\n25#3:147\n25#3:148\n*S KotlinDebug\n*F\n+ 1 AiPluginAuthenticator.kt\ncom/google/tools/intellij/aiplugin/oauth/AiPluginAuthenticator\n*L\n34#1:139,3\n42#1:142,3\n77#1:145\n82#1:146\n102#1:147\n119#1:148\n*E\n"})
public final class AiPluginAuthenticator
implements Authenticator {
    @NotNull
    private final MutableStateFlow<Authenticator.AuthState> _authStateFlow = StateFlowKt.MutableStateFlow((Object)Authenticator.AuthState.Initializing.INSTANCE);
    @Nullable
    private volatile Authenticator.UserInfo googleUserInfo;
    public static final int $stable = 8;

    @Override
    @NotNull
    public StateFlow<Authenticator.AuthState> getAuthenticationState() {
        return FlowKt.asStateFlow(this._authStateFlow);
    }

    @Override
    @Nullable
    public String getOauthToken() {
        GoogleLoginCredential googleLoginCredential = AiPluginLoginService.Companion.getInstance().getLoginCredentials();
        return googleLoginCredential != null ? googleLoginCredential.getAccessToken() : null;
    }

    @Override
    @Nullable
    public Object logIn(@NotNull List<String> scopes, @NotNull Continuation<? super Unit> $completion) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        GoogleLoginService.logInWithLocalServer$default((GoogleLoginService)((GoogleLoginService)AiPluginLoginService.Companion.getInstance()), null, (int)1, null);
        this.updateUserInfoWithProfilePicture();
        boolean $i$f$service = false;
        Class<UsageTrackerService> serviceClass$iv = UsageTrackerService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        UsageTrackerService usageTrackerService = (UsageTrackerService)object;
        Duration duration = stopwatch.elapsed();
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"elapsed(...)");
        usageTrackerService.trackOnboardingLogin(duration);
        this._authStateFlow.tryEmit((Object)new Authenticator.AuthState.Authorized(this.getUserInfo()));
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object logOut(@NotNull Continuation<? super Unit> $completion) {
        if (AiPluginLoginService.Companion.getInstance().isLoggedIn()) {
            GoogleLoginService.logOut$default((GoogleLoginService)((GoogleLoginService)AiPluginLoginService.Companion.getInstance()), null, (int)1, null);
            boolean $i$f$service = false;
            Class<AiPluginOnboardingSessionTracking> serviceClass$iv = AiPluginOnboardingSessionTracking.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            ((AiPluginOnboardingSessionTracking)object).prepareForNewOnboarding();
        }
        return Unit.INSTANCE;
    }

    @Override
    public boolean shouldShowLogOutInStatusBar() {
        return true;
    }

    private final Authenticator.UserInfo getUserInfo() {
        Authenticator.UserInfo userInfo = this.googleUserInfo;
        if (userInfo == null && (userInfo = this.googleUserInfoByEmail()) == null) {
            throw new IllegalStateException("User is logged in, but no info are available");
        }
        return userInfo;
    }

    public final void updateAuthState$aiplugin_ij_platform() {
        if (!AiPluginLoginService.Companion.getInstance().isLoggedIn()) {
            this.googleUserInfo = null;
            this._authStateFlow.tryEmit((Object)Authenticator.AuthState.LoggedOut.INSTANCE);
            return;
        }
        this.updateUserInfoWithProfilePicture();
        Authenticator.UserInfo currentUserInfo = this.googleUserInfo;
        if (AiPluginLoginService.Companion.getInstance().isLoggedIn() && currentUserInfo != null) {
            this._authStateFlow.tryEmit((Object)new Authenticator.AuthState.Authorized(currentUserInfo));
        } else {
            if (currentUserInfo == null && AiPluginLoginService.Companion.getInstance().isLoggedIn()) {
                AiPluginAuthenticator $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(AiPluginAuthenticator.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("User info could not be retrieved even though user appears logged in. Treating as logged out.");
            } else if (!AiPluginLoginService.Companion.getInstance().isLoggedIn()) {
                AiPluginAuthenticator $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(AiPluginAuthenticator.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.info("User logged out during auth state update.");
            }
            this.googleUserInfo = null;
            this._authStateFlow.tryEmit((Object)Authenticator.AuthState.LoggedOut.INSTANCE);
        }
    }

    private final void updateUserInfoWithProfilePicture() {
        if (this.googleUserInfo == null && AiPluginLoginService.Companion.getInstance().isLoggedIn()) {
            Authenticator.UserInfo userInfo;
            Object $this$updateUserInfoWithProfilePicture_u24lambda_u240;
            Object object = this;
            try {
                $this$updateUserInfoWithProfilePicture_u24lambda_u240 = object;
                boolean bl = false;
                $this$updateUserInfoWithProfilePicture_u24lambda_u240 = Result.constructor-impl((Object)OauthUserInfoFetcher.INSTANCE.getUserInfo((Credential)AiPluginLoginService.Companion.getInstance().createCredentials()));
            }
            catch (Throwable throwable) {
                $this$updateUserInfoWithProfilePicture_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            object = $this$updateUserInfoWithProfilePicture_u24lambda_u240;
            UserinfoWithPicture userInfo2 = (UserinfoWithPicture)(Result.isFailure-impl((Object)object) ? null : object);
            if (userInfo2 != null) {
                userInfo = AiPluginAuthenticatorKt.toGoogleUserInfo(userInfo2);
            } else {
                AiPluginAuthenticator $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(AiPluginAuthenticator.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("Failed to fetch user info via OauthUserInfoFetcher, falling back to email only");
                userInfo = this.googleUserInfoByEmail();
            }
            this.googleUserInfo = userInfo;
        }
    }

    private final Authenticator.UserInfo googleUserInfoByEmail() {
        Authenticator.UserInfo userInfo;
        String loggedInEmail = AiPluginLoginService.Companion.getInstance().getEmail();
        if (loggedInEmail != null) {
            userInfo = new Authenticator.UserInfo(null, null, loggedInEmail, null);
        } else {
            AiPluginAuthenticator $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(AiPluginAuthenticator.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("The email address for the logged-in user is not available (null)");
            userInfo = null;
        }
        return userInfo;
    }

    @Override
    public boolean isAuthorized() {
        return Authenticator.super.isAuthorized();
    }

    @Override
    public boolean isLoggedIn() {
        return Authenticator.super.isLoggedIn();
    }

    @Override
    @Nullable
    public Authenticator.UserInfo getLoggedInUser() {
        return Authenticator.super.getLoggedInUser();
    }

    @Override
    public boolean clientIsStudio() {
        return Authenticator.super.clientIsStudio();
    }
}

