/*
 * Decompiled with CFR 0.152.
 */
package com.google.tools.intellij.aiplugin.network;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.CompletionModel;
import com.android.studio.ml.ProductBrandingProvider;
import com.google.tools.intellij.aiplugin.CaicProjectService;
import com.google.tools.intellij.aiplugin.SmlIjBundle;
import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u00060\u0011j\u0002`\u0012J\u0006\u0010\u0013\u001a\u00020\u000fR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lcom/google/tools/intellij/aiplugin/network/NetworkStatusService;", "", "scope", "Lkotlinx/coroutines/CoroutineScope;", "(Lkotlinx/coroutines/CoroutineScope;)V", "_networkStatus", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/android/studio/ml/CompletionModel$NetworkStatus;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "networkStatus", "Lkotlinx/coroutines/flow/StateFlow;", "getNetworkStatus", "()Lkotlinx/coroutines/flow/StateFlow;", "setNetworkStatusToError", "", "error", "Ljava/lang/Exception;", "Lkotlin/Exception;", "setNetworkStatusToOk", "aiplugin.ij-platform"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nNetworkStatusService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NetworkStatusService.kt\ncom/google/tools/intellij/aiplugin/network/NetworkStatusService\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,58:1\n25#2:59\n40#3,3:60\n*S KotlinDebug\n*F\n+ 1 NetworkStatusService.kt\ncom/google/tools/intellij/aiplugin/network/NetworkStatusService\n*L\n20#1:59\n34#1:60,3\n*E\n"})
public final class NetworkStatusService {
    @NotNull
    private final Logger logger;
    @NotNull
    private MutableStateFlow<CompletionModel.NetworkStatus> _networkStatus;
    public static final int $stable = 8;

    public NetworkStatusService(@NotNull CoroutineScope scope2) {
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        NetworkStatusService $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(NetworkStatusService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this._networkStatus = StateFlowKt.MutableStateFlow((Object)CompletionModel.NetworkStatus.OK.INSTANCE);
        boolean $i$f$service = false;
        Class<CaicProjectService> serviceClass$iv = CaicProjectService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        FlowKt.launchIn((Flow)FlowKt.onEach((Flow)((Flow)((CaicProjectService)object).getCaicProjectId()), (Function2)((Function2)new Function2<String, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ NetworkStatusService this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.this$0._networkStatus.setValue((Object)CompletionModel.NetworkStatus.OK.INSTANCE);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(String p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        })), (CoroutineScope)scope2);
    }

    @NotNull
    public final StateFlow<CompletionModel.NetworkStatus> getNetworkStatus() {
        return FlowKt.asStateFlow(this._networkStatus);
    }

    public final void setNetworkStatusToOk() {
        this.logger.info("Network status is back to okay");
        this._networkStatus.setValue((Object)CompletionModel.NetworkStatus.OK.INSTANCE);
    }

    public final void setNetworkStatusToError(@NotNull Exception error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        this.logger.debug("Network is either not available or unreachable");
        Object[] objectArray = new Object[]{ProductBrandingProvider.Companion.getInstance().getCompletionStatusProductPrefix()};
        CompletionModel.NetworkStatus.NetworkError networkStatusValue = new CompletionModel.NetworkStatus.NetworkError(SmlIjBundle.INSTANCE.getMessage("aiplugin.completion.statusBarWidget.status.network.error.general", objectArray), SmlIjBundle.INSTANCE.getMessage("aiplugin.completion.statusBarWidget.status.network.error.detailed", new Object[0]));
        this.logger.debug("Network status has changed to error ", (Throwable)error);
        this._networkStatus.setValue((Object)networkStatusValue);
    }
}

