/*
 * Decompiled with CFR 0.152.
 */
package com.google.tools.intellij.aiplugin.completion;

import androidx.compose.runtime.internal.StabilityInferred;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.util.Disposer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\r\b\u0087\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0012J\t\u0010\u0019\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0006H\u00c6\u0003J8\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0006H\u00c6\u0001\u00a2\u0006\u0002\u0010\u001cJ\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0006\u0010\u001f\u001a\u00020\u001eJ\u0013\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#H\u00d6\u0003J\b\u0010$\u001a\u0004\u0018\u00010\u000eJ\f\u0010%\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0010J\t\u0010&\u001a\u00020\u0003H\u00d6\u0001J\u0006\u0010'\u001a\u00020!J\u0006\u0010(\u001a\u00020!J\u0006\u0010)\u001a\u00020\u001eJ\u0016\u0010*\u001a\u00020\u001e2\u0006\u0010+\u001a\u00020\u000e2\u0006\u0010,\u001a\u00020\fJ\u0012\u0010-\u001a\u00020\u001e2\n\u0010.\u001a\u0006\u0012\u0002\b\u00030\u0010J\t\u0010/\u001a\u00020\u0006H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015\u00a8\u00060"}, d2={"Lcom/google/tools/intellij/aiplugin/completion/SuggestionLine;", "Lcom/intellij/openapi/Disposable;", "atLine", "", "inlineOffset", "toReplace", "", "text", "(ILjava/lang/Integer;Ljava/lang/String;Ljava/lang/String;)V", "getAtLine", "()I", "editor", "Lcom/intellij/openapi/editor/Editor;", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "inlay", "Lcom/intellij/openapi/editor/Inlay;", "getInlineOffset", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getText", "()Ljava/lang/String;", "getToReplace", "component1", "component2", "component3", "component4", "copy", "(ILjava/lang/Integer;Ljava/lang/String;Ljava/lang/String;)Lcom/google/tools/intellij/aiplugin/completion/SuggestionLine;", "dispose", "", "disposeInlay", "equals", "", "other", "", "getHighlighter", "getInlay", "hashCode", "isDeletion", "isInline", "removeHighlighter", "setHighlighter", "newHighlighter", "newEditor", "setInlay", "newInlay", "toString", "aiplugin.ij-platform"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nSuggestionSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SuggestionSession.kt\ncom/google/tools/intellij/aiplugin/completion/SuggestionLine\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,664:1\n1#2:665\n*E\n"})
public final class SuggestionLine
implements Disposable {
    private final int atLine;
    @Nullable
    private final Integer inlineOffset;
    @NotNull
    private final String toReplace;
    @NotNull
    private final String text;
    @Nullable
    private Inlay<?> inlay;
    @Nullable
    private RangeHighlighter highlighter;
    @Nullable
    private Editor editor;
    public static final int $stable = 8;

    public SuggestionLine(int atLine, @Nullable Integer inlineOffset, @NotNull String toReplace, @NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)toReplace, (String)"toReplace");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        this.atLine = atLine;
        this.inlineOffset = inlineOffset;
        this.toReplace = toReplace;
        this.text = text2;
    }

    public final int getAtLine() {
        return this.atLine;
    }

    @Nullable
    public final Integer getInlineOffset() {
        return this.inlineOffset;
    }

    @NotNull
    public final String getToReplace() {
        return this.toReplace;
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    public final boolean isInline() {
        return this.inlineOffset != null;
    }

    public final boolean isDeletion() {
        return ((CharSequence)this.text).length() == 0 && ((CharSequence)this.toReplace).length() > 0;
    }

    public final void disposeInlay() {
        Inlay<?> inlay = this.inlay;
        if (inlay != null) {
            Inlay<?> it = inlay;
            boolean bl = false;
            Disposer.dispose((Disposable)((Disposable)it));
        }
        this.inlay = null;
    }

    @Nullable
    public final Inlay<?> getInlay() {
        return this.inlay;
    }

    public final void setInlay(@NotNull Inlay<?> newInlay) {
        Intrinsics.checkNotNullParameter(newInlay, (String)"newInlay");
        this.disposeInlay();
        this.inlay = newInlay;
        Disposer.register((Disposable)this, (Disposable)((Disposable)newInlay));
    }

    public final void removeHighlighter() {
        RangeHighlighter rangeHighlighter = this.highlighter;
        if (rangeHighlighter != null) {
            RangeHighlighter it = rangeHighlighter;
            boolean bl = false;
            Editor editor = this.editor;
            if (editor != null && (editor = editor.getMarkupModel()) != null) {
                editor.removeHighlighter(it);
            }
        }
        this.highlighter = null;
    }

    @Nullable
    public final RangeHighlighter getHighlighter() {
        return this.highlighter;
    }

    public final void setHighlighter(@NotNull RangeHighlighter newHighlighter, @NotNull Editor newEditor) {
        Intrinsics.checkNotNullParameter((Object)newHighlighter, (String)"newHighlighter");
        Intrinsics.checkNotNullParameter((Object)newEditor, (String)"newEditor");
        this.removeHighlighter();
        this.editor = newEditor;
        this.highlighter = newHighlighter;
    }

    public void dispose() {
        this.removeHighlighter();
        this.disposeInlay();
    }

    public final int component1() {
        return this.atLine;
    }

    @Nullable
    public final Integer component2() {
        return this.inlineOffset;
    }

    @NotNull
    public final String component3() {
        return this.toReplace;
    }

    @NotNull
    public final String component4() {
        return this.text;
    }

    @NotNull
    public final SuggestionLine copy(int atLine, @Nullable Integer inlineOffset, @NotNull String toReplace, @NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)toReplace, (String)"toReplace");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        return new SuggestionLine(atLine, inlineOffset, toReplace, text2);
    }

    public static /* synthetic */ SuggestionLine copy$default(SuggestionLine suggestionLine, int n, Integer n2, String string, String string2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = suggestionLine.atLine;
        }
        if ((n3 & 2) != 0) {
            n2 = suggestionLine.inlineOffset;
        }
        if ((n3 & 4) != 0) {
            string = suggestionLine.toReplace;
        }
        if ((n3 & 8) != 0) {
            string2 = suggestionLine.text;
        }
        return suggestionLine.copy(n, n2, string, string2);
    }

    @NotNull
    public String toString() {
        return "SuggestionLine(atLine=" + this.atLine + ", inlineOffset=" + this.inlineOffset + ", toReplace=" + this.toReplace + ", text=" + this.text + ")";
    }

    public int hashCode() {
        int result2 = Integer.hashCode(this.atLine);
        result2 = result2 * 31 + (this.inlineOffset == null ? 0 : ((Object)this.inlineOffset).hashCode());
        result2 = result2 * 31 + this.toReplace.hashCode();
        result2 = result2 * 31 + this.text.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SuggestionLine)) {
            return false;
        }
        SuggestionLine suggestionLine = (SuggestionLine)other;
        if (this.atLine != suggestionLine.atLine) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.inlineOffset, (Object)suggestionLine.inlineOffset)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.toReplace, (Object)suggestionLine.toReplace)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.text, (Object)suggestionLine.text);
    }
}

