/*
 * Decompiled with CFR 0.152.
 */
package com.google.tools.intellij.aiplugin.completion;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.idea.studiobot.util.Diffs;
import com.google.api.services.cloudcode_pa.v1internal.model.RecentUserAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 (2\u00020\u00012\u00020\u0002:\u0001(B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0002J\b\u0010\u0017\u001a\u00020\u0013H\u0016J\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\b0\u001cJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002J\u0018\u0010&\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010'\u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0010\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\f0\f0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/google/tools/intellij/aiplugin/completion/RecentUserActionsListener;", "Lcom/intellij/openapi/editor/event/DocumentListener;", "Lcom/intellij/openapi/Disposable;", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/openapi/editor/Editor;)V", "recentUserActions", "", "Lcom/google/api/services/cloudcode_pa/v1internal/model/RecentUserAction;", "timeout", "Ljava/util/TimerTask;", "timer", "Ljava/util/Timer;", "getTimer", "()Ljava/util/Timer;", "timerRef", "Ljava/util/concurrent/atomic/AtomicReference;", "kotlin.jvm.PlatformType", "addRecentUserAction", "", "filePath", "", "diff", "dispose", "documentChanged", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "getRecentUserActions", "", "getTimeoutDuration", "", "handleDocumentChanged", "isCurrentFile", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "document", "Lcom/intellij/openapi/editor/Document;", "pushRecentUserAction", "shouldRecordRecentAction", "Companion", "aiplugin.ij-platform"})
@StabilityInferred(parameters=0)
public final class RecentUserActionsListener
implements DocumentListener,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Editor editor;
    @NotNull
    private final List<RecentUserAction> recentUserActions;
    @Nullable
    private TimerTask timeout;
    @NotNull
    private final AtomicReference<Timer> timerRef;
    public static final int $stable = 8;
    public static final int MAX_RECENT_USER_ACTIONS = 10;
    public static final int TYPING_TIMEOUT_MS = 1000;
    public static final int SELECTION_TIMEOUT_MS = 500;

    public RecentUserActionsListener(@NotNull Editor editor) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            this.editor = editor;
            this.recentUserActions = new ArrayList();
            this.timerRef = new AtomicReference<Timer>(new Timer());
            TimerTask timerTask = this.timeout;
            if (timerTask == null) break block0;
            timerTask.cancel();
        }
    }

    private final Timer getTimer() {
        Timer timer = this.timerRef.get();
        Intrinsics.checkNotNullExpressionValue((Object)timer, (String)"get(...)");
        return timer;
    }

    @NotNull
    public final synchronized List<RecentUserAction> getRecentUserActions() {
        return CollectionsKt.toList((Iterable)this.recentUserActions);
    }

    public void documentChanged(@NotNull DocumentEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.handleDocumentChanged(event);
    }

    public void dispose() {
        TimerTask timerTask = this.timeout;
        if (timerTask != null) {
            timerTask.cancel();
        }
        this.timerRef.getAndSet(new Timer()).cancel();
    }

    private final void handleDocumentChanged(DocumentEvent event) {
        Document document = event.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        VirtualFile virtualFile2 = FileDocumentManager.getInstance().getFile(document2);
        if (virtualFile2 == null) {
            return;
        }
        VirtualFile file = virtualFile2;
        if (!this.shouldRecordRecentAction(file, document2)) {
            return;
        }
        TimerTask timerTask = this.timeout;
        if (timerTask != null) {
            timerTask.cancel();
        }
        Timer timer = this.getTimer();
        long l2 = this.getTimeoutDuration(event);
        TimerTask timerTask2 = new TimerTask(this, file, event){
            final /* synthetic */ RecentUserActionsListener this$0;
            final /* synthetic */ VirtualFile $file$inlined;
            final /* synthetic */ DocumentEvent $event$inlined;
            {
                this.this$0 = recentUserActionsListener;
                this.$file$inlined = virtualFile2;
                this.$event$inlined = documentEvent;
            }

            public void run() {
                TimerTask $this$handleDocumentChanged_u24lambda_u240 = this;
                boolean bl = false;
                RecentUserActionsListener.access$pushRecentUserAction(this.this$0, this.$file$inlined, this.$event$inlined);
            }
        };
        timer.schedule(timerTask2, l2);
        this.timeout = timerTask2;
    }

    private final void pushRecentUserAction(VirtualFile file, DocumentEvent event) {
        String currentText = ((Object)event.getNewFragment()).toString();
        String previousContent = ((Object)event.getOldFragment()).toString();
        if (Intrinsics.areEqual((Object)previousContent, (Object)currentText)) {
            return;
        }
        String diff = Diffs.Companion.diff$default(Diffs.Companion, previousContent, currentText, 0, false, 12, null);
        if (this.recentUserActions.size() == 10) {
            this.recentUserActions.remove(0);
        }
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        this.addRecentUserAction(string, diff);
    }

    private final long getTimeoutDuration(DocumentEvent event) {
        return event.getNewLength() > 1 || event.getOldLength() > 1 ? 1000 : 500;
    }

    private final boolean shouldRecordRecentAction(VirtualFile file, Document document) {
        return !file.getFileType().isBinary() && this.isCurrentFile(file, document);
    }

    private final boolean isCurrentFile(VirtualFile file, Document document) {
        return Intrinsics.areEqual((Object)this.editor.getDocument(), (Object)document) && Intrinsics.areEqual((Object)FileDocumentManager.getInstance().getFile(this.editor.getDocument()), (Object)file);
    }

    /*
     * WARNING - void declaration
     */
    private final synchronized void addRecentUserAction(String filePath, String diff) {
        void $this$addRecentUserAction_u24lambda_u241;
        RecentUserAction recentUserAction;
        RecentUserAction recentUserAction2 = recentUserAction = new RecentUserAction();
        List<RecentUserAction> list = this.recentUserActions;
        boolean bl = false;
        $this$addRecentUserAction_u24lambda_u241.setFilePath(filePath);
        $this$addRecentUserAction_u24lambda_u241.setDiff(diff);
        list.add(recentUserAction);
    }

    public static final /* synthetic */ void access$pushRecentUserAction(RecentUserActionsListener $this, VirtualFile file, DocumentEvent event) {
        $this.pushRecentUserAction(file, event);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/google/tools/intellij/aiplugin/completion/RecentUserActionsListener$Companion;", "", "()V", "MAX_RECENT_USER_ACTIONS", "", "SELECTION_TIMEOUT_MS", "TYPING_TIMEOUT_MS", "aiplugin.ij-platform"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

