/*
 * Decompiled with CFR 0.152.
 */
package com.google.tools.aiplugin.editor.predictionservices.controls.rules;

import com.android.studio.ml.suggestion.AnchoredDiffChunk;
import com.android.studio.ml.suggestion.controls.EditorSuggestionControl;
import com.android.studio.ml.suggestion.controls.EditorSuggestionControlFactory;
import com.android.studio.ml.suggestion.controls.viewmodel.CodeDisplayKt;
import com.android.studio.ml.suggestion.controls.viewmodel.CodeDisplayRow;
import com.android.studio.ml.suggestion.controls.viewmodel.CodeDisplaySnippet;
import com.android.studio.ml.suggestion.grouping.GroupedChange;
import com.android.studio.ml.suggestion.grouping.LineLevelChange;
import com.google.tools.aiplugin.editor.predictionservices.controls.ControlWithChunks;
import com.google.tools.aiplugin.editor.predictionservices.controls.rules.CreateControlRule;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/google/tools/aiplugin/editor/predictionservices/controls/rules/PopoutForSmallInlineChanges;", "Lcom/google/tools/aiplugin/editor/predictionservices/controls/rules/CreateControlRule;", "<init>", "()V", "SMALL_CHANGE_CHAR_LIMIT", "", "doCreate", "Lcom/google/tools/aiplugin/editor/predictionservices/controls/ControlWithChunks;", "groupedChange", "Lcom/android/studio/ml/suggestion/grouping/GroupedChange;", "editor", "Lcom/intellij/openapi/editor/Editor;", "project", "Lcom/intellij/openapi/project/Project;", "factory", "Lcom/android/studio/ml/suggestion/controls/EditorSuggestionControlFactory;", "aiplugin.editor.prediction-services"})
public final class PopoutForSmallInlineChanges
extends CreateControlRule {
    @NotNull
    public static final PopoutForSmallInlineChanges INSTANCE = new PopoutForSmallInlineChanges();
    public static final int SMALL_CHANGE_CHAR_LIMIT = 40;

    private PopoutForSmallInlineChanges() {
        super(SetsKt.setOf((Object)Reflection.getOrCreateKotlinClass(GroupedChange.ModificationBlock.class)), null);
    }

    @Override
    @Nullable
    protected ControlWithChunks doCreate(@NotNull GroupedChange groupedChange, @NotNull Editor editor, @NotNull Project project2, @NotNull EditorSuggestionControlFactory factory) {
        Intrinsics.checkNotNullParameter((Object)groupedChange, (String)"groupedChange");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        if (!(groupedChange instanceof GroupedChange.ModificationBlock)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (((GroupedChange.ModificationBlock)groupedChange).getChanges().size() != 1) {
            return null;
        }
        LineLevelChange.Modification change = (LineLevelChange.Modification)CollectionsKt.single(((GroupedChange.ModificationBlock)groupedChange).getChanges());
        AnchoredDiffChunk chunk = change.getSourceChunk();
        LineLevelChange.Signature displaySignature = change.getSignature().toDisplaySignature();
        if (displaySignature.getRemoved().length() + displaySignature.getAdded().length() >= 40) {
            return null;
        }
        AnchoredDiffChunk adjustedChunk = change.adjustAnchorForChangesWithinLine(chunk);
        VirtualFile virtualFile2 = editor.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getVirtualFile(...)");
        List<CodeDisplaySnippet> snippets = CodeDisplayKt.createHighlightedSnippetsForSingleLineChunk(adjustedChunk, project2, virtualFile2);
        EditorSuggestionControl control = factory.createPopoutReplacement(adjustedChunk, editor, CollectionsKt.listOf((Object)new CodeDisplayRow(snippets)), adjustedChunk.getRangeMarker().getTextRange().getEndOffset());
        return new ControlWithChunks(control, CollectionsKt.listOf((Object)chunk));
    }
}

