/*
 * Decompiled with CFR 0.152.
 */
package com.google.tools.aiplugin.editor.predictionservices;

import com.google.tools.aiplugin.editor.prediction.Prediction;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001:\u0007\r\u000e\u000f\u0010\u0011\u0012\u0013B\u0011\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\f\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u0082\u0001\u0007\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u00a8\u0006\u001b"}, d2={"Lcom/google/tools/aiplugin/editor/predictionservices/PredictionEvent;", "", "title", "", "<init>", "(Ljava/lang/String;)V", "getTitle", "()Ljava/lang/String;", "time", "Ljava/time/LocalDateTime;", "getTime", "()Ljava/time/LocalDateTime;", "toString", "Success", "Outdated", "Fail", "LlmRequest", "Initiated", "Forced", "LlmResponse", "Lcom/google/tools/aiplugin/editor/predictionservices/PredictionEvent$Fail;", "Lcom/google/tools/aiplugin/editor/predictionservices/PredictionEvent$Forced;", "Lcom/google/tools/aiplugin/editor/predictionservices/PredictionEvent$Initiated;", "Lcom/google/tools/aiplugin/editor/predictionservices/PredictionEvent$LlmRequest;", "Lcom/google/tools/aiplugin/editor/predictionservices/PredictionEvent$LlmResponse;", "Lcom/google/tools/aiplugin/editor/predictionservices/PredictionEvent$Outdated;", "Lcom/google/tools/aiplugin/editor/predictionservices/PredictionEvent$Success;", "aiplugin.editor.prediction-services"})
public abstract class PredictionEvent {
    @NotNull
    private final String title;
    @NotNull
    private final LocalDateTime time;

    private PredictionEvent(String title) {
        this.title = title;
        LocalDateTime localDateTime = LocalDateTime.now();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"now(...)");
        this.time = localDateTime;
    }

    @NotNull
    public final String getTitle() {
        return this.title;
    }

    @NotNull
    public final LocalDateTime getTime() {
        return this.time;
    }

    @NotNull
    public String toString() {
        return "[" + this.time.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME) + "] " + this.title;
    }

    public /* synthetic */ PredictionEvent(String title, DefaultConstructorMarker $constructor_marker) {
        this(title);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/google/tools/aiplugin/editor/predictionservices/PredictionEvent$Fail;", "Lcom/google/tools/aiplugin/editor/predictionservices/PredictionEvent;", "message", "", "<init>", "(Ljava/lang/String;)V", "getMessage", "()Ljava/lang/String;", "aiplugin.editor.prediction-services"})
    public static final class Fail
    extends PredictionEvent {
        @NotNull
        private final String message;

        public Fail(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            super("Failed to produced prediction", null);
            this.message = message;
        }

        @NotNull
        public final String getMessage() {
            return this.message;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/google/tools/aiplugin/editor/predictionservices/PredictionEvent$Forced;", "Lcom/google/tools/aiplugin/editor/predictionservices/PredictionEvent;", "<init>", "()V", "aiplugin.editor.prediction-services"})
    public static final class Forced
    extends PredictionEvent {
        public Forced() {
            super("Manual prediction initiated", null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/google/tools/aiplugin/editor/predictionservices/PredictionEvent$Initiated;", "Lcom/google/tools/aiplugin/editor/predictionservices/PredictionEvent;", "<init>", "()V", "aiplugin.editor.prediction-services"})
    public static final class Initiated
    extends PredictionEvent {
        public Initiated() {
            super("Idle prediction initiated", null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/google/tools/aiplugin/editor/predictionservices/PredictionEvent$LlmRequest;", "Lcom/google/tools/aiplugin/editor/predictionservices/PredictionEvent;", "prompt", "", "<init>", "(Ljava/lang/String;)V", "getPrompt", "()Ljava/lang/String;", "aiplugin.editor.prediction-services"})
    public static final class LlmRequest
    extends PredictionEvent {
        @NotNull
        private final String prompt;

        public LlmRequest(@NotNull String prompt2) {
            Intrinsics.checkNotNullParameter((Object)prompt2, (String)"prompt");
            super("Sending request to the LLM", null);
            this.prompt = prompt2;
        }

        @NotNull
        public final String getPrompt() {
            return this.prompt;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/google/tools/aiplugin/editor/predictionservices/PredictionEvent$LlmResponse;", "Lcom/google/tools/aiplugin/editor/predictionservices/PredictionEvent;", "response", "", "<init>", "(Ljava/lang/String;)V", "getResponse", "()Ljava/lang/String;", "aiplugin.editor.prediction-services"})
    public static final class LlmResponse
    extends PredictionEvent {
        @NotNull
        private final String response;

        public LlmResponse(@NotNull String response2) {
            Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
            super("Response received from the LLM", null);
            this.response = response2;
        }

        @NotNull
        public final String getResponse() {
            return this.response;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/google/tools/aiplugin/editor/predictionservices/PredictionEvent$Outdated;", "Lcom/google/tools/aiplugin/editor/predictionservices/PredictionEvent;", "prediction", "Lcom/google/tools/aiplugin/editor/prediction/Prediction;", "<init>", "(Lcom/google/tools/aiplugin/editor/prediction/Prediction;)V", "getPrediction", "()Lcom/google/tools/aiplugin/editor/prediction/Prediction;", "aiplugin.editor.prediction-services"})
    public static final class Outdated
    extends PredictionEvent {
        @NotNull
        private final Prediction prediction;

        public Outdated(@NotNull Prediction prediction2) {
            Intrinsics.checkNotNullParameter((Object)prediction2, (String)"prediction");
            super("Outdated prediction", null);
            this.prediction = prediction2;
        }

        @NotNull
        public final Prediction getPrediction() {
            return this.prediction;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/google/tools/aiplugin/editor/predictionservices/PredictionEvent$Success;", "Lcom/google/tools/aiplugin/editor/predictionservices/PredictionEvent;", "prediction", "Lcom/google/tools/aiplugin/editor/prediction/Prediction;", "<init>", "(Lcom/google/tools/aiplugin/editor/prediction/Prediction;)V", "getPrediction", "()Lcom/google/tools/aiplugin/editor/prediction/Prediction;", "aiplugin.editor.prediction-services"})
    public static final class Success
    extends PredictionEvent {
        @NotNull
        private final Prediction prediction;

        public Success(@NotNull Prediction prediction2) {
            Intrinsics.checkNotNullParameter((Object)prediction2, (String)"prediction");
            super("Prediction", null);
            this.prediction = prediction2;
        }

        @NotNull
        public final Prediction getPrediction() {
            return this.prediction;
        }
    }
}

