/*
 * Decompiled with CFR 0.152.
 */
package com.google.tools.aiplugin.editor.prediction;

import com.google.tools.aiplugin.editor.prediction.Diff;
import com.google.tools.aiplugin.editor.prediction.DiffChunk;
import com.google.tools.aiplugin.editor.prediction.DocumentHistory;
import com.google.tools.aiplugin.editor.prediction.Event;
import com.google.tools.aiplugin.editor.prediction.FileHeader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0010J\u001e\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bR\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u001c"}, d2={"Lcom/google/tools/aiplugin/editor/prediction/EditHistory;", "", "<init>", "()V", "history", "Lcom/google/tools/aiplugin/editor/prediction/DocumentHistory;", "getHistory", "()Lcom/google/tools/aiplugin/editor/prediction/DocumentHistory;", "setHistory", "(Lcom/google/tools/aiplugin/editor/prediction/DocumentHistory;)V", "events", "", "Lcom/google/tools/aiplugin/editor/prediction/Event;", "wantToMerge", "", "diff1", "Lcom/google/tools/aiplugin/editor/prediction/Diff;", "diff2", "addDiff", "", "diff", "reset", "path", "Ljava/nio/file/Path;", "content", "", "stamp", "", "aiplugin.editor.prediction"})
@SourceDebugExtension(value={"SMAP\nEditHistory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditHistory.kt\ncom/google/tools/aiplugin/editor/prediction/EditHistory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,75:1\n1#2:76\n*E\n"})
public final class EditHistory {
    @Nullable
    private DocumentHistory history;

    @Nullable
    public final DocumentHistory getHistory() {
        return this.history;
    }

    public final void setHistory(@Nullable DocumentHistory documentHistory) {
        this.history = documentHistory;
    }

    @NotNull
    public final List<Event> events() {
        Object object = this.history;
        if (object == null || (object = ((DocumentHistory)object).getEdits()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    public final boolean wantToMerge(@NotNull Diff diff1, @NotNull Diff diff2) {
        Intrinsics.checkNotNullParameter((Object)diff1, (String)"diff1");
        Intrinsics.checkNotNullParameter((Object)diff2, (String)"diff2");
        if (diff1.getChunks().size() > 1 || diff2.getChunks().size() > 1) {
            return false;
        }
        if (diff1.getChunks().isEmpty() || diff2.getChunks().isEmpty()) {
            return true;
        }
        DiffChunk chunk1 = (DiffChunk)CollectionsKt.first(diff1.getChunks());
        DiffChunk chunk2 = (DiffChunk)CollectionsKt.first(diff2.getChunks());
        return chunk1.getOldStart() <= chunk2.getOldStart() && chunk2.getOldStart() <= chunk1.getOldStart() + chunk1.getOldLength();
    }

    public final void addDiff(@NotNull Diff diff) {
        Event last;
        Object object;
        DocumentHistory history2;
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter((Object)diff, (String)"diff");
                history2 = this.history;
                Object object2 = history2;
                if (object2 == null) break block5;
                object = object2;
                DocumentHistory it = object;
                boolean bl = false;
                String string = ((Object)it.getPath()).toString();
                FileHeader fileHeader = diff.getNewFile();
                Intrinsics.checkNotNull((Object)fileHeader);
                object2 = Intrinsics.areEqual((Object)string, (Object)fileHeader.getPath()) ? object : null;
                if (object2 != null) break block6;
            }
            return;
        }
        long l2 = history2.getStamp();
        FileHeader fileHeader = diff.getOldFile();
        Intrinsics.checkNotNull((Object)fileHeader);
        Long l3 = fileHeader.getStamp();
        if (!(l3 != null && l2 == l3)) {
            object = "Failed requirement.";
            throw new IllegalArgumentException(object.toString());
        }
        FileHeader fileHeader2 = diff.getNewFile();
        Intrinsics.checkNotNull((Object)fileHeader2);
        Long l4 = fileHeader2.getStamp();
        Intrinsics.checkNotNull((Object)l4);
        history2.setStamp(l4);
        history2.setAfter(diff.apply(history2.getAfter()));
        if (!((Collection)history2.getEdits()).isEmpty() && this.wantToMerge((last = (Event)CollectionsKt.last(history2.getEdits())).getDiff(), diff)) {
            last.setDiff(last.getDiff().squash(diff));
            return;
        }
        history2.getEdits().add(new Event(diff));
    }

    public final void reset(@NotNull Path path2, @NotNull String content2, long stamp) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        this.history = new DocumentHistory(path2, content2, new ArrayList(), content2, stamp);
    }
}

