/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.intellij.util;

import com.google.cloud.tools.intellij.util.CloudCodePlatform;
import com.google.cloud.tools.intellij.util.CommonDirectoryProviderKt;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000b\u00a8\u0006\r"}, d2={"Lcom/google/cloud/tools/intellij/util/CommonDirectoryProvider;", "", "<init>", "()V", "getPlatformSpecificDepsDir", "Ljava/nio/file/Path;", "platform", "Lcom/google/cloud/tools/intellij/util/CloudCodePlatform;", "systemProperties", "Ljava/util/Properties;", "env", "", "", "aiplugin.cloudcode-core"})
@SourceDebugExtension(value={"SMAP\nCommonDirectoryProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommonDirectoryProvider.kt\ncom/google/cloud/tools/intellij/util/CommonDirectoryProvider\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,75:1\n108#2:76\n80#2,22:77\n*S KotlinDebug\n*F\n+ 1 CommonDirectoryProvider.kt\ncom/google/cloud/tools/intellij/util/CommonDirectoryProvider\n*L\n48#1:76\n48#1:77,22\n*E\n"})
public final class CommonDirectoryProvider {
    @NotNull
    public static final CommonDirectoryProvider INSTANCE = new CommonDirectoryProvider();

    private CommonDirectoryProvider() {
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final Path getPlatformSpecificDepsDir(@NotNull CloudCodePlatform platform, @NotNull Properties systemProperties, @NotNull Map<String, String> env) {
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        Intrinsics.checkNotNullParameter((Object)systemProperties, (String)"systemProperties");
        Intrinsics.checkNotNullParameter(env, (String)"env");
        userHome = Paths.get(systemProperties.getProperty("user.home"), new String[0]);
        cloudCodeDepsRootPath = Paths.get("cloud-code", new String[0]);
        xdgPath = userHome.resolve(".cache").resolve(cloudCodeDepsRootPath);
        switch (WhenMappings.$EnumSwitchMapping$0[platform.ordinal()]) {
            case 1: {
                localAppDataEnv = env.get("LOCALAPPDATA");
                if (localAppDataEnv == null) ** GOTO lbl33
                $this$trim$iv = localAppDataEnv;
                $i$f$trim = false;
                $this$trim$iv$iv = $this$trim$iv;
                $i$f$trim = false;
                startIndex$iv$iv = 0;
                endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    index$iv$iv = startFound$iv$iv == false ? startIndex$iv$iv : endIndex$iv$iv;
                    it = $this$trim$iv$iv.charAt(index$iv$iv);
                    $i$a$-trim-CommonDirectoryProvider$getPlatformSpecificDepsDir$1 = false;
                    v0 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                if (!(((CharSequence)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1).toString()).length() == 0)) ** GOTO lbl36
lbl33:
                // 2 sources

                CommonDirectoryProviderKt.access$getLog$p().warn("LOCALAPPDATA environment is invalid or missing");
                Intrinsics.checkNotNull((Object)xdgPath);
                return xdgPath;
lbl36:
                // 1 sources

                localAppData = Paths.get(localAppDataEnv, new String[0]);
                if (!Files.exists(localAppData, new LinkOption[0])) {
                    CommonDirectoryProviderKt.access$getLog$p().warn(localAppData + " does not exist");
                    Intrinsics.checkNotNull((Object)xdgPath);
                    return xdgPath;
                }
                v1 = localAppData.resolve(cloudCodeDepsRootPath);
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"resolve(...)");
                return v1;
            }
            case 2: {
                applicationSupport = userHome.resolve("Library").resolve("Application Support");
                if (!Files.exists(applicationSupport, new LinkOption[0])) {
                    CommonDirectoryProviderKt.access$getLog$p().warn(applicationSupport + " does not exist");
                    Intrinsics.checkNotNull((Object)xdgPath);
                    return xdgPath;
                }
                v2 = applicationSupport.resolve(cloudCodeDepsRootPath);
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"resolve(...)");
                return v2;
            }
            case 3: {
                Intrinsics.checkNotNull((Object)xdgPath);
                return xdgPath;
            }
        }
        throw new RuntimeException("Unsupported operating system -- cannot detect platform specific directory");
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CloudCodePlatform.values().length];
            try {
                nArray[CloudCodePlatform.WINDOWS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CloudCodePlatform.MAC.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CloudCodePlatform.LINUX.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

