/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.intellij.project;

import com.google.api.services.cloudresourcemanager.model.Project;
import com.google.cloud.tools.intellij.IntellijPluginCoreMessageBundle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

class ProjectListTableModel
extends AbstractTableModel {
    private static final int PROJECT_NAME_COLUMN = 0;
    private static final int PROJECT_ID_COLUMN = 1;
    private final List<Project> projectList = new ArrayList<Project>();

    ProjectListTableModel() {
    }

    @Override
    public int getRowCount() {
        return this.projectList.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Object getValueAt(int row, int column) {
        switch (column) {
            case 0: {
                if (!this.projectList.get(row).getName().isBlank()) {
                    return this.projectList.get(row).getName();
                }
                return this.projectList.get(row).getProjectId();
            }
            case 1: {
                return this.projectList.get(row).getProjectId();
            }
        }
        return "";
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return IntellijPluginCoreMessageBundle.getString("cloud.project.selector.project.list.project.name.column", new Object[0]);
            }
            case 1: {
                return IntellijPluginCoreMessageBundle.getString("cloud.project.selector.project.list.project.id.column", new Object[0]);
            }
        }
        return "";
    }

    String getProjectNameAtRow(int row) {
        return this.getValueAt(row, 0).toString();
    }

    String getProjectIdAtRow(int row) {
        return this.getValueAt(row, 1).toString();
    }

    Long getProjectNumberAtRow(int row) {
        return this.projectList.get(row).getProjectNumber();
    }

    void setProjectList(List<Project> updatedList) {
        this.projectList.clear();
        this.projectList.addAll(updatedList);
        this.fireTableDataChanged();
    }
}

