/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.intellij.feedback;

import com.google.cloud.tools.intellij.IntellijPluginCoreMessageBundle;
import com.google.cloud.tools.intellij.feedback.GoogleAnonymousFeedbackTask;
import com.intellij.diagnostic.LogMessage;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.ErrorReportSubmitter;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.openapi.diagnostic.SubmittedReportInfo;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import java.awt.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GoogleFeedbackErrorReporterBase
extends ErrorReportSubmitter {
    public abstract void notifySuccess(Project var1);

    public abstract void notifyFailure(Project var1, String var2);

    public abstract GoogleAnonymousFeedbackTask.FeedbackSender getFeedbackSender();

    private boolean doSubmit(@Nullable Throwable throwable, Component parentComponent, Consumer<SubmittedReportInfo> callback, String description) {
        DataContext dataContext2 = DataManager.getInstance().getDataContext(parentComponent);
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext2);
        Consumer successCallback = token -> {
            SubmittedReportInfo reportInfo = new SubmittedReportInfo(null, "Issue " + token, SubmittedReportInfo.SubmissionStatus.NEW_ISSUE);
            callback.consume((Object)reportInfo);
            this.notifySuccess(project2);
        };
        Consumer errorCallback = ex -> {
            String message = IntellijPluginCoreMessageBundle.message("error.googlefeedback.error", ex.getMessage());
            this.notifyFailure(project2, message);
        };
        GoogleAnonymousFeedbackTask task = new GoogleAnonymousFeedbackTask(project2, "Submitting error report", true, throwable, description, (Consumer<String>)successCallback, (Consumer<Exception>)errorCallback, this.getFeedbackSender());
        if (project2 == null) {
            task.run((ProgressIndicator)new EmptyProgressIndicator());
        } else {
            ProgressManager.getInstance().run((Task)task);
        }
        return true;
    }

    public String getReportActionText() {
        return IntellijPluginCoreMessageBundle.message("error.googlefeedback.message", new Object[0]);
    }

    public boolean submit(@NotNull IdeaLoggingEvent[] events, @Nullable String additionalInfo, @NotNull Component parentComponent, @NotNull Consumer consumer) {
        IdeaLoggingEvent event = events[0];
        Throwable throwable = null;
        if (event.getData() instanceof LogMessage) {
            throwable = ((LogMessage)event.getData()).getThrowable();
        }
        return this.doSubmit(throwable, parentComponent, (Consumer<SubmittedReportInfo>)consumer, additionalInfo);
    }
}

