/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.intellij.analytics.ai_companion;

import com.google.cloud.tools.intellij.analytics.MetricWithMetadata;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0014\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\b\u001a\u0014\u0010\t\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\b\u00a8\u0006\n"}, d2={"isFullAcceptanceEvent", "", "event", "Lcom/google/cloud/tools/intellij/analytics/MetricWithMetadata;", "isOfferedEvent", "getNumFullAcceptanceEvents", "", "events", "", "getNumOfferedEvents", "aiplugin.cloudcode-core"})
@SourceDebugExtension(value={"SMAP\nAiCompanionMetricsValidatorUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AiCompanionMetricsValidatorUtil.kt\ncom/google/cloud/tools/intellij/analytics/ai_companion/AiCompanionMetricsValidatorUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,33:1\n1782#2,4:34\n1782#2,4:38\n*S KotlinDebug\n*F\n+ 1 AiCompanionMetricsValidatorUtil.kt\ncom/google/cloud/tools/intellij/analytics/ai_companion/AiCompanionMetricsValidatorUtilKt\n*L\n29#1:34,4\n32#1:38,4\n*E\n"})
public final class AiCompanionMetricsValidatorUtilKt {
    public static final boolean isFullAcceptanceEvent(@NotNull MetricWithMetadata event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String responseSize = event.getEventMetadata().get("response_size");
        return Intrinsics.areEqual((Object)event.getEventName(), (Object)"cloudcode.aipp.inlinecompletion.accepted") && (event.getEventMetadata().get("partial_accepted_characters") == null || Intrinsics.areEqual((Object)event.getEventMetadata().get("partial_accepted_characters"), (Object)responseSize)) && event.getEventMetadata().get("failure_reason") == null;
    }

    public static final boolean isOfferedEvent(@NotNull MetricWithMetadata event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        return Intrinsics.areEqual((Object)event.getEventName(), (Object)"cloudcode.aipp.inlinecompletion.offered") && event.getEventMetadata().get("failure_reason") == null && Intrinsics.areEqual((Object)event.getEventMetadata().get("completion_mode"), (Object)"language_client");
    }

    /*
     * WARNING - void declaration
     */
    public static final int getNumFullAcceptanceEvents(@NotNull List<MetricWithMetadata> events) {
        int n;
        Intrinsics.checkNotNullParameter(events, (String)"events");
        Iterable $this$count$iv = events;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            void var3_3;
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                MetricWithMetadata it = (MetricWithMetadata)element$iv;
                boolean bl = false;
                if (!AiCompanionMetricsValidatorUtilKt.isFullAcceptanceEvent(it) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = var3_3;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public static final int getNumOfferedEvents(@NotNull List<MetricWithMetadata> events) {
        int n;
        Intrinsics.checkNotNullParameter(events, (String)"events");
        Iterable $this$count$iv = events;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            void var3_3;
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                MetricWithMetadata it = (MetricWithMetadata)element$iv;
                boolean bl = false;
                if (!AiCompanionMetricsValidatorUtilKt.isOfferedEvent(it) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = var3_3;
        }
        return n;
    }
}

