/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.intellij.analytics;

import androidx.annotation.GuardedBy;
import com.google.cloud.tools.intellij.analytics.IdeSessionIndex;
import com.google.cloud.tools.intellij.analytics.IdeSessionIndexSerializer;
import com.google.cloud.tools.intellij.analytics.IdeSessionTracking;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.diagnostic.Logger;
import java.time.LocalDate;
import java.time.ZoneId;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\b&\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H$J\b\u0010\u0006\u001a\u00020\u0007H$J\b\u0010\r\u001a\u00020\fH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u000fH\u0002J\b\u0010\u0011\u001a\u00020\u000fH\u0002J\n\u0010\u0012\u001a\u0004\u0018\u00010\fH\u0002J\b\u0010\u0013\u001a\u00020\fH\u0002R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u0004\u0018\u00010\f8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/google/cloud/tools/intellij/analytics/IdeSessionTrackingBase;", "Lcom/google/cloud/tools/intellij/analytics/IdeSessionTracking;", "<init>", "()V", "getIdeSessionPropertyName", "", "getPropertiesComponent", "Lcom/intellij/ide/util/PropertiesComponent;", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "_ideSessionIndex", "Lcom/google/cloud/tools/intellij/analytics/IdeSessionIndex;", "getIdeSessionIndex", "updateThenPersist", "", "updateIdeSessionIndex", "persistIdeSessionIndex", "read", "getInitialIndex", "Companion", "aiplugin.cloudcode-core"})
public abstract class IdeSessionTrackingBase
implements IdeSessionTracking {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger log;
    @GuardedBy(value="this")
    @Nullable
    private IdeSessionIndex _ideSessionIndex;
    public static final int MAX_COUNT = 9999;

    public IdeSessionTrackingBase() {
        Logger logger = Logger.getInstance(IdeSessionTracking.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.log = logger;
    }

    @NotNull
    protected abstract String getIdeSessionPropertyName();

    @NotNull
    protected abstract PropertiesComponent getPropertiesComponent();

    @Override
    @NotNull
    public synchronized IdeSessionIndex getIdeSessionIndex() {
        if (this._ideSessionIndex == null) {
            this._ideSessionIndex = this.getInitialIndex();
        }
        IdeSessionIndex ideSessionIndex = this._ideSessionIndex;
        Intrinsics.checkNotNull((Object)ideSessionIndex);
        return ideSessionIndex;
    }

    public void updateThenPersist() {
        if (this.getPropertiesComponent().isValueSet(this.getIdeSessionPropertyName())) {
            this.updateIdeSessionIndex();
        }
        this.persistIdeSessionIndex();
    }

    private final synchronized void updateIdeSessionIndex() {
        LocalDate today = Companion.getLocalDateWithTimezone();
        IdeSessionIndex currentIndex = this.getIdeSessionIndex();
        this.log.debug("Updating IdeSessionIndex -- Before: date=" + currentIndex.getDate() + ", count=" + currentIndex.getCount());
        IdeSessionIndex newIndex = currentIndex.getDate().isBefore(today) ? new IdeSessionIndex(today, 0) : (currentIndex.getCount() == 9999 ? IdeSessionIndex.copy$default(currentIndex, null, 0, 1, null) : IdeSessionIndex.copy$default(currentIndex, null, currentIndex.getCount() + 1, 1, null));
        this.log.debug("Updating IdeSessionIndex -- After: date=" + newIndex.getDate() + ", count=" + newIndex.getCount());
        this._ideSessionIndex = newIndex;
    }

    private final synchronized void persistIdeSessionIndex() {
        String serializedIndex = IdeSessionIndexSerializer.Companion.serialize(this.getIdeSessionIndex());
        this.log.debug("Persisting serialized IdeSessionIndex: " + serializedIndex);
        this.getPropertiesComponent().setValue(this.getIdeSessionPropertyName(), serializedIndex);
    }

    private final IdeSessionIndex read() {
        String ideSessionIndexString = this.getPropertiesComponent().getValue(this.getIdeSessionPropertyName());
        return ideSessionIndexString != null ? IdeSessionIndexSerializer.Companion.deserialize(ideSessionIndexString) : null;
    }

    private final IdeSessionIndex getInitialIndex() {
        IdeSessionIndex ideSessionIndex = this.read();
        if (ideSessionIndex == null) {
            ideSessionIndex = new IdeSessionIndex(Companion.getLocalDateWithTimezone(), 0);
        }
        return ideSessionIndex;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/google/cloud/tools/intellij/analytics/IdeSessionTrackingBase$Companion;", "", "<init>", "()V", "MAX_COUNT", "", "getLocalDateWithTimezone", "Ljava/time/LocalDate;", "aiplugin.cloudcode-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LocalDate getLocalDateWithTimezone() {
            LocalDate localDate = LocalDate.now(ZoneId.systemDefault());
            Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"now(...)");
            return localDate;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

