/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.intellij.analytics;

import androidx.annotation.GuardedBy;
import com.google.cloud.tools.intellij.analytics.IUsageTrackingManagement;
import com.google.cloud.tools.intellij.analytics.MetricsEnvironmentProviderBase;
import com.google.cloud.tools.intellij.analytics.MetricsLocalFileWriter;
import com.google.cloud.tools.intellij.analytics.SendsEvents;
import com.google.cloud.tools.intellij.analytics.UsageTrackerBase;
import com.google.cloud.tools.intellij.analytics.Utils;
import com.google.cloud.tools.intellij.analytics.firelog.ActiveExperiments;
import com.google.cloud.tools.intellij.analytics.firelog.ClearcutEventPayload;
import com.google.cloud.tools.intellij.analytics.firelog.ClientInfo;
import com.google.cloud.tools.intellij.analytics.firelog.DesktopClientInfo;
import com.google.cloud.tools.intellij.analytics.firelog.EventMetadata;
import com.google.cloud.tools.intellij.analytics.firelog.FirelogHttpSenderBase;
import com.google.cloud.tools.intellij.analytics.firelog.HatsResponse;
import com.google.cloud.tools.intellij.analytics.firelog.LogEvent;
import com.google.cloud.tools.intellij.analytics.firelog.MetricsSender;
import com.google.cloud.tools.intellij.analytics.firelog.SourceExtensionJson;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.io.MoreFiles;
import com.google.gson.Gson;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FirelogUsageTrackerBase
implements UsageTrackerBase,
SendsEvents {
    private static final String LOG_SOURCE_NAME = "CONCORD";
    private static final String CLIENT_TYPE = "DESKTOP";
    private static final String OS_PLATFORM = SystemInfo.OS_NAME;
    private static final String OS_VERSION = SystemInfo.OS_VERSION;
    private static final String ARCH_PLATFORM = SystemInfo.OS_ARCH;
    private static final String OS = OS_PLATFORM + OS_VERSION;
    private static final String SIGNIN_EVENT_NAME = "signinEvent";
    private static final String WIPEOUT_REQUEST_EVENT_NAME = "INSTALL_ID";
    private static final String WIPEOUT_REQUEST_EVENT_TYPE = "wipeoutRequest";
    private static final String IDE_VERSION = ApplicationInfo.getInstance().getStrictVersion();
    private static final String JDK_VERSION = SystemInfo.JAVA_VERSION;
    private static final DesktopClientInfo DESKTOP_CLIENT_INFO = new DesktopClientInfo(OS);
    private static final ClientInfo CLIENT_INFO = new ClientInfo("DESKTOP", DESKTOP_CLIENT_INFO);
    private static final String PLUGIN_NAME_KEY = "ext_name";
    private static final String PLUGIN_VERSION_KEY = "ext_version";
    private static final String OS_PLATFORM_KEY = "os_platform";
    private static final String OS_RELEASE_KEY = "os_release";
    private static final String ARCH_PLATFORM_KEY = "arch_platform";
    private static final String IDE_NAME_KEY = "editor_name";
    private static final String IDE_VERSION_KEY = "editor_version";
    private static final String IS_CLOUD_WORKSTATIONS_KEY = "is_cloud_workstations";
    private static final String JDK_VERSION_KEY = "jdk_version";
    private static final String EXPERIMENT_IDS = "experiment_ids";
    private static final String FLAGS = "flags";
    private static final String METRICS_DIRECTORY_NAME = "metrics";
    private static final String METRICS_FILE_EXTENSION_JSON = ".json";
    private static final String HATS_SURVEY = "hatsSurvey";
    private static final Path METRICS_DIRECTORY_PATH = Path.of(PathManager.getLogPath(), "metrics");
    @VisibleForTesting
    public static final Duration FILE_FRESHNESS_THRESHOLD = Duration.ofDays(7L);
    private static final Gson GSON = Utils.getProtoGson();
    private static final Logger logger = Logger.getInstance(FirelogUsageTrackerBase.class);
    private final MetricsLocalFileWriter metricsLocalFileWriter = new MetricsLocalFileWriter();
    private final AtomicBoolean isSignedInOnLastEvent;
    @GuardedBy(value="this")
    @VisibleForTesting
    final List<LogEvent> logEvents = new ArrayList<LogEvent>();

    public abstract String getPluginVersion();

    public abstract String getPluginName();

    public abstract String getConsoleType();

    public abstract String isCloudWorkstations();

    public abstract MetricsEnvironmentProviderBase getMetricsEnvironmentProvider();

    public abstract FirelogHttpSenderBase getFirelogHttpSender();

    public abstract IUsageTrackingManagement getUsageTrackingManagement();

    public abstract String getActiveEmail();

    public abstract List<Integer> getExperimentIds();

    public abstract String getExperimentFlags();

    public abstract String getUserLoginEventName();

    public abstract ImmutableList<MetricsSender> getAllSenders();

    protected String getIdeName() {
        return ApplicationInfo.getInstance().getVersionName();
    }

    @VisibleForTesting
    public MetricsEnvironmentProviderBase.MetricsEnvironment getMetricsEnvironment() {
        return this.getMetricsEnvironmentProvider().getMetricsEnvironment();
    }

    private String getMetricsEnvironmentValue() {
        return this.getMetricsEnvironment().getValue();
    }

    public FirelogUsageTrackerBase() {
        this(false);
    }

    @VisibleForTesting
    FirelogUsageTrackerBase(boolean isSignedInOnLastEvent) {
        this.isSignedInOnLastEvent = new AtomicBoolean(isSignedInOnLastEvent);
    }

    @Override
    public void sendEvent(@NotNull String eventCategory, @NotNull String eventAction, @Nullable String clientEmail, @Nullable String projectId, @Nullable Map<String, String> metadataMap, @Nullable String traceId) {
        if (this.isTelemetryBlocked().booleanValue()) {
            return;
        }
        if (metadataMap == null) {
            metadataMap = new HashMap<String, String>();
        }
        this.sendMetricEvent(eventAction, clientEmail, projectId, metadataMap, traceId);
    }

    public Boolean isTelemetryBlocked() {
        return this.isAdminTelemetryBlocked() != false || this.isLocalTelemetryBlocked() != false;
    }

    private Boolean isLocalTelemetryBlocked() {
        return !this.getUsageTrackingManagement().isTrackingEnabled();
    }

    public abstract Boolean isAdminTelemetryBlocked();

    @VisibleForTesting
    void sendMetricEvent(@NotNull String eventAction, @Nullable String clientEmail, @Nullable String projectId, @Nullable Map<String, String> metadataMap, @Nullable String traceId) {
        String installationId = this.getUsageTrackingManagement().getInstallationId();
        ImmutableMap immutableMetadataMap = metadataMap != null ? ImmutableMap.copyOf(metadataMap) : null;
        this.executeOnPooledThread(() -> this.doSendMetricEvent(eventAction, clientEmail, installationId, projectId, (ImmutableMap<String, String>)immutableMetadataMap, traceId));
    }

    private void doSendMetricEvent(@NotNull String eventAction, @Nullable String clientEmail, @NotNull String installationId, @Nullable String projectId, @Nullable ImmutableMap<String, String> metadataMap, @Nullable String traceId) {
        if (clientEmail == null) {
            clientEmail = this.getActiveEmail();
        }
        boolean isSignedIn = clientEmail != null;
        this.sendSignInEvent(isSignedIn || this.getUserLoginEventName().equals(eventAction));
        String filteredInstallationId = isSignedIn ? null : installationId;
        HashMap combinedMetadata = Maps.newHashMap();
        if (metadataMap != null) {
            combinedMetadata.putAll(metadataMap);
        }
        combinedMetadata.putAll(this.getCommonMetadata());
        List<EventMetadata> metadataList = FirelogUsageTrackerBase.toEventMetadataList(combinedMetadata);
        SourceExtensionJson sourceExtensionJson = new SourceExtensionJson(this.getConsoleType(), eventAction, null, filteredInstallationId, clientEmail, metadataList, this.getMetricsEnvironmentValue(), projectId, traceId);
        this.enqueuePing(sourceExtensionJson);
    }

    @VisibleForTesting
    void sendSignInEvent(boolean isSignedInNow) {
        boolean sendSignInPing;
        boolean isSignedInOnLastEvent = this.isSignedInOnLastEvent.getAndSet(isSignedInNow);
        boolean bl = sendSignInPing = isSignedInNow && !isSignedInOnLastEvent;
        if (!sendSignInPing) {
            return;
        }
        String installationId = this.getUsageTrackingManagement().getInstallationId();
        SourceExtensionJson sourceExtensionJson = new SourceExtensionJson(this.getConsoleType(), SIGNIN_EVENT_NAME, null, installationId, null, null, this.getMetricsEnvironmentValue());
        this.enqueuePing(sourceExtensionJson);
    }

    @Override
    public void sendInstallIdWipeoutPing() {
        String installationId = this.getUsageTrackingManagement().getInstallationId();
        SourceExtensionJson sourceExtensionJson = new SourceExtensionJson(this.getConsoleType(), WIPEOUT_REQUEST_EVENT_NAME, WIPEOUT_REQUEST_EVENT_TYPE, installationId, null, null, this.getMetricsEnvironmentValue());
        this.enqueuePing(sourceExtensionJson);
        this.flushInBackground();
    }

    @Override
    public void sendHatsPing(HatsResponse hatsResponse, Map<String, String> extraMetadata) {
        Logger.getInstance((String)"TrackingEventBuilder").debug("sendHatsPing " + hatsResponse);
        String clientEmail = this.getActiveEmail();
        boolean isSignedIn = clientEmail != null;
        String filteredInstallationId = null;
        if (!isSignedIn) {
            filteredInstallationId = this.getUsageTrackingManagement().getInstallationId();
        }
        List<EventMetadata> eventMetadata = FirelogUsageTrackerBase.toEventMetadataList(this.getCommonMetadata());
        if (extraMetadata != null) {
            HashMap<String, String> filteredExtraMetadata = new HashMap<String, String>(extraMetadata);
            filteredExtraMetadata.keySet().removeIf(Objects::isNull);
            filteredExtraMetadata.values().removeIf(Objects::isNull);
            eventMetadata.addAll(FirelogUsageTrackerBase.toEventMetadataList(filteredExtraMetadata));
        }
        SourceExtensionJson sourceExtensionJson = new SourceExtensionJson(this.getConsoleType(), HATS_SURVEY, HATS_SURVEY, filteredInstallationId, clientEmail, eventMetadata, this.getMetricsEnvironmentValue(), hatsResponse);
        this.enqueuePing(sourceExtensionJson);
    }

    private Map<String, String> getCommonMetadata() {
        HashMap result2 = Maps.newHashMapWithExpectedSize((int)11);
        result2.put(PLUGIN_NAME_KEY, this.getPluginName());
        result2.put(PLUGIN_VERSION_KEY, this.getPluginVersion());
        result2.put(OS_PLATFORM_KEY, OS_PLATFORM);
        result2.put(OS_RELEASE_KEY, OS_VERSION);
        result2.put(IDE_NAME_KEY, this.getIdeName());
        result2.put(IDE_VERSION_KEY, IDE_VERSION);
        result2.put(IS_CLOUD_WORKSTATIONS_KEY, this.isCloudWorkstations());
        result2.put(JDK_VERSION_KEY, JDK_VERSION);
        result2.put(ARCH_PLATFORM_KEY, ARCH_PLATFORM);
        result2.put(EXPERIMENT_IDS, this.getExperimentIds().toString());
        result2.put(FLAGS, this.getExperimentFlags());
        return result2;
    }

    private synchronized void enqueuePing(SourceExtensionJson sourceExtensionJson) {
        this.checkMetricsEnvironmentAndWriteToFile(sourceExtensionJson);
        this.logEvents.add(new LogEvent(Instant.now().toEpochMilli(), 0, GSON.toJson((Object)sourceExtensionJson), new ActiveExperiments(this.getExperimentIds())));
    }

    @VisibleForTesting
    public void checkMetricsEnvironmentAndWriteToFile(SourceExtensionJson sourceExtensionJson) {
        switch (this.getMetricsEnvironment()) {
            case PROD: {
                break;
            }
            case TEST: 
            case DEV: {
                this.writeToMetricsLocalFile(sourceExtensionJson);
                break;
            }
        }
    }

    @VisibleForTesting
    public abstract void writeToMetricsLocalFile(SourceExtensionJson var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RequiresBackgroundThread
    public Optional<Duration> flushAndAwait() {
        ArrayList<LogEvent> logEventsSnapshot;
        FirelogUsageTrackerBase firelogUsageTrackerBase = this;
        synchronized (firelogUsageTrackerBase) {
            if (this.logEvents.isEmpty()) {
                return Optional.empty();
            }
            logEventsSnapshot = new ArrayList<LogEvent>(this.logEvents);
            this.logEvents.clear();
        }
        Optional<Duration> nextRequestWaitDuration = Optional.empty();
        ClearcutEventPayload payload = new ClearcutEventPayload(CLIENT_INFO, LOG_SOURCE_NAME, System.currentTimeMillis(), logEventsSnapshot);
        ImmutableList<MetricsSender> senders = this.getAllSenders();
        for (MetricsSender sender : senders) {
            Optional<Duration> senderNextRequestWaitDuration = sender.sendPing(payload);
            if (this.uploadFromDiskEnabled() && (senderNextRequestWaitDuration.isEmpty() || senderNextRequestWaitDuration.get().isNegative())) {
                String payloadString = GSON.toJson((Object)payload);
                Path filePath = Path.of(METRICS_DIRECTORY_PATH.toString(), sender.getId(), UUID.randomUUID() + METRICS_FILE_EXTENSION_JSON);
                this.metricsLocalFileWriter.writeToMetricsFileForRetry(payloadString, filePath);
            }
            if (!nextRequestWaitDuration.isEmpty() && (!senderNextRequestWaitDuration.isPresent() || senderNextRequestWaitDuration.get().compareTo(nextRequestWaitDuration.get()) <= 0)) continue;
            nextRequestWaitDuration = senderNextRequestWaitDuration;
        }
        return nextRequestWaitDuration;
    }

    @Override
    public boolean retryFailedUploadsAndAwait() {
        boolean result2 = true;
        ImmutableList<MetricsSender> senders = this.getAllSenders();
        for (MetricsSender sender : senders) {
            result2 = result2 && this.retryFailedUploadsForSender(sender);
        }
        return result2;
    }

    @RequiresBackgroundThread
    private boolean retryFailedUploadsForSender(MetricsSender sender) {
        ImmutableList metricFiles = ImmutableList.of();
        try {
            metricFiles = MoreFiles.listFiles((Path)Path.of(METRICS_DIRECTORY_PATH.toString(), sender.getId()));
        }
        catch (Exception e) {
            if (!(e instanceof FileNotFoundException)) {
                logger.warn("Exception trying to read log files directory: ", (Throwable)e);
            }
            return true;
        }
        for (Path path2 : metricFiles) {
            try {
                Optional<Duration> retryDuration;
                boolean isExpired;
                Duration fileAge = Duration.between(Files.getLastModifiedTime(path2, new LinkOption[0]).toInstant(), Instant.now());
                boolean bl = isExpired = fileAge.compareTo(FILE_FRESHNESS_THRESHOLD) > 0;
                if (isExpired) {
                    Files.deleteIfExists(path2);
                    continue;
                }
                if (!path2.toString().endsWith(METRICS_FILE_EXTENSION_JSON) || !(retryDuration = this.uploadEventsFromFile(sender, path2)).isPresent() || retryDuration.get().isNegative()) continue;
                Files.deleteIfExists(path2);
            }
            catch (Exception e) {
                logger.warn("Exception trying to handle log file: " + path2, (Throwable)e);
                return false;
            }
        }
        return true;
    }

    @VisibleForTesting
    @RequiresBackgroundThread
    public Optional<Duration> uploadEventsFromFile(MetricsSender sender, Path path2) {
        ClearcutEventPayload eventPayload;
        try {
            if (path2 == null) {
                return Optional.empty();
            }
            String content2 = Files.readString(path2, StandardCharsets.UTF_8);
            eventPayload = (ClearcutEventPayload)GSON.fromJson(content2, ClearcutEventPayload.class);
        }
        catch (IOException e) {
            logger.debug("Not able to read file: " + path2, (Throwable)e);
            return Optional.empty();
        }
        return sender.sendPing(eventPayload);
    }

    @Override
    public boolean uploadFromDiskEnabled() {
        return this.getMetricsEnvironment() == MetricsEnvironmentProviderBase.MetricsEnvironment.DEV;
    }

    @NotNull
    private static List<EventMetadata> toEventMetadataList(Map<String, String> metadataMap) {
        return metadataMap.entrySet().stream().map(entry -> new EventMetadata((String)entry.getKey(), (String)entry.getValue())).collect(Collectors.toList());
    }

    @VisibleForTesting
    void executeOnPooledThread(Runnable callable) {
        ApplicationManager.getApplication().executeOnPooledThread(callable);
    }
}

