/*
 * Decompiled with CFR 0.152.
 */
package com.google.aiplugin.rag.internal;

import com.google.aiplugin.rag.internal.IndexerMode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0012\u001a\u00020\u0007*\u00020\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00078F@GX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000fR\u000e\u0010\u0011\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/google/aiplugin/rag/internal/IndexerModeProvider;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "value", "Lcom/google/aiplugin/rag/internal/IndexerMode;", "currentMode", "getCurrentMode", "()Lcom/google/aiplugin/rag/internal/IndexerMode;", "setCurrentMode", "(Lcom/google/aiplugin/rag/internal/IndexerMode;)V", "isBm25Mode", "", "()Z", "isEmbeddingMode", "DEFAULT_MODE", "orDefaultInProduction", "RAG_INDEX_PROPERTY_KEY", "", "COMMON_DESCRIPTION", "aiplugin.rag.indexer"})
@SourceDebugExtension(value={"SMAP\nIndexerModeProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndexerModeProvider.kt\ncom/google/aiplugin/rag/internal/IndexerModeProvider\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,86:1\n25#2:87\n*S KotlinDebug\n*F\n+ 1 IndexerModeProvider.kt\ncom/google/aiplugin/rag/internal/IndexerModeProvider\n*L\n23#1:87\n*E\n"})
public final class IndexerModeProvider {
    @NotNull
    public static final IndexerModeProvider INSTANCE;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final IndexerMode DEFAULT_MODE;
    @NotNull
    public static final String RAG_INDEX_PROPERTY_KEY = "gemini.rag.index";
    @NotNull
    public static final String COMMON_DESCRIPTION = "Use this tool when answering the user's query requires first searching through the codebase\nin natural language. When using this tool, if there are not enough results, consider widening the\nsearch terms and search again. Once relevant files are found, use read_file tool to read those files\nas appropriate.";

    private IndexerModeProvider() {
    }

    @NotNull
    public final IndexerMode getCurrentMode() {
        String string = System.getProperty(RAG_INDEX_PROPERTY_KEY);
        if (string == null) {
            return DEFAULT_MODE;
        }
        String ragIndexer = string;
        String string2 = ragIndexer;
        return Intrinsics.areEqual((Object)string2, (Object)IndexerMode.BM25.getModeName$aiplugin_rag_indexer()) ? IndexerMode.BM25 : (Intrinsics.areEqual((Object)string2, (Object)IndexerMode.EMBEDDING.getModeName$aiplugin_rag_indexer()) ? this.orDefaultInProduction(IndexerMode.EMBEDDING) : IndexerMode.NONE);
    }

    @VisibleForTesting
    public final void setCurrentMode(@NotNull IndexerMode value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        System.setProperty(RAG_INDEX_PROPERTY_KEY, value.getModeName$aiplugin_rag_indexer());
    }

    public final boolean isBm25Mode() {
        return this.getCurrentMode() == IndexerMode.BM25;
    }

    public final boolean isEmbeddingMode() {
        return this.getCurrentMode() == IndexerMode.EMBEDDING;
    }

    private final IndexerMode orDefaultInProduction(IndexerMode $this$orDefaultInProduction) {
        IndexerMode indexerMode;
        if (ApplicationManager.getApplication().isInternal()) {
            logger.info("It is in dev mode (or dogfood). " + $this$orDefaultInProduction.getModeName$aiplugin_rag_indexer() + " RAG will be used.");
            indexerMode = $this$orDefaultInProduction;
        } else {
            logger.warn("Embedding RAG is not available now. Instead, " + DEFAULT_MODE.getModeName$aiplugin_rag_indexer() + " RAG will be used.");
            indexerMode = DEFAULT_MODE;
        }
        return indexerMode;
    }

    static {
        IndexerModeProvider $this$thisLogger$iv = INSTANCE = new IndexerModeProvider();
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(IndexerModeProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        IndexerModeProvider.logger = logger;
        DEFAULT_MODE = IndexerMode.BM25;
    }
}

