/*
 * Decompiled with CFR 0.152.
 */
package com.google.aiplugin.rag.internal;

import com.google.aiplugin.rag.bm25.Bm25IndexerService;
import com.google.aiplugin.rag.embedding.EmbeddingIndexerService;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u000e\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\r"}, d2={"Lcom/google/aiplugin/rag/internal/IndexableFilesCleaner;", "Lcom/intellij/openapi/vfs/AsyncFileListener;", "<init>", "()V", "prepareChange", "Lcom/intellij/openapi/vfs/AsyncFileListener$ChangeApplier;", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "unindexRecursively", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "aiplugin.rag.indexer"})
@SourceDebugExtension(value={"SMAP\nIndexableFilesCleaner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndexableFilesCleaner.kt\ncom/google/aiplugin/rag/internal/IndexableFilesCleaner\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,56:1\n13402#2,2:57\n*S KotlinDebug\n*F\n+ 1 IndexableFilesCleaner.kt\ncom/google/aiplugin/rag/internal/IndexableFilesCleaner\n*L\n48#1:57,2\n*E\n"})
public final class IndexableFilesCleaner
implements AsyncFileListener {
    @Nullable
    public AsyncFileListener.ChangeApplier prepareChange(@NotNull List<? extends VFileEvent> events) {
        Intrinsics.checkNotNullParameter(events, (String)"events");
        for (VFileEvent vFileEvent : events) {
            VirtualFile file;
            if (vFileEvent.getFile() == null || !(vFileEvent instanceof VFileDeleteEvent)) continue;
            this.unindexRecursively(file);
        }
        return null;
    }

    private final void unindexRecursively(VirtualFile file) {
        ProgressManager.checkCanceled();
        if (file.isDirectory() && !file.is(VFileProperty.SYMLINK)) {
            VirtualFile[] virtualFileArray = file.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getChildren(...)");
            Object[] $this$forEach$iv = virtualFileArray;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                VirtualFile it = (VirtualFile)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                this.unindexRecursively(it);
            }
            return;
        }
        EmbeddingIndexerService.Companion.getInstance().unindex(file);
        Bm25IndexerService.Companion.getInstance().unindex(file);
    }
}

