/*
 * Decompiled with CFR 0.152.
 */
package com.google.aiplugin.rag.bm25;

import com.google.aiplugin.agents.Response;
import com.google.aiplugin.agents.Tool;
import com.google.aiplugin.agents.ToolHandler;
import com.google.aiplugin.agents.tools.ToolArgument;
import com.google.aiplugin.agents.tools.ToolContext;
import com.google.aiplugin.agents.tools.ToolDescription;
import com.google.aiplugin.agents.tools.ToolResult;
import com.google.aiplugin.rag.bm25.Bm25IndexerService;
import com.google.aiplugin.rag.bm25.Bm25IndexerServiceImpl;
import com.google.aiplugin.rag.bm25.Bm25SearchTool;
import com.google.aiplugin.rag.bm25.Bm25SearchTool$Args$;
import com.google.aiplugin.rag.bm25.CodeAnalyzer;
import com.google.aiplugin.rag.internal.ContextSharingUtilsKt;
import com.google.aiplugin.rag.internal.RagSearchToolResult;
import com.google.aiplugin.rag.internal.VirtualFileUtilsKt;
import com.google.gson.Gson;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.Closeable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KParameter;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import kotlinx.serialization.internal.StringSerializer;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.similarities.BM25Similarity;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ToolDescription(summary="Searches an index of the user's code base", description="The index is created by Lucene, and contains a field for the file name and one for its contents.", instructions="Use this tool when answering the user's query requires first searching through the codebase\nin natural language. When using this tool, if there are not enough results, consider widening the\nsearch terms and search again. Once relevant files are found, use read_file tool to read those files\nas appropriate.", examples={})
@ToolResult(description="Returns up to 50 file paths that match the given query.")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00112\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003\u000f\u0010\u0011B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u0002H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lcom/google/aiplugin/rag/bm25/Bm25SearchTool;", "Lcom/google/aiplugin/agents/Tool;", "Lcom/google/aiplugin/rag/bm25/Bm25SearchTool$Args;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "getDisplayText", "args", "createHandler", "Lcom/google/aiplugin/rag/bm25/Bm25SearchTool$Handler;", "context", "Lcom/google/aiplugin/agents/tools/ToolContext;", "Args", "Handler", "Companion", "aiplugin.rag.indexer"})
public final class Bm25SearchTool
implements Tool<Args> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;

    public Bm25SearchTool() {
        this.name = "code_search";
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getDisplayText(@NotNull Args args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return "Searching the codebase";
    }

    @NotNull
    public Handler createHandler(@NotNull ToolContext context2, @NotNull Args args) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return new Handler(context2, args);
    }

    @Override
    @Nullable
    public String getStatusMessage() {
        return Tool.super.getStatusMessage();
    }

    @Override
    @Nullable
    public Map<KParameter, ToolArgument> getToolArguments() {
        return Tool.super.getToolArguments();
    }

    @Override
    @NotNull
    public ToolDescription getToolDescription() {
        return Tool.super.getToolDescription();
    }

    @Override
    @Nullable
    public ToolResult getToolResult() {
        return Tool.super.getToolResult();
    }

    @Override
    @Nullable
    public ToolHandler restoreHandler(@NotNull Project project2, @NotNull Args args, @NotNull Response response2) {
        return Tool.super.restoreHandler(project2, args, response2);
    }

    @Override
    @NotNull
    public String getDescription() {
        return Tool.super.getDescription();
    }

    @Serializable
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 \u001e2\u00020\u0001:\u0002\u001d\u001eB\u0017\u0012\u000e\b\u0001\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B+\b\u0010\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u000e\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u0005\u0010\u000bJ\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\u000f\u001a\u00020\u00002\u000e\b\u0003\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\bH\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0004H\u00d6\u0001J%\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0001\u00a2\u0006\u0002\b\u001cR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001f"}, d2={"Lcom/google/aiplugin/rag/bm25/Bm25SearchTool$Args;", "", "terms", "", "", "<init>", "(Ljava/util/List;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/util/List;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getTerms", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$aiplugin_rag_indexer", "$serializer", "Companion", "aiplugin.rag.indexer"})
    public static final class Args {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final List<String> terms;
        @JvmField
        @NotNull
        private static final Lazy<KSerializer<Object>>[] $childSerializers;

        public Args(@ToolArgument(description="List of string terms that should be present in the file content.") @NotNull List<String> terms) {
            Intrinsics.checkNotNullParameter(terms, (String)"terms");
            this.terms = terms;
        }

        @NotNull
        public final List<String> getTerms() {
            return this.terms;
        }

        @NotNull
        public final List<String> component1() {
            return this.terms;
        }

        @NotNull
        public final Args copy(@ToolArgument(description="List of string terms that should be present in the file content.") @NotNull List<String> terms) {
            Intrinsics.checkNotNullParameter(terms, (String)"terms");
            return new Args(terms);
        }

        public static /* synthetic */ Args copy$default(Args args, List list, int n, Object object) {
            if ((n & 1) != 0) {
                list = args.terms;
            }
            return args.copy(list);
        }

        @NotNull
        public String toString() {
            return "Args(terms=" + this.terms + ")";
        }

        public int hashCode() {
            return ((Object)this.terms).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Args)) {
                return false;
            }
            Args args = (Args)other;
            return Intrinsics.areEqual(this.terms, args.terms);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$aiplugin_rag_indexer(Args self, CompositeEncoder output, SerialDescriptor serialDesc) {
            Lazy<KSerializer<Object>>[] lazyArray = $childSerializers;
            output.encodeSerializableElement(serialDesc, 0, (SerializationStrategy)lazyArray[0].getValue(), self.terms);
        }

        public /* synthetic */ Args(int seen0, List terms, SerializationConstructorMarker serializationConstructorMarker) {
            if (1 != (1 & seen0)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)1, (SerialDescriptor)Args$$serializer.INSTANCE.getDescriptor());
            }
            this.terms = terms;
        }

        public static final /* synthetic */ Lazy[] access$get$childSerializers$cp() {
            return $childSerializers;
        }

        static {
            Lazy[] lazyArray = new Lazy[]{LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> (KSerializer)new ArrayListSerializer((KSerializer)StringSerializer.INSTANCE))};
            $childSerializers = lazyArray;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lcom/google/aiplugin/rag/bm25/Bm25SearchTool$Args$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/google/aiplugin/rag/bm25/Bm25SearchTool$Args;", "aiplugin.rag.indexer"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<Args> serializer() {
                return (KSerializer)Args$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\b\u0002\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u000b"}, d2={"Lcom/google/aiplugin/rag/bm25/Bm25SearchTool$Companion;", "", "<init>", "()V", "buildSearchQuery", "Lorg/apache/lucene/search/Query;", "terms", "", "", "analyzer", "Lorg/apache/lucene/analysis/Analyzer;", "aiplugin.rag.indexer"})
    public static final class Companion {
        private Companion() {
        }

        private final Query buildSearchQuery(List<String> terms, Analyzer analyzer) {
            BooleanQuery.Builder booleanQuery = new BooleanQuery.Builder();
            String query = CollectionsKt.joinToString$default((Iterable)terms, (CharSequence)" OR ", null, null, (int)0, null, Companion::buildSearchQuery$lambda$0, (int)30, null);
            Query fileNameQuery = new QueryParser("vfile.name", analyzer).parse(query);
            booleanQuery.add(fileNameQuery, BooleanClause.Occur.SHOULD);
            Query contentQuery = new QueryParser("vfile.contents", analyzer).parse(query);
            booleanQuery.add(contentQuery, BooleanClause.Occur.SHOULD);
            BooleanQuery booleanQuery2 = booleanQuery.build();
            Intrinsics.checkNotNullExpressionValue((Object)booleanQuery2, (String)"build(...)");
            return (Query)booleanQuery2;
        }

        static /* synthetic */ Query buildSearchQuery$default(Companion companion, List list, Analyzer analyzer, int n, Object object) {
            if ((n & 2) != 0) {
                analyzer = new CodeAnalyzer(null, 1, null);
            }
            return companion.buildSearchQuery(list, analyzer);
        }

        private static final CharSequence buildSearchQuery$lambda$0(String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            String string = QueryParser.escape((String)it);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"escape(...)");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u000e\u001a\u00020\u000fH\u0096@\u00a2\u0006\u0002\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/google/aiplugin/rag/bm25/Bm25SearchTool$Handler;", "Lcom/google/aiplugin/agents/ToolHandler;", "context", "Lcom/google/aiplugin/agents/tools/ToolContext;", "args", "Lcom/google/aiplugin/rag/bm25/Bm25SearchTool$Args;", "<init>", "(Lcom/google/aiplugin/agents/tools/ToolContext;Lcom/google/aiplugin/rag/bm25/Bm25SearchTool$Args;)V", "getContext", "()Lcom/google/aiplugin/agents/tools/ToolContext;", "getArgs", "()Lcom/google/aiplugin/rag/bm25/Bm25SearchTool$Args;", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "handle", "Lcom/google/aiplugin/agents/Response;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "aiplugin.rag.indexer"})
    @SourceDebugExtension(value={"SMAP\nBm25SearchTool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Bm25SearchTool.kt\ncom/google/aiplugin/rag/bm25/Bm25SearchTool$Handler\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,132:1\n25#2:133\n1#3:134\n11158#4:135\n11493#4,3:136\n827#5:139\n855#5,2:140\n1557#5:142\n1628#5,3:143\n*S KotlinDebug\n*F\n+ 1 Bm25SearchTool.kt\ncom/google/aiplugin/rag/bm25/Bm25SearchTool$Handler\n*L\n66#1:133\n85#1:135\n85#1:136,3\n96#1:139\n96#1:140,2\n103#1:142\n103#1:143,3\n*E\n"})
    public static final class Handler
    implements ToolHandler {
        @NotNull
        private final ToolContext context;
        @NotNull
        private final Args args;
        @NotNull
        private final Logger log;

        public Handler(@NotNull ToolContext context2, @NotNull Args args) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            this.context = context2;
            this.args = args;
            Handler $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(Handler.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            this.log = logger;
        }

        @NotNull
        public final ToolContext getContext() {
            return this.context;
        }

        @NotNull
        public final Args getArgs() {
            return this.args;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @Override
        @Nullable
        public Object handle(@NotNull Continuation<? super Response> $completion) {
            if (!($completion instanceof handle.1)) ** GOTO lbl-1000
            var27_2 = $completion;
            if ((var27_2.label & -2147483648) != 0) {
                var27_2.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ Handler this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.handle((Continuation<? super Response>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var29_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    if (!Bm25IndexerService.Companion.getInstance().getActive()) {
                        this.log.warn("Bm25 Indexer is not active");
                        return new Response(null, "code search is disabled", null, 5, null);
                    }
                    try {
                        var3_5 = (Closeable)FSDirectory.open((Path)Bm25IndexerService.Companion.getInstance().getIndexDirectory());
                        var4_6 = null;
                        try {
                            fsDir = (FSDirectory)var3_5;
                            $i$a$-use-Bm25SearchTool$Handler$handle$docIds$1 = false;
                            var7_16 = (Closeable)DirectoryReader.open((Directory)((Directory)fsDir));
                            var8_17 = null;
                            try {
                                index /* !! */  = (DirectoryReader)var7_16;
                                $i$a$-use-Bm25SearchTool$Handler$handle$docIds$1$1 = false;
                                this.log.debug("Searching index version " + index /* !! */ .getVersion() + ", #docs " + index /* !! */ .numDocs());
                                it = var11_27 = new IndexSearcher((IndexReader)index /* !! */ );
                                $i$a$-also-Bm25SearchTool$Handler$handle$docIds$1$1$searcher$1 = false;
                                it.setSimilarity((Similarity)new BM25Similarity());
                                searcher = var11_27;
                                query = com.google.aiplugin.rag.bm25.Bm25SearchTool$Companion.buildSearchQuery$default(Bm25SearchTool.Companion, this.args.getTerms(), null, 2, null);
                                maxHits = 200;
                                Intrinsics.checkNotNullExpressionValue((Object)searcher.search((Query)query, (int)maxHits).scoreDocs, (String)"scoreDocs");
                                $this$map$iv = searcher.search((Query)query, (int)maxHits).scoreDocs;
                                $i$f$map = false;
                                var16_36 = $this$map$iv;
                                destination$iv$iv = new ArrayList<E>($this$map$iv.length);
                                $i$f$mapTo = false;
                                for (void item$iv$iv : $this$mapTo$iv$iv) {
                                    var22_42 = (ScoreDoc)item$iv$iv;
                                    var23_43 = destination$iv$iv;
                                    $i$a$-map-Bm25SearchTool$Handler$handle$docIds$1$1$1 = false;
                                    var23_43.add(Boxing.boxInt((int)Bm25IndexerServiceImpl.Companion.getFileIdForDoc$aiplugin_rag_indexer(searcher, scoreDoc.doc)));
                                }
                                index /* !! */  = (List)destination$iv$iv;
                            }
                            catch (Throwable $i$a$-use-Bm25SearchTool$Handler$handle$docIds$1$1) {
                                var8_17 = $i$a$-use-Bm25SearchTool$Handler$handle$docIds$1$1;
                                throw $i$a$-use-Bm25SearchTool$Handler$handle$docIds$1$1;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)var7_16, (Throwable)var8_17);
                            }
                            fsDir = index /* !! */ ;
                        }
                        catch (Throwable $i$a$-use-Bm25SearchTool$Handler$handle$docIds$1) {
                            var4_6 = $i$a$-use-Bm25SearchTool$Handler$handle$docIds$1;
                            throw $i$a$-use-Bm25SearchTool$Handler$handle$docIds$1;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)var3_5, (Throwable)var4_6);
                        }
                        var3_5 = fsDir;
                    }
                    catch (Exception e) {
                        this.log.warn("Error opening lucene index", (Throwable)e);
                        var3_5 = CollectionsKt.emptyList();
                    }
                    $continuation.L$0 = docIds = var3_5;
                    $continuation.label = 1;
                    v0 = VirtualFileUtilsKt.validFilesInProject((List<Integer>)docIds, this.context.getProject(), (Continuation<? super List<? extends VirtualFile>>)$continuation);
                    if (v0 == var29_4) {
                        return var29_4;
                    }
                    ** GOTO lbl80
                }
                case 1: {
                    docIds = (List)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl80:
                    // 2 sources

                    $this$filterNot$iv = (Iterable)v0;
                    $i$f$filterNot = false;
                    $i$a$-use-Bm25SearchTool$Handler$handle$docIds$1 = $this$filterNot$iv;
                    destination$iv$iv /* !! */  = new ArrayList<E>();
                    $i$f$filterNotTo = false;
                    for (T element$iv$iv : $this$filterNotTo$iv$iv) {
                        it = (VirtualFile)element$iv$iv;
                        $i$a$-filterNot-Bm25SearchTool$Handler$handle$projectFiles$1 = false;
                        if (ContextSharingUtilsKt.isContextSharingDenied(it, this.context.getProject())) continue;
                        destination$iv$iv /* !! */ .add(element$iv$iv);
                    }
                    projectFiles = (List)destination$iv$iv /* !! */ ;
                    this.log.debug("Found " + ((Collection)docIds).size() + " files overall, " + projectFiles.size() + " that are valid and inside the project");
                    $this$map$iv = projectFiles;
                    $i$f$map = false;
                    destination$iv$iv /* !! */  = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        $i$a$-filterNot-Bm25SearchTool$Handler$handle$projectFiles$1 = (VirtualFile)item$iv$iv;
                        var25_46 = destination$iv$iv;
                        $i$a$-map-Bm25SearchTool$Handler$handle$result$1 = false;
                        var25_46.add(it.getPath());
                    }
                    var28_47 = CollectionsKt.take((Iterable)((List)destination$iv$iv), (int)50);
                    result = new RagSearchToolResult(var28_47);
                    return new Response(new Gson().toJson((Object)result), null, null, 6, null);
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }
    }
}

