/*
 * Decompiled with CFR 0.152.
 */
package com.google.aiplugin.rag.bm25;

import com.google.aiplugin.rag.bm25.Bm25IndexerService;
import com.google.aiplugin.rag.bm25.Bm25SearchTool;
import com.google.aiplugin.rag.bm25.CodeAnalyzer;
import com.google.aiplugin.rag.internal.IndexerModeProvider;
import com.google.aiplugin.rag.internal.VirtualFileUtilsKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.util.io.PathKt;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelKt;
import kotlinx.coroutines.channels.ClosedReceiveChannelException;
import org.HdrHistogram.Histogram;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.IntField;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexNotFoundException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.similarities.BM25Similarity;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.LockObtainFailedException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 <2\u00020\u00012\u00020\u0002:\u0001<B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eB\u0011\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\r\u0010\u000fJ\u0010\u0010/\u001a\u0002002\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u00101\u001a\u0002002\u0006\u00102\u001a\u000203H\u0016J\u0010\u00104\u001a\u0002002\u0006\u00102\u001a\u000203H\u0016J\u0010\u00104\u001a\u0002002\u0006\u00105\u001a\u00020\u0019H\u0002J\r\u00106\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b7J\u0010\u00108\u001a\u00020\u00042\u0006\u00102\u001a\u000203H\u0016J\b\u00109\u001a\u000200H\u0016J\r\u0010:\u001a\u000200H\u0000\u00a2\u0006\u0002\b;R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0010\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u0019X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020'X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00190*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010+\u001a\u00020,8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.\u00a8\u0006="}, d2={"Lcom/google/aiplugin/rag/bm25/Bm25IndexerServiceImpl;", "Lcom/google/aiplugin/rag/bm25/Bm25IndexerService;", "Lcom/intellij/openapi/Disposable;", "enabled", "", "scope", "Lkotlinx/coroutines/CoroutineScope;", "ioDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "indexDirectory", "Ljava/nio/file/Path;", "indexCommitInterval", "Lkotlin/time/Duration;", "<init>", "(ZLkotlinx/coroutines/CoroutineScope;Lkotlinx/coroutines/CoroutineDispatcher;Ljava/nio/file/Path;JLkotlin/jvm/internal/DefaultConstructorMarker;)V", "(Lkotlinx/coroutines/CoroutineScope;)V", "getIndexDirectory", "()Ljava/nio/file/Path;", "J", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "active", "getActive", "()Z", "version", "", "getVersion", "()I", "iwc", "Lorg/apache/lucene/index/IndexWriterConfig;", "fsDir", "Lorg/apache/lucene/store/FSDirectory;", "indexWriter", "Lorg/apache/lucene/index/IndexWriter;", "indexingDurationInMillisHistogram", "Lorg/HdrHistogram/Histogram;", "histogramLock", "", "indexCommitter", "Lkotlinx/coroutines/Job;", "unindexCommitter", "unindexChannel", "Lkotlinx/coroutines/channels/Channel;", "hasUncommittedChanges", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getHasUncommittedChanges", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "initialize", "", "index", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "unindex", "fileId", "isReady", "isReady$aiplugin_rag_indexer", "isIndexed", "dispose", "dumpStats", "dumpStats$aiplugin_rag_indexer", "Companion", "aiplugin.rag.indexer"})
@SourceDebugExtension(value={"SMAP\nBm25IndexerService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Bm25IndexerService.kt\ncom/google/aiplugin/rag/bm25/Bm25IndexerServiceImpl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 Timing.kt\nkotlin/system/TimingKt\n*L\n1#1,338:1\n25#2:339\n29#3,3:340\n*S KotlinDebug\n*F\n+ 1 Bm25IndexerService.kt\ncom/google/aiplugin/rag/bm25/Bm25IndexerServiceImpl\n*L\n100#1:339\n210#1:340,3\n*E\n"})
public final class Bm25IndexerServiceImpl
implements Bm25IndexerService,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final CoroutineDispatcher ioDispatcher;
    @NotNull
    private final Path indexDirectory;
    private final long indexCommitInterval;
    @NotNull
    private final Logger log;
    private final boolean active;
    private final int version;
    @NotNull
    private final IndexWriterConfig iwc;
    private FSDirectory fsDir;
    private IndexWriter indexWriter;
    @NotNull
    private final Histogram indexingDurationInMillisHistogram;
    @NotNull
    private final Object histogramLock;
    private Job indexCommitter;
    private Job unindexCommitter;
    @NotNull
    private final Channel<Integer> unindexChannel;
    @VisibleForTesting
    @NotNull
    private final AtomicBoolean hasUncommittedChanges;
    private static final long INDEX_COMMIT_INTERVAL = DurationKt.toDuration((int)30, (DurationUnit)DurationUnit.SECONDS);
    private static final long MAX_MEASURED_LATENCY_MS = 10000L;

    /*
     * WARNING - void declaration
     */
    private Bm25IndexerServiceImpl(boolean enabled, CoroutineScope scope2, CoroutineDispatcher ioDispatcher, Path indexDirectory, long indexCommitInterval) {
        boolean bl;
        void config22;
        IndexWriterConfig indexWriterConfig;
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)ioDispatcher, (String)"ioDispatcher");
        Intrinsics.checkNotNullParameter((Object)indexDirectory, (String)"indexDirectory");
        this.scope = scope2;
        this.ioDispatcher = ioDispatcher;
        this.indexDirectory = indexDirectory;
        this.indexCommitInterval = indexCommitInterval;
        Bm25IndexerServiceImpl $this$thisLogger$iv = this;
        boolean $i$f$thisLogger22 = false;
        Logger logger = Logger.getInstance(Bm25IndexerServiceImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.log = logger;
        this.version = 2;
        IndexWriterConfig $i$f$thisLogger22 = indexWriterConfig = new IndexWriterConfig((Analyzer)new CodeAnalyzer(null, 1, null));
        Bm25IndexerServiceImpl bm25IndexerServiceImpl = this;
        boolean bl2 = false;
        config22.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
        config22.setSimilarity((Similarity)new BM25Similarity());
        bm25IndexerServiceImpl.iwc = indexWriterConfig;
        this.indexingDurationInMillisHistogram = new Histogram(10000L, 1);
        this.histogramLock = new Object();
        this.unindexChannel = ChannelKt.Channel$default((int)Integer.MAX_VALUE, null, null, (int)6, null);
        this.hasUncommittedChanges = new AtomicBoolean();
        Bm25IndexerServiceImpl bm25IndexerServiceImpl2 = this;
        if (enabled) {
            boolean bl3;
            bm25IndexerServiceImpl = bm25IndexerServiceImpl2;
            try {
                bm25IndexerServiceImpl2 = bm25IndexerServiceImpl;
                this.initialize(this.scope);
                bl3 = true;
            }
            catch (Exception config22) {
                void e;
                bm25IndexerServiceImpl2 = bm25IndexerServiceImpl;
                this.log.warn("Could not initialize index writer", (Throwable)e);
                bl3 = false;
            }
            bl = bl3;
        } else {
            bl = false;
        }
        bm25IndexerServiceImpl2.active = bl;
    }

    @Override
    @NotNull
    public Path getIndexDirectory() {
        return this.indexDirectory;
    }

    public Bm25IndexerServiceImpl(@NotNull CoroutineScope scope2) {
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        boolean bl = IndexerModeProvider.INSTANCE.isBm25Mode();
        CoroutineDispatcher coroutineDispatcher = Dispatchers.getIO();
        Path path2 = PathManager.getSystemDir();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getSystemDir(...)");
        Path path3 = path2;
        Path path4 = path3.resolve("caches");
        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"resolve(...)");
        path3 = path4;
        Path path5 = path3.resolve("gemini");
        Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"resolve(...)");
        path3 = path5;
        Path path6 = path3.resolve("bm25");
        Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"resolve(...)");
        this(bl, scope2, coroutineDispatcher, path6, INDEX_COMMIT_INTERVAL, null);
    }

    @Override
    public boolean getActive() {
        return this.active;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @NotNull
    public final AtomicBoolean getHasUncommittedChanges() {
        return this.hasUncommittedChanges;
    }

    /*
     * WARNING - void declaration
     */
    private final void initialize(CoroutineScope scope2) {
        IndexWriter indexWriter;
        Bm25IndexerServiceImpl bm25IndexerServiceImpl;
        PathKt.createDirectories((Path)this.getIndexDirectory());
        FSDirectory fSDirectory = FSDirectory.open((Path)this.getIndexDirectory());
        Intrinsics.checkNotNullExpressionValue((Object)fSDirectory, (String)"open(...)");
        this.fsDir = fSDirectory;
        Bm25IndexerServiceImpl bm25IndexerServiceImpl2 = this;
        try {
            bm25IndexerServiceImpl = bm25IndexerServiceImpl2;
            FSDirectory fSDirectory2 = this.fsDir;
            if (fSDirectory2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"fsDir");
                fSDirectory2 = null;
            }
            indexWriter = new IndexWriter((Directory)fSDirectory2, this.iwc);
        }
        catch (LockObtainFailedException lockObtainFailedException) {
            void e;
            bm25IndexerServiceImpl = bm25IndexerServiceImpl2;
            this.log.warn("Could not obtain lock on index directory: " + e.getMessage());
            Path path2 = this.getIndexDirectory().resolve("write.lock");
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
            boolean deleted = Files.deleteIfExists(path2);
            this.log.info("Deleting write.lock, status: " + deleted);
            FSDirectory fSDirectory3 = this.fsDir;
            if (fSDirectory3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"fsDir");
                fSDirectory3 = null;
            }
            indexWriter = new IndexWriter((Directory)fSDirectory3, this.iwc);
        }
        bm25IndexerServiceImpl.indexWriter = indexWriter;
        this.indexCommitter = BuildersKt.launch$default((CoroutineScope)scope2, (CoroutineContext)((CoroutineContext)this.ioDispatcher), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Bm25IndexerServiceImpl this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$launch = (CoroutineScope)this.L$0;
lbl6:
                        // 3 sources

                        while (CoroutineScopeKt.isActive((CoroutineScope)$this$launch)) {
                            v0 = Bm25IndexerServiceImpl.access$getIndexWriter$p(this.this$0);
                            if (v0 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"indexWriter");
                                v0 = null;
                            }
                            needsToCommit = v0.hasUncommittedChanges();
                            this.this$0.getHasUncommittedChanges().set(needsToCommit != false);
                            if (needsToCommit) {
                                v1 = Bm25IndexerServiceImpl.access$getIndexWriter$p(this.this$0);
                                if (v1 == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"indexWriter");
                                    v1 = null;
                                }
                                v1.commit();
                            }
                            this.L$0 = $this$launch;
                            this.label = 1;
                            v2 = DelayKt.delay-VtjQ1oo((long)Bm25IndexerServiceImpl.access$getIndexCommitInterval$p(this.this$0), (Continuation)((Continuation)this));
                            if (v2 != var4_2) continue;
                            return var4_2;
                        }
                        break;
                    }
                    case 1: {
                        $this$launch = (CoroutineScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
                        ** GOTO lbl6
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        this.unindexCommitter = BuildersKt.launch$default((CoroutineScope)scope2, (CoroutineContext)((CoroutineContext)this.ioDispatcher), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Bm25IndexerServiceImpl this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$launch = (CoroutineScope)this.L$0;
lbl6:
                        // 2 sources

                        while (CoroutineScopeKt.isActive((CoroutineScope)$this$launch)) {
                            this.L$0 = $this$launch;
                            this.label = 1;
                            v0 = Bm25IndexerServiceImpl.access$getUnindexChannel$p(this.this$0).receive((Continuation)this);
                            ** if (v0 != var6_2) goto lbl14
lbl13:
                            // 1 sources

                            return var6_2;
lbl14:
                            // 1 sources

                            ** GOTO lbl22
                        }
                        ** GOTO lbl32
                    }
                    case 1: {
                        $this$launch = (CoroutineScope)this.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl22:
                            // 2 sources

                            var4_5 = ((Number)v0).intValue();
                        }
                        catch (ClosedReceiveChannelException e) {
                            Bm25IndexerServiceImpl.access$getLog$p(this.this$0).warn("Unindex channel closed", (Throwable)e);
                            ** GOTO lbl32
                        }
                        catch (CancellationException e) {
                            throw e;
                        }
                        fileIdToUnindex = var4_5;
                        Bm25IndexerServiceImpl.access$unindex(this.this$0, fileIdToUnindex);
                        ** GOTO lbl6
lbl32:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void index(@NotNull VirtualFile file) {
        String string;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!this.getActive()) {
            return;
        }
        Integer n = VirtualFileUtilsKt.id(file);
        if (n == null) {
            return;
        }
        int fileId = n;
        try {
            string = VirtualFileUtil.readText((VirtualFile)file);
        }
        catch (Exception e) {
            this.log.warn("Could not read file: " + file.getPath(), (Throwable)e);
            return;
        }
        String fileText2 = string;
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        this.unindex(fileId);
        Document doc = new Document();
        doc.add((IndexableField)new IntField("vfile.id", fileId, Field.Store.YES));
        doc.add((IndexableField)new TextField("vfile.name", file.getName(), Field.Store.NO));
        doc.add((IndexableField)new TextField("vfile.contents", fileText2, Field.Store.NO));
        IndexWriter indexWriter = this.indexWriter;
        if (indexWriter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"indexWriter");
            indexWriter = null;
        }
        indexWriter.addDocument((Iterable)doc);
        long millis = System.currentTimeMillis() - start$iv;
        Job job2 = this.indexCommitter;
        if (job2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"indexCommitter");
            job2 = null;
        }
        if (!job2.isActive()) {
            this.log.warn("The thread handling indexing is not active. We use pooled thread instead.");
            ApplicationManager.getApplication().executeOnPooledThread(() -> Bm25IndexerServiceImpl.index$lambda$2(this));
            return;
        }
        Object object = this.histogramLock;
        synchronized (object) {
            boolean bl2 = false;
            this.indexingDurationInMillisHistogram.recordValue(Math.min(millis, 10000L));
            Unit unit = Unit.INSTANCE;
        }
        if (millis > 2000L) {
            this.log.info("Took " + millis + " ms to index " + file.getPath());
        }
    }

    @Override
    public void unindex(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!this.getActive()) {
            return;
        }
        Integer n = VirtualFileUtilsKt.id(file);
        if (n == null) {
            return;
        }
        int fileId = n;
        Job job2 = this.unindexCommitter;
        if (job2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"unindexCommitter");
            job2 = null;
        }
        if (!job2.isActive()) {
            this.log.warn("The thread handling unindexing is not active. We use pooled thread instead.");
            ApplicationManager.getApplication().executeOnPooledThread(() -> Bm25IndexerServiceImpl.unindex$lambda$4(this, fileId));
            return;
        }
        this.unindexChannel.trySend-JP2dKIU((Object)fileId);
    }

    private final void unindex(int fileId) {
        Query docIdQuery = IntField.newExactQuery((String)"vfile.id", (int)fileId);
        IndexWriter indexWriter = this.indexWriter;
        if (indexWriter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"indexWriter");
            indexWriter = null;
        }
        Query[] queryArray = new Query[]{docIdQuery};
        indexWriter.deleteDocuments(queryArray);
    }

    public final boolean isReady$aiplugin_rag_indexer() {
        Job job2 = this.indexCommitter;
        if (job2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"indexCommitter");
            job2 = null;
        }
        return job2.isActive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public boolean isIndexed(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Integer n = VirtualFileUtilsKt.id(file);
        if (n == null) {
            return false;
        }
        int fileId = n;
        Query query = IntPoint.newExactQuery((String)"vfile.id", (int)fileId);
        Closeable closeable = (Closeable)FSDirectory.open((Path)this.getIndexDirectory());
        Throwable throwable = null;
        try {
            int n2;
            IndexSearcher searcher;
            Throwable throwable2;
            Closeable closeable2;
            block18: {
                FSDirectory fsDir = (FSDirectory)closeable;
                boolean bl = false;
                closeable2 = (Closeable)DirectoryReader.open((Directory)((Directory)fsDir));
                throwable2 = null;
                DirectoryReader reader = (DirectoryReader)closeable2;
                boolean bl2 = false;
                searcher = new IndexSearcher((IndexReader)reader);
                TopDocs matchingDoc = searcher.search(query, 1);
                if (matchingDoc.totalHits.value != 1L) {
                    this.log.warn("Searching for virtual file with id " + fileId + " from BM25 index returns " + matchingDoc.totalHits.value + " files");
                }
                Intrinsics.checkNotNullExpressionValue((Object)matchingDoc.scoreDocs, (String)"scoreDocs");
                ScoreDoc scoreDoc = (ScoreDoc)ArraysKt.firstOrNull((Object[])matchingDoc.scoreDocs);
                if (scoreDoc != null) {
                    n2 = scoreDoc.doc;
                    break block18;
                }
                boolean bl3 = false;
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                boolean bl4 = bl3;
                return bl4;
            }
            int docId = n2;
            boolean bl = Companion.getFileIdForDoc$aiplugin_rag_indexer(searcher, docId) == fileId;
            CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            boolean bl5 = bl;
            return bl5;
            {
                catch (Throwable throwable3) {
                    try {
                        try {
                            try {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            catch (Throwable throwable4) {
                                CloseableKt.closeFinally((Closeable)closeable2, throwable2);
                                throw throwable4;
                            }
                        }
                        catch (IndexNotFoundException e) {
                            this.log.warn("BM25 index is not found in " + this.getIndexDirectory() + ": " + e.getMessage());
                            boolean bl6 = false;
                            return bl6;
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    catch (Throwable throwable6) {
                        throw throwable6;
                    }
                }
            }
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public void dispose() {
        if (!this.getActive()) {
            return;
        }
        try {
            Job job2;
            IndexWriter indexWriter;
            IndexWriter indexWriter2 = this.indexWriter;
            if (indexWriter2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"indexWriter");
                indexWriter2 = null;
            }
            if (indexWriter2.hasUncommittedChanges()) {
                IndexWriter indexWriter3 = this.indexWriter;
                if (indexWriter3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"indexWriter");
                    indexWriter3 = null;
                }
                indexWriter3.commit();
            }
            if ((indexWriter = this.indexWriter) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"indexWriter");
                indexWriter = null;
            }
            indexWriter.close();
            FSDirectory fSDirectory = this.fsDir;
            if (fSDirectory == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"fsDir");
                fSDirectory = null;
            }
            fSDirectory.close();
            Job job3 = this.indexCommitter;
            if (job3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"indexCommitter");
                job3 = null;
            }
            if (job3.isActive()) {
                Job job4 = this.indexCommitter;
                if (job4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"indexCommitter");
                    job4 = null;
                }
                Job.DefaultImpls.cancel$default((Job)job4, null, (int)1, null);
            }
            if ((job2 = this.unindexCommitter) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"unindexCommitter");
                job2 = null;
            }
            if (job2.isActive()) {
                Job job5 = this.unindexCommitter;
                if (job5 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"unindexCommitter");
                    job5 = null;
                }
                Job.DefaultImpls.cancel$default((Job)job5, null, (int)1, null);
            }
        }
        catch (IOException e) {
            this.log.error("Error closing index writer", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dumpStats$aiplugin_rag_indexer() {
        if (!this.getActive()) {
            this.log.info("Index not initialized");
            return;
        }
        IndexWriter indexWriter = this.indexWriter;
        if (indexWriter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"indexWriter");
            indexWriter = null;
        }
        this.log.info("Total # of docs: " + indexWriter.getDocStats().numDocs);
        Object object = this.histogramLock;
        synchronized (object) {
            boolean bl = false;
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            Closeable closeable = new PrintStream((OutputStream)outputStream, true, StandardCharsets.UTF_8);
            Throwable throwable = null;
            try {
                PrintStream it = (PrintStream)closeable;
                boolean bl2 = false;
                this.indexingDurationInMillisHistogram.outputPercentileDistribution(it, Double.valueOf(1.0));
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            this.log.info("\n" + outputStream);
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    @NotNull
    public Bm25SearchTool searchTool() {
        return Bm25IndexerService.super.searchTool();
    }

    private static final void index$lambda$2(Bm25IndexerServiceImpl this$0) {
        IndexWriter indexWriter = this$0.indexWriter;
        if (indexWriter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"indexWriter");
            indexWriter = null;
        }
        indexWriter.commit();
    }

    private static final void unindex$lambda$4(Bm25IndexerServiceImpl this$0, int $fileId) {
        this$0.unindex($fileId);
    }

    public /* synthetic */ Bm25IndexerServiceImpl(boolean enabled, CoroutineScope scope2, CoroutineDispatcher ioDispatcher, Path indexDirectory, long indexCommitInterval, DefaultConstructorMarker $constructor_marker) {
        this(enabled, scope2, ioDispatcher, indexDirectory, indexCommitInterval);
    }

    public static final /* synthetic */ IndexWriter access$getIndexWriter$p(Bm25IndexerServiceImpl $this) {
        return $this.indexWriter;
    }

    public static final /* synthetic */ long access$getIndexCommitInterval$p(Bm25IndexerServiceImpl $this) {
        return $this.indexCommitInterval;
    }

    public static final /* synthetic */ Channel access$getUnindexChannel$p(Bm25IndexerServiceImpl $this) {
        return $this.unindexChannel;
    }

    public static final /* synthetic */ Logger access$getLog$p(Bm25IndexerServiceImpl $this) {
        return $this.log;
    }

    public static final /* synthetic */ void access$unindex(Bm25IndexerServiceImpl $this, int fileId) {
        $this.unindex(fileId);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0019\u0010\t\u001a\u00020\n*\u00020\u000b2\u0006\u0010\f\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\rR\u0010\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/google/aiplugin/rag/bm25/Bm25IndexerServiceImpl$Companion;", "", "<init>", "()V", "INDEX_COMMIT_INTERVAL", "Lkotlin/time/Duration;", "J", "MAX_MEASURED_LATENCY_MS", "", "getFileIdForDoc", "", "Lorg/apache/lucene/search/IndexSearcher;", "docId", "getFileIdForDoc$aiplugin_rag_indexer", "aiplugin.rag.indexer"})
    public static final class Companion {
        private Companion() {
        }

        public final int getFileIdForDoc$aiplugin_rag_indexer(@NotNull IndexSearcher $this$getFileIdForDoc, int docId) {
            Intrinsics.checkNotNullParameter((Object)$this$getFileIdForDoc, (String)"<this>");
            return $this$getFileIdForDoc.storedFields().document(docId).getField("vfile.id").numericValue().intValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

