/*
 * Decompiled with CFR 0.152.
 */
package com.google.aiplugin.mcp.config;

import androidx.compose.runtime.internal.StabilityInferred;
import com.google.aiplugin.mcp.config.GlobalMcpServerRegistry;
import com.google.aiplugin.mcp.config.HttpSSEMcpServerConfig;
import com.google.aiplugin.mcp.config.LocalMcpServerConfig;
import com.google.aiplugin.mcp.config.McpServerConfig;
import com.google.aiplugin.mcp.config.StreamableHttpMcpServerConfig;
import com.google.aiplugin.mcp.config.UnknownMcpServerConfig;
import com.intellij.openapi.diagnostic.Logger;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.JsonContentPolymorphicSerializer;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c1\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014\u00a8\u0006\t"}, d2={"Lcom/google/aiplugin/mcp/config/McpServerConfigPolymorphicSerializer;", "Lkotlinx/serialization/json/JsonContentPolymorphicSerializer;", "Lcom/google/aiplugin/mcp/config/McpServerConfig;", "<init>", "()V", "selectDeserializer", "Lkotlinx/serialization/DeserializationStrategy;", "element", "Lkotlinx/serialization/json/JsonElement;", "aiplugin.mcp.client.sdkcompat"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nGlobalMcpServerRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GlobalMcpServerRegistry.kt\ncom/google/aiplugin/mcp/config/McpServerConfigPolymorphicSerializer\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,176:1\n15#2:177\n*S KotlinDebug\n*F\n+ 1 GlobalMcpServerRegistry.kt\ncom/google/aiplugin/mcp/config/McpServerConfigPolymorphicSerializer\n*L\n169#1:177\n*E\n"})
public final class McpServerConfigPolymorphicSerializer
extends JsonContentPolymorphicSerializer<McpServerConfig> {
    @NotNull
    public static final McpServerConfigPolymorphicSerializer INSTANCE = new McpServerConfigPolymorphicSerializer();
    public static final int $stable = 8;

    private McpServerConfigPolymorphicSerializer() {
        super(Reflection.getOrCreateKotlinClass(McpServerConfig.class));
    }

    @NotNull
    protected DeserializationStrategy<McpServerConfig> selectDeserializer(@NotNull JsonElement element) {
        DeserializationStrategy deserializationStrategy;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        JsonObject jsonObject = JsonElementKt.getJsonObject((JsonElement)element);
        if (((Map)jsonObject).containsKey("command")) {
            deserializationStrategy = (DeserializationStrategy)LocalMcpServerConfig.Companion.serializer();
        } else if (((Map)jsonObject).containsKey("url")) {
            deserializationStrategy = (DeserializationStrategy)HttpSSEMcpServerConfig.Companion.serializer();
        } else if (((Map)jsonObject).containsKey("httpUrl")) {
            deserializationStrategy = (DeserializationStrategy)StreamableHttpMcpServerConfig.Companion.serializer();
        } else {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(GlobalMcpServerRegistry.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Could not parse MCP server configuration: " + jsonObject);
            deserializationStrategy = (DeserializationStrategy)UnknownMcpServerConfig.INSTANCE.serializer();
        }
        return deserializationStrategy;
    }
}

