/*
 * Decompiled with CFR 0.152.
 */
package com.google.aiplugin.agents.tools.write;

import com.google.aiplugin.agents.Response;
import com.google.aiplugin.agents.Tool;
import com.google.aiplugin.agents.tools.ToolArgument;
import com.google.aiplugin.agents.tools.ToolContext;
import com.google.aiplugin.agents.tools.ToolDescription;
import com.google.aiplugin.agents.tools.ToolResult;
import com.google.aiplugin.agents.tools.write.ActiveWriteFileHandler;
import com.google.aiplugin.agents.tools.write.RestoredWriteFileHandler;
import com.google.aiplugin.agents.tools.write.WriteFileHandler;
import com.google.aiplugin.agents.tools.write.WriteFileToolArgs;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFileSystem;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KParameter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ToolDescription(summary="Writes the given text to the specified file, creating the file if it doesn't exist", instructions="Use this tool to modify the entire contents of a file using an absolute path. Use replace_text instead for smaller or more targeted changes. Files can only be created if they reside within the project.", examples={})
@ToolResult(description="Returns one of these responses:\n- \"file was written\" if the file was successfully updated\n- error \"could not create file\" if the file didn't exist and it could not be created \n- error \"file not in project\" if the file is not part of the project\n- error \"file blocked by aiexclude\" if the file is blocked by a .aiexclude file in the project")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J \u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/google/aiplugin/agents/tools/write/WriteFileTool;", "Lcom/google/aiplugin/agents/Tool;", "Lcom/google/aiplugin/agents/tools/write/WriteFileToolArgs;", "fileSystem", "Lcom/intellij/openapi/vfs/VirtualFileSystem;", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFileSystem;)V", "name", "", "getName", "()Ljava/lang/String;", "createHandler", "Lcom/google/aiplugin/agents/tools/write/WriteFileHandler;", "context", "Lcom/google/aiplugin/agents/tools/ToolContext;", "args", "restoreHandler", "project", "Lcom/intellij/openapi/project/Project;", "response", "Lcom/google/aiplugin/agents/Response;", "aiplugin.agents.agents-core"})
public final class WriteFileTool
implements Tool<WriteFileToolArgs> {
    @NotNull
    private final VirtualFileSystem fileSystem;
    @NotNull
    private final String name;

    public WriteFileTool(@NotNull VirtualFileSystem fileSystem) {
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        this.fileSystem = fileSystem;
        this.name = "write_file";
    }

    public /* synthetic */ WriteFileTool(VirtualFileSystem virtualFileSystem, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)localFileSystem, (String)"getInstance(...)");
            virtualFileSystem = (VirtualFileSystem)localFileSystem;
        }
        this(virtualFileSystem);
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public WriteFileHandler createHandler(@NotNull ToolContext context2, @NotNull WriteFileToolArgs args) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return new ActiveWriteFileHandler(this, context2, this.fileSystem, args);
    }

    @NotNull
    public WriteFileHandler restoreHandler(@NotNull Project project2, @NotNull WriteFileToolArgs args, @NotNull Response response2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        return new RestoredWriteFileHandler(this, project2, args, response2);
    }

    @Override
    @NotNull
    public String getDescription() {
        return Tool.super.getDescription();
    }

    @Override
    @NotNull
    public String getDisplayText(@NotNull WriteFileToolArgs args) {
        return Tool.super.getDisplayText(args);
    }

    @Override
    @Nullable
    public String getStatusMessage() {
        return Tool.super.getStatusMessage();
    }

    @Override
    @NotNull
    public ToolDescription getToolDescription() {
        return Tool.super.getToolDescription();
    }

    @Override
    @Nullable
    public ToolResult getToolResult() {
        return Tool.super.getToolResult();
    }

    @Override
    @Nullable
    public Map<KParameter, ToolArgument> getToolArguments() {
        return Tool.super.getToolArguments();
    }

    public WriteFileTool() {
        this(null, 1, null);
    }
}

