/*
 * Decompiled with CFR 0.152.
 */
package com.google.aiplugin.agents.tools.write;

import com.google.aiplugin.agents.Response;
import com.google.aiplugin.agents.Tool;
import com.google.aiplugin.agents.tools.ToolArgument;
import com.google.aiplugin.agents.tools.ToolContext;
import com.google.aiplugin.agents.tools.ToolDescription;
import com.google.aiplugin.agents.tools.ToolResult;
import com.google.aiplugin.agents.tools.write.ActiveReplaceTextHandler;
import com.google.aiplugin.agents.tools.write.ReplaceTextArgs;
import com.google.aiplugin.agents.tools.write.ReplaceTextHandler;
import com.google.aiplugin.agents.tools.write.RestoredReplaceTextHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFileSystem;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KParameter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ToolDescription(summary="Replaces specific text occurrences in a file with new text", instructions="Use this tool to make targeted changes without replacing the entire file content. Use this method if the file is large and the change is smaller than the old text. Prioritize this tool among other editing tools. It's more efficient and granular in the most of cases.\nNEVER escape `oldText` or `newText`, that would break the exact literal text requirement.\n\nIf you intend to only replace one instance of the text in the file, you must include at least 3 lines of context BEFORE and AFTER the target text, matching whitespace and indentation precisely. If this string matches multiple locations, or does not match exactly, the tool will not work correctly. If you intend to replace multiple instances of the same text in the file, this context may not be necessary.\n\nNote: This tool automatically saves the file after modification.", examples={})
@ToolResult(description="Returns one of these responses:\n- \"file was written\" when replacement happened\n- error \"file not found\" if the file doesn't exist\n- error \"file not in project\" if the file is not in the project\n- error \"could not get document\" if the file content cannot be accessed\n- error \"no occurrences found\" if the old text was not found in the file\n- error \"file blocked by aiexclude\" if the file is blocked by a .aiexclude file in the project")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J\"\u0010\u0010\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/google/aiplugin/agents/tools/write/ReplaceTextTool;", "Lcom/google/aiplugin/agents/Tool;", "Lcom/google/aiplugin/agents/tools/write/ReplaceTextArgs;", "fileSystem", "Lcom/intellij/openapi/vfs/VirtualFileSystem;", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFileSystem;)V", "name", "", "getName", "()Ljava/lang/String;", "createHandler", "Lcom/google/aiplugin/agents/tools/write/ReplaceTextHandler;", "context", "Lcom/google/aiplugin/agents/tools/ToolContext;", "args", "restoreHandler", "project", "Lcom/intellij/openapi/project/Project;", "response", "Lcom/google/aiplugin/agents/Response;", "aiplugin.agents.agents-core"})
public final class ReplaceTextTool
implements Tool<ReplaceTextArgs> {
    @NotNull
    private final VirtualFileSystem fileSystem;
    @NotNull
    private final String name;

    public ReplaceTextTool(@NotNull VirtualFileSystem fileSystem) {
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        this.fileSystem = fileSystem;
        this.name = "replace_text";
    }

    public /* synthetic */ ReplaceTextTool(VirtualFileSystem virtualFileSystem, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)localFileSystem, (String)"getInstance(...)");
            virtualFileSystem = (VirtualFileSystem)localFileSystem;
        }
        this(virtualFileSystem);
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public ReplaceTextHandler createHandler(@NotNull ToolContext context2, @NotNull ReplaceTextArgs args) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return new ActiveReplaceTextHandler(this, context2, this.fileSystem, args);
    }

    @Nullable
    public ReplaceTextHandler restoreHandler(@NotNull Project project2, @NotNull ReplaceTextArgs args, @NotNull Response response2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        return new RestoredReplaceTextHandler(this, project2, args, response2);
    }

    @Override
    @NotNull
    public String getDescription() {
        return Tool.super.getDescription();
    }

    @Override
    @NotNull
    public String getDisplayText(@NotNull ReplaceTextArgs args) {
        return Tool.super.getDisplayText(args);
    }

    @Override
    @Nullable
    public String getStatusMessage() {
        return Tool.super.getStatusMessage();
    }

    @Override
    @NotNull
    public ToolDescription getToolDescription() {
        return Tool.super.getToolDescription();
    }

    @Override
    @Nullable
    public ToolResult getToolResult() {
        return Tool.super.getToolResult();
    }

    @Override
    @Nullable
    public Map<KParameter, ToolArgument> getToolArguments() {
        return Tool.super.getToolArguments();
    }

    public ReplaceTextTool() {
        this(null, 1, null);
    }
}

