/*
 * Decompiled with CFR 0.152.
 */
package com.google.aiplugin.agents.tools.search;

import com.android.tools.idea.studiobot.AiExcludeService;
import com.google.aiplugin.agents.Response;
import com.google.aiplugin.agents.ToolHandler;
import com.google.aiplugin.agents.tools.ToolContext;
import com.google.aiplugin.agents.tools.search.ListFilesToolArgs;
import com.google.aiplugin.agents.tools.search.ListFilesToolHandler;
import com.google.gson.Gson;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u000e\u001a\u00020\u000fH\u0096@\u00a2\u0006\u0002\u0010\u0010J\u0016\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0016"}, d2={"Lcom/google/aiplugin/agents/tools/search/ListFilesToolHandler;", "Lcom/google/aiplugin/agents/ToolHandler;", "context", "Lcom/google/aiplugin/agents/tools/ToolContext;", "fileSystem", "Lcom/intellij/openapi/vfs/VirtualFileSystem;", "args", "Lcom/google/aiplugin/agents/tools/search/ListFilesToolArgs;", "<init>", "(Lcom/google/aiplugin/agents/tools/ToolContext;Lcom/intellij/openapi/vfs/VirtualFileSystem;Lcom/google/aiplugin/agents/tools/search/ListFilesToolArgs;)V", "getContext", "()Lcom/google/aiplugin/agents/tools/ToolContext;", "getArgs", "()Lcom/google/aiplugin/agents/tools/search/ListFilesToolArgs;", "handle", "Lcom/google/aiplugin/agents/Response;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "toJson", "", "files", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "aiplugin.agents.agents-core"})
@SourceDebugExtension(value={"SMAP\nListFilesTool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ListFilesTool.kt\ncom/google/aiplugin/agents/tools/search/ListFilesToolHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,106:1\n1557#2:107\n1628#2,3:108\n*S KotlinDebug\n*F\n+ 1 ListFilesTool.kt\ncom/google/aiplugin/agents/tools/search/ListFilesToolHandler\n*L\n103#1:107\n103#1:108,3\n*E\n"})
public final class ListFilesToolHandler
implements ToolHandler {
    @NotNull
    private final ToolContext context;
    @NotNull
    private final VirtualFileSystem fileSystem;
    @NotNull
    private final ListFilesToolArgs args;

    public ListFilesToolHandler(@NotNull ToolContext context2, @NotNull VirtualFileSystem fileSystem, @NotNull ListFilesToolArgs args) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.context = context2;
        this.fileSystem = fileSystem;
        this.args = args;
    }

    @NotNull
    public final ToolContext getContext() {
        return this.context;
    }

    @NotNull
    public final ListFilesToolArgs getArgs() {
        return this.args;
    }

    @Override
    @Nullable
    public Object handle(@NotNull Continuation<? super Response> $completion) {
        return ActionsKt.runReadAction(() -> ListFilesToolHandler.handle$lambda$1(this));
    }

    /*
     * WARNING - void declaration
     */
    private final String toJson(List<? extends VirtualFile> files) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = files;
        Gson gson = new Gson();
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VirtualFile virtualFile2 = (VirtualFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000!\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0002*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u0010\u0010\r\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\nJ$\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u0010\u001a\u00020\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\u0004\u0010\n\u00a8\u0006\u0015"}, d2={"com/google/aiplugin/agents/tools/search/ListFilesToolHandler$toJson$FilePath", "", "name", "", "isDirectory", "", "<init>", "(Ljava/lang/String;Ljava/lang/Boolean;)V", "getName", "()Ljava/lang/String;", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "component1", "component2", "copy", "(Ljava/lang/String;Ljava/lang/Boolean;)Lcom/google/aiplugin/agents/tools/search/ListFilesToolHandler$toJson$FilePath;", "equals", "other", "hashCode", "", "toString", "aiplugin.agents.agents-core"})
            public final class FilePath {
                private final String name;
                private final Boolean isDirectory;

                public FilePath(String name, Boolean isDirectory) {
                    Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                    this.name = name;
                    this.isDirectory = isDirectory;
                }

                public final String getName() {
                    return this.name;
                }

                public final Boolean isDirectory() {
                    return this.isDirectory;
                }

                public final String component1() {
                    return this.name;
                }

                public final Boolean component2() {
                    return this.isDirectory;
                }

                public final FilePath copy(String name, Boolean isDirectory) {
                    Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                    return new FilePath(name, isDirectory);
                }

                public static /* synthetic */ FilePath copy$default(FilePath filePath, String string, Boolean bl, int n, Object object) {
                    if ((n & 1) != 0) {
                        string = filePath.name;
                    }
                    if ((n & 2) != 0) {
                        bl = filePath.isDirectory;
                    }
                    return filePath.copy(string, bl);
                }

                public String toString() {
                    return "FilePath(name=" + this.name + ", isDirectory=" + this.isDirectory + ")";
                }

                public int hashCode() {
                    int result2 = this.name.hashCode();
                    result2 = result2 * 31 + (this.isDirectory == null ? 0 : ((Object)this.isDirectory).hashCode());
                    return result2;
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof FilePath)) {
                        return false;
                    }
                    FilePath filePath = (FilePath)other;
                    if (!Intrinsics.areEqual((Object)this.name, (Object)filePath.name)) {
                        return false;
                    }
                    return Intrinsics.areEqual((Object)this.isDirectory, (Object)filePath.isDirectory);
                }
            }
            collection.add(new FilePath(string, it.isDirectory() ? Boolean.valueOf(true) : null));
        }
        String string = gson.toJson((Object)((List)destination$iv$iv));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
        return string;
    }

    private static final boolean handle$lambda$1$lambda$0(AiExcludeService $aiExcludeService, VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !$aiExcludeService.isFileExcluded(it);
    }

    private static final Response handle$lambda$1(ListFilesToolHandler this$0) {
        Project project2 = this$0.context.getProject();
        try {
            VirtualFile virtualFile2 = this$0.fileSystem.findFileByPath(this$0.args.getAbsolutePath());
            if (virtualFile2 == null) {
                return new Response(null, "directory not found", null, 5, null);
            }
            VirtualFile targetDir = virtualFile2;
            if (!GlobalSearchScope.allScope((Project)project2).contains(targetDir)) {
                return new Response(null, "directory not in project", null, 5, null);
            }
            if (!targetDir.exists()) {
                return new Response(null, "directory not found", null, 5, null);
            }
            if (!targetDir.isDirectory()) {
                return new Response(null, targetDir + " is not a directory", null, 5, null);
            }
            AiExcludeService aiExcludeService2 = AiExcludeService.Companion.getInstance(project2);
            if (aiExcludeService2.isFileExcluded(targetDir)) {
                return new Response(null, "directory blocked by aiexclude", null, 5, null);
            }
            List list = VfsUtil.getChildren((VirtualFile)targetDir, arg_0 -> ListFilesToolHandler.handle$lambda$1$lambda$0(aiExcludeService2, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildren(...)");
            List children = list;
            if (children.isEmpty()) {
                return new Response(null, "directory is empty", null, 5, null);
            }
            return new Response(this$0.toJson(children), null, null, 6, null);
        }
        catch (Exception e) {
            return new Response(null, "Error listing directory: " + e.getMessage(), null, 5, null);
        }
    }
}

