/*
 * Decompiled with CFR 0.152.
 */
package com.google.aiplugin.agents.tools.search;

import com.android.tools.idea.studiobot.AiExcludeService;
import com.google.aiplugin.agents.Response;
import com.google.aiplugin.agents.ToolHandler;
import com.google.aiplugin.agents.tools.ToolContext;
import com.google.aiplugin.agents.tools.search.FindModelCreator;
import com.google.aiplugin.agents.tools.search.GrepToolArgs;
import com.google.aiplugin.agents.tools.search.GrepToolResult;
import com.google.gson.Gson;
import com.intellij.find.FindModel;
import com.intellij.find.impl.FindInProjectUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiFileRange;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.FindUsagesProcessPresentation;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.Processor;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u0012\u001a\u00020\u0013H\u0096@\u00a2\u0006\u0002\u0010\u0014J\f\u0010\u0015\u001a\u00020\u0016*\u00020\u0017H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010\u00a8\u0006\u0018"}, d2={"Lcom/google/aiplugin/agents/tools/search/GrepFilesToolHandler;", "Lcom/google/aiplugin/agents/ToolHandler;", "context", "Lcom/google/aiplugin/agents/tools/ToolContext;", "args", "Lcom/google/aiplugin/agents/tools/search/GrepToolArgs;", "maxResults", "", "maxSnippetLength", "<init>", "(Lcom/google/aiplugin/agents/tools/ToolContext;Lcom/google/aiplugin/agents/tools/search/GrepToolArgs;II)V", "getContext", "()Lcom/google/aiplugin/agents/tools/ToolContext;", "getArgs", "()Lcom/google/aiplugin/agents/tools/search/GrepToolArgs;", "getMaxResults", "()I", "getMaxSnippetLength", "handle", "Lcom/google/aiplugin/agents/Response;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "matchingText", "", "Lcom/intellij/usageView/UsageInfo;", "aiplugin.agents.agents-core"})
public final class GrepFilesToolHandler
implements ToolHandler {
    @NotNull
    private final ToolContext context;
    @NotNull
    private final GrepToolArgs args;
    private final int maxResults;
    private final int maxSnippetLength;

    public GrepFilesToolHandler(@NotNull ToolContext context2, @NotNull GrepToolArgs args, int maxResults, int maxSnippetLength) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.context = context2;
        this.args = args;
        this.maxResults = maxResults;
        this.maxSnippetLength = maxSnippetLength;
    }

    @NotNull
    public final ToolContext getContext() {
        return this.context;
    }

    @NotNull
    public final GrepToolArgs getArgs() {
        return this.args;
    }

    public final int getMaxResults() {
        return this.maxResults;
    }

    public final int getMaxSnippetLength() {
        return this.maxSnippetLength;
    }

    @Override
    @Nullable
    public Object handle(@NotNull Continuation<? super Response> $completion) {
        String pattern = this.args.getPattern();
        if (StringsKt.isBlank((CharSequence)pattern)) {
            return new Response(null, "pattern parameter is required and cannot be blank", null, 5, null);
        }
        FindModel findModel = FindModelCreator.getFindModel(this.context, pattern);
        ConcurrentHashMap.KeySetView keySetView = ConcurrentHashMap.newKeySet();
        Intrinsics.checkNotNullExpressionValue(keySetView, (String)"newKeySet(...)");
        Set results = keySetView;
        AiExcludeService aiExcludeService2 = AiExcludeService.Companion.getInstance(this.context.getProject());
        Processor processor = arg_0 -> GrepFilesToolHandler.handle$lambda$0(aiExcludeService2, results, this, arg_0);
        FindInProjectUtil.findUsages((FindModel)findModel, (Project)this.context.getProject(), (Processor)processor, (FindUsagesProcessPresentation)new FindUsagesProcessPresentation(new UsageViewPresentation()));
        return new Response(new Gson().toJson((Object)results), null, null, 6, null);
    }

    private final String matchingText(UsageInfo $this$matchingText) {
        SmartPsiFileRange smartPsiFileRange = $this$matchingText.getPsiFileRange();
        if (smartPsiFileRange == null) {
            return "";
        }
        SmartPsiFileRange range = smartPsiFileRange;
        Segment segment = $this$matchingText.getPsiFileRange().getRange();
        if (segment == null) {
            return "";
        }
        Segment segment2 = segment;
        PsiFile psiFile2 = (PsiFile)range.getElement();
        if (psiFile2 == null || (psiFile2 = psiFile2.getFileDocument()) == null) {
            return "";
        }
        PsiFile doc = psiFile2;
        int start2 = doc.getLineStartOffset(doc.getLineNumber(segment2.getStartOffset()));
        int end = doc.getLineEndOffset(doc.getLineNumber(segment2.getEndOffset()));
        String string = doc.getText(new TextRange(start2, end));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    private static final boolean handle$lambda$0(AiExcludeService $aiExcludeService, Set $results, GrepFilesToolHandler this$0, UsageInfo usageInfo) {
        VirtualFile virtualFile2 = usageInfo.getVirtualFile();
        if (virtualFile2 == null) {
            return true;
        }
        VirtualFile virtualFile3 = virtualFile2;
        if ($aiExcludeService.isFileExcluded(virtualFile3)) {
            return true;
        }
        String string = virtualFile3.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        Intrinsics.checkNotNull((Object)usageInfo);
        $results.add(new GrepToolResult(string, StringsKt.take((String)this$0.matchingText(usageInfo), (int)this$0.maxSnippetLength)));
        return $results.size() < this$0.maxResults;
    }
}

