/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.templates.settings;

import com.android.studio.ml.SmlBundle;
import com.android.studio.ml.bot.StudioBotFlags;
import com.android.studio.ml.templates.PromptTemplate;
import com.android.studio.ml.templates.PromptTemplateImpl;
import com.android.studio.ml.templates.PromptTemplateScheme;
import com.android.studio.ml.templates.PromptTemplatesManager;
import com.android.studio.ml.templates.Templates;
import com.android.studio.ml.templates.ValidationError;
import com.android.studio.ml.templates.settings.PromptTemplatesSettingsComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableProvider;
import com.intellij.openapi.options.ConfigurableWithId;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import kotlin.Triple;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PromptTemplatesConfigurable
extends ConfigurableProvider
implements ConfigurableWithId,
Configurable.VariableProjectAppLevel {
    private static final Dimension DEFAULT_PREFERRED_SIZE = new Dimension(100, 100);
    private static final Dimension STANDALONE_PREFERRED_SIZE = new Dimension(800, 600);
    private final Project project;
    private Disposable myDisposable;
    private PromptTemplatesSettingsComponent mySettingsComponent;
    private boolean addSinglePromptMode;
    private Dimension preferredSize = DEFAULT_PREFERRED_SIZE;

    public PromptTemplatesConfigurable(Project project2) {
        this.project = project2;
    }

    public static void addPromptAndOpenForEdit(Project project2, String text2) {
        ShowSettingsUtil util = ShowSettingsUtil.getInstance();
        PromptTemplatesConfigurable configurable = new PromptTemplatesConfigurable(project2);
        configurable.addSinglePromptMode = true;
        configurable.preferredSize = STANDALONE_PREFERRED_SIZE;
        util.editConfigurable(project2, (Configurable)configurable, () -> configurable.mySettingsComponent.addNewFromTimeline(text2));
    }

    public static void openForEdit(Project project2) {
        PromptTemplatesConfigurable configurable = new PromptTemplatesConfigurable(project2);
        configurable.preferredSize = STANDALONE_PREFERRED_SIZE;
        ShowSettingsUtil.getInstance().editConfigurable(project2, (Configurable)configurable);
    }

    @Nullable
    public Configurable createConfigurable() {
        return this.canCreateConfigurable() ? this : null;
    }

    public boolean canCreateConfigurable() {
        return StudioBotFlags.Companion.getInstance().isPromptLibraryEnabled();
    }

    public String getDisplayName() {
        return this.addSinglePromptMode ? SmlBundle.message("sml.studiobot.settings.prompt.templates.add.new", new Object[0]) : SmlBundle.message("sml.studiobot.settings.prompt.templates.display.name", new Object[0]);
    }

    @Nullable
    public JComponent createComponent() {
        this.myDisposable = Disposer.newDisposable();
        this.mySettingsComponent = new PromptTemplatesSettingsComponent(this.project, this.myDisposable, this.addSinglePromptMode);
        JComponent mainPanel = this.mySettingsComponent.getPanel();
        mainPanel.setPreferredSize(this.preferredSize);
        return mainPanel;
    }

    @NotNull
    @NonNls
    public String getId() {
        return "prompt.templates.configurable";
    }

    public boolean isProjectLevel() {
        return this.project != null && !this.project.isDefault();
    }

    public boolean isModified() {
        if (this.mySettingsComponent == null) {
            return false;
        }
        Templates persistedState = PromptTemplatesManager.getInstance(this.project).loadState();
        PromptTemplatesSettingsComponent.SettingsUIState uiState = this.mySettingsComponent.getState();
        return uiState.newPrompt() != null || !Objects.equals(uiState.templates(), persistedState);
    }

    public void apply() throws ConfigurationException {
        PromptTemplatesSettingsComponent.SettingsUIState uiState = this.mySettingsComponent.getState();
        this.validate(uiState);
        Templates templates = uiState.templates();
        if (uiState.newPrompt() != null) {
            templates = templates.copy();
            templates.add(uiState.newPromptScheme(), uiState.newPrompt());
        }
        PromptTemplatesManager.getInstance(this.project).saveState(templates);
    }

    public void reset() {
        Templates persistedState = PromptTemplatesManager.getInstance(this.project).loadState();
        this.mySettingsComponent.reset(persistedState);
    }

    public void disposeUIResources() {
        if (this.myDisposable != null) {
            Disposer.dispose((Disposable)this.myDisposable);
        }
        this.myDisposable = null;
        this.mySettingsComponent = null;
    }

    private void validate(PromptTemplatesSettingsComponent.SettingsUIState updatedState) throws ConfigurationException {
        ArrayList<Triple<PromptTemplate, PromptTemplateScheme, ValidationError>> invalidTemplates = new ArrayList<Triple<PromptTemplate, PromptTemplateScheme, ValidationError>>();
        PromptTemplatesManager manager = PromptTemplatesManager.getInstance(this.project);
        if (updatedState.newPrompt() != null) {
            PromptTemplateScheme scheme = updatedState.newPromptScheme();
            List<PromptTemplateImpl> existingTemplates = updatedState.templates().getTemplates(scheme);
            invalidTemplates.addAll(manager.validate(List.of(updatedState.newPrompt()), existingTemplates, scheme));
        } else {
            for (PromptTemplateScheme scheme : PromptTemplateScheme.getEntries()) {
                List<PromptTemplateImpl> templates = updatedState.templates().getTemplates(scheme);
                invalidTemplates.addAll(PromptTemplatesManager.getInstance(this.project).validate(templates, List.of(), scheme));
            }
        }
        if (!invalidTemplates.isEmpty()) {
            PromptTemplateScheme scheme;
            PromptTemplate itemWithError = (PromptTemplate)((Triple)invalidTemplates.get(invalidTemplates.size() - 1)).getFirst();
            scheme = (PromptTemplateScheme)((Object)((Triple)invalidTemplates.get(invalidTemplates.size() - 1)).getSecond());
            ValidationError reason = (ValidationError)((Object)((Triple)invalidTemplates.get(invalidTemplates.size() - 1)).getThird());
            String errorString = switch (reason) {
                default -> throw new IncompatibleClassChangeError();
                case ValidationError.EmptyName -> SmlBundle.message("sml.studiobot.settings.prompt.templates.error.empty.name", new Object[0]);
                case ValidationError.EmptyPrompt -> SmlBundle.message("sml.studiobot.settings.prompt.templates.error.empty.prompt", new Object[0]);
                case ValidationError.NameTooLong -> SmlBundle.message("sml.studiobot.settings.prompt.templates.error.name.too.long", new Object[0]);
                case ValidationError.DuplicateName -> SmlBundle.message("sml.studiobot.settings.prompt.templates.error.duplicate.name", itemWithError.getName());
            };
            this.mySettingsComponent.focusOnFieldWithError(scheme, itemWithError, reason);
            throw new ConfigurationException(errorString);
        }
    }
}

