/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.templates.modelproviders.providerinfo;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.ActiveOnboardingProvider;
import com.android.studio.ml.Authenticator;
import com.android.studio.ml.SmlBundle;
import com.android.studio.ml.bot.StudioBotFlags;
import com.android.studio.ml.bot.configuration.UserAccountPanel;
import com.android.studio.ml.bot.ui.onboarding.OnboardingState;
import com.android.studio.ml.templates.modelproviders.data.ProviderData;
import com.android.studio.ml.templates.modelproviders.data.ProviderDetails;
import com.android.studio.ml.templates.modelproviders.data.ProviderType;
import com.android.studio.ml.templates.modelproviders.providerinfo.GeminiProviderInfoPanel;
import com.android.studio.ml.templates.modelproviders.providerinfo.ModelInformationTablePanel;
import com.android.studio.ml.templates.modelproviders.providerinfo.ModelProviderInfoConfiguration;
import com.android.studio.ml.util.CoroutineScopesKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.observable.properties.AtomicBooleanProperty;
import com.intellij.openapi.observable.properties.ObservableProperty;
import com.intellij.openapi.observable.util.PropertyOperationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBPasswordField;
import com.intellij.ui.dsl.builder.BottomGap;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.TextFieldKt;
import com.intellij.ui.dsl.builder.TopGap;
import com.intellij.ui.table.TableView;
import com.intellij.util.ui.ListTableModel;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0002\u0012\u001b\b\u0007\u0018\u00002\u00020\u0001B1\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010*\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020,H\u0016J\b\u0010-\u001a\u00020.H\u0002J\b\u0010/\u001a\u00020.H\u0002J\u0010\u00100\u001a\u00020.2\u0006\u00101\u001a\u000202H\u0016J\b\u00103\u001a\u00020.H\u0016R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010$\u001a\u00020%8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b(\u0010)\u001a\u0004\b&\u0010'\u00a8\u00064"}, d2={"Lcom/android/studio/ml/templates/modelproviders/providerinfo/GeminiProviderInfoPanel;", "Lcom/android/studio/ml/templates/modelproviders/providerinfo/ModelProviderInfoConfiguration;", "linkTable", "Lcom/intellij/ui/table/TableView;", "Lcom/android/studio/ml/templates/modelproviders/data/ProviderDetails;", "modelProviders", "Lcom/intellij/util/ui/ListTableModel;", "project", "Lcom/intellij/openapi/project/Project;", "disposable", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/ui/table/TableView;Lcom/intellij/util/ui/ListTableModel;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;)V", "areSettingsAvailable", "Lcom/intellij/openapi/observable/properties/ObservableProperty;", "", "authenticator", "Lcom/android/studio/ml/Authenticator;", "enterKeyListener", "com/android/studio/ml/templates/modelproviders/providerinfo/GeminiProviderInfoPanel$enterKeyListener$1", "Lcom/android/studio/ml/templates/modelproviders/providerinfo/GeminiProviderInfoPanel$enterKeyListener$1;", "geminiApiKeyField", "Lcom/intellij/ui/components/JBPasswordField;", "isAuthorized", "Lcom/intellij/openapi/observable/properties/AtomicBooleanProperty;", "isLoggedIn", "isProviderSettingVisible", "listener", "com/android/studio/ml/templates/modelproviders/providerinfo/GeminiProviderInfoPanel$listener$1", "Lcom/android/studio/ml/templates/modelproviders/providerinfo/GeminiProviderInfoPanel$listener$1;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "modelInformationTablePanel", "Lcom/android/studio/ml/templates/modelproviders/providerinfo/ModelInformationTablePanel;", "onboardingCompleted", "onboardingState", "Lcom/android/studio/ml/bot/ui/onboarding/OnboardingState;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "getScope", "()Lkotlinx/coroutines/CoroutineScope;", "scope$delegate", "Lkotlin/Lazy;", "canHandleProviderType", "providerType", "Lcom/android/studio/ml/templates/modelproviders/data/ProviderType;", "observeAuthState", "", "observeOnboardingCompleted", "setupUi", "builder", "Lcom/intellij/ui/dsl/builder/Panel;", "update", "aiplugin.core.aicore"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nGeminiProviderInfoPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GeminiProviderInfoPanel.kt\ncom/android/studio/ml/templates/modelproviders/providerinfo/GeminiProviderInfoPanel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,187:1\n25#2:188\n31#3,2:189\n*S KotlinDebug\n*F\n+ 1 GeminiProviderInfoPanel.kt\ncom/android/studio/ml/templates/modelproviders/providerinfo/GeminiProviderInfoPanel\n*L\n62#1:188\n67#1:189,2\n*E\n"})
public final class GeminiProviderInfoPanel
extends ModelProviderInfoConfiguration {
    @NotNull
    private final Disposable disposable;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Lazy scope$delegate;
    @NotNull
    private final Authenticator authenticator;
    @NotNull
    private final OnboardingState onboardingState;
    @NotNull
    private final AtomicBooleanProperty isLoggedIn;
    @NotNull
    private final AtomicBooleanProperty isAuthorized;
    @NotNull
    private final AtomicBooleanProperty onboardingCompleted;
    @NotNull
    private final ObservableProperty<Boolean> areSettingsAvailable;
    @NotNull
    private final JBPasswordField geminiApiKeyField;
    @NotNull
    private final AtomicBooleanProperty isProviderSettingVisible;
    @NotNull
    private final enterKeyListener.1 enterKeyListener;
    @NotNull
    private final ModelInformationTablePanel modelInformationTablePanel;
    @NotNull
    private final listener.1 listener;
    public static final int $stable = 8;

    public GeminiProviderInfoPanel(@NotNull TableView<ProviderDetails> linkTable, @NotNull ListTableModel<ProviderDetails> modelProviders, @NotNull Project project2, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter(linkTable, (String)"linkTable");
        Intrinsics.checkNotNullParameter(modelProviders, (String)"modelProviders");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        super(linkTable, modelProviders);
        this.disposable = disposable;
        GeminiProviderInfoPanel $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(GeminiProviderInfoPanel.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.scope$delegate = LazyKt.lazy((Function0)((Function0)new Function0<CoroutineScope>(this){
            final /* synthetic */ GeminiProviderInfoPanel this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final CoroutineScope invoke() {
                return CoroutineScopesKt.createCoroutineScope$default(GeminiProviderInfoPanel.access$getDisposable$p(this.this$0), null, null, 3, null);
            }
        }));
        this.authenticator = Authenticator.Companion.current();
        ComponentManager $this$service$iv = (ComponentManager)project2;
        boolean $i$f$service = false;
        Class<ActiveOnboardingProvider> serviceClass$iv = ActiveOnboardingProvider.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        this.onboardingState = (OnboardingState)((ActiveOnboardingProvider)object).getOnboardingState().getValue();
        this.isLoggedIn = new AtomicBooleanProperty(this.authenticator.isLoggedIn());
        this.isAuthorized = new AtomicBooleanProperty(this.authenticator.isAuthorized());
        this.onboardingCompleted = new AtomicBooleanProperty(this.onboardingState.getCurrentState().getValue() == OnboardingState.State.ONBOARDED);
        this.areSettingsAvailable = PropertyOperationUtil.and((ObservableProperty)((ObservableProperty)this.onboardingCompleted), (ObservableProperty)((ObservableProperty)this.isAuthorized));
        this.geminiApiKeyField = new JBPasswordField();
        this.isProviderSettingVisible = new AtomicBooleanProperty(false);
        this.enterKeyListener = new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (e.getKeyCode() == 10) {
                    e.consume();
                }
            }
        };
        this.modelInformationTablePanel = new ModelInformationTablePanel((ObservableProperty)new AtomicBooleanProperty(false), null, 2, null);
        this.geminiApiKeyField.addKeyListener((KeyListener)this.enterKeyListener);
        this.listener = new DocumentAdapter(this){
            final /* synthetic */ GeminiProviderInfoPanel this$0;
            {
                this.this$0 = $receiver;
            }

            protected void textChanged(DocumentEvent e) {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    ProviderDetails providerDetails = this.this$0.getCurrentProvider();
                    if (providerDetails == null) break block1;
                    ProviderDetails providerDetails2 = providerDetails;
                    GeminiProviderInfoPanel geminiProviderInfoPanel = this.this$0;
                    ProviderDetails item = providerDetails2;
                    boolean bl = false;
                    Object object = item.getProviderData();
                    ProviderData.RemoteProviderData remoteProviderData = object instanceof ProviderData.RemoteProviderData ? (ProviderData.RemoteProviderData)object : null;
                    if (remoteProviderData != null) {
                        char[] cArray = GeminiProviderInfoPanel.access$getGeminiApiKeyField$p(geminiProviderInfoPanel).getPassword();
                        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"getPassword(...)");
                        object = cArray;
                        remoteProviderData.setApiKey(new String((char[])object));
                    }
                }
            }
        };
    }

    private final CoroutineScope getScope() {
        Lazy lazy = this.scope$delegate;
        return (CoroutineScope)lazy.getValue();
    }

    @Override
    public void setupUi(@NotNull Panel builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Panel $this$setupUi_u24lambda_u240 = builder;
        boolean bl = false;
        this.geminiApiKeyField.getDocument().addDocumentListener((DocumentListener)((Object)this.listener));
        this.observeAuthState();
        this.observeOnboardingCompleted();
        UserAccountPanel userAccountPanel = new UserAccountPanel(this.disposable, this.getScope());
        userAccountPanel.updateState((Authenticator.AuthState)this.authenticator.getAuthenticationState().getValue());
        this.isLoggedIn.afterChange(this.disposable, (Function1)new Function1<Boolean, Unit>(userAccountPanel, this){
            final /* synthetic */ UserAccountPanel $userAccountPanel;
            final /* synthetic */ GeminiProviderInfoPanel this$0;
            {
                this.$userAccountPanel = $userAccountPanel;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(boolean it) {
                this.$userAccountPanel.updateState((Authenticator.AuthState)GeminiProviderInfoPanel.access$getAuthenticator$p(this.this$0).getAuthenticationState().getValue());
            }
        });
        this.isAuthorized.afterChange(this.disposable, (Function1)new Function1<Boolean, Unit>(userAccountPanel, this){
            final /* synthetic */ UserAccountPanel $userAccountPanel;
            final /* synthetic */ GeminiProviderInfoPanel this$0;
            {
                this.$userAccountPanel = $userAccountPanel;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(boolean it) {
                this.$userAccountPanel.updateState((Authenticator.AuthState)GeminiProviderInfoPanel.access$getAuthenticator$p(this.this$0).getAuthenticationState().getValue());
            }
        });
        Panel.row$default((Panel)$this$setupUi_u24lambda_u240, null, (Function1)((Function1)new Function1<Row, Unit>(userAccountPanel){
            final /* synthetic */ UserAccountPanel $userAccountPanel;
            {
                this.$userAccountPanel = $userAccountPanel;
                super(1);
            }

            public final void invoke(Row $this$row) {
                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                $this$row.cell((JComponent)this.$userAccountPanel);
            }
        }), (int)1, null).topGap(TopGap.SMALL).bottomGap(BottomGap.MEDIUM).visibleIf((ObservableProperty)this.isProviderSettingVisible);
        if (StudioBotFlags.Companion.getInstance().isBringYourOwnKeyEnabled()) {
            $this$setupUi_u24lambda_u240.row(SmlBundle.message("sml.studiobot.settings.modelProviders.addModelProvider.apikey.title", new Object[0]), (Function1)new Function1<Row, Unit>(this){
                final /* synthetic */ GeminiProviderInfoPanel this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(Row $this$row) {
                    Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                    Cell.comment$default((Cell)TextFieldKt.columns((Cell)$this$row.cell((JComponent)GeminiProviderInfoPanel.access$getGeminiApiKeyField$p(this.this$0)).enabledIf(GeminiProviderInfoPanel.access$getAreSettingsAvailable$p(this.this$0)), (int)36), (String)SmlBundle.message("sml.studiobot.settings.chat.bringYourOwnKey.comment", new Object[0]), (int)0, null, (int)6, null);
                }
            }).visibleIf((ObservableProperty)this.isProviderSettingVisible);
        }
        this.modelInformationTablePanel.setupUi($this$setupUi_u24lambda_u240, (Function0<ProviderDetails>)((Function0)new Function0<ProviderDetails>((Object)this){

            public final ProviderDetails invoke() {
                return ((GeminiProviderInfoPanel)this.receiver).getCurrentProvider();
            }
        }));
    }

    @Override
    public void update() {
        ProviderDetails providerDetails = this.getCurrentProvider();
        if (providerDetails == null) {
            return;
        }
        ProviderDetails providerDetails2 = providerDetails;
        this.isProviderSettingVisible.set(providerDetails2.getProviderType() == ProviderType.GEMINI);
        if (!this.canHandleProviderType(providerDetails2.getProviderType())) {
            return;
        }
        ProviderData providerData = providerDetails2.getProviderData();
        ProviderData.RemoteProviderData remoteProviderData = providerData instanceof ProviderData.RemoteProviderData ? (ProviderData.RemoteProviderData)providerData : null;
        this.geminiApiKeyField.setText(remoteProviderData != null ? remoteProviderData.getApiKey() : null);
        this.modelInformationTablePanel.updateModels(providerDetails2.getModelList());
    }

    @Override
    public boolean canHandleProviderType(@NotNull ProviderType providerType) {
        Intrinsics.checkNotNullParameter((Object)((Object)providerType), (String)"providerType");
        return providerType == ProviderType.GEMINI;
    }

    private final void observeAuthState() {
        FlowKt.launchIn((Flow)FlowKt.flowOn((Flow)FlowKt.onEach((Flow)FlowKt.onStart((Flow)((Flow)this.authenticator.getAuthenticationState()), (Function2)((Function2)new Function2<FlowCollector<? super Authenticator.AuthState>, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ GeminiProviderInfoPanel this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        GeminiProviderInfoPanel.access$getLogger$p(this.this$0).debug("Listening to auth state...");
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(FlowCollector<? super Authenticator.AuthState> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        })), (Function2)((Function2)new Function2<Authenticator.AuthState, Continuation<? super Unit>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ GeminiProviderInfoPanel this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Authenticator.AuthState newState = (Authenticator.AuthState)this.L$0;
                        GeminiProviderInfoPanel.access$getLogger$p(this.this$0).debug("Auth state changed: " + newState);
                        GeminiProviderInfoPanel.access$isLoggedIn$p(this.this$0).set(Authenticator.AuthState.Companion.hasProfileInfo(newState));
                        GeminiProviderInfoPanel.access$isAuthorized$p(this.this$0).set(Authenticator.AuthState.Companion.isAuthorized(newState));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(Authenticator.AuthState p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        })), (CoroutineContext)((CoroutineContext)Dispatchers.getDefault())), (CoroutineScope)this.getScope());
    }

    private final void observeOnboardingCompleted() {
        FlowKt.launchIn((Flow)FlowKt.flowOn((Flow)FlowKt.onEach((Flow)((Flow)this.onboardingState.getCurrentState()), (Function2)((Function2)new Function2<OnboardingState.State, Continuation<? super Unit>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ GeminiProviderInfoPanel this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        OnboardingState.State it = (OnboardingState.State)((Object)this.L$0);
                        GeminiProviderInfoPanel.access$getLogger$p(this.this$0).debug("OnboardingState changed: " + it);
                        GeminiProviderInfoPanel.access$getOnboardingCompleted$p(this.this$0).set(it == OnboardingState.State.ONBOARDED);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(OnboardingState.State p1, Continuation<? super Unit> p2) {
                return (this.create((Object)((Object)p1), p2)).invokeSuspend(Unit.INSTANCE);
            }
        })), (CoroutineContext)((CoroutineContext)Dispatchers.getDefault())), (CoroutineScope)this.getScope());
    }

    public static final /* synthetic */ Logger access$getLogger$p(GeminiProviderInfoPanel $this) {
        return $this.logger;
    }

    public static final /* synthetic */ AtomicBooleanProperty access$isLoggedIn$p(GeminiProviderInfoPanel $this) {
        return $this.isLoggedIn;
    }

    public static final /* synthetic */ AtomicBooleanProperty access$isAuthorized$p(GeminiProviderInfoPanel $this) {
        return $this.isAuthorized;
    }

    public static final /* synthetic */ AtomicBooleanProperty access$getOnboardingCompleted$p(GeminiProviderInfoPanel $this) {
        return $this.onboardingCompleted;
    }

    public static final /* synthetic */ Authenticator access$getAuthenticator$p(GeminiProviderInfoPanel $this) {
        return $this.authenticator;
    }

    public static final /* synthetic */ JBPasswordField access$getGeminiApiKeyField$p(GeminiProviderInfoPanel $this) {
        return $this.geminiApiKeyField;
    }

    public static final /* synthetic */ ObservableProperty access$getAreSettingsAvailable$p(GeminiProviderInfoPanel $this) {
        return $this.areSettingsAvailable;
    }

    public static final /* synthetic */ Disposable access$getDisposable$p(GeminiProviderInfoPanel $this) {
        return $this.disposable;
    }
}

