/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.templates.modelproviders.data;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.templates.modelproviders.data.ProviderData;
import com.android.studio.ml.templates.modelproviders.data.ProviderDetails;
import com.android.studio.ml.templates.modelproviders.data.ProviderType;
import com.android.studio.ml.templates.modelproviders.data.ValidationDetails;
import com.android.studio.ml.templates.modelproviders.data.ValidationError;
import com.intellij.openapi.options.ConfigurationException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J\u0016\u0010\b\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J\u0016\u0010\t\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J\u0014\u0010\n\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a8\u0006\u000b"}, d2={"Lcom/android/studio/ml/templates/modelproviders/data/DataValidator;", "", "()V", "doGenericValidations", "Lcom/android/studio/ml/templates/modelproviders/data/ValidationDetails;", "providers", "", "Lcom/android/studio/ml/templates/modelproviders/data/ProviderDetails;", "doLocalProviderValidations", "doRemoteProviderValidations", "execute", "aiplugin.core.aicore"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nDataValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataValidator.kt\ncom/android/studio/ml/templates/modelproviders/data/DataValidator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ValidationDetails.kt\ncom/android/studio/ml/templates/modelproviders/data/ValidationDetails$Companion\n*L\n1#1,94:1\n1872#2,3:95\n1872#2,3:99\n1872#2,3:103\n36#3:98\n36#3:102\n36#3:106\n*S KotlinDebug\n*F\n+ 1 DataValidator.kt\ncom/android/studio/ml/templates/modelproviders/data/DataValidator\n*L\n44#1:95,3\n59#1:99,3\n81#1:103,3\n53#1:98\n75#1:102\n91#1:106\n*E\n"})
public final class DataValidator {
    @NotNull
    public static final DataValidator INSTANCE = new DataValidator();
    public static final int $stable;

    private DataValidator() {
    }

    @NotNull
    public final ValidationDetails execute(@NotNull List<ProviderDetails> providers) throws ConfigurationException {
        Intrinsics.checkNotNullParameter(providers, (String)"providers");
        ValidationDetails validationDetails = this.doGenericValidations(providers);
        if (validationDetails.getValidationError() == ValidationError.NoError) {
            validationDetails = this.doLocalProviderValidations(providers);
        }
        if (validationDetails.getValidationError() == ValidationError.NoError) {
            validationDetails = this.doRemoteProviderValidations(providers);
        }
        return validationDetails;
    }

    /*
     * WARNING - void declaration
     */
    private final ValidationDetails doGenericValidations(List<ProviderDetails> providers) {
        Set providerNameSet = new LinkedHashSet();
        Iterable $this$forEachIndexed$iv = providers;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void provider;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ProviderDetails providerDetails = (ProviderDetails)item$iv;
            int index = n;
            boolean bl = false;
            String providerName = ((Object)StringsKt.trim((CharSequence)provider.getDescription())).toString();
            if (providerNameSet.contains(providerName)) {
                return new ValidationDetails(ValidationError.DuplicateProviderName, index);
            }
            providerNameSet.add(providerName);
            if (!StringsKt.isBlank((CharSequence)providerName)) continue;
            return new ValidationDetails(ValidationError.EmptyProviderName, index);
        }
        ValidationDetails.Companion this_$iv = ValidationDetails.Companion;
        boolean $i$f$noError = false;
        return this_$iv.getNO_ERROR_INSTANCE();
    }

    /*
     * WARNING - void declaration
     */
    private final ValidationDetails doLocalProviderValidations(List<ProviderDetails> providers) {
        Set portNumberSet = new LinkedHashSet();
        Iterable $this$forEachIndexed$iv = providers;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void provider;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ProviderDetails providerDetails = (ProviderDetails)item$iv;
            int index = n;
            boolean bl = false;
            if (provider.getProviderType() != ProviderType.LOCAL) continue;
            ProviderData providerData = provider.getProviderData();
            Object object = providerData instanceof ProviderData.LocalProviderData ? (ProviderData.LocalProviderData)providerData : null;
            String port = object != null && (object = ((ProviderData.LocalProviderData)object).getPort()) != null ? ((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString() : null;
            CharSequence charSequence = port;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                return new ValidationDetails(ValidationError.EmptyProviderPort, index);
            }
            Integer portNumber = StringsKt.toIntOrNull((String)port);
            if (portNumber == null || portNumber < 0 || portNumber > 65535) {
                return new ValidationDetails(ValidationError.InvalidPort, index);
            }
            if (portNumberSet.contains(portNumber)) {
                return new ValidationDetails(ValidationError.DuplicateProviderPort, index);
            }
            portNumberSet.add(portNumber);
        }
        ValidationDetails.Companion this_$iv = ValidationDetails.Companion;
        boolean $i$f$noError = false;
        return this_$iv.getNO_ERROR_INSTANCE();
    }

    /*
     * WARNING - void declaration
     */
    private final ValidationDetails doRemoteProviderValidations(List<ProviderDetails> providers) {
        Set providerUrlSet = new LinkedHashSet();
        Iterable $this$forEachIndexed$iv = providers;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void provider;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ProviderDetails providerDetails = (ProviderDetails)item$iv;
            int index = n;
            boolean bl = false;
            if (provider.getProviderType() != ProviderType.REMOTE) continue;
            ProviderData providerData = provider.getProviderData();
            Object object = providerData instanceof ProviderData.RemoteProviderData ? (ProviderData.RemoteProviderData)providerData : null;
            String url = object != null && (object = ((ProviderData.RemoteProviderData)object).getUrl()) != null ? ((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString() : null;
            CharSequence charSequence = url;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                return new ValidationDetails(ValidationError.EmptyProviderUrl, index);
            }
            if (providerUrlSet.contains(url)) {
                return new ValidationDetails(ValidationError.DuplicateProviderUrl, index);
            }
            providerUrlSet.add(url);
        }
        ValidationDetails.Companion this_$iv = ValidationDetails.Companion;
        boolean $i$f$noError = false;
        return this_$iv.getNO_ERROR_INSTANCE();
    }
}

