/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.suggestion.session;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.suggestion.controls.EditorSuggestionControl;
import com.android.studio.ml.suggestion.controls.JumpToLocationControl;
import com.android.studio.ml.suggestion.session.SuggestionControlSession;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0012B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0006H\u0016J\b\u0010\u0011\u001a\u00020\u000fH\u0002R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00060\rR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/android/studio/ml/suggestion/session/OrderedSuggestionControlSession;", "Lcom/android/studio/ml/suggestion/session/SuggestionControlSession;", "editor", "Lcom/intellij/openapi/editor/Editor;", "controls", "", "Lcom/android/studio/ml/suggestion/controls/EditorSuggestionControl;", "showInactiveControls", "", "continueAfterRejection", "(Lcom/intellij/openapi/editor/Editor;Ljava/util/List;ZZ)V", "Ljava/util/Queue;", "listener", "Lcom/android/studio/ml/suggestion/session/OrderedSuggestionControlSession$AdvancementListener;", "dispose", "", "getActiveControl", "setUpHead", "AdvancementListener", "aiplugin.core.aicore"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nOrderedSuggestionControlSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OrderedSuggestionControlSession.kt\ncom/android/studio/ml/suggestion/session/OrderedSuggestionControlSession\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,81:1\n1#2:82\n1#2:86\n1863#3,2:83\n2642#3:85\n*S KotlinDebug\n*F\n+ 1 OrderedSuggestionControlSession.kt\ncom/android/studio/ml/suggestion/session/OrderedSuggestionControlSession\n*L\n62#1:86\n43#1:83,2\n62#1:85\n*E\n"})
public final class OrderedSuggestionControlSession
implements SuggestionControlSession {
    @NotNull
    private final Editor editor;
    private final boolean showInactiveControls;
    private final boolean continueAfterRejection;
    @NotNull
    private final Queue<EditorSuggestionControl> controls;
    @NotNull
    private final AdvancementListener listener;
    public static final int $stable = 8;

    public OrderedSuggestionControlSession(@NotNull Editor editor, @NotNull List<? extends EditorSuggestionControl> controls2, boolean showInactiveControls, boolean continueAfterRejection) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(controls2, (String)"controls");
        this.editor = editor;
        this.showInactiveControls = showInactiveControls;
        this.continueAfterRejection = continueAfterRejection;
        this.controls = new ConcurrentLinkedQueue(controls2);
        this.listener = new AdvancementListener();
        Project project2 = this.editor.getProject();
        if (project2 != null) {
            Project it = project2;
            boolean bl = false;
            v1 = new JumpToLocationControl(it, this.editor, this);
        } else {
            v1 = null;
        }
        if (!(!((Collection)controls2).isEmpty())) {
            boolean $i$a$-require-OrderedSuggestionControlSession$32 = false;
            String $i$a$-require-OrderedSuggestionControlSession$32 = "Cannot create single-use session with no controls. ";
            throw new IllegalArgumentException($i$a$-require-OrderedSuggestionControlSession$32.toString());
        }
        this.setUpHead();
        if (this.showInactiveControls) {
            Iterable $this$forEach$iv = controls2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                EditorSuggestionControl it = (EditorSuggestionControl)element$iv;
                boolean bl = false;
                it.show();
            }
        }
    }

    public /* synthetic */ OrderedSuggestionControlSession(Editor editor, List list, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        this(editor, list, bl, bl2);
    }

    private final void setUpHead() {
        EditorSuggestionControl nextControl = this.controls.peek();
        if (nextControl == null) {
            Disposer.dispose((Disposable)this);
            return;
        }
        nextControl.addListener(this.listener, this);
        EditorSuggestionControl.activate$default(nextControl, false, 1, null);
        if (!this.showInactiveControls) {
            nextControl.show();
        }
    }

    @Override
    @Nullable
    public EditorSuggestionControl getActiveControl() {
        return this.controls.peek();
    }

    public void dispose() {
        Iterable iterable;
        Iterable $this$onEach$iv = this.controls;
        boolean $i$f$onEach = false;
        Iterable $this$onEach_u24lambda_u2418$iv = iterable = $this$onEach$iv;
        boolean bl = false;
        for (Object element$iv : $this$onEach_u24lambda_u2418$iv) {
            Disposable p0 = (Disposable)element$iv;
            boolean bl2 = false;
            Disposer.dispose((Disposable)p0);
        }
        ((Queue)iterable).clear();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002J\b\u0010\u0005\u001a\u00020\u0004H\u0016J\b\u0010\u0006\u001a\u00020\u0004H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/android/studio/ml/suggestion/session/OrderedSuggestionControlSession$AdvancementListener;", "Lcom/android/studio/ml/suggestion/controls/EditorSuggestionControl$Listener;", "(Lcom/android/studio/ml/suggestion/session/OrderedSuggestionControlSession;)V", "advance", "", "onAccept", "onReject", "aiplugin.core.aicore"})
    @SourceDebugExtension(value={"SMAP\nOrderedSuggestionControlSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OrderedSuggestionControlSession.kt\ncom/android/studio/ml/suggestion/session/OrderedSuggestionControlSession$AdvancementListener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,81:1\n1#2:82\n*E\n"})
    private final class AdvancementListener
    implements EditorSuggestionControl.Listener {
        private final void advance() {
            EditorSuggestionControl editorSuggestionControl = (EditorSuggestionControl)OrderedSuggestionControlSession.this.controls.poll();
            if (editorSuggestionControl != null) {
                Disposable p0 = editorSuggestionControl;
                boolean bl = false;
                Disposer.dispose((Disposable)p0);
            }
            OrderedSuggestionControlSession.this.setUpHead();
        }

        @Override
        public void onAccept() {
            this.advance();
        }

        @Override
        public void onReject() {
            if (OrderedSuggestionControlSession.this.continueAfterRejection) {
                this.advance();
            } else {
                Disposer.dispose((Disposable)OrderedSuggestionControlSession.this);
            }
        }
    }
}

