/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.suggestion.grouping;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.suggestion.AnchoredDiffChunk;
import com.android.studio.ml.suggestion.grouping.GroupedChangeKt;
import com.android.studio.ml.suggestion.grouping.GroupingJustification;
import com.android.studio.ml.suggestion.grouping.LineLevelChange;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0005\n\u000b\f\r\u000eJ\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH&R\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0005\u000f\u0010\u0011\u0012\u0013\u00a8\u0006\u0014\u00c0\u0006\u0003"}, d2={"Lcom/android/studio/ml/suggestion/grouping/GroupedChange;", "", "changes", "", "Lcom/android/studio/ml/suggestion/grouping/LineLevelChange;", "getChanges", "()Ljava/util/List;", "getAdjustedAnchor", "Lcom/android/studio/ml/suggestion/AnchoredDiffChunk;", "originalAnchor", "AdditionGroup", "DeletionGroup", "ModificationBlock", "ModificationGroup", "ReplacementGroup", "Lcom/android/studio/ml/suggestion/grouping/GroupedChange$AdditionGroup;", "Lcom/android/studio/ml/suggestion/grouping/GroupedChange$DeletionGroup;", "Lcom/android/studio/ml/suggestion/grouping/GroupedChange$ModificationBlock;", "Lcom/android/studio/ml/suggestion/grouping/GroupedChange$ModificationGroup;", "Lcom/android/studio/ml/suggestion/grouping/GroupedChange$ReplacementGroup;", "aiplugin.core.aicore"})
public interface GroupedChange {
    @NotNull
    public List<LineLevelChange> getChanges();

    @NotNull
    public AnchoredDiffChunk getAdjustedAnchor(@NotNull AnchoredDiffChunk var1);

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\t\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lcom/android/studio/ml/suggestion/grouping/GroupedChange$AdditionGroup;", "Lcom/android/studio/ml/suggestion/grouping/GroupedChange;", "changes", "", "Lcom/android/studio/ml/suggestion/grouping/LineLevelChange$Addition;", "(Ljava/util/List;)V", "getChanges", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "", "getAdjustedAnchor", "Lcom/android/studio/ml/suggestion/AnchoredDiffChunk;", "originalAnchor", "hashCode", "", "toString", "", "aiplugin.core.aicore"})
    @StabilityInferred(parameters=0)
    public static final class AdditionGroup
    implements GroupedChange {
        @NotNull
        private final List<LineLevelChange.Addition> changes;
        public static final int $stable = 8;

        public AdditionGroup(@NotNull List<LineLevelChange.Addition> changes) {
            Intrinsics.checkNotNullParameter(changes, (String)"changes");
            this.changes = changes;
        }

        @NotNull
        public List<LineLevelChange.Addition> getChanges() {
            return this.changes;
        }

        @Override
        @NotNull
        public AnchoredDiffChunk getAdjustedAnchor(@NotNull AnchoredDiffChunk originalAnchor) {
            Intrinsics.checkNotNullParameter((Object)originalAnchor, (String)"originalAnchor");
            if (!(((CharSequence)originalAnchor.getOriginalContent()).length() == 0)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (!(originalAnchor.getNewContentLines().size() == this.getChanges().size())) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            return originalAnchor;
        }

        @NotNull
        public final List<LineLevelChange.Addition> component1() {
            return this.changes;
        }

        @NotNull
        public final AdditionGroup copy(@NotNull List<LineLevelChange.Addition> changes) {
            Intrinsics.checkNotNullParameter(changes, (String)"changes");
            return new AdditionGroup(changes);
        }

        public static /* synthetic */ AdditionGroup copy$default(AdditionGroup additionGroup, List list, int n, Object object) {
            if ((n & 1) != 0) {
                list = additionGroup.changes;
            }
            return additionGroup.copy(list);
        }

        @NotNull
        public String toString() {
            return "AdditionGroup(changes=" + this.changes + ")";
        }

        public int hashCode() {
            return ((Object)this.changes).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AdditionGroup)) {
                return false;
            }
            AdditionGroup additionGroup = (AdditionGroup)other;
            return Intrinsics.areEqual(this.changes, additionGroup.changes);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\t\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lcom/android/studio/ml/suggestion/grouping/GroupedChange$DeletionGroup;", "Lcom/android/studio/ml/suggestion/grouping/GroupedChange;", "changes", "", "Lcom/android/studio/ml/suggestion/grouping/LineLevelChange$Deletion;", "(Ljava/util/List;)V", "getChanges", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "", "getAdjustedAnchor", "Lcom/android/studio/ml/suggestion/AnchoredDiffChunk;", "originalAnchor", "hashCode", "", "toString", "", "aiplugin.core.aicore"})
    @StabilityInferred(parameters=0)
    public static final class DeletionGroup
    implements GroupedChange {
        @NotNull
        private final List<LineLevelChange.Deletion> changes;
        public static final int $stable = 8;

        public DeletionGroup(@NotNull List<LineLevelChange.Deletion> changes) {
            Intrinsics.checkNotNullParameter(changes, (String)"changes");
            this.changes = changes;
        }

        @NotNull
        public List<LineLevelChange.Deletion> getChanges() {
            return this.changes;
        }

        @Override
        @NotNull
        public AnchoredDiffChunk getAdjustedAnchor(@NotNull AnchoredDiffChunk originalAnchor) {
            Intrinsics.checkNotNullParameter((Object)originalAnchor, (String)"originalAnchor");
            if (!(((CharSequence)originalAnchor.getNewContent()).length() == 0)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (!(originalAnchor.getOriginalContentLines().size() == this.getChanges().size())) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            return originalAnchor;
        }

        @NotNull
        public final List<LineLevelChange.Deletion> component1() {
            return this.changes;
        }

        @NotNull
        public final DeletionGroup copy(@NotNull List<LineLevelChange.Deletion> changes) {
            Intrinsics.checkNotNullParameter(changes, (String)"changes");
            return new DeletionGroup(changes);
        }

        public static /* synthetic */ DeletionGroup copy$default(DeletionGroup deletionGroup, List list, int n, Object object) {
            if ((n & 1) != 0) {
                list = deletionGroup.changes;
            }
            return deletionGroup.copy(list);
        }

        @NotNull
        public String toString() {
            return "DeletionGroup(changes=" + this.changes + ")";
        }

        public int hashCode() {
            return ((Object)this.changes).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DeletionGroup)) {
                return false;
            }
            DeletionGroup deletionGroup = (DeletionGroup)other;
            return Intrinsics.areEqual(this.changes, deletionGroup.changes);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\t\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lcom/android/studio/ml/suggestion/grouping/GroupedChange$ModificationBlock;", "Lcom/android/studio/ml/suggestion/grouping/GroupedChange;", "changes", "", "Lcom/android/studio/ml/suggestion/grouping/LineLevelChange$Modification;", "(Ljava/util/List;)V", "getChanges", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "", "getAdjustedAnchor", "Lcom/android/studio/ml/suggestion/AnchoredDiffChunk;", "originalAnchor", "hashCode", "", "toString", "", "aiplugin.core.aicore"})
    @StabilityInferred(parameters=0)
    public static final class ModificationBlock
    implements GroupedChange {
        @NotNull
        private final List<LineLevelChange.Modification> changes;
        public static final int $stable = 8;

        public ModificationBlock(@NotNull List<LineLevelChange.Modification> changes) {
            Intrinsics.checkNotNullParameter(changes, (String)"changes");
            this.changes = changes;
        }

        @NotNull
        public List<LineLevelChange.Modification> getChanges() {
            return this.changes;
        }

        @Override
        @NotNull
        public AnchoredDiffChunk getAdjustedAnchor(@NotNull AnchoredDiffChunk originalAnchor) {
            Intrinsics.checkNotNullParameter((Object)originalAnchor, (String)"originalAnchor");
            return GroupedChangeKt.access$adjustForModifications(originalAnchor, this.getChanges());
        }

        @NotNull
        public final List<LineLevelChange.Modification> component1() {
            return this.changes;
        }

        @NotNull
        public final ModificationBlock copy(@NotNull List<LineLevelChange.Modification> changes) {
            Intrinsics.checkNotNullParameter(changes, (String)"changes");
            return new ModificationBlock(changes);
        }

        public static /* synthetic */ ModificationBlock copy$default(ModificationBlock modificationBlock, List list, int n, Object object) {
            if ((n & 1) != 0) {
                list = modificationBlock.changes;
            }
            return modificationBlock.copy(list);
        }

        @NotNull
        public String toString() {
            return "ModificationBlock(changes=" + this.changes + ")";
        }

        public int hashCode() {
            return ((Object)this.changes).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ModificationBlock)) {
                return false;
            }
            ModificationBlock modificationBlock = (ModificationBlock)other;
            return Intrinsics.areEqual(this.changes, modificationBlock.changes);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lcom/android/studio/ml/suggestion/grouping/GroupedChange$ModificationGroup;", "Lcom/android/studio/ml/suggestion/grouping/GroupedChange;", "justification", "Lcom/android/studio/ml/suggestion/grouping/GroupingJustification;", "changes", "", "Lcom/android/studio/ml/suggestion/grouping/LineLevelChange$Modification;", "(Lcom/android/studio/ml/suggestion/grouping/GroupingJustification;Ljava/util/List;)V", "getChanges", "()Ljava/util/List;", "getJustification", "()Lcom/android/studio/ml/suggestion/grouping/GroupingJustification;", "component1", "component2", "copy", "equals", "", "other", "", "getAdjustedAnchor", "Lcom/android/studio/ml/suggestion/AnchoredDiffChunk;", "originalAnchor", "hashCode", "", "toString", "", "aiplugin.core.aicore"})
    @StabilityInferred(parameters=0)
    public static final class ModificationGroup
    implements GroupedChange {
        @NotNull
        private final GroupingJustification justification;
        @NotNull
        private final List<LineLevelChange.Modification> changes;
        public static final int $stable = 8;

        public ModificationGroup(@NotNull GroupingJustification justification, @NotNull List<LineLevelChange.Modification> changes) {
            Intrinsics.checkNotNullParameter((Object)justification, (String)"justification");
            Intrinsics.checkNotNullParameter(changes, (String)"changes");
            this.justification = justification;
            this.changes = changes;
        }

        @NotNull
        public final GroupingJustification getJustification() {
            return this.justification;
        }

        @NotNull
        public List<LineLevelChange.Modification> getChanges() {
            return this.changes;
        }

        @Override
        @NotNull
        public AnchoredDiffChunk getAdjustedAnchor(@NotNull AnchoredDiffChunk originalAnchor) {
            Intrinsics.checkNotNullParameter((Object)originalAnchor, (String)"originalAnchor");
            return GroupedChangeKt.access$adjustForModifications(originalAnchor, this.getChanges());
        }

        @NotNull
        public final GroupingJustification component1() {
            return this.justification;
        }

        @NotNull
        public final List<LineLevelChange.Modification> component2() {
            return this.changes;
        }

        @NotNull
        public final ModificationGroup copy(@NotNull GroupingJustification justification, @NotNull List<LineLevelChange.Modification> changes) {
            Intrinsics.checkNotNullParameter((Object)justification, (String)"justification");
            Intrinsics.checkNotNullParameter(changes, (String)"changes");
            return new ModificationGroup(justification, changes);
        }

        public static /* synthetic */ ModificationGroup copy$default(ModificationGroup modificationGroup, GroupingJustification groupingJustification, List list, int n, Object object) {
            if ((n & 1) != 0) {
                groupingJustification = modificationGroup.justification;
            }
            if ((n & 2) != 0) {
                list = modificationGroup.changes;
            }
            return modificationGroup.copy(groupingJustification, list);
        }

        @NotNull
        public String toString() {
            return "ModificationGroup(justification=" + this.justification + ", changes=" + this.changes + ")";
        }

        public int hashCode() {
            int result2 = this.justification.hashCode();
            result2 = result2 * 31 + ((Object)this.changes).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ModificationGroup)) {
                return false;
            }
            ModificationGroup modificationGroup = (ModificationGroup)other;
            if (!Intrinsics.areEqual((Object)this.justification, (Object)modificationGroup.justification)) {
                return false;
            }
            return Intrinsics.areEqual(this.changes, modificationGroup.changes);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0002\u0010\u0007J\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0003J)\u0010\u0010\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0016J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\tR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\t\u00a8\u0006\u001c"}, d2={"Lcom/android/studio/ml/suggestion/grouping/GroupedChange$ReplacementGroup;", "Lcom/android/studio/ml/suggestion/grouping/GroupedChange;", "deletions", "", "Lcom/android/studio/ml/suggestion/grouping/LineLevelChange$Deletion;", "additions", "Lcom/android/studio/ml/suggestion/grouping/LineLevelChange$Addition;", "(Ljava/util/List;Ljava/util/List;)V", "getAdditions", "()Ljava/util/List;", "changes", "Lcom/android/studio/ml/suggestion/grouping/LineLevelChange;", "getChanges", "getDeletions", "component1", "component2", "copy", "equals", "", "other", "", "getAdjustedAnchor", "Lcom/android/studio/ml/suggestion/AnchoredDiffChunk;", "originalAnchor", "hashCode", "", "toString", "", "aiplugin.core.aicore"})
    @StabilityInferred(parameters=0)
    public static final class ReplacementGroup
    implements GroupedChange {
        @NotNull
        private final List<LineLevelChange.Deletion> deletions;
        @NotNull
        private final List<LineLevelChange.Addition> additions;
        @NotNull
        private final List<LineLevelChange> changes;
        public static final int $stable = 8;

        public ReplacementGroup(@NotNull List<LineLevelChange.Deletion> deletions, @NotNull List<LineLevelChange.Addition> additions) {
            Intrinsics.checkNotNullParameter(deletions, (String)"deletions");
            Intrinsics.checkNotNullParameter(additions, (String)"additions");
            this.deletions = deletions;
            this.additions = additions;
            this.changes = CollectionsKt.plus((Collection)this.deletions, (Iterable)this.additions);
        }

        @NotNull
        public final List<LineLevelChange.Deletion> getDeletions() {
            return this.deletions;
        }

        @NotNull
        public final List<LineLevelChange.Addition> getAdditions() {
            return this.additions;
        }

        @Override
        @NotNull
        public List<LineLevelChange> getChanges() {
            return this.changes;
        }

        @Override
        @NotNull
        public AnchoredDiffChunk getAdjustedAnchor(@NotNull AnchoredDiffChunk originalAnchor) {
            Intrinsics.checkNotNullParameter((Object)originalAnchor, (String)"originalAnchor");
            Pair pair = GroupedChangeKt.access$getContiguousLineStartAndCount(this.deletions);
            int deletionStartLineNumber = ((Number)pair.component1()).intValue();
            int deletionLineCount = ((Number)pair.component2()).intValue();
            Pair pair2 = GroupedChangeKt.access$getContiguousLineStartAndCount(this.additions);
            int additionStartLineNumber = ((Number)pair2.component1()).intValue();
            int additionLineCount = ((Number)pair2.component2()).intValue();
            return originalAnchor.getAdjustedAnchorForLines(deletionStartLineNumber, deletionLineCount, additionStartLineNumber, additionLineCount);
        }

        @NotNull
        public final List<LineLevelChange.Deletion> component1() {
            return this.deletions;
        }

        @NotNull
        public final List<LineLevelChange.Addition> component2() {
            return this.additions;
        }

        @NotNull
        public final ReplacementGroup copy(@NotNull List<LineLevelChange.Deletion> deletions, @NotNull List<LineLevelChange.Addition> additions) {
            Intrinsics.checkNotNullParameter(deletions, (String)"deletions");
            Intrinsics.checkNotNullParameter(additions, (String)"additions");
            return new ReplacementGroup(deletions, additions);
        }

        public static /* synthetic */ ReplacementGroup copy$default(ReplacementGroup replacementGroup, List list, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                list = replacementGroup.deletions;
            }
            if ((n & 2) != 0) {
                list2 = replacementGroup.additions;
            }
            return replacementGroup.copy(list, list2);
        }

        @NotNull
        public String toString() {
            return "ReplacementGroup(deletions=" + this.deletions + ", additions=" + this.additions + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.deletions).hashCode();
            result2 = result2 * 31 + ((Object)this.additions).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ReplacementGroup)) {
                return false;
            }
            ReplacementGroup replacementGroup = (ReplacementGroup)other;
            if (!Intrinsics.areEqual(this.deletions, replacementGroup.deletions)) {
                return false;
            }
            return Intrinsics.areEqual(this.additions, replacementGroup.additions);
        }
    }
}

