/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.suggestion.controls;

import com.android.studio.ml.suggestion.AnchoredDiffChunk;
import com.android.studio.ml.suggestion.controls.AggregateEditorSuggestionControl;
import com.android.studio.ml.suggestion.controls.BlockReplacementSuggestionControl;
import com.android.studio.ml.suggestion.controls.EditorSuggestionControl;
import com.android.studio.ml.suggestion.controls.EditorSuggestionControlFactory;
import com.android.studio.ml.suggestion.controls.InlineReplacementSuggestionControl;
import com.android.studio.ml.suggestion.controls.PopoutSuggestionControl;
import com.android.studio.ml.suggestion.controls.viewmodel.CodeDisplayKt;
import com.android.studio.ml.suggestion.controls.viewmodel.CodeDisplayRow;
import com.android.studio.ml.suggestion.controls.viewmodel.CodeDisplaySnippet;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bH\u0016J\u0018\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J&\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\bH\u0016J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J(\u0010\u0010\u001a\u0004\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\bH\u0016J\u0018\u0010\u0013\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J.\u0010\u0013\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/android/studio/ml/suggestion/controls/EditorSuggestionControlFactoryImpl;", "Lcom/android/studio/ml/suggestion/controls/EditorSuggestionControlFactory;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "createAggregate", "Lcom/android/studio/ml/suggestion/controls/EditorSuggestionControl;", "childSuggestions", "", "createBlockReplacement", "chunk", "Lcom/android/studio/ml/suggestion/AnchoredDiffChunk;", "editor", "Lcom/intellij/openapi/editor/Editor;", "rows", "Lcom/android/studio/ml/suggestion/controls/viewmodel/CodeDisplayRow;", "createInlineReplacement", "snippets", "Lcom/android/studio/ml/suggestion/controls/viewmodel/CodeDisplaySnippet;", "createPopoutReplacement", "offset", "", "aiplugin.core.aicore"})
final class EditorSuggestionControlFactoryImpl
implements EditorSuggestionControlFactory {
    @NotNull
    private final Project project;

    private EditorSuggestionControlFactoryImpl(Project project2) {
        this.project = project2;
    }

    @Override
    @Nullable
    public EditorSuggestionControl createInlineReplacement(@NotNull AnchoredDiffChunk chunk, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (!(!StringsKt.contains$default((CharSequence)chunk.getOriginalContent(), (char)'\n', (boolean)false, (int)2, null))) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(!StringsKt.contains$default((CharSequence)chunk.getNewContent(), (char)'\n', (boolean)false, (int)2, null))) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        VirtualFile virtualFile2 = editor.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getVirtualFile(...)");
        return this.createInlineReplacement(chunk, editor, CodeDisplayKt.createHighlightedSnippetsForSingleLineChunk(chunk, this.project, virtualFile2));
    }

    @Override
    @Nullable
    public EditorSuggestionControl createInlineReplacement(@NotNull AnchoredDiffChunk chunk, @NotNull Editor editor, @NotNull List<CodeDisplaySnippet> snippets) {
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(snippets, (String)"snippets");
        return InlineReplacementSuggestionControl.Companion.create$aiplugin_core_aicore(snippets, chunk, this.project, editor);
    }

    @Override
    @NotNull
    public EditorSuggestionControl createBlockReplacement(@NotNull AnchoredDiffChunk chunk, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        VirtualFile virtualFile2 = editor.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getVirtualFile(...)");
        return this.createBlockReplacement(chunk, editor, CodeDisplayKt.createHighlightedRowsForChunk(chunk, this.project, virtualFile2));
    }

    @Override
    @NotNull
    public EditorSuggestionControl createBlockReplacement(@NotNull AnchoredDiffChunk chunk, @NotNull Editor editor, @NotNull List<CodeDisplayRow> rows) {
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(rows, (String)"rows");
        return BlockReplacementSuggestionControl.Companion.create$aiplugin_core_aicore(rows, chunk, this.project, editor);
    }

    @Override
    @NotNull
    public EditorSuggestionControl createPopoutReplacement(@NotNull AnchoredDiffChunk chunk, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        VirtualFile virtualFile2 = editor.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getVirtualFile(...)");
        return this.createPopoutReplacement(chunk, editor, CodeDisplayKt.createHighlightedRowsForChunk(chunk, this.project, virtualFile2), chunk.getRangeMarker().getTextRange().getEndOffset());
    }

    @Override
    @NotNull
    public EditorSuggestionControl createPopoutReplacement(@NotNull AnchoredDiffChunk chunk, @NotNull Editor editor, @NotNull List<CodeDisplayRow> rows, int offset2) {
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(rows, (String)"rows");
        return new PopoutSuggestionControl(new PopoutSuggestionControl.ViewModel(rows, offset2), this.project, editor, CollectionsKt.listOf((Object)chunk));
    }

    @Override
    @NotNull
    public EditorSuggestionControl createAggregate(@NotNull List<? extends EditorSuggestionControl> childSuggestions) {
        Intrinsics.checkNotNullParameter(childSuggestions, (String)"childSuggestions");
        return new AggregateEditorSuggestionControl(this.project, childSuggestions);
    }
}

