/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.releasenotes.fetchers;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.ide.common.gradle.Version;
import com.android.studio.ml.releasenotes.MavenLibrary;
import com.android.studio.ml.releasenotes.ReleaseNotes;
import com.android.studio.ml.releasenotes.ReleaseNotesContentProvider;
import com.android.studio.ml.releasenotes.ReleaseNotesFetcher;
import com.android.studio.ml.releasenotes.ReleaseNotesQuery;
import com.android.studio.ml.releasenotes.ReleaseNotesUtils;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0013H\u0002J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\"\u0010\u0017\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00130\u00180\r2\u0006\u0010\u001a\u001a\u00020\u0013H\u0002\u00a8\u0006\u001b"}, d2={"Lcom/android/studio/ml/releasenotes/fetchers/JetpackReleaseNotesFetcher;", "Lcom/android/studio/ml/releasenotes/ReleaseNotesFetcher;", "<init>", "()V", "canHandle", "", "library", "Lcom/android/studio/ml/releasenotes/MavenLibrary;", "getReleaseNotesUrl", "Ljava/net/URL;", "query", "Lcom/android/studio/ml/releasenotes/ReleaseNotesQuery;", "fetch", "", "Lcom/android/studio/ml/releasenotes/ReleaseNotes;", "request", "contentProvider", "Lcom/android/studio/ml/releasenotes/ReleaseNotesContentProvider;", "getReleaseNotesHtmlPage", "", "libraryUrl", "key", "libraryKey", "splitDacVersions", "Lkotlin/Pair;", "Lcom/android/ide/common/gradle/Version;", "html", "aiplugin.android"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nJetpackReleaseNotesFetcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JetpackReleaseNotesFetcher.kt\ncom/android/studio/ml/releasenotes/fetchers/JetpackReleaseNotesFetcher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,165:1\n1557#2:166\n1628#2,3:167\n*S KotlinDebug\n*F\n+ 1 JetpackReleaseNotesFetcher.kt\ncom/android/studio/ml/releasenotes/fetchers/JetpackReleaseNotesFetcher\n*L\n65#1:166\n65#1:167,3\n*E\n"})
public final class JetpackReleaseNotesFetcher
implements ReleaseNotesFetcher {
    public static final int $stable;

    @Override
    public boolean canHandle(@NotNull MavenLibrary library) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        return StringsKt.startsWith$default((String)library.getGroup(), (String)"androidx.", (boolean)false, (int)2, null);
    }

    @Override
    @NotNull
    public URL getReleaseNotesUrl(@NotNull ReleaseNotesQuery query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        return new URL(this.libraryUrl(this.libraryKey(query.getLibrary())));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public List<ReleaseNotes> fetch(@NotNull ReleaseNotesQuery request2, @NotNull ReleaseNotesContentProvider contentProvider) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Intrinsics.checkNotNullParameter((Object)contentProvider, (String)"contentProvider");
        String artifact = request2.getLibrary().getArtifact();
        String newVersion = request2.getTargetVersion();
        Version oldVersion = request2.getLibrary().getVersion();
        String html = this.getReleaseNotesHtmlPage(request2.getLibrary(), contentProvider);
        int start2 = StringsKt.indexOf$default((CharSequence)html, (String)("<h3 id=\"" + artifact + "-" + newVersion + "\""), (int)0, (boolean)false, (int)6, null);
        if (start2 == -1 && (start2 = StringsKt.indexOf$default((CharSequence)html, (String)("<h3 id=\"" + newVersion + "\""), (int)0, (boolean)false, (int)6, null)) == -1) {
            return null;
        }
        int end = StringsKt.indexOf$default((CharSequence)html, (String)("<h3 id=\"" + artifact + "-" + oldVersion + "\""), (int)start2, (boolean)false, (int)4, null);
        if (end == -1 && (end = StringsKt.indexOf$default((CharSequence)html, (String)("<h3 id=\"" + oldVersion + "\""), (int)start2, (boolean)false, (int)4, null)) == -1) {
            return null;
        }
        String string = html.substring(start2, end);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        html = string;
        List<Pair<Version, String>> versions = this.splitDacVersions(html);
        Iterable $this$map$iv = versions;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Version version = (Version)pair.component1();
            String html2 = (String)pair.component2();
            String cleanHtml = ReleaseNotesUtils.INSTANCE.stripDacHtmlJunk(html2);
            String text2 = ReleaseNotesUtils.INSTANCE.convertToMarkdown(cleanHtml);
            text2 = ReleaseNotesUtils.INSTANCE.stripMarkdownJunk(text2);
            collection.add(new ReleaseNotes(version, text2));
        }
        return (List)destination$iv$iv;
    }

    private final String getReleaseNotesHtmlPage(MavenLibrary library, ReleaseNotesContentProvider contentProvider) {
        String key = this.libraryKey(library);
        String url = this.libraryUrl(key);
        Object object = contentProvider.getReleaseNotes(new URL(url));
        if (object == null || (object = ((ReleaseNotesContentProvider.ReleaseNotesContent)object).getContent()) == null) {
            object = "";
        }
        return object;
    }

    private final String libraryUrl(String key) {
        return "https://developer.android.com/jetpack/androidx/releases/" + key + "/index.html";
    }

    private final String libraryKey(MavenLibrary library) {
        return StringsKt.replace$default((String)StringsKt.substringAfter$default((String)library.getGroup(), (String)"androidx.", null, (int)2, null), (String)".", (String)"-", (boolean)false, (int)4, null);
    }

    private final List<Pair<Version, String>> splitDacVersions(String html) {
        List list = new ArrayList();
        StringBuilder sb = new StringBuilder();
        List lines = StringsKt.lines((CharSequence)html);
        Ref.ObjectRef versionString = new Ref.ObjectRef();
        for (String line : lines) {
            int idEnd;
            int idStart;
            if (StringsKt.startsWith$default((String)line, (String)"<h3", (boolean)false, (int)2, null)) {
                JetpackReleaseNotesFetcher.splitDacVersions$flush((Ref.ObjectRef<String>)versionString, list, sb);
            }
            if ((idStart = StringsKt.indexOf$default((CharSequence)line, (String)"id=\"", (int)0, (boolean)false, (int)6, null)) != -1 && (idEnd = StringsKt.indexOf$default((CharSequence)line, (String)"\"", (int)(idStart += 4), (boolean)false, (int)4, null)) != -1) {
                int label;
                int dash;
                String id;
                Intrinsics.checkNotNullExpressionValue((Object)line.substring(idStart, idEnd), (String)"substring(...)");
                while (((CharSequence)id).length() > 0 && !Character.isDigit(id.charAt(0)) && (dash = StringsKt.indexOf$default((CharSequence)id, (char)'-', (int)0, (boolean)false, (int)6, null)) != -1) {
                    Intrinsics.checkNotNullExpressionValue((Object)id.substring(dash + 1), (String)"substring(...)");
                }
                versionString.element = id;
                if (StringsKt.contains$default((CharSequence)id, (CharSequence)"_", (boolean)false, (int)2, null) && (label = StringsKt.indexOf$default((CharSequence)line, (String)"Version ", (int)idStart, (boolean)false, (int)4, null)) != -1) {
                    for (idEnd = idStart = label + 8; idEnd < line.length(); ++idEnd) {
                        char c = line.charAt(idEnd);
                        if (Character.isLetterOrDigit(c) || c == '.' || c == '-') {
                            continue;
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)line.substring(idStart, idEnd), (String)"substring(...)");
                        versionString.element = versionString.element;
                        break;
                    }
                }
            }
            sb.append(line).append('\n');
        }
        JetpackReleaseNotesFetcher.splitDacVersions$flush((Ref.ObjectRef<String>)versionString, list, sb);
        return list;
    }

    private static final void splitDacVersions$flush(Ref.ObjectRef<String> versionString, List<Pair<Version, String>> list, StringBuilder sb) {
        if (versionString.element != null) {
            Object object = versionString.element;
            Intrinsics.checkNotNull((Object)object);
            Version version = Version.Companion.parse((String)object);
            list.add((Pair<Version, String>)new Pair((Object)version, (Object)sb.toString()));
            StringsKt.clear((StringBuilder)sb);
            versionString.element = null;
        }
    }
}

