/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.releasenotes.fetchers;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.ide.common.gradle.Version;
import com.android.studio.ml.releasenotes.MavenLibrary;
import com.android.studio.ml.releasenotes.ReleaseNotes;
import com.android.studio.ml.releasenotes.ReleaseNotesContentProvider;
import com.android.studio.ml.releasenotes.ReleaseNotesFetcher;
import com.android.studio.ml.releasenotes.ReleaseNotesQuery;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0013H\u0002J0\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J$\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0013\u00a8\u0006\u001c"}, d2={"Lcom/android/studio/ml/releasenotes/fetchers/GithubChangeLogFetcher;", "Lcom/android/studio/ml/releasenotes/ReleaseNotesFetcher;", "<init>", "()V", "canHandle", "", "library", "Lcom/android/studio/ml/releasenotes/MavenLibrary;", "getReleaseNotesUrl", "Ljava/net/URL;", "query", "Lcom/android/studio/ml/releasenotes/ReleaseNotesQuery;", "fetch", "", "Lcom/android/studio/ml/releasenotes/ReleaseNotes;", "request", "contentProvider", "Lcom/android/studio/ml/releasenotes/ReleaseNotesContentProvider;", "findGithubChangelog", "", "group", "artifact", "getReleasesFromMarkdownChangelogUrl", "changelogUrl", "newVersion", "oldVersion", "extractReleasesFromMarkdownChangelog", "markdown", "aiplugin.android"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nGithubChangeLogFetcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GithubChangeLogFetcher.kt\ncom/android/studio/ml/releasenotes/fetchers/GithubChangeLogFetcher\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,144:1\n1#2:145\n*E\n"})
public final class GithubChangeLogFetcher
implements ReleaseNotesFetcher {
    public static final int $stable;

    @Override
    public boolean canHandle(@NotNull MavenLibrary library) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        return this.findGithubChangelog(library.getGroup(), library.getArtifact()) != null;
    }

    @Override
    @Nullable
    public URL getReleaseNotesUrl(@NotNull ReleaseNotesQuery query) {
        URL uRL;
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        String string = this.findGithubChangelog(query.getLibrary().getGroup(), query.getLibrary().getArtifact());
        if (string != null) {
            String it = string;
            boolean bl = false;
            uRL = new URL(it);
        } else {
            uRL = null;
        }
        return uRL;
    }

    @Override
    @Nullable
    public List<ReleaseNotes> fetch(@NotNull ReleaseNotesQuery request2, @NotNull ReleaseNotesContentProvider contentProvider) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Intrinsics.checkNotNullParameter((Object)contentProvider, (String)"contentProvider");
        String newVersion = request2.getTargetVersion();
        Version oldVersion = request2.getLibrary().getVersion();
        String string = this.findGithubChangelog(request2.getLibrary().getGroup(), request2.getLibrary().getArtifact());
        if (string == null) {
            return null;
        }
        String changeLog = string;
        return this.getReleasesFromMarkdownChangelogUrl(changeLog, newVersion, oldVersion.toString(), contentProvider);
    }

    private final String findGithubChangelog(String group2, String artifact) {
        if (Intrinsics.areEqual((Object)group2, (Object)"org.jetbrains.kotlinx")) {
            if (StringsKt.startsWith$default((String)artifact, (String)"kotlinx-coroutines-", (boolean)false, (int)2, null)) {
                return "https://raw.githubusercontent.com/Kotlin/kotlinx.coroutines/refs/heads/master/CHANGES.md";
            }
        } else {
            if (StringsKt.startsWith$default((String)artifact, (String)"kotlinx-datetime", (boolean)false, (int)2, null)) {
                return "https://raw.githubusercontent.com/Kotlin/kotlinx-datetime/refs/heads/master/CHANGELOG.md";
            }
            if (StringsKt.startsWith$default((String)artifact, (String)"kotlinx-serialization", (boolean)false, (int)2, null)) {
                return "https://raw.githubusercontent.com/Kotlin/kotlinx.serialization/refs/heads/master/CHANGELOG.md";
            }
            if (Intrinsics.areEqual((Object)group2, (Object)"com.squareup.retrofit2")) {
                return "https://raw.githubusercontent.com/square/retrofit/refs/heads/trunk/CHANGELOG.md";
            }
            if (Intrinsics.areEqual((Object)group2, (Object)"io.coil-kt")) {
                return "https://raw.githubusercontent.com/coil-kt/coil/refs/heads/main/CHANGELOG.md";
            }
        }
        return null;
    }

    private final List<ReleaseNotes> getReleasesFromMarkdownChangelogUrl(String changelogUrl, String newVersion, String oldVersion, ReleaseNotesContentProvider contentProvider) {
        Object object = contentProvider.getReleaseNotes(new URL(changelogUrl));
        if (object == null || (object = ((ReleaseNotesContentProvider.ReleaseNotesContent)object).getContent()) == null) {
            object = "";
        }
        Object markdown2 = object;
        return this.extractReleasesFromMarkdownChangelog((String)markdown2, newVersion, oldVersion);
    }

    @NotNull
    public final List<ReleaseNotes> extractReleasesFromMarkdownChangelog(@NotNull String markdown2, @NotNull String newVersion, @NotNull String oldVersion) {
        Intrinsics.checkNotNullParameter((Object)markdown2, (String)"markdown");
        Intrinsics.checkNotNullParameter((Object)newVersion, (String)"newVersion");
        Intrinsics.checkNotNullParameter((Object)oldVersion, (String)"oldVersion");
        List list = new ArrayList();
        Version fromVersion = Version.Companion.parse(oldVersion);
        Version toVersion = Version.Companion.parse(newVersion);
        Ref.ObjectRef currentVersion = new Ref.ObjectRef();
        List currentText = new ArrayList();
        List lines = StringsKt.lines((CharSequence)markdown2);
        for (int lineNo = 0; lineNo < lines.size(); ++lineNo) {
            String line = (String)lines.get(lineNo);
            if (StringsKt.startsWith$default((String)line, (String)"## ", (boolean)false, (int)2, null) && line.length() > 3 || lineNo < lines.size() - 1 && StringsKt.startsWith$default((String)((String)lines.get(lineNo + 1)), (String)"===", (boolean)false, (int)2, null)) {
                GithubChangeLogFetcher.extractReleasesFromMarkdownChangelog$flush((Ref.ObjectRef<Version>)currentVersion, list, currentText);
                Version version = GithubChangeLogFetcher.extractReleasesFromMarkdownChangelog$getVersion(line);
                if (version == null || version.compareTo(fromVersion) <= 0 || version.compareTo(toVersion) > 0) continue;
                currentVersion.element = version;
                if (StringsKt.startsWith$default((String)line, (String)"## ", (boolean)false, (int)2, null)) continue;
                ++lineNo;
                continue;
            }
            if (currentVersion.element == null) continue;
            currentText.add(line);
        }
        GithubChangeLogFetcher.extractReleasesFromMarkdownChangelog$flush((Ref.ObjectRef<Version>)currentVersion, list, currentText);
        return list;
    }

    private static final void extractReleasesFromMarkdownChangelog$flush(Ref.ObjectRef<Version> currentVersion, List<ReleaseNotes> list, List<String> currentText) {
        if (currentVersion.element != null) {
            Object object = currentVersion.element;
            Intrinsics.checkNotNull((Object)object);
            list.add(new ReleaseNotes((Version)object, ((Object)StringsKt.trim((CharSequence)CollectionsKt.joinToString$default((Iterable)currentText, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null))).toString()));
            currentText.clear();
            currentVersion.element = null;
        }
    }

    private static final Version extractReleasesFromMarkdownChangelog$getVersion(String line) {
        String line2 = StringsKt.removeSurrounding((String)StringsKt.substringBefore$default((String)((Object)StringsKt.trim((CharSequence)StringsKt.removePrefix((String)StringsKt.removePrefix((String)line, (CharSequence)"## "), (CharSequence)"Version "))).toString(), (String)" ", null, (int)2, null), (CharSequence)"[", (CharSequence)"]");
        if (((CharSequence)line2).length() > 0 && Character.isDigit(line2.charAt(0))) {
            return Version.Companion.parse(line2);
        }
        return null;
    }
}

