/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.npa.tools;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.npa.tools.MemoryItem;
import com.google.aiplugin.agents.Response;
import com.google.aiplugin.agents.tools.DeclarativeToolSet;
import com.google.aiplugin.agents.tools.ToolContext;
import com.google.aiplugin.agents.tools.ToolFunction;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J4\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00032\b\b\u0002\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u0003H\u0007J\u0018\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003H\u0007J\u0018\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003H\u0007J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\u0006\u0010\u001b\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR*\u0010\n\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\f0\u000bj\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\f`\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/android/studio/ml/npa/tools/MemoryTools;", "Lcom/google/aiplugin/agents/tools/DeclarativeToolSet;", "prefix", "", "maxKeys", "", "<init>", "(Ljava/lang/String;I)V", "getMaxKeys", "()I", "memoryItems", "Ljava/util/LinkedHashMap;", "Lcom/android/studio/ml/npa/tools/MemoryItem;", "Lkotlin/collections/LinkedHashMap;", "noteDown", "Lcom/google/aiplugin/agents/Response;", "context", "Lcom/google/aiplugin/agents/tools/ToolContext;", "key", "value", "sticky", "", "creator", "recall", "delete", "evictOldestByPriority", "", "peekAsPrompt", "aiplugin.android"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nMemoryTools.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MemoryTools.kt\ncom/android/studio/ml/npa/tools/MemoryTools\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,171:1\n1#2:172\n774#3:173\n865#3,2:174\n1863#3,2:176\n774#3:178\n865#3,2:179\n*S KotlinDebug\n*F\n+ 1 MemoryTools.kt\ncom/android/studio/ml/npa/tools/MemoryTools\n*L\n154#1:173\n154#1:174,2\n154#1:176,2\n157#1:178\n157#1:179,2\n*E\n"})
public final class MemoryTools
extends DeclarativeToolSet {
    @NotNull
    private final String prefix;
    private final int maxKeys;
    @NotNull
    private LinkedHashMap<String, MemoryItem> memoryItems;
    public static final int $stable = 8;

    public MemoryTools(@NotNull String prefix, int maxKeys) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        super(prefix);
        this.prefix = prefix;
        this.maxKeys = maxKeys;
        this.memoryItems = new LinkedHashMap();
        if (!(this.maxKeys > 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ MemoryTools(String string, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            string = "memory";
        }
        if ((n2 & 2) != 0) {
            n = 50;
        }
        this(string, n);
    }

    public final int getMaxKeys() {
        return this.maxKeys;
    }

    @ToolFunction(name="note_down", description="\n      Creates a new note in memory.\n\n      Args:\n        key: The key to store.\n        value: The value to store.\n        sticky: Whether to mark the key as sticky.\n        creator: The creator of the key-value pair.\n      ", displayText="Creating a new note in memory with key: {key}")
    @NotNull
    public final Response noteDown(@NotNull ToolContext context2, @NotNull String key, @NotNull String value, boolean sticky, @NotNull String creator) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)creator, (String)"creator");
        if (this.memoryItems.containsKey(key)) {
            this.memoryItems.remove(key);
        } else if (this.memoryItems.size() >= this.maxKeys) {
            this.evictOldestByPriority();
        }
        if (this.memoryItems.size() >= this.maxKeys) {
            return new Response(null, "Memory is full. Could not add new keys.", null, 5, null);
        }
        ((Map)this.memoryItems).put(key, new MemoryItem(key, value, System.currentTimeMillis(), sticky, creator));
        return new Response(null, null, Response.ToolExecutionStatus.OK, 3, null);
    }

    public static /* synthetic */ Response noteDown$default(MemoryTools memoryTools, ToolContext toolContext, String string, String string2, boolean bl, String string3, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            string3 = "";
        }
        return memoryTools.noteDown(toolContext, string, string2, bl, string3);
    }

    @ToolFunction(name="recall", description="\n      Fetches a note from memory.\n\n      Args:\n        key: The key to recall.\n      ", displayText="Fetching note with key: {key} from memory")
    @NotNull
    public final Response recall(@NotNull ToolContext context2, @NotNull String key) {
        Response response2;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        MemoryItem item = (MemoryItem)this.memoryItems.remove(key);
        if (item != null) {
            ((Map)this.memoryItems).put(key, item);
            Response.ToolExecutionStatus toolExecutionStatus = Response.ToolExecutionStatus.OK;
            String string = new Gson().toJson((Object)item.getValue());
            response2 = new Response(string, null, toolExecutionStatus, 2, null);
        } else {
            response2 = new Response(null, "No note found for key: " + key, null, 5, null);
        }
        return response2;
    }

    @ToolFunction(name="delete", description="\n      Deletes a note from memory.\n\n      Args:\n        key: The key to delete.\n    ", displayText="Deleting note with key: {key} from memory")
    @NotNull
    public final Response delete(@NotNull ToolContext context2, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        MemoryItem removed = (MemoryItem)this.memoryItems.remove(key);
        return removed != null ? new Response("Deleted note with key: " + key, null, Response.ToolExecutionStatus.OK, 2, null) : new Response(null, "No note found with key: " + key, null, 5, null);
    }

    private final void evictOldestByPriority() {
        Map.Entry entry;
        Object v1;
        block3: {
            if (this.memoryItems.isEmpty()) {
                return;
            }
            Set<Map.Entry<String, MemoryItem>> set = this.memoryItems.entrySet();
            Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
            Iterable iterable = set;
            for (Object t : iterable) {
                Map.Entry it = (Map.Entry)t;
                boolean bl = false;
                if (!(!((MemoryItem)it.getValue()).getSticky())) continue;
                v1 = t;
                break block3;
            }
            v1 = null;
        }
        if ((entry = (Map.Entry)v1) == null) {
            Set<Map.Entry<String, MemoryItem>> set = this.memoryItems.entrySet();
            Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
            Object object = CollectionsKt.first((Iterable)set);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first(...)");
            entry = (Map.Entry)object;
        }
        Map.Entry entryToRemove = entry;
        this.memoryItems.remove(entryToRemove.getKey());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String peekAsPrompt() {
        void $this$filterTo$iv$iv;
        Object element$iv2;
        void $this$forEach$iv;
        Iterator $this$filterTo$iv$iv2;
        long now = System.currentTimeMillis();
        List lines = new ArrayList();
        Collection<MemoryItem> collection = this.memoryItems.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv2.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            MemoryItem it = (MemoryItem)element$iv$iv;
            boolean bl = false;
            if (!it.getSticky()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            MemoryItem v = (MemoryItem)element$iv2;
            boolean bl = false;
            lines.add(v.getKey() + " : " + v.getValue() + "\n");
        }
        Collection<MemoryItem> collection2 = this.memoryItems.values();
        Intrinsics.checkNotNullExpressionValue(collection2, (String)"<get-values>(...)");
        Iterable $this$filter$iv2 = collection2;
        boolean $i$f$filter2 = false;
        element$iv2 = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            MemoryItem it = (MemoryItem)element$iv$iv;
            boolean bl = false;
            if (!(!it.getSticky())) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List nonSticky = (List)destination$iv$iv2;
        if (!((Collection)nonSticky).isEmpty()) {
            lines.add("\n### Other available memory items (values accessible vial recall tool):");
            for (Object e : nonSticky) {
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                MemoryItem v = (MemoryItem)e;
                int secondsAgo = (int)((now - v.getTimestamp()) / (long)1000);
                lines.add("- " + v.getKey() + " (" + secondsAgo + "s ago)");
            }
        }
        return CollectionsKt.joinToString$default((Iterable)lines, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    public MemoryTools() {
        this(null, 0, 3, null);
    }
}

