/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.metrics;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.ModelProvider;
import com.android.studio.ml.SmlCodeEditedListener;
import com.android.studio.ml.SmlCodeReportEvent;
import com.android.studio.ml.metrics.CodeEditingAction;
import com.android.studio.ml.metrics.SmlCodeEditedMetricsService;
import com.android.studio.ml.metrics.SmlCodeEditedMetricsServiceKt;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.ApplicationKt;
import com.intellij.util.EventDispatcher;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0017\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u000bH\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u000bH\u0016R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/android/studio/ml/metrics/SmlCodeEditedMetricsServiceImpl;", "Lcom/android/studio/ml/metrics/SmlCodeEditedMetricsService;", "Lcom/intellij/openapi/Disposable$Default;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "(Lkotlinx/coroutines/CoroutineScope;)V", "dispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "(Lkotlinx/coroutines/CoroutineScope;Lkotlinx/coroutines/CoroutineDispatcher;)V", "codeEditingAction", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/android/studio/ml/metrics/CodeEditingAction;", "listeners", "Lcom/android/studio/ml/SmlCodeEditedListener;", "kotlin.jvm.PlatformType", "clearCodeEditingAction", "", "currentCodeEditingAction", "getLanguageFromDocument", "Lcom/intellij/lang/Language;", "document", "Lcom/intellij/openapi/editor/Document;", "recordCodeEdited", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "setCodeEditingAction", "action", "aiplugin.core.aicore"})
@VisibleForTesting
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nSmlCodeEditedMetricsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SmlCodeEditedMetricsService.kt\ncom/android/studio/ml/metrics/SmlCodeEditedMetricsServiceImpl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,276:1\n25#2:277\n*S KotlinDebug\n*F\n+ 1 SmlCodeEditedMetricsService.kt\ncom/android/studio/ml/metrics/SmlCodeEditedMetricsServiceImpl\n*L\n246#1:277\n*E\n"})
public final class SmlCodeEditedMetricsServiceImpl
implements SmlCodeEditedMetricsService,
Disposable.Default {
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final CoroutineDispatcher dispatcher;
    private final SmlCodeEditedListener listeners;
    @NotNull
    private final AtomicReference<CodeEditingAction> codeEditingAction;
    public static final int $stable = 8;

    @TestOnly
    public SmlCodeEditedMetricsServiceImpl(@NotNull CoroutineScope coroutineScope, @NotNull CoroutineDispatcher dispatcher2) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter((Object)dispatcher2, (String)"dispatcher");
        this.coroutineScope = coroutineScope;
        this.dispatcher = dispatcher2;
        this.listeners = (SmlCodeEditedListener)EventDispatcher.createMulticaster(SmlCodeEditedListener.class, SmlCodeEditedMetricsServiceImpl::listeners$lambda$0);
        this.codeEditingAction = new AtomicReference<CodeEditingAction.Unknown>(CodeEditingAction.Unknown.INSTANCE);
        ApplicationKt.getApplication().addApplicationListener(new ApplicationListener(){

            public void afterWriteActionFinished(Object action) {
                Intrinsics.checkNotNullParameter((Object)action, (String)"action");
                this.clearCodeEditingAction();
            }
        }, (Disposable)this);
    }

    public SmlCodeEditedMetricsServiceImpl(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this(coroutineScope, Dispatchers.getDefault());
    }

    @Override
    public void setCodeEditingAction(@NotNull CodeEditingAction action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        this.codeEditingAction.set(action);
    }

    @Override
    public void clearCodeEditingAction() {
        this.codeEditingAction.set(CodeEditingAction.Unknown.INSTANCE);
    }

    @Override
    @NotNull
    public CodeEditingAction currentCodeEditingAction() {
        CodeEditingAction codeEditingAction = this.codeEditingAction.get();
        Intrinsics.checkNotNullExpressionValue((Object)codeEditingAction, (String)"get(...)");
        return codeEditingAction;
    }

    @Override
    public void recordCodeEdited(@NotNull DocumentEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        CharSequence charSequence = event.getNewFragment();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getNewFragment(...)");
        CharSequence newFragment = charSequence;
        CharSequence charSequence2 = event.getOldFragment();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence2, (String)"getOldFragment(...)");
        CharSequence oldFragment = charSequence2;
        if (newFragment.length() == 0 && oldFragment.length() == 0) {
            return;
        }
        Document document = event.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        Language language2 = this.getLanguageFromDocument(document2);
        List<SmlCodeReportEvent.CodeEdited> codeEditedEvents = this.codeEditingAction.get().getCodeEditedEvents(((Object)newFragment).toString(), ((Object)oldFragment).toString(), language2);
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, (CoroutineContext)((CoroutineContext)this.dispatcher), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(document2, codeEditedEvents, this, null){
            int label;
            final /* synthetic */ Document $document;
            final /* synthetic */ List<SmlCodeReportEvent.CodeEdited> $codeEditedEvents;
            final /* synthetic */ SmlCodeEditedMetricsServiceImpl this$0;
            {
                this.$document = $document;
                this.$codeEditedEvents = $codeEditedEvents;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$forEach$iv;
                        ResultKt.throwOnFailure((Object)object);
                        if (!SmlCodeEditedMetricsServiceKt.access$isDocumentEligibleForCompletion(this.$document)) {
                            return Unit.INSTANCE;
                        }
                        Iterable iterable = this.$codeEditedEvents;
                        SmlCodeEditedListener smlCodeEditedListener = SmlCodeEditedMetricsServiceImpl.access$getListeners$p(this.this$0);
                        Intrinsics.checkNotNullExpressionValue((Object)smlCodeEditedListener, (String)"access$getListeners$p(...)");
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            SmlCodeReportEvent p0 = (SmlCodeReportEvent)element$iv;
                            boolean bl = false;
                            smlCodeEditedListener.handleEvent(p0);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    private final Language getLanguageFromDocument(Document document) {
        Language language2;
        try {
            language2 = (Language)ActionsKt.runReadAction((Function0)((Function0)new Function0<Language>(document){
                final /* synthetic */ Document $document;
                {
                    this.$document = $document;
                    super(0);
                }

                public final Language invoke() {
                    VirtualFile virtualFile2 = FileDocumentManager.getInstance().getFile(this.$document);
                    if (virtualFile2 == null) {
                        return null;
                    }
                    VirtualFile virtualFile3 = virtualFile2;
                    Project project2 = ProjectUtil.guessProjectForFile((VirtualFile)virtualFile3);
                    if (project2 == null) {
                        return null;
                    }
                    Project project3 = project2;
                    PsiFile psiFile2 = PsiDocumentManager.getInstance((Project)project3).getPsiFile(this.$document);
                    return psiFile2 != null ? psiFile2.getLanguage() : null;
                }
            }));
        }
        catch (Exception e) {
            SmlCodeEditedMetricsServiceImpl $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(SmlCodeEditedMetricsServiceImpl.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Error getting language from document", (Throwable)e);
            language2 = null;
        }
        return language2;
    }

    private static final Iterable listeners$lambda$0() {
        return CollectionsKt.listOfNotNull((Object)ModelProvider.Companion.activeModelProvider().getCodeEditedListener());
    }

    public static final /* synthetic */ SmlCodeEditedListener access$getListeners$p(SmlCodeEditedMetricsServiceImpl $this) {
        return $this.listeners;
    }
}

