/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.journeys.run;

import androidx.compose.runtime.internal.StabilityInferred;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lcom/android/studio/ml/journeys/run/JourneysXmlUtils;", "", "<init>", "()V", "Companion", "aiplugin.android.journeys"})
@StabilityInferred(parameters=1)
public final class JourneysXmlUtils {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int $stable;
    @NotNull
    private static final String JOURNEY_TAG = "journey";

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000f\u001a\u00020\tJ\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0012H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/android/studio/ml/journeys/run/JourneysXmlUtils$Companion;", "", "<init>", "()V", "JOURNEY_TAG", "", "isJourneyFile", "", "psiElement", "Lcom/intellij/psi/xml/XmlFile;", "isFirstLeafTokenOfJourneyTag", "xmlToken", "Lcom/intellij/psi/xml/XmlToken;", "getJourneyNameFromJourneyTagLeafToken", "getJourneyNameFromJourneyFile", "xmlFile", "getJourneyNameFromTag", "xmlTag", "Lcom/intellij/psi/xml/XmlTag;", "isJourneyTag", "tag", "aiplugin.android.journeys"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isJourneyFile(@NotNull XmlFile psiElement) {
            Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
            XmlTag xmlTag = psiElement.getRootTag();
            if (xmlTag == null) {
                return false;
            }
            XmlTag rootTag = xmlTag;
            return this.isJourneyTag(rootTag);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isFirstLeafTokenOfJourneyTag(@NotNull XmlToken xmlToken) {
            Intrinsics.checkNotNullParameter((Object)xmlToken, (String)"xmlToken");
            PsiElement parent = xmlToken.getParent();
            if (!(parent instanceof XmlTag)) return false;
            if (!this.isJourneyTag((XmlTag)parent)) return false;
            PsiElement[] psiElementArray = ((XmlTag)parent).getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
            if (!Intrinsics.areEqual((Object)ArraysKt.first((Object[])psiElementArray), (Object)xmlToken)) return false;
            return true;
        }

        @Nullable
        public final String getJourneyNameFromJourneyTagLeafToken(@NotNull XmlToken xmlToken) {
            Intrinsics.checkNotNullParameter((Object)xmlToken, (String)"xmlToken");
            PsiElement psiElement = xmlToken.getParent();
            XmlTag xmlTag = psiElement instanceof XmlTag ? (XmlTag)psiElement : null;
            if (xmlTag == null) {
                return null;
            }
            XmlTag parent = xmlTag;
            return this.getJourneyNameFromTag(parent);
        }

        @Nullable
        public final String getJourneyNameFromJourneyFile(@NotNull XmlFile xmlFile2) {
            Intrinsics.checkNotNullParameter((Object)xmlFile2, (String)"xmlFile");
            XmlTag xmlTag = xmlFile2.getRootTag();
            if (xmlTag == null) {
                return null;
            }
            XmlTag rootTag = xmlTag;
            return this.getJourneyNameFromTag(rootTag);
        }

        private final String getJourneyNameFromTag(XmlTag xmlTag) {
            if (!this.isJourneyTag(xmlTag)) {
                return null;
            }
            return xmlTag.getAttributeValue("name");
        }

        private final boolean isJourneyTag(XmlTag tag) {
            return Intrinsics.areEqual((Object)tag.getName(), (Object)JourneysXmlUtils.JOURNEY_TAG);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

