/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.gradle.buildsystem;

import com.android.studio.ml.gradle.buildsystem.GetTopLevelSubProjectsKt;
import com.android.studio.ml.gradle.buildsystem.GradleToolsUtilsKt;
import com.android.studio.ml.gradle.buildsystem.ProjectData;
import com.android.tools.idea.projectsystem.AndroidProjectSystem;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.google.aiplugin.agents.NoArgs;
import com.google.aiplugin.agents.Response;
import com.google.aiplugin.agents.Tool;
import com.google.aiplugin.agents.ToolHandler;
import com.google.aiplugin.agents.tools.ToolArgument;
import com.google.aiplugin.agents.tools.ToolContext;
import com.google.aiplugin.agents.tools.ToolDescription;
import com.google.aiplugin.agents.tools.ToolResult;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.project.Project;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KParameter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ToolDescription(summary="Returns the main artifacts of the top level sub-projects", instructions="Top level sub-projects means that they are not consumed by other projects. This includes apps and libraries with no consumers.", examples={})
@ToolResult(description="Returns a JSON array of objects containing the following information:\n- subproject_path: the path of the Gradle sub-project containing the file\n- variant_name: the name of the variant containing the file, 'null' for java projects\n- artifact_type: the name of the artifact containing the file\nReturns an empty array ([]) if no artifacts are found.")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u000e2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u000e\u000fB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lcom/android/studio/ml/gradle/buildsystem/GetTopLevelSubProjects;", "Lcom/google/aiplugin/agents/Tool;", "Lcom/google/aiplugin/agents/NoArgs;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "createHandler", "Lcom/google/aiplugin/agents/ToolHandler;", "context", "Lcom/google/aiplugin/agents/tools/ToolContext;", "args", "Companion", "Handler", "aiplugin.android.gradle"})
public final class GetTopLevelSubProjects
implements Tool<NoArgs> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME = "get_top_level_sub_projects";

    @Override
    @NotNull
    public String getName() {
        return NAME;
    }

    @Override
    @NotNull
    public ToolHandler createHandler(@NotNull ToolContext context2, @NotNull NoArgs args) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return new Handler(context2, args);
    }

    @Override
    @NotNull
    public String getDisplayText(@NotNull NoArgs args) {
        return Tool.super.getDisplayText(args);
    }

    @Override
    @Nullable
    public String getStatusMessage() {
        return Tool.super.getStatusMessage();
    }

    @Override
    @Nullable
    public Map<KParameter, ToolArgument> getToolArguments() {
        return Tool.super.getToolArguments();
    }

    @Override
    @NotNull
    public ToolDescription getToolDescription() {
        return Tool.super.getToolDescription();
    }

    @Override
    @Nullable
    public ToolResult getToolResult() {
        return Tool.super.getToolResult();
    }

    @Override
    @Nullable
    public ToolHandler restoreHandler(@NotNull Project project2, @NotNull NoArgs args, @NotNull Response response2) {
        return Tool.super.restoreHandler(project2, args, response2);
    }

    @Override
    @NotNull
    public String getDescription() {
        return Tool.super.getDescription();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/android/studio/ml/gradle/buildsystem/GetTopLevelSubProjects$Companion;", "", "<init>", "()V", "NAME", "", "aiplugin.android.gradle"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\b\u001a\u00020\tH\u0096@\u00a2\u0006\u0002\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/android/studio/ml/gradle/buildsystem/GetTopLevelSubProjects$Handler;", "Lcom/google/aiplugin/agents/ToolHandler;", "context", "Lcom/google/aiplugin/agents/tools/ToolContext;", "args", "Lcom/google/aiplugin/agents/NoArgs;", "<init>", "(Lcom/google/aiplugin/agents/tools/ToolContext;Lcom/google/aiplugin/agents/NoArgs;)V", "handle", "Lcom/google/aiplugin/agents/Response;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "aiplugin.android.gradle"})
    private static final class Handler
    implements ToolHandler {
        @NotNull
        private final ToolContext context;
        @NotNull
        private final NoArgs args;

        public Handler(@NotNull ToolContext context2, @NotNull NoArgs args) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            this.context = context2;
            this.args = args;
        }

        @Override
        @Nullable
        public Object handle(@NotNull Continuation<? super Response> $completion) {
            return CoroutinesKt.readAction(() -> Handler.handle$lambda$0(this), $completion);
        }

        private static final Response handle$lambda$0(Handler this$0) {
            Project project2 = this$0.context.getProject();
            AndroidProjectSystem projectSystem = ProjectSystemUtil.getProjectSystem((Project)project2);
            if (!projectSystem.isAndroidProject()) {
                return GradleToolsUtilsKt.errorNotAndroid();
            }
            Map<String, ProjectData> modulesByGradlePath = GradleToolsUtilsKt.buildModulesMap(project2);
            if (modulesByGradlePath.isEmpty()) {
                return GradleToolsUtilsKt.errorNoModules();
            }
            List matchingArtifacts = GetTopLevelSubProjectsKt.topLevelArtifacts$default(project2, modulesByGradlePath, null, 4, null);
            return new Response(CollectionsKt.joinToString$default((Iterable)matchingArtifacts, (CharSequence)",\n", (CharSequence)"[", (CharSequence)"]", (int)0, null, null, (int)56, null), null, null, 6, null);
        }
    }
}

